
/**

 * <P><CODE>finder.js</CODE> finds the controller for the User Assistant.
 * </P>

 */

 
/**
 * Find the help controller for a given window
 * @param  win   The window in which the controller has to be searched.
 */
 function findHelpController( win ) {

  if ( findHelpController.controller )

    return findHelpController.controller;

  var controllerWindow = ( arguments.length > 0 ) ?

    findHelpController.findWindow( win ) :

    findHelpController.findWindow();

  if ( controllerWindow )

    return controllerWindow.helpController;  

  return null;

}


findHelpController.controller = undefined;


/**
 * Find the window in the browser space.
 * @param win   Window to be found.
 */
findHelpController.findWindow = function( win ) {

  if ( arguments.length < 1 )

    win = window;

  try {

    var checkingRemote = false;

    while ( win ) {

      if ( win.helpController ) {

        if ( checkingRemote )

          isHelpControllerRemote.truth = true;

        return win;

      }

      else if ( win != win.parent ) {

        win = win.parent;

      }

      else if ( win != win.opener ) {

        win = win.opener;

        if ( ! checkingRemote )

          checkingRemote = true;

      }

      else {

        break;

      }

    }

  } catch ( ex ) {

    alert( "Error finding window " + ex );

  }

  return null;

}


isHelpControllerRemote.truth = false;

/**
 * Return if the help controller is remote or is in 
 */
function isHelpControllerRemote() {

  return isHelpControllerRemote.truth;

}

