
/**

 * <P><CODE>Toolbar.js</CODE> represents the methods available to the user on the
 * toolbar of the User Assistant. The methods are used to navigate the User Assistant.
 * </P>

 */




/**
 * The function checks for the help controller and if available
 * calls the function to show current topic in User Asssitant.
 */
function showCurrentHelp() {
 
  var controller=findHelpController();
 
  if ( controller ) {

      controller.showCurrentTopic();

  }

}


/**
 * The function is used to toggle the User Assistant window.
 * @param  on   The boolean used to indicate the state of the User Assistant.
 */
function toggleHelp( on ) {

  var controller=findHelpController();

  if ( controller )

  {
      if(on == undefined)
        controller.toggleAssist( ! toggleHelpButton.current );
      else
        controller.toggleAssist( on );
  }

}


/**
 * The function is used to toggle the images on the help button for User Assistant window.
 * @param  on   The boolean used to indicate the state of the User Assistant.
 */

function toggleHelpButton( on ) {

  if ( toggleHelpButton.button != null && toggleHelpButton.images != null && toggleHelpButton.images.length < 2 ) {

    var next = on ? 0 : 1;

    toggleHelpButton.button.src = toggleHelpButton.images[ next ];

  }

  toggleHelpButton.current = on;

}



toggleHelpButton.button = undefined;

toggleHelpButton.images = undefined;



toggleHelpButton.current = undefined;


/**
 * The function initializes the toggle button.
 * @param  imgButton   The reference image-button for this togglebutton.
 * @param  onImage     The image when the User Asssitant is off so that it can be turned on.
 * @param  offImage    The image when the User Asssitant is on so that it can be turned off.
 */
toggleHelpButton.init = function( imgButton, onImage, offImage ){



	toggleHelpButton.button = imgButton;

	toggleHelpButton.images = new Array(onImage, offImage);



	var controller=findHelpController();

	if ( controller ) {

    	controller.setToggleButtonImpl( toggleHelpButton );

	}

}



