<%--
 Copyright (c) 2006 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials 
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 
 Contributors:
    Hong Guang (IBM Corp.) - initial implementation
--%>
<%@ include file="header.jsp"%>
<html>
<head>
<%
	boolean isSafari = UrlUtil.isSafari(request);
%>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">
<style type="text/css">
HTML, BODY { 
	width:100%;
	height:100%;
	margin:0px;
	padding:0px;
	border:0px;
}

BODY {
	font:icon;
	background:ButtonFace;
	color: WindowText;
}

TABLE {
	font:icon;
	background:ButtonFace;
}

#titleText {
	font-weight:bold;
	color:WindowText;
}
<%if(isSafari) {%> 
	.caption {
		background:ActiveCaption;
		color:HighLight;
	}
<%} else {%>
	.caption {
		background:ActiveCaption;
		color:CaptionText;
	}
<%}%>


BUTTON {
	font:icon;
}

</style>
<script language="JavaScript">

function onloadHandler() {
	sizeButtons();
}

function sizeButtons() {
	var minWidth=60;

	if(document.getElementById("ok").offsetWidth < minWidth){
		document.getElementById("ok").style.width = minWidth+"px";
	}
	if(document.getElementById("cancel").offsetWidth < minWidth){
		document.getElementById("cancel").style.width = minWidth+"px";
	}
}

</script>
<title><%=ServletResources.getString("deleteAllBookmarks", request)%></title>
</head>


<body  dir="<%=direction%>" onload="onloadHandler()">


<table valign="middle" width="100%" hight="100%">
	<tbody>
		<tr>
			<td height="80" align="center" class="button">
			<p><%=ServletResources.getString("confirmDeleteAllBookmarks", request)%></p>
			</td>
		</tr>
		<tr>
			<td class="button">
			<div align="center">
				<button id="ok" onClick="window.opener.location.replace('bookmarksView.jsp?operation=removeAll');window.close();"><%=ServletResources.getString("yes", request)%></button>
				&nbsp;&nbsp;&nbsp;
				<button id="cancel" onClick="window.close()"><%=ServletResources.getString("no", request)%></button>
            </div>
			</td>
		</tr>
	</tbody>
	</form>
</table>

</body>