<%--
 Copyright (c) 2005, 2006 Intel Corporation.
 All rights reserved. This program and the accompanying materials 
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 
 Contributors:
     Intel Corporation - initial API and implementation
     2005/11/29 - updated by Mei Yang (IBM Corp.) for uat4i00000149 2
     2005/12/2 - updated by Mei Yang (IBM Corp.) for uat4i00000117
 --%>
<%@ include file="header.jsp"%>

<%IndexData data = new IndexData(application, request, response);
			WebappPreferences prefs = data.getPrefs();
%>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">
<title><%=ServletResources.getString("index", request)%></title>
</head>

<style type="text/css">

/* need this one for Mozilla */
html { 
  width:100%;
  height:100%;
  margin:0px;
  padding:0px;
  border:0px;
}

body {
  width:100%;
  height:100%;
  margin:0px;
  padding:0px;
	background-color: <%=prefs.getViewBackground()%>;
	color:WindowText;
	font: <%=prefs.getViewFont()%>;
}

table {
  width: 100%;
  height: 100%;
  cell-spacing: 10px;
  background-color: <%=prefs.getViewBackground()%>;
  color:WindowText;
  font: <%=prefs.getViewFont()%>;
}

td {
  width: 100%;
  padding: 4px;
}

td.editor {
  height:16px;
  width:250px;
}

input.editor {
  color:black;
  width:200px;
  font-size:12px;
  border: 1px solid ThreeDShadow;;
  background-color: window;
}

td.index {
  height:100%;
}

select.index {
  width:100%;
<%
	if (data.isMozilla()) {
%>
  height:90%;
<%
	} else {
%>
  height:100%;
<%
	}
%>
  color:black;
  font-family: "sans serif";
  font-size:10px
  border: 1px solid;
  background-color: window;
}

td.display {
  height:16px;
<%
	if (isRTL) {
%>
	text-align: right;
<%
	}
	else {
%>
	text-align: left;
<%
	}
%>
}

input.display {
  background:ThreeDShadow;
  color:Window;
  font-weight:bold;
  border: 1px solid ThreeDShadow;
}

</style>
<script language="JavaScript">
var advancedDialog;

var oldEditor;
var index;
var editor;

var w = 500;
var h = 250;

function keyListener(e){
   if(!e){
      //for IE
      e = window.event;
   }
   switch (e.keyCode) {
  case 38:
    if (index.selectedIndex > 0) {
      index.selectedIndex = index.selectedIndex - 1;
      onIndexChange();
  	  setCaretToEnd(editor);
      return false;
    }
    return true;
  case 40:
    if (index.selectedIndex < (index.length - 1) ) {
      index.selectedIndex = index.selectedIndex + 1;
      onIndexChange(index);
  	  setCaretToEnd(editor);
      return false;
    }
    return true;
   default:
    return true;
   };
}

function selectTopic(i) {

<%
if (data.isIE()){
%>
  var l = top.screenLeft + (top.document.body.clientWidth - w) / 2;
  var t = top.screenTop + (top.document.body.clientHeight - h) / 2;
<%
} else {
%>
  var l = top.screenX + (top.innerWidth - w) / 2;
  var t = top.screenY + (top.innerHeight - h) / 2;
<%
}
%>

  // move the dialog just a bit higher than the middle
  if (t-50 > 0) t = t-50;

  window.location="javascript://needModal";
  advancedDialog = window.open("selectTopic.jsp?entry="+encodeURIComponent(index.options[i].id), "selectDialog", "resizable=yes,height="+h+",width="+w+",left="+l+",top="+t );
  advancedDialog.focus(); 
}

function openTopic(href) {
  window.parent.parent.parent.setContentToolbarTitle("");
  window.parent.parent.parent.parent.ContentFrame.ContentViewFrame.window.location=href;
}

function alertEmpty() {
  alert("To locate information about this keyword \nplease select one of the subentries in the list");
}
function onEnterKeyPress(onEvent) {

 // updateIndex();

  if(onEvent.keyCode==13) {
 
    // uat4i00000149 1/2
    onIndexChange();
    // end of uat4i00000149 1/2
 
    displayTopic();
    return false;
  }
  else {
    return true;
  }
}

function setCaretToEnd (control) {
  if (control.createTextRange) {
    var range = control.createTextRange();
    range.collapse(false);
    range.select();
  }
  else if (control.setSelectionRange) {
    control.focus();
    var length = control.value.length;
    control.setSelectionRange(length, length);
  }
}

function onIndexChange() {
  //alert("onIndexChange");
  
  var input = index.options[index.selectedIndex].text;
  var start = 0;
  while (input.charCodeAt(start)==160) {
    start++;
  }

  editor.value = input.substring(start, input.length);
  oldEditor = editor.value;
}

// uat4i00000117
function compare(keyword, pattern) {
  var kI = 0, pI = 0;
  var kCh, pCh;
  
  while ( kI < keyword.length && pI < pattern.length) {
    kCh = keyword.charAt(kI).toLowerCase();
    pCh = pattern.charAt(pI).toLowerCase();
	if ( kCh > pCh ) {
      return kI+1;
    }
    else if ( kCh < pCh) {
      return -1*(kI+1);
    }
    kI++;
    pI++;
  }
  if( keyword.length == pattern.length ) {
    return 0;
  }
  else if( keyword.length > pattern.length ) {
    return kI+1;
  }
  else {
  	return -1*(kI+1);
  }
 }

function searchPattern(pattern) {
  var from = 0;
  var to = index.length;
  var i;
  var res;

  do {

    i = Math.floor((to + from) / 2);
    
    res = compare(index.options[index.options[i].value].text, pattern);
    if( res == 0) {
      if (index.options[i].value == i) {
        index.selectedIndex = i;
        return;    
      }
      else {
        to = i;
      }
    }
    else if (res < 0) {
      from = i + 1;
    }
    else {
      to = i;
    }
  } while (to > from) ; 
  
  i = from;
  if (i >= index.length)
  	i = index.length - 1;

  while ((index.options[i].value != i)) {
    i--;
  };	
  
  res = compare(index.options[index.options[i].value].text, pattern);
  
  var j=i;
  
  while ((res > 0) && (i > 0)) {
  	j = i;
    do {
      i--;
    } while ((index.options[i].value != i) && (i > 0));
    res = compare(index.options[index.options[i].value].text, pattern);
  };
 
  var resj = compare(index.options[index.options[j].value].text, pattern);
  if (Math.abs(resj) > Math.abs(res)) {
      i = j;
  }
  
  index.selectedIndex = i;
  return;    
}

// end of uat4i00000117

function updateIndex() {
  var newEditor = editor.value;
  if(oldEditor != newEditor) {
    oldEditor = newEditor;
    searchPattern(oldEditor);
  }
}

function onloadHandler() {
  editor = document.getElementById("editor");
  index = document.getElementById("index");
  index.selectedIndex = 0;
  editor.value = "";
  //editor.focus();
  oldEditor=editor.value;
  document.onkeydown = keyListener;
  window.self.setInterval("updateIndex()", 200);
}

// uat4i00000496
function onunloadHandler()
{
	try{
		if (advancedDialog){		
			advancedDialog.close();
		}
	}catch(e){
	}
}
// end of uat4i00000496

</script>
<body dir="<%=direction%>" onload="onloadHandler()" onunload="onunloadHandler()">

<table>
	<tr>
		<td colspan="2">
		<label id="indexInstruction" for="editor"><%=ServletResources.getString("Index_header", request)%></label>
		</td>
	</tr>
	<tr>
		<td class="editor">
		<input type="text" class="editor" id="editor"
			onKeyPress="return onEnterKeyPress(event);"></td>
		<td class="display"><input class="display" type="submit" id="display"
			value="<%=ServletResources.getString("Index_display", request)%>"
			onClick="javascript:displayTopic();"></td>
	</tr>
	<tr>
		<td colspan="2" class="index">
		<label for="index" style="display:none"><%=ServletResources.getString("Index_box", request)%></label>
		<select name="select" size="2" class="index"
			id="index" onChange="onIndexChange();"
			onKeyPress="return onEnterKeyPress(event);"
    		// uat4i00000149 2/2
			onClick="onIndexChange();"
   			// end of uat4i00000149 2/2
			onDblClick="javascript:displayTopic();">

			<%data.generateIndex(out, "&#160;&#160;");

			%>
		</select></td>
	</tr>
</table>
</body>
<script language="JavaScript">

function displayTopic() {
  switch (index.selectedIndex) {
  <%
    data.generateHrefs(out);
  %>
    default:
      selectTopic(index.selectedIndex);
  };
}


</script>
</html>
