<%--
 Copyright (c) 2000, 2006 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials 
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 
 Contributors:
     IBM Corporation - initial API and implementation
   	 2005/10/17 - updated by Jiang LinQuan(IBM Corp.) for Quick search uat4i00000002
   	 2005/10/27 - updated by Hong Guang (IBM Corp.) for group search result uat4i00000025
   	 2005/11/07 - updated by Hong Guang (IBM Corp.) for group search result uat4i00000025
   	 2006/02/21 - updated by Jiang LinQuan(IBM Corp.) for uat4i00000454
--%>
<%@ include file="header.jsp"%>
<!--
	For grouped search result 
	uat4i00000025 1/2
 -->
<%@ page import="java.util.*"%>
<%@ page import="org.eclipse.help.internal.search.*"%>
<%@ page import="org.eclipse.help.internal.webapp.data.*"%>
<!--
	end of For grouped search result 
	uat4i00000025 1/2
 -->
<% 
	boolean isSafari = UrlUtil.isSafari(request);
	SearchData data = new SearchData(application, request, response);
	// After each search we preserve the scope (working set), if any
	// this need to be at the beginning, otherwise cookie is not written
	if (data.isSearchRequest())
		data.saveScope();

	WebappPreferences prefs = data.getPrefs();
%>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">

<title><%=ServletResources.getString("SearchResults", request)%></title>

<style type="text/css">
BODY {
	background-color: <%=prefs.getViewBackground()%>;
	color:WindowText;
	font: <%=prefs.getViewFont()%>;
	margin-top:5px;
	margin-<%=isRTL?"right":"left"%>:5px;
	padding:0;
	border:0;
	cursor:default;
}
A {
	text-decoration:none; 
	padding:0px;
	white-space: nowrap;
}

A:hover {
	text-decoration:underline; 
}
<%if(data.isSafari()) {%>
A.highlight{ 
	background:Grey;
	color: #FFFFFF;
}
.active { 
	background:Grey;
	color: #FFFFFF;
	width:100%;
	height:100%;
}
A.grouptype {
	text-decoration:none; 
	color:WindowText;
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
}
		
A.grouptype:hover {
	text-decoration:none; 
	color:WindowText;
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
}

<%} else {%>
A.highlight{ 
	background:Highlight;
	color:HighlightText;
}
.active { 
	background:Highlight;
	color:HighlightText;
	width:100%;
	height:100%;
}
A.grouptype {
	text-decoration:none; 
	color:WindowText;
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
}
		
A.grouptype:hover {
	text-decoration:none; 
	color:WindowText;
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
}
<%}%>


IMG {
	border:0px;
	margin:0px;
	padding:0px;
	margin-<%=isRTL?"left":"right"%>:4px;
}

TABLE {
	background-color: <%=prefs.getViewBackground()%>;
	font: <%=prefs.getViewFont()%>;
	width:100%;
}

.list {
	background-color: <%=prefs.getViewBackground()%>;
	padding:2px;
}

.label {
	margin-<%=isRTL?"right":"left"%>:4px;
}

.score {
	padding-<%=isRTL?"left":"right"%>:5px;
}
#detailinfo{
	text-decoration:underline; 
}

</style>

<%
// uat4i00000025
if("none".equalsIgnoreCase(data.getGroup()) || data.getGroup() == null){
// end of uat4i00000025
%>
<%
// uat4i00000025
} else {
//	 end of uat4i00000025
%> 
<!--
	For grouped search result 
	uat4i00000025 1/2
 -->
<style type="text/css">
.searchresult {
	border-left-width: 15px;
	border-left-style: solid;
	border-left-color: <%=prefs.getViewBackground()%>;
	display:none;
}
</style>  
<script language="JavaScript">

// Preload images
minus = new Image();
minus.src = "<%=prefs.getImagesDirectory()%>"+"/minus.gif";
plus = new Image();
plus.src = "<%=prefs.getImagesDirectory()%>"+"/plus.gif";
altGroupClosed="<%=ServletResources.getString("groupClosed", request)%>";
altGroupOpen="<%=ServletResources.getString("groupOpen", request)%>";
</script>
<script type="text/javascript">
<!--
/**
 * display topic label in the status line on mouse over topic
 */
var isMozilla = navigator.userAgent.indexOf('Mozilla') != -1 && parseInt(navigator.appVersion.substring(0,1)) >= 5;
var isIE = navigator.userAgent.indexOf('MSIE') != -1;


function clickHandler(arg) {
		if(isExpanded(arg)){
			collapse(arg);
		} else {
			expand(arg);
		}
}
/**
 * Returns the child node with specified tag
 */
function getChildNode(parent, childTag)
{
	var list = parent.childNodes;
	if (list == null) return null;
	for (var i=0; i<list.length; i++){
		if (list.item(i).tagName == childTag)
			return list.item(i);
	}
	return null;
}

/**
 * Collapses a tree rooted at the specified element
 */
function collapse(node) {
  node.className = "collapsed";
  var image = getChildNode(node, "IMG");
  image.src = plus.src;
  image.alt=altGroupClosed;
  image.title=altGroupClosed;
  // set the UL as well
  var tds = document.getElementById("c" + node.id);
  tds.style.display="none";
}



/**
 * Expands a tree rooted at the specified element
 */
function expand(node) {
  	node.className = "expanded";
  	var image = getChildNode(node, "IMG");
  	image.src = minus.src;
  	image.alt = altGroupOpen;
  	image.title = altGroupOpen;
  	// set the UL as well
  	var tds = document.getElementById("c" + node.id);
  	tds.style.display="block";
}

/**
 * Returns true when this is an expanded tree node
 */
function isExpanded(node) {
  return node.className == "expanded";
}

/**
 * Returns true when this is a collapsed tree node
 */
function isCollapsed(node) {
  return  node.className == "collapsed";
}

var preA;
function hightlight(arg) {
	if(preA){
		var preLink =  document.getElementById(preA);
		preLink.className="";
	}
	arg.className="highlight";
	preA = arg.id;
}
//-->
</script>
<!--
	end of For grouped search result 
	uat4i00000025 1/2
 -->
<%} 
%>

<base target="ContentViewFrame">
<%//uat4i00000025
 if("none".equalsIgnoreCase(data.getGroup()) || data.getGroup() == null) {%>
<script language="JavaScript" src="list.js"></script>
<%} %> 
<script language="JavaScript">		
function showWindowStatus(arg) {
	try {
		var statusText = "";
		if (isIE)
			statusText = arg.innerText;
		else if (isMozilla)
			statusText = arg.lastChild.nodeValue;
		if (statusText != arg.title) {
			statusText += " - " + arg.title;
		}
		window.status = statusText;
	} catch (e) {
	}

}
function clearWindowStatus() {
	window.status="";
}
function refresh() 
{ 
	window.location.replace("searchView.jsp?<%=request.getQueryString()%>");
}
function changeGroup(arg)
{
	var selectedGroup = arg;
	var query = "<%=request.getQueryString()%>";
	var index = query.indexOf("group");
	var detail = query.indexOf("detail");
	var url;
	if(index==-1)
		url = "searchView.jsp?" + query + "&group=" + selectedGroup;
	else {
		url = "searchView.jsp?" + query.substr(0, index - 1) + "&group=" + selectedGroup;
		if(detail != -1 && detail > index)
			url += "&detail=true";
	}
	window.location.replace(url);
}
function details() {
	var query = "<%=request.getQueryString()%>";
	var index = query.indexOf("detail");
	var url;
	if(index==-1) {
		url = "searchView.jsp?" + query + "&detail=true";
		}
	else {
		url = "searchView.jsp?" + query.substr(0, index - 1) + query.substr(index + 11, query.length);
	}
	window.location.replace(url);
}

</script>


</head>

<body  tabindex="0" dir="<%=direction%>">


<%
if (!data.isSearchRequest()) {
	out.write(ServletResources.getString("doSearch", request));
} else if (data.getQueryExceptionMessage()!=null) {
	out.write(data.getQueryExceptionMessage());
} else if (data.isProgressRequest()) {
%>

<CENTER>
<TABLE BORDER='0'>
	<TR><TD><%=ServletResources.getString("Indexing", request)%></TD></TR>
	<TR><TD ALIGN='<%=isRTL?"RIGHT":"LEFT"%>'>
		<DIV STYLE='width:100px;height:16px;border:1px solid ThreeDShadow;'>
			<DIV ID='divProgress' STYLE='width:<%=data.getIndexedPercentage()%>px;height:100%;<%if(isSafari) {%>background-color:grey'<%}else { %>background-color:Highlight'<%} %>></DIV>
		</DIV>
	</TD></TR>
	
	<TR><TD><%=data.getIndexedPercentage()%>% <%=ServletResources.getString("complete", request)%>
	</TD></TR>
	
	<TR><TD><br><%=ServletResources.getString("IndexingPleaseWait", request)%></TD></TR>
</TABLE>
</CENTER>
<script language='JavaScript'>
setTimeout('refresh()', 2000);
</script>


<%
	return;
} else if (data.getResultsCount() == 0){
	out.write(ServletResources.getString("Nothing_found", request));
} else {
%>

<table id='list'  cellspacing='0' >
<tr><td>&nbsp;</td></tr>
<tr>
	<%
		String []arg =  new String[]{String.valueOf(data.getResultsCount()),data.getSearchWord()};
		String resultAmout = ServletResources.getString("resultAmout", arg, request);
	%>
	<%if(data.getResultsCount() < 500) {%>
	<td colspan="2">
		<font size="-1"><%=resultAmout%></font>
	</td>
	<%} else { %>
	<td colspan="2">
		<font size="-1"><%=ServletResources.getString("morethan500", request)%></font>
	</td>
	<%} %>
</tr>
	<tr><td>
	&nbsp;</td></tr>
<%if(data.isFilterEnabled()) { %>
<tr>
	
	<td colspan="2" class="" style="border-bottom-width: 2px;border-bottom-style: solid;border-bottom-color: #0000FF" nowrap>
		<strong><font size="-1"><%=ServletResources.getString("groupBy", request)%></font></strong>
		<a onmouseover="showWindowStatus(this);return true;" onmouseout="clearWindowStatus();return true;" style="text-decoration:underline;" <%if("none".equalsIgnoreCase(data.getGroup()) || data.getGroup() == null){%> class='highlight' <%}%> href="javascript://needmodel" title='<%=ServletResources.getString("none", request)%>' onClick="changeGroup('none')"><%=ServletResources.getString("none", request)%></a>
		<%
		Iterator groupTypes = data.getGroupTypes();
		while(groupTypes.hasNext()) { 
		String groupType = (String)groupTypes.next();
		%>
		&nbsp;|
		<a onmouseover="showWindowStatus(this);return true;" onmouseout="clearWindowStatus();return true;" style="text-decoration:underline;" <%if(groupType.equalsIgnoreCase(data.getGroup())){ %>class='highlight'<%}%> href="javascript://needmodel" title='<%=ServletResources.getString(groupType, request) %>' onClick="changeGroup('<%=groupType %>')"><%=ServletResources.getString(groupType, request) %></a>
		<%}%>
		
	</td>
</tr>
<%} else { %>
	<tr>
	
		<td colspan="2" class="" style="border-bottom-width: 2px;border-bottom-style: solid;border-bottom-color: #0000FF" nowrap>
			&nbsp;
		</td>
	</tr>
<%} %>
<tr>
	<td tabindex="2" colspan="2">
		&nbsp;
		<font size="-2">
		<a id="detailinfo" class="" href="javascript://needmodel" title='<%if(data.getDetail() != null && data.getDetail().equalsIgnoreCase("true")) { %><%=ServletResources.getString("Hide_Summary", request)%><%} else {%><%=ServletResources.getString("Show_Summary", request)%><%} %>' onmouseover="showWindowStatus(this);return true;" onmouseout="clearWindowStatus();return true;"  onClick="details()" ><%if(data.getDetail() != null && data.getDetail().equalsIgnoreCase("true")) { %><%=ServletResources.getString("Hide_Summary", request)%><%} else {%><%=ServletResources.getString("Show_Summary", request)%><%}%></a>
		</font>
	</td>
</tr>
<tr>
	<td colspan="2">
		&nbsp;
	</td>
</tr>
<%//uat4i00000025
 if("none".equalsIgnoreCase(data.getGroup()) || data.getGroup() == null) {
 // end of uat4i00000025
	for (int topic = 0; topic < data.getResultsCount(); topic++)
	{
		if(data.isActivityFiltering() && !data.isEnabled(topic)){
			continue;
		}
		if(data.isFiltered(topic)) {
			continue;
		}
%>

<tr class='list' id='r<%=topic%>'>

<%if(data.isPercentageDisplay()){%>
	<td class='score' align='<%=isRTL?"left":"right"%>'><%=data.getTopicScore(topic)%></td>
<%}%>
	<td align='<%=isRTL?"right":"left"%>' class='label' nowrap>
		<a id='a<%=topic%>' 
		   href="<%=data.getTopicHref(topic)%>" 
		   onmouseover="showStatus(event);return true;"
		   onmouseout="clearStatus();return true;"
		   onclick='parent.parent.parent.setContentToolbarTitle(this.title)' 
		   title="<%=data.getTopicTocLabel(topic)%>"><%=data.getTopicLabel(topic)%>
		 </a>
	</td>
</tr>

<%
//uat4i00000025
if(data.getDetail() != null) { 
// end of uat4i00000025
%>
<tr>
	 <%if(data.isPercentageDisplay()){%>
	    <td>&nbsp;</td>
	 <%}%>
	<td class='label'>
		<font size="-2"><%=data.getTopicSummury(topic)%></font>
	</td>
</tr>
<%} %>
<!--
	For grouped search result 
	uat4i00000025 2/2
 -->
<%

	}
 } else {

%>
</table>
<%
	int ids = 0;
	HashMap groups = data.getResults();
	Set keysSet = groups.keySet();
	List keysList = new ArrayList(keysSet);
    Collections.sort(keysList);
    String unCategory = ServletResources.getString("Uncategorized",
			request);
    if(keysList.remove(unCategory)){
    	keysList.add(unCategory);
    }
	for(Iterator keys = keysList.iterator(); keys.hasNext(); ) {
			String key = (String)keys.next();
%>	
		<table>
			<tr>
				<td class='collapsed' id="<%=key%>" colspan="2" nowrap>
				<img src='images/plus.gif' class='collapsed' alt="<%=ServletResources.getString("groupClosed", request)%>" title="<%=ServletResources.getString("groupClosed", request)%>" onClick='clickHandler(this.parentNode);'>
				<strong><a id="a<%=key%>" class="grouptype" href="javascript://needModal" title='<%=key%>' onclick='clickHandler(this.parentNode.parentNode);'><%=key%></a></strong>
				</td>
			</tr>
		</table>
		<table class="searchresult" id="c<%=key%>" >
					<%
						for(Iterator values = ((List)groups.get(key)).iterator(); values.hasNext(); ) {
							SearchHit hit = (SearchHit)values.next();
							String tocLable = "";
							if(hit.getToc() != null) {
								tocLable = UrlUtil.htmlEncode(hit.getToc().getLabel());
							}
					%>
						<tr id='r<%=ids%>' class='list'>
						<%if(data.isPercentageDisplay()){%>
							<td width="35px" class='score' align='<%=isRTL?"left":"right"%>'>
								<div style="width:35px;">	
									<%=data.getTopicScore(hit)%>
								</div>
							</td>
						<%}%>
							<td class='label' align='<%=isRTL?"right":"left"%>' nowrap>
								<a id='a<%=ids++%>'
								   href="<%=UrlUtil.getHelpURL(hit.getHref())%>" 
								   onmouseover="showWindowStatus(this);return true;"
								   onmouseout="clearWindowStatus();return true;"
								   onclick='parent.parent.parent.setContentToolbarTitle(this.title);hightlight(this);' 
								   title="<%=tocLable%>">
								  <%=hit.getLabel()%>
								 </a>
							 </td>
							 </tr>
							 <%if(data.getDetail() != null && data.getDetail().equalsIgnoreCase("true")) { %>
			
							 <tr>
							 <%if(data.isPercentageDisplay()){%>
							 	    <td>&nbsp;</td>
							 <%}%>
									<td class='label'>
										<font size="-2"><%=hit.getSummary() %></font>
									</td>
								</tr>
							
							 <%} %>
						
					<%
						}
					%>
				
		</table>
		
	<%
		}
	}
	%>


<!--
	end of For grouped search result 
	uat4i00000025 2/2
 -->
<%
	}


%>

<script language="JavaScript">
<!--uat4i00000002-->
<%
if(data.getQueryExceptionMessage()==null&&data.isSingleTopicSearch()&&data.getResultsCount()==1){ 
%>

top.HelpFrame.ContentFrame.ContentViewFrame.location.replace("<%=data.getTopicHref(0)%>"+"&singleTopicSearch=true");
parent.parent.parent.setContentToolbarTitle("<%=data.getTopicTocLabel(0)%>");
top.HelpFrame.NavFrame.ViewsFrame.toc.tocViewFrame.tocTitle="<%=data.getTopicTocLabel(0)%>";

<%
} else if (data.getQueryExceptionMessage()==null&&data.isSingleTopicSearch()&&data.getResultsCount()==0){
%>
        var w = 315;
		var h = 70;
	   
		if (isIE){
		
			var l = top.screenLeft + (top.document.body.clientWidth - w) / 2;
			var t = top.screenTop + (top.document.body.clientHeight - h) / 2;
		
		} else {
		
			var l = top.screenX + (top.innerWidth - w) / 2;
			var t = top.screenY + (top.innerHeight - h) / 2;
		
		}
		
		// move the dialog just a bit higher than the middle
		if (t-50 > 0) t = t-50;
	  	window.location="javascript://needModal";  	
	  	var quickSearchResultDialog = window.open("quickSearchNoResult.jsp", "QuickSearch", "location=no, status=no,resizable=yes,height="+h+",width="+w +",left="+l+",top="+t);
		quickSearchResultDialog.focus(); 

<%
} else {
%>
top.HelpFrame.NavFrame.showView("search");
<%
}
%>
<!--end of uat4i00000002-->

//selectTopicById('<%=data.getSelectedTopicId()%>');

</script>

</body>
</html>
