<%--
 Copyright (c) 2005 Intel Corporation.
 All rights reserved. This program and the accompanying materials 
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 
 Contributors:
     Intel Corporation - initial API and implementation
--%>
<%@ include file="header.jsp"%>

<% 
	SelectTopicData data = new SelectTopicData(application, request, response);
%>

<html>
<head>
<title><%=ServletResources.getString("select_topic", request)%></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">

<style type="text/css">
body {
	background-color: ButtonFace;
	color:WindowText;
	font: icon;
	border:0;
	cursor:default;
	padding: 10px;
	margin:0px;
}

td {
	padding: 0px;
	margin: 0px;
	border-width: 0px;
}

table {
	padding: 0px;
	margin: 0px;
}

table div table {
	width: 447px;
	border-width: 1px;
	border-style: solid;
}

table div table td {
	border-width: 0px;
	border-style: solid;
	padding: 1px 3px 1px 3px;
}

table div table th {
	border-width: 0px;
	border-style: solid;
	padding: 1px 3px 1px 3px;
}

.c0 {
	width: 25px;
	border-bottom-width: 1px;
}

.c1 {
	border-left-width: 1px;
	border-right-width: 1px;
	border-bottom-width: 1px;
	width: 200px;
}

.c2 {
	border-bottom-width: 1px;
	width: 200px;
}

div.content {
	padding: 0px;
	margin: 0px;
	height: 150px;
	overflow: auto;
	width: 463px; /*Original width + 2 pixels for border + 16 pixels for scrollbar*/
	border-width: 0px;
}

table tr.header {
	height: 16px;
	border-color: black;
	border-bottom-width: 0px;
}

table tr.header th {
	background: #AAA;
	border-color: black;
}

table tr.content {
	border-top-width: 0px;
	border-bottom-width: 0px;
	border-color: black;
	height: 100%;
	background: white;
	border-color: #AAA;
}

.footer {
	border-width: 0px;
	border-color: black;
	border-top-width: 1px;
}

.footer td{
<%
	if (isRTL) {
%>
	text-align: left;
<%
	}
	else {
%>
	text-align: right;
<%
	}
%>
	padding: 5px;
}

td.title {
	padding: 5px;
}

</style>
<script language="JavaScript">

function findChecked(group) {
	for(var i=0; i<group.length; i++) {
		if(group[i].checked) {
			return i;
		}
	}
	return -1;
}

function keyListener(e){
   if(!e){
      //for IE
      e = window.event;
   }
   var hrefs = document.topicForm.hrefs;
   var checked =  findChecked(hrefs);
   if(checked < 0) return;
   switch (e.keyCode) {
	case 38:
		if (checked > 0) {
			checked = checked  -1;
			break;
		}
		return true;
	case 40:
		if (checked < (hrefs.length - 1) ) {
			checked = checked  + 1;
			break;
		}
		return true;
   	default:
		return true;
   };
   hrefs[checked].checked = true;
   hrefs[checked].focus();
   return false;
}

function openTopic() {
	var hrefs = document.topicForm.hrefs;
	for(var i=0; i<hrefs.length; i++) {
		if(hrefs[i].checked) {
	        window.opener.openTopic(hrefs[i].value);
			window.close();
		}
	}
}

function sizeButtons() {
	var minWidth=60;

	if(document.getElementById("display").offsetWidth < minWidth){
		document.getElementById("display").style.width = minWidth+"px";
	}
	if(document.getElementById("cancel").offsetWidth < minWidth){
		document.getElementById("cancel").style.width = minWidth+"px";
	}
}

function onloadHandler() {
	sizeButtons();
	document.topicForm.hrefs[0].checked = true;
	document.topicForm.hrefs[0].focus();
	document.onkeydown = keyListener;
}


</script>
<body dir="<%=direction%>" onload="onloadHandler()">
<form name="topicForm">
<table border="0" cellpadding="0" cellspacing="0"  align="center">
  <tr> 
      <td class="title"><%=ServletResources.getString("select_topic_header", request)%></td>
  </tr>
  <tr> 
    <td> 
	<div class="content"> 
        <table border="0" cellpadding="0" cellspacing="0">
            <tr class="header"> 
              <th class="c0" scope="col">&nbsp;</th>
              <th class="c1" scope="col"><%=ServletResources.getString("select_topic_title", request)%></th>
              <th class="c2" scope="col"><%=ServletResources.getString("select_topic_location", request)%></th>
            </tr>
<%
	data.generateTopics(out);
%>
        </table>
	</div>
	</td>
  </tr>
  <tr class="footer"> 
     <td> 
            <button id="display" onClick="openTopic()"><%=ServletResources.getString("select_topic_display", request)%></button>
            <button id="cancel" onClick="window.close()"><%=ServletResources.getString("select_topic_cancel", request)%></button>
     </td>
  </tr>
</table>
</form>
</body>
</html>
