<%--
 Copyright (c) 2000, 2006 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials 
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 
 Contributors:
     IBM Corporation - initial API and implementation
     2005/09/30 - updated by Mei Yang (IBM Corp.) for Quick Print uat4i00000015 2
     2005/10/13 - updated by Hong Guang (IBM Corp.) for quick menu uat4i00000020 5
     2005/10/14 - updated by Hong Guang (IBM Corp.) for uat4i00000021
     2005/10/17 - updated by Jiang LinQuan(IBM Corp.) for uat4i00000009
     2005/10/27 - updated by Jiang LinQuan(IBM Corp.) for Quick search uat4i00000002
     2006/02/21 - updated by Jiang LinQuan(IBM Corp.) for uat4i00000454     
--%>
<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<% 
	TocData data = new TocData(application,request, response);	
	WebappPreferences prefs = data.getPrefs();
%>
<% 
	response.setHeader("Pragma","no-cache"); 
	response.setHeader("Cache-Control","no-cache"); 
	response.setDateHeader("Expires", 0); 
%> 

<STYLE TYPE='text/css'>

.cMenu{
   position: absolute;
   visibility:hidden;
   cursor: default;
   font: menutext;
   background-color: #FFFFFF;
   border: 1px solid buttonface;
   border: 2px outset buttonhighlight;
}

TD.disable{
	background:transparent;
	color: lightgrey;
}


.tdbottom {
	border-bottom-width: 1px;
	border-bottom-style: solid;
	border-bottom-color: InactiveBorder;	
}

.tdright {
	border-right-width: 1px;
	border-right-style: solid;	
	border-right-color: #999999;
}

.dMenu{
   position: absolute;
   visibility:hidden;
   cursor: default;
   font: menutext;
   width: 20px;
}

</STYLE>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

<title><%=ServletResources.getString("Content", request)%></title>

<style type="text/css">
<%@ include file="tree.css"%>
</style>  

<base target="ContentViewFrame">
<script language="JavaScript">

// Preload images
minus = new Image();
minus.src = "<%=prefs.getImagesDirectory()%>"+"/minus.gif";
plus = new Image();
plus.src = "<%=prefs.getImagesDirectory()%>"+"/plus.gif";
toc_open_img = new Image();
toc_open_img.src = "<%=prefs.getImagesDirectory()%>"+"/toc_open.gif";
toc_closed_img = new Image();
toc_closed_img.src = "<%=prefs.getImagesDirectory()%>"+"/toc_closed.gif";
folder_img = new Image();
folder_img.src = "<%=prefs.getImagesDirectory()%>"+"/container_obj.gif";
topic_img = new Image();
topic_img.src = "<%=prefs.getImagesDirectory()%>"+"/topic.gif";
altTopicClosed = "<%=UrlUtil.JavaScriptEncode(ServletResources.getString("topicClosed", request))%>";
altTopicOpen = "<%=UrlUtil.JavaScriptEncode(ServletResources.getString("topicOpen", request))%>";
<!-- uat4i00000009 1/3 -->
altBookClosed="<%=ServletResources.getString("bookClosed", request)%>";
altBookOpen="<%=ServletResources.getString("bookOpen", request)%>";
<!-- end of uat4i00000009 1/3 -->
</script>

<script language="JavaScript" src="toc.js"></script>
<script language="JavaScript" src="tocview.js"></script>
<script language="JavaScript"> 
function getDisable(){
	return "<%=ServletResources.getString("disabled", request)%>";
}
/**
 * Loads the specified table of contents
 */		
function loadTOC(tocHref)
{
<!-- uat4i00000009 2/3 -->
	// navigate to this toc, if not already loaded
	if (window.location.href.indexOf("tocView.jsp?toc="+escape(tocHref)) != -1){
		var links = document.getElementsByTagName("A")
	  	     for(var i=0;i<links.length;i++){
		  	    if (links[i].name=="opened"){
			  	    var plus_minus = getPlusMinus(links[i]);
			  		if (plus_minus != null)
			  		{	
			    		if (isCollapsed(plus_minus)) 
			   				expand(plus_minus);
			  			scrollIntoView(links[i]);
			  		}
					  return;
		  	    }
	  	    }
	  } else {
		 window.location.replace("tocView.jsp?toc="+tocHref);
	  }
<!-- end of uat4i00000009 2/3 -->
}

var tocTitle = "";
var tocId = "";

// The flag used in toc.js-highlightTopic()
// to prevent the book from opening when a 
// quick action occured.
var quickActionClicked=false;
	
function onloadHandler()
{
<!-- uat4i00000020 2/5 -->
<!-- initMouseMove();  -->
<!-- end of uat4i00000020 2/5 -->
<%
	if (data.getSelectedToc() != -1)
	{
%>
	
	tocTitle = '<%=UrlUtil.JavaScriptEncode(data.getTocLabel(data.getSelectedToc()))%>';
	
	var tocTopic = "<%=data.getTocDescriptionTopic(data.getSelectedToc())%>";
	// set title on the content toolbar
	parent.parent.parent.setContentToolbarTitle(tocTitle);
		
	var topicSelected=false;
	// select specified topic, or else the book
	var topic = "<%=data.getSelectedTopic()%>";
	if (topic != "about:blank" && topic != tocTopic) {
		if (topic.indexOf(window.location.protocol) != 0 && topic.length > 2) {
			// remove the .. from topic
			topic = topic.substring(2);
			// remove advanced/tocView.jsp from path to obtain contextPath
			var contextPath = window.location.pathname;
			var slash = contextPath.lastIndexOf('/');
			if(slash > 0) {
				slash = contextPath.lastIndexOf('/', slash-1);
				if(slash >= 0) {
					contextPath = contextPath.substr(0, slash);
					topic = window.location.protocol + "//" +window.location.host + contextPath + topic;
				}
			}			
		}
		topicSelected = selectTopic(escape(topic));
	} else {
		topicSelected = selectTopicById(tocId);
	}
<%
	// if topic failed to be selected, but we know it exist in some book,
	// offer to turn on "show all"
	
	// do not offer to show all just after it was manually turned off
	if (null==request.getParameter("showAll")) {
%>
	if(!topicSelected){
		if(parent.parent.activityFiltering){
			askShowAll();
		}
	}
<%
	}
%>
<%
	} else if ("yes".equals(request.getParameter("synch"))) {
%>
	var message='<%=UrlUtil.JavaScriptEncode(ServletResources.getString("CannotSync", request))%>';
	// when we don't find the specified toc, we just restore navigation
	parent.parent.parent.restoreNavigation(message);
<%
	}
%>
	focusHandler("e");
	var leftmenu = document.getElementById("leftmenu");
	var divWidth = parseInt(document.getElementById("divtable").offsetWidth);
	divWidth = divWidth;
	leftmenu.style.width = divWidth  +"px";
}

var askShowAllDialog;
var w = 470;
var h = 270;

function askShowAll(){
<%
if (data.isIE()){
%>
	var l = top.screenLeft + (top.document.body.clientWidth - w) / 2;
	var t = top.screenTop + (top.document.body.clientHeight - h) / 2;
<%
} else {
%>
	var l = top.screenX + (top.innerWidth - w) / 2;
	var t = top.screenY + (top.innerHeight - h) / 2;
<%
}
%>
	// move the dialog just a bit higher than the middle
	if (t-50 > 0) t = t-50;
	
	window.location="javascript://needModal";
	askShowAllDialog = window.open("askShowAll.jsp", "askShowAllDialog", "resizable=yes,height="+h+",width="+w+",left="+l+",top="+t );
	askShowAllDialog.focus(); 
}

function yesShowAll(){
	window.parent.parent.showAll();
}

function closeAskShowAllDialog(){
	try {
		if (askShowAllDialog){
			askShowAllDialog.close();
		}
	}
	catch(e) {}
}

// uat4i00000002
function closeQuickSearchDialog(){
	try {
		if (quickSingleSearchDialog){
			quickSingleSearchDialog.close();
		}
		
		if(quickSubSearchDialog){
		quickSubSearchDialog.close();
		}
	}
	catch(e) {}
}

// end of uat4i00000002

function onunloadHandler() {
	closeAskShowAllDialog();
	
<%
// for large books, we want to avoid a long unload time
if (data.isIE()){
%>
	document.body.innerHTML = "";
<%
}
%>
}

</script>
</head>


<body tabIndex="0"  dir="<%=direction%>" onload="onloadHandler()" onunload="onunloadHandler()">
	<ul dir="<%=direction%>" class='expanded' id='root'>
<%
	for (int toc=0; toc<data.getTocCount(); toc++) {
		boolean isSelected =data.getSelectedToc() != -1 &&
					   data.getTocHref(data.getSelectedToc()).equals(data.getTocHref(toc));
		if(!data.isEnabled(toc)){
			// do not show
			continue;
		}
		//uat4i00000021
		if(!FilterData.filter(session, data.getTocs()[toc])){
			continue;
		}
		// end of uat4i00000021
		if(isSelected) {
%>
		<li>
		<!-- uat4i00000020 3/5-->
		<!-- uat4i00000015 1/2-->
			
		<!-- uat4i00000009 3/3-->
		<!-- uat4i00000454 1/2 -->
		<img src="<%=prefs.getImagesDirectory()%>/toc_open.gif" onClick='' class="expanded" alt="<%=ServletResources.getString("bookOpen", request)%>" title="<%=ServletResources.getString("bookOpen", request)%>"><a id="b<%=toc%>" name="opened" style="font-weight: bold;" href="<%=data.getTocDescriptionTopic(toc)%>" onFocus="addChild(this)" onMouseOver="addChild(this)" onclick='loadTOC("<%=data.getTocHref(toc)%>")'><%=data.getTocLabel(toc)%></a>
		<!-- end of uat4i00000015 1/2 -->
		<!-- end of uat4i00000020 3/5-->
		<!-- end of uat4i00000009 3/3-->
		<!-- end of uat4i00000454 1/2 -->
		<ul dir="<%=direction%>" class="expanded">
		<%
			// Only generate the selected toc
			data.generateToc(toc, out);
			// keep track of the selected toc id
		%>
		</ul>
			<script language="JavaScript">tocId="b"+<%=toc%></script>
<%
		} else {
%>
		<li>
		<!-- uat4i00000015 2/2 -->
		<!-- uat4i00000020 4/5-->
		<!-- uat4i00000454 2/2 -->
		<img src="<%=prefs.getImagesDirectory()%>/toc_closed.gif"  alt="<%=ServletResources.getString("bookClosed", request)%>" title="<%=ServletResources.getString("bookClosed", request)%>"><a id="b<%=toc%>" name="<%=data.getTocHref(toc)%>" style="font-weight: bold;" href="<%=data.getTocDescriptionTopic(toc)%>" onFocus="addChild(this)" onMouseOver="addChild(this)" onclick='if(window.loadTOC){loadTOC("<%=data.getTocHref(toc)%>");} else {window.location.replace("tocView.jsp?toc="+"<%=data.getTocHref(toc)%>");} '><%=data.getTocLabel(toc)%></a>
		<!-- end of uat4i00000020 4/5-->
		<!-- end of uat4i00000015 2/2 -->
		<!-- end of uat4i00000454 2/2 -->
<%
		}
%>
		</li>	
<%
	}
%>		
	</ul>
   <iframe name="dynLoadFrame" title="<%=ServletResources.getString("ignore", "dynLoadFrame", request)%>" style="visibility:hidden" tabindex="-1" frameborder="no" width="0" height="0" scrolling="no">
    </iframe>
     <iframe name="syncFrame" src="sync.jsp" title="<%=ServletResources.getString("ignore", "syncFrame", request)%>" style="visibility:hidden" tabindex="-1" frameborder="no" width="0" height="0" scrolling="no">
    </iframe>
</body>
</html>
<STYLE TYPE='text/css'>

.hight{
	text-decoration:none; 
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
	<%if(data.isSafari()) {%>
	color: #000000;
	<%}else {%>
	color: HighlightText;
	<%}%>
}
.hight:hover{
	text-decoration:none; 
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
	color: HighlightText;

}

#singleTopicPrint.disable{
	text-decoration:none; 
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
	background:transparent;
	color: lightgrey;
	cursor: default;
}
#singleTopicSearch.disable{
	text-decoration:none; 
	padding-<%=isRTL?"left":"right"%>:2px;
	/* this works in ie5.5, but not in ie5.0  */
	white-space: nowrap;
	background:transparent;
	color: lightgrey;
	cursor: default;
}


</STYLE>
<!-- uat4i00000020 5/5-->
<div dir="<%=direction%>" id="leftmenu" class="cMenu" onMouseOver="this.style.visibility='visible'" onMouseOut="hidePopupMenu()">
	<table id="divtable" border="0" cellpadding="3" cellspacing="0" >
		<tr>
			<td id="lsingleTopicPrint" class="tdright" height="27" width="25" bgcolor="#C0C0C0" align="center"><img src="images/e_print_edit.gif" alt="<%=ServletResources.getString("print_the_topic", request)%>" title="<%=ServletResources.getString("print_the_topic", request)%>" width="16" height="16">
			</td>
    
			<td id="psingleTopicPrint" onMouseOver="highlightitem(this)" nowrap>
				<font size="-1"> <a tabIndex="1" onFocus="highlightitem(this.parentNode.parentNode)" class="menuanchor" id="singleTopicPrint" href="javascript://needModal"><%=ServletResources.getString("print_the_topic", request)%></a></font>
			</td>
		</tr>
		<tr>
			<td id="lsubTopicsPrint" class="tdright" height="27" width="25" bgcolor="#C0C0C0" align="center">&nbsp;
			</td>
			<td id="psubTopicsPrint" onMouseOver="highlightitem(this)" class="tdbottom"  nowrap>
				<font size="-1"><a tabIndex="2" onFocus="highlightitem(this.parentNode.parentNode)" class="menuanchor" id="subTopicsPrint" href="javascript://needModal"><%=ServletResources.getString("print_the_branch", request)%></a></font>
			</td>
		</tr>
		
		<tr>
			<td id="lsingleTopicSearch" class="tdright" height="27" width="25" bgcolor="#C0C0C0" align="center"><img src="images/e_search_results_view.gif" alt="<%=ServletResources.getString("search_the_topic", request)%>" title="<%=ServletResources.getString("search_the_topic", request)%>" width="16" height="16">
			</td>
			<td id="psingleTopicSearch" onMouseOver="highlightitem(this)" nowrap>
				<font size="-1"><a tabIndex="3" onFocus="highlightitem(this.parentNode.parentNode)" class="menuanchor" id="singleTopicSearch" href="javascript://needModal"><%=ServletResources.getString("search_the_topic", request)%></a></font>
			</td>
		</tr>	
		<tr>
			<td id="lsubTopicsSearch" class="tdright" height="27" width="25" bgcolor="#C0C0C0" align="center">
				&nbsp;
			</td>
			<td id="psubTopicsSearch" onMouseOver="highlightitem(this)" nowrap>
				<font size="-1"><a tabIndex="4" onFocus="highlightitem(this.parentNode.parentNode)" class="menuanchor" id="subTopicsSearch" href="javascript://needModal"><%=ServletResources.getString("search_the_branch", request)%></a></font>
				<label id="searchLabela" for="hideanchor" accesskey="h"></label><a id="hideanchor" href="javascript:void window.location.reload();" />
			</td>
		</tr>
	</table>
</div>
<%
if (data.isIE()){
%>
<div dir="<%=direction%>" id="imagmenu"  title="<%=ServletResources.getString("show_quick", request)%>" class="dMenu" onMouseDown="showPopupMenu(this)">
	<img src="images/float.gif" alt="<%=ServletResources.getString("show_quick", request)%>">
</div>
<%
} else {
%>
<layer dir="<%=direction%>" id="imagmenu"  title="<%=ServletResources.getString("show_quick", request)%>" class="dMenu" onClick="showPopupMenu(this)" onMouseDown="showPopupMenu(this)">
	<img src="images/float.gif" alt="<%=ServletResources.getString("show_quick", request)%>">
</layer>
<%
}
%>
<!-- end of uat4i00000020 5/5-->

