#########################################
# This program may be used, executed, copied, modified and distributed
# without royalty for the purpose of developing, using, marketing, or distribution

#---------------------------------------------------
# addTrustedConnection
#---------------------------------------------------
#
# This script is used to add the TrustedConnectionMapping JAAS login configuration
#

import sys
def wsadminToList(inStr):
        outList=[]
        if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
                tmpList = inStr[1:-1].split() #splits space-separated lists,
        else:
                tmpList = inStr.split("\n")   #splits for Windows or Linux
        for item in tmpList:
                item = item.rstrip();         #removes any Windows "\r"
                if (len(item)>0):
                        outList.append(item)
        return outList
#endDef

#########################################
#
# Open security.xml 
#
#########################################

sec = AdminConfig.list("Security" )

#########################################
#
# Locate applicationLoginConfig 
#
#########################################

alc = AdminConfig.showAttribute(sec, "applicationLoginConfig" )

entries = AdminConfig.showAttribute(alc, "entries" )

entries = wsadminToList(entries)


#########################################
#
# Add the TrustedConnectionMapping login configuration
#
#########################################

newJAASConfigurationEntryId = AdminConfig.create("JAASConfigurationEntry", alc, [["alias", "TrustedConnectionMapping"]] )

newJAASLoginModuleId = AdminConfig.create("JAASLoginModule", newJAASConfigurationEntryId, [["moduleClassName", "com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy"]] )

newPropertyId = AdminConfig.create("Property", newJAASLoginModuleId, [["name", "delegate"], ["value", "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule"]] )

newPropertyId2 = AdminConfig.create("Property", newJAASLoginModuleId, [["name", "useTrustedConnection"], ["value", "true"]] )

AdminConfig.modify(newJAASLoginModuleId, [["authenticationStrategy", "REQUIRED"]] )

#########################################
#
# save the change
#
#########################################

AdminConfig.save( )
