# This program may be used, executed, copied, modified and distributed
# without royalty for the purpose of developing, using, marketing, or distribution

#---------------------------------------------------
#
# certMonitorUninstall 
# 
#---------------------------------------------------

def certMonitorInstall(): 
    global AdminConfig

    print "Changing information on the Certificate Expiration Monitor"
    # Get the security object
    cells = AdminConfig.list("Cell")
    if len(cells) == 0:
       return

    cell = cells.split("\r\n")[0] 

    secObjects = AdminConfig.list("Security", cell)
    if len(secObjects) == 0:
       return 0

    # Get the expiration monitor schedule
    scheduleObjs = AdminConfig.showAttribute(secObjects, "wsSchedules")
    if len(scheduleObjs) > 0:
        schedLen = len(scheduleObjs) - 1
        schedList = scheduleObjs[1:schedLen].split(" ")
        for sched in schedList:
            if AdminConfig.showAttribute(sched, "name") == "ExpirationMonitorSchedule":
                frequency = AdminConfig.showAttribute(sched, "frequency")
                if (frequency == "30" or frequency == "28") :
                    attrs = [["frequency", 14]]
                    AdminConfig.modify(sched, attrs)
                    print "ExpirationMonitorSchedule frequency updated."
                    break
            
    else:
        print "There are no wsSchedules in the security.xml file"

    # Get the expiration monitor object
    monitorObj = AdminConfig.showAttribute(secObjects, "wsCertificateExpirationMonitor")
    if len(monitorObj) > 0:
        if AdminConfig.showAttribute(monitorObj, "name") == "Certificate Expiration Monitor":
            if AdminConfig.showAttribute(monitorObj, "daysBeforeNotification") == "60":
                attrs = [["daysBeforeNotification", 15]]
                AdminConfig.modify(monitorObj, attrs)
                print "Certificate Expiration Monitor daysBeforeNotification updated."
    else:
        print "There are no wsCertificateExpirationMonitor"
    

    # Add a new custom property to specify pre-notification period

    propertyFound = "false"
    properties = AdminConfig.showAttribute(secObjects, "properties")
    if len(properties) > 0:
        propertiesLen = len(properties) - 1
        propertiesList = properties[1:propertiesLen].split(" ")
        for property in propertiesList :
            if AdminConfig.showAttribute(property, "name") == "com.ibm.ws.security.expirationMonitorNotificationPeriod":
                propertyFound = "true"
                break
        if propertyFound == "false":
            attrs = [["name", "com.ibm.ws.security.expirationMonitorNotificationPeriod"], ["value", 90]]
            AdminConfig.create("Property", secObjects, attrs)
            print "com.ibm.ws.security.expirationMonitorNotificationPeriod property created."

    AdminConfig.save()
    return 



#Call the update method
certMonitorInstall()                       
