@REM This script Resets the CIMOM ports used by the SVC GUI for 4.2.1
@REM Licensed Materials - Property of IBM
@REM "Restricted Materials of IBM"
@REM 5639-VC5 5639-VW2 5639-VC4 5639-VW1 5639-VC3 5639-VC2 5639-VC1
@REM Copyright IBM Corp. 2003,2009 All Rights Reserved.
@REM US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

@REM This script must be run from the ...\svcconsole\console\embeddedWAS\bin directory
@REM The usage is:
@REM
@REM   setCIMOMPorts <SslPort> <NonSslPort> <true>
@REM
@REM If no arguments are provide the default 5989/5988 ports will be used and ssl will be disabled
@REM if the third parameter is provided then the GUI will be configured to use SSL to communicate to the CIMOM
@REM 

@setlocal
@echo off

@REM Bootstrap values ...

call "%~dp0setupCmdLine.bat"

@REM Set default ports value
set SSL_PORT=5989
set NON_SSL_PORT=5988
set SSL_VAL=false

@REM set ports to a user provided values
if not "%1" == "" set SSL_PORT=%1
if not "%2" == "" set NON_SSL_PORT=%2
if not "%3" == "" set SSL_VAL=true


echo Setting "SslPort" to %SSL_PORT% , "Port" to %NON_SSL_PORT% and SSL connection is %SSL_VAL%...

@REM Change the Port and SslPort properties to a user provided value
@REM Put change of Port in front of SslPort as Port changing will also change the value of SslPort
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search Port=.*  -replace Port=%NON_SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search SslPort=.*  -replace SslPort=%SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search SslEnabled=.*  -replace SslEnabled=%SSL_VAL%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search "# SslPort=.*"  -replace SslPort=%SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search "# Port=.*"  -replace Port=%NON_SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\ICAConsole.ear\ICAConsole.war\WEB-INF\cimom.properties"  -search "# SslEnabled=.*"  -replace SslEnabled=%SSL_VAL%


"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search Port=.*  -replace Port=%NON_SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search SslPort=.*  -replace SslPort=%SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search SslEnabled=.*  -replace SslEnabled=%SSL_VAL%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search "# SslPort=.*"  -replace SslPort=%SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search "# Port=.*"  -replace Port=%NON_SSL_PORT%
"%JAVA_HOME%\bin\java"  "-classpath" "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\lib\SVCConsole.jar" com.ibm.storage.svc.console.util.SearchReplace_inFile  -file "%WAS_HOME%\profiles\SVCProfile\installedApps\SVCCell\SVCConsole.ear\SVCConsole.war\WEB-INF\cimom.properties"  -search "# SslEnabled=.*"  -replace SslEnabled=%SSL_VAL%

@REM restart applications for changes to take effect
call "%WAS_HOME%\bin\wsadmin.bat" -c "$AdminControl invoke [$AdminControl completeObjectName type=ApplicationManager,process=server1,*] stopApplication ICAConsole" >NULL
call "%WAS_HOME%\bin\wsadmin.bat" -c "$AdminControl invoke [$AdminControl completeObjectName type=ApplicationManager,process=server1,*] startApplication ICAConsole" >NULL

call "%WAS_HOME%\bin\wsadmin.bat" -c "$AdminControl invoke [$AdminControl completeObjectName type=ApplicationManager,process=server1,*] stopApplication SVCConsole" >NULL
call "%WAS_HOME%\bin\wsadmin.bat" -c "$AdminControl invoke [$AdminControl completeObjectName type=ApplicationManager,process=server1,*] startApplication SVCConsole" >NULL


@endlocal
