--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLE DBENTITY (
	ENTITY_ID		BIGINT NOT NULL,
	ENTITY_TYPE		VARCHAR(36) NOT NULL,
	UNIQUE_ID		CHAR(36) NOT NULL,
	UNIQUE_NAME		VARCHAR(1000) NOT NULL,
	UNIQUE_NAME_KEY		VARCHAR(236) NOT NULL	
);


CREATE TABLE DBPROPTYPE (
	TYPE_ID			CHAR(16) NOT NULL,
	DESCRIPTION		VARCHAR(254)
);



CREATE TABLE DBPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR(200) NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	META_NAME		VARCHAR(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0,
	VALUE_LENGTH		INTEGER,
	READ_ONLY		INTEGER DEFAULT 0,
	MULTI_VALUED		INTEGER DEFAULT 1,
	CASE_EXACT_MATCH	INTEGER DEFAULT 1,
	CLASSNAME		VARCHAR(512),
	DESCRIPTION		VARCHAR(512),
	APPLICATION_ID		VARCHAR(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL
);


CREATE TABLE DBPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBLONGPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		BIGINT,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBBLOBPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		BLOB(10000000),
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBDBLPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		DOUBLE,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBINTPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		INTEGER,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBREFPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	REF_UNAME_KEY		VARCHAR(236) NOT NULL,
	REF_UNAME		VARCHAR(1000) NOT NULL,
	REF_EXT_ID		VARCHAR(200) NOT NULL,
	REF_FULL_EXT_ID		VARCHAR(1000) NOT NULL,
	REF_REPOS_ID		CHAR(36) NOT NULL,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBSTRPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		VARCHAR(1500),
	VALUE_KEY		VARCHAR(1500),
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBTSPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE		BIGINT,
	PROPVALUE		TIMESTAMP,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBCOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBCOMPPROP (
	VALUE_ID		BIGINT NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		BIGINT NOT NULL,
	COMPOSITE_ID		BIGINT,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBENTREL (
	DESCENDANT_ID		BIGINT NOT NULL,
	ANCESTOR_ID		BIGINT NOT NULL
);


CREATE TABLE DBKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR(10) NOT NULL,
	COLUMNNAME		VARCHAR(18) NOT NULL,
	COUNTER			BIGINT NOT NULL,
	PREFETCH_SIZE		BIGINT DEFAULT 20,
	LOWER_BOUND		BIGINT DEFAULT 0,
	UPPER_BOUND		BIGINT DEFAULT 2147483648
);


CREATE TABLE DBGRPREL (
	GRP_ID			BIGINT NOT NULL,
	REPOS_ID		CHAR(36) NOT NULL,
	EXT_ID			VARCHAR(200) NOT NULL,
	FULL_EXT_ID		VARCHAR(1000) NOT NULL
);


CREATE TABLE DBACCT (
	ENTITY_ID		BIGINT NOT NULL, 
	PASSWORD		CHAR(128) FOR BIT DATA,
	SALT			VARCHAR(254),
	EXT_ID			VARCHAR(200),
	FULL_EXT_ID		VARCHAR(1000),
	REPOS_ID		CHAR(36)
);

