--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLESPACE TS001 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;
	
CREATE TABLE DBENTITY (
	ENTITY_ID		DECIMAL(19) NOT NULL,
	ENTITY_TYPE		VARCHAR(36) NOT NULL,
	UNIQUE_ID		CHAR(36) NOT NULL,
	UNIQUE_NAME		VARCHAR(1000) NOT NULL,
	UNIQUE_NAME_KEY		VARCHAR(236) NOT NULL,
	CONSTRAINT PK001 PRIMARY KEY (ENTITY_ID)
)IN @DbName@.TS001;

CREATE UNIQUE INDEX IXWIM010PK ON DBENTITY (ENTITY_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBENTITY
	TO PUBLIC AT ALL LOCATIONS;
	


CREATE TABLESPACE TS002 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;


CREATE TABLE DBPROPTYPE (
	TYPE_ID			CHAR(16) NOT NULL,
	DESCRIPTION		VARCHAR(254),
	CONSTRAINT PK002 PRIMARY KEY (TYPE_ID)
)IN @DbName@.TS002;

CREATE UNIQUE INDEX IXWIM020PK ON DBPROPTYPE (TYPE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBPROPTYPE
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS003 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR(200) NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	META_NAME		VARCHAR(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0, 
	VALUE_LENGTH		INTEGER,
	READ_ONLY		INTEGER DEFAULT 0, 
	MULTI_VALUED		INTEGER DEFAULT 1, 
	CASE_EXACT_MATCH	INTEGER DEFAULT 1, 
	CLASSNAME		VARCHAR(512),
	DESCRIPTION		VARCHAR(512),
	APPLICATION_ID		VARCHAR(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL,
	CONSTRAINT pk003 PRIMARY KEY (PROP_ID)
)IN @DbName@.TS003;

CREATE UNIQUE INDEX IXWIM030PK ON DBPROP (PROP_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS004 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL,
	CONSTRAINT PK004 PRIMARY KEY (PROP_ID, APPLICABLE_ENTTYPE)
)IN @DbName@.TS004;

CREATE UNIQUE INDEX IXWIM040PK ON DBPROPENT (PROP_ID, APPLICABLE_ENTTYPE);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBPROPENT
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS005 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBLONGPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		DECIMAL(19),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK005 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS005;

CREATE UNIQUE INDEX IXWIM050PK ON DBLONGPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBLONGPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS006 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBBLOBPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		BLOB(10000000),
	RID ROWID NOT NULL GENERATED ALWAYS,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK006 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS006;
	
CREATE UNIQUE INDEX IXWIM060PK ON DBBLOBPROP (VALUE_ID);
	
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBBLOBPROP
	TO PUBLIC AT ALL LOCATIONS;
	

	
CREATE LOB TABLESPACE TS106 IN @DbName@
	BUFFERPOOL BP0;
	
CREATE AUX TABLE DBBLOB
IN @DbName@.TS106 
STORES DBBLOBPROP COLUMN PROPVALUE;
	
CREATE UNIQUE INDEX IXWIM061PK ON DBBLOB
	BUFFERPOOL BP0;
		

	
CREATE TABLESPACE TS007 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBDBLPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		DOUBLE,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK007 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS007;

CREATE UNIQUE INDEX IXWIM070PK ON DBDBLPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBDBLPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS008 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;	

CREATE TABLE DBINTPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		INTEGER,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK008 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS008;
	
CREATE UNIQUE INDEX IXWIM080PK ON DBINTPROP (VALUE_ID);
	
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBINTPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS009 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBREFPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	REF_UNAME_KEY		VARCHAR(236) NOT NULL,
	REF_UNAME		VARCHAR(1000) NOT NULL,
	REF_EXT_ID		VARCHAR(200) NOT NULL,
	REF_FULL_EXT_ID		VARCHAR(1000) NOT NULL,
	REF_REPOS_ID		CHAR(36) NOT NULL,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK009 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS009;
		
CREATE UNIQUE INDEX IXWIM090PK ON DBREFPROP (VALUE_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBREFPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS010 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBSTRPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		VARCHAR(1500),
	VALUE_KEY		VARCHAR(1500),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK010 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS010;
		
CREATE UNIQUE INDEX IXWIM100PK ON DBSTRPROP (VALUE_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBSTRPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS011 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBTSPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		TIMESTAMP,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK011 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS011;
		
CREATE UNIQUE INDEX IXWIM110PK ON DBTSPROP (VALUE_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBTSPROP
	TO PUBLIC AT ALL LOCATIONS;
	


CREATE TABLESPACE TS012 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBCOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL,
	CONSTRAINT PK012 PRIMARY KEY (COMPOSITE_ID, COMPONENT_ID)
)IN @DbName@.TS012;
		
CREATE UNIQUE INDEX IXWIM120PK ON DBCOMPREL (COMPOSITE_ID, COMPONENT_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBCOMPREL
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS013 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;


CREATE TABLE DBCOMPPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE_ID		DECIMAL(19),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK013 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS013;
		
CREATE UNIQUE INDEX IXWIM130PK ON DBCOMPPROP (VALUE_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBCOMPPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS014 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;
	
CREATE TABLE DBENTREL (
	DESCENDANT_ID		DECIMAL(19) NOT NULL,
	ANCESTOR_ID		DECIMAL(19) NOT NULL,
	CONSTRAINT PK014 PRIMARY KEY (DESCENDANT_ID, ANCESTOR_ID)
)IN @DbName@.TS014;
		
CREATE UNIQUE INDEX IXWIM140PK ON DBENTREL (DESCENDANT_ID, ANCESTOR_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBENTREL
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS015 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR(10) NOT NULL,
	COLUMNNAME		VARCHAR(18) NOT NULL,
	COUNTER			DECIMAL(19) NOT NULL,
	PREFETCH_SIZE		DECIMAL(19) DEFAULT 20, 
	LOWER_BOUND		DECIMAL(19) DEFAULT 0, 
	UPPER_BOUND		DECIMAL(19) DEFAULT 2147483648, 
	CONSTRAINT PK015 PRIMARY KEY (KEYS_ID)
)IN @DbName@.TS015;
		
CREATE UNIQUE INDEX IXWIM150PK ON DBKEYS (KEYS_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBKEYS
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS016 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBGRPREL (
	GRP_ID			DECIMAL(19) NOT NULL,
	REPOS_ID		CHAR(36) NOT NULL,
	EXT_ID			VARCHAR(200) NOT NULL,
	FULL_EXT_ID		VARCHAR(1000) NOT NULL,
	CONSTRAINT PK016 PRIMARY KEY (GRP_ID, REPOS_ID, EXT_ID)
)IN @DbName@.TS016;
		
CREATE UNIQUE INDEX IXWIM160PK ON DBGRPREL (GRP_ID, REPOS_ID, EXT_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBGRPREL
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS017 IN @DbName@
	BUFFERPOOL BP0
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15;

CREATE TABLE DBACCT (
	ENTITY_ID		DECIMAL(19) NOT NULL, 
	PASSWORD		CHAR(128) FOR BIT DATA,
	SALT			VARCHAR(254),
	EXT_ID			VARCHAR(200),
	FULL_EXT_ID		VARCHAR(1000),
	REPOS_ID		CHAR(36),
	CONSTRAINT PK017 PRIMARY KEY (ENTITY_ID)
)IN @DbName@.TS017;
		
CREATE UNIQUE INDEX IXWIM170PK ON DBACCT (ENTITY_ID);
		
GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE DBACCT
	TO PUBLIC AT ALL LOCATIONS;



