--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLE DBENTITY (
	ENTITY_ID		INT8 NOT NULL,
	ENTITY_TYPE		VARCHAR(36) NOT NULL,
	UNIQUE_ID		CHAR(36) NOT NULL,
	UNIQUE_NAME		LVARCHAR(1000) NOT NULL,
	UNIQUE_NAME_KEY		VARCHAR(236) NOT NULL	
);


CREATE TABLE DBPROPTYPE (
	TYPE_ID			CHAR(16) NOT NULL,
	DESCRIPTION		VARCHAR(254)
);



CREATE TABLE DBPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR(200) NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	META_NAME		VARCHAR(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0,
	VALUE_LENGTH		INTEGER,
	READ_ONLY		INTEGER DEFAULT 0,
	MULTI_VALUED		INTEGER DEFAULT 1,
	CASE_EXACT_MATCH	INTEGER DEFAULT 1,
	CLASSNAME		LVARCHAR(512),
	DESCRIPTION		LVARCHAR(512),
	APPLICATION_ID		VARCHAR(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL
);


CREATE TABLE DBPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBLONGPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		INT8,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBBLOBPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		BLOB,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBDBLPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		DOUBLE PRECISION,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBINTPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		INTEGER,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBREFPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	REF_UNAME_KEY		VARCHAR(236) NOT NULL,
	REF_UNAME		LVARCHAR(1000) NOT NULL,
	REF_EXT_ID		VARCHAR(200) NOT NULL,
	REF_FULL_EXT_ID		LVARCHAR(1000) NOT NULL,
	REF_REPOS_ID		CHAR(36) NOT NULL,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBSTRPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		LVARCHAR(1500),
	VALUE_KEY		LVARCHAR(1500),
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBTSPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		DATETIME YEAR TO FRACTION,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBCOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBCOMPPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE_ID		INT8,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE DBENTREL (
	DESCENDANT_ID		INT8 NOT NULL,
	ANCESTOR_ID		INT8 NOT NULL
);


CREATE TABLE DBKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR(10) NOT NULL,
	COLUMNNAME		VARCHAR(18) NOT NULL,
	COUNTER			INT8 NOT NULL,
	PREFETCH_SIZE		INT8 DEFAULT 20,
	LOWER_BOUND		INT8 DEFAULT 0,
	UPPER_BOUND		INT8 DEFAULT 2147483648
);


CREATE TABLE DBGRPREL (
	GRP_ID			INT8 NOT NULL,
	REPOS_ID		CHAR(36) NOT NULL,
	EXT_ID			VARCHAR(200) NOT NULL,
	FULL_EXT_ID		LVARCHAR(1000) NOT NULL
);


CREATE TABLE DBACCT (
	ENTITY_ID		INT8 NOT NULL, 
	PASSWORD		BYTE,
	SALT			VARCHAR(254),
	EXT_ID			VARCHAR(200),
	FULL_EXT_ID		LVARCHAR(1000),
	REPOS_ID		CHAR(36)
);

