--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLE DBENTITY (
	ENTITY_ID		NUMBER NOT NULL,
	ENTITY_TYPE		VARCHAR2(36) NOT NULL,
	UNIQUE_ID		VARCHAR2(36) NOT NULL,
	UNIQUE_NAME		VARCHAR2(1000) NOT NULL,
	UNIQUE_NAME_KEY		VARCHAR2(236) NOT NULL	
);


CREATE TABLE DBPROPTYPE (
	TYPE_ID			VARCHAR2(16) NOT NULL,
	DESCRIPTION		VARCHAR2(254) NULL
);



CREATE TABLE DBPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR2(254) NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	META_NAME		VARCHAR2(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0 NULL,
	VALUE_LENGTH		INTEGER NULL,
	READ_ONLY		INTEGER DEFAULT 0 NULL,
	MULTI_VALUED		INTEGER DEFAULT 1 NULL,
	CASE_EXACT_MATCH	INTEGER DEFAULT 1 NULL,
	CLASSNAME		VARCHAR2(512) NULL,
	DESCRIPTION		VARCHAR2(512) NULL,
	APPLICATION_ID		VARCHAR2(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL
);


CREATE TABLE DBPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR2(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBLONGPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		NUMBER NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBBLOBPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		BLOB NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBDBLPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		NUMBER NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBINTPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		INTEGER NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBREFPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	REF_UNAME_KEY		VARCHAR2(236) NOT NULL,
	REF_UNAME		VARCHAR2(1000) NOT NULL,
	REF_EXT_ID		VARCHAR2(200) NOT NULL,
	REF_FULL_EXT_ID		VARCHAR2(1000) NOT NULL,
	REF_REPOS_ID		VARCHAR2(36) NOT NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBSTRPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		VARCHAR2(1500) NULL,
	VALUE_KEY		VARCHAR2(1500) NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBTSPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			VARCHAR2(16) NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE		NUMBER NULL,
	PROPVALUE		DATE NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBCOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE DBCOMPPROP (
	VALUE_ID		NUMBER NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		NUMBER NOT NULL,
	COMPOSITE_ID		NUMBER NULL,
	META_VALUE		VARCHAR2(36) NULL
);


CREATE TABLE DBENTREL (
	DESCENDANT_ID		NUMBER NOT NULL,
	ANCESTOR_ID		NUMBER NOT NULL
);


CREATE TABLE DBKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR2(10) NOT NULL,
	COLUMNNAME		VARCHAR2(18) NOT NULL,
	COUNTER			NUMBER NOT NULL,
	PREFETCH_SIZE		NUMBER DEFAULT 20 NULL,
	LOWER_BOUND		NUMBER DEFAULT 0 NULL,
	UPPER_BOUND		NUMBER DEFAULT 2147483648 NULL
);


CREATE TABLE DBGRPREL (
	GRP_ID			NUMBER NOT NULL,
	REPOS_ID		VARCHAR2(36) NOT NULL,
	EXT_ID			VARCHAR2(200) NOT NULL,
	FULL_EXT_ID		VARCHAR2(1000) NOT NULL
);


CREATE TABLE DBACCT (
	ENTITY_ID		NUMBER NOT NULL, 
	PASSWORD		RAW(128) NULL,
	SALT			VARCHAR2(254) NULL,
	EXT_ID			VARCHAR2(200) NULL,
	FULL_EXT_ID		VARCHAR2(1000) NULL,
	REPOS_ID		VARCHAR2(36) NULL
);

