--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLESPACE TS020 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;
	
CREATE TABLE LAENTITY (
	ENTITY_ID		DECIMAL(19) NOT NULL,
	ENTITY_TYPE		VARCHAR(36) NOT NULL,
	EXT_ID			VARCHAR(200) NOT NULL,
	FULL_EXT_ID		VARCHAR(1000) NOT NULL,
	REPOS_ID		CHAR(36) NOT NULL,
	CONSTRAINT PK020 PRIMARY KEY (ENTITY_ID)
)IN @DbName@.TS020;

CREATE UNIQUE INDEX IXWIM200PK ON LAENTITY (ENTITY_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAENTITY
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS021 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR(10) NOT NULL,
	COLUMNNAME		VARCHAR(18) NOT NULL,
	COUNTER			DECIMAL(19)NOT NULL,
	PREFETCH_SIZE		DECIMAL(19) DEFAULT 20, 
	LOWER_BOUND		DECIMAL(19) DEFAULT 0, 
	UPPER_BOUND 		DECIMAL(19) DEFAULT 2147483648, 
	CONSTRAINT PK021 PRIMARY KEY (KEYS_ID)
)IN @DbName@.TS021;

CREATE UNIQUE INDEX IXWIM210PK ON LAKEYS (KEYS_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAKEYS
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS022 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR(200) NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	META_NAME		VARCHAR(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0, 
	VALUE_LENGTH		INTEGER,
	READ_ONLY		INTEGER DEFAULT 0, 
	MULTI_VALUED		INTEGER DEFAULT 1, 
	CASE_EXACT_MATCH	INTEGER DEFAULT 1, 
	CLASSNAME		VARCHAR(512),
	DESCRIPTION		VARCHAR(512),
	APPLICATION_ID		VARCHAR(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL,
	CONSTRAINT PK022 PRIMARY KEY (PROP_ID)
)IN @DbName@.TS022;

CREATE UNIQUE INDEX IXWIM220PK ON LAPROP (PROP_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS023 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAPROPTYPE (
	TYPE_ID			CHAR(16) NOT NULL,
	DESCRIPTION		VARCHAR(254),
	CONSTRAINT PK023 PRIMARY KEY (TYPE_ID)
)IN @DbName@.TS023;

CREATE UNIQUE INDEX IXWIM230PK ON LAPROPTYPE (TYPE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAPROPTYPE
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS024 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL,
	CONSTRAINT PK024 PRIMARY KEY (PROP_ID, APPLICABLE_ENTTYPE)
)IN @DbName@.TS024;

CREATE UNIQUE INDEX IXWIM240PK ON LAPROPENT (PROP_ID, APPLICABLE_ENTTYPE);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAPROPENT
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS025 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LALONGPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		DECIMAL(19),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK025 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS025;

CREATE UNIQUE INDEX IXWIM250PK ON LALONGPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LALONGPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS026 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LABLOBPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		BLOB(10000000),
	ROW_ID ROWID NOT NULL GENERATED ALWAYS,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK026 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS026;

CREATE UNIQUE INDEX IXWIM260PK ON LABLOBPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LABLOBPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE LOB TABLESPACE TS126 IN @DbName@
	BUFFERPOOL BP0;

CREATE AUX TABLE LABLOB
IN @DbName@.TS126
STORES LABLOBPROP COLUMN PROPVALUE;

CREATE UNIQUE INDEX IXWIM261PK ON LABLOB
	BUFFERPOOL BP0;
	


CREATE TABLESPACE TS027 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LADBLPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		DOUBLE,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK027 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS027;

CREATE UNIQUE INDEX IXWIM270PK ON LADBLPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LADBLPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS028 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAINTPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		INTEGER,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK028 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS028;

CREATE UNIQUE INDEX IXWIM280PK ON LAINTPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAINTPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS029 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LAREFPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	REF_UNAME_KEY		VARCHAR(236) NOT NULL,
	REF_UNAME		VARCHAR(1000) NOT NULL,
	REF_EXT_ID		VARCHAR(200) NOT NULL,
	REF_FULL_EXT_ID		VARCHAR(1000) NOT NULL,
	REF_REPOS_ID		CHAR(36) NOT NULL,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK029 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS029;

CREATE UNIQUE INDEX IXWIM290PK ON LAREFPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LAREFPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS030 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LASTRPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		VARCHAR(1500),
	VALUE_KEY		VARCHAR(1500),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK030 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS030;

CREATE UNIQUE INDEX IXWIM300PK ON LASTRPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LASTRPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS031 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LATSPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE		DECIMAL(19),
	PROPVALUE		TIMESTAMP,
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK031 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS031;

CREATE UNIQUE INDEX IXWIM310PK ON LATSPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LATSPROP
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS032 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LACOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL,
	CONSTRAINT PK032 PRIMARY KEY (COMPOSITE_ID, COMPONENT_ID)
)IN @DbName@.TS032;

CREATE UNIQUE INDEX IXWIM320PK ON LACOMPREL (COMPOSITE_ID, COMPONENT_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LACOMPREL
	TO PUBLIC AT ALL LOCATIONS;



CREATE TABLESPACE TS033 IN @DbName@
	LOCKSIZE ROW
	SEGSIZE 32
	PCTFREE 15
	BUFFERPOOL BP0;

CREATE TABLE LACOMPPROP (
	VALUE_ID		DECIMAL(19) NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		DECIMAL(19) NOT NULL,
	COMPOSITE_ID		DECIMAL(19),
	META_VALUE		VARCHAR(36),
	CONSTRAINT PK033 PRIMARY KEY (VALUE_ID)
)IN @DbName@.TS033;

CREATE UNIQUE INDEX IXWIM330PK ON LACOMPPROP (VALUE_ID);

GRANT DELETE, INSERT, SELECT, UPDATE ON TABLE LACOMPPROP
	TO PUBLIC AT ALL LOCATIONS;


