--------------- Begin Copyright - Do not add comments here --------------
--
-- Licensed Materials - Property of IBM
--
-- Restricted Materials of IBM
--
-- Virtual Member Manager
--
-- (C) Copyright IBM Corp. 2005
--
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
----------------------------- End Copyright -----------------------------
CREATE TABLE LAENTITY (
	ENTITY_ID		INT8 NOT NULL,
	ENTITY_TYPE		VARCHAR(36) NOT NULL,
	EXT_ID			VARCHAR(200) NOT NULL,
	FULL_EXT_ID		LVARCHAR(1000) NOT NULL,
	REPOS_ID		CHAR(36) NOT NULL
);


CREATE TABLE LAKEYS (
	KEYS_ID			INTEGER NOT NULL,
	TABLENAME		VARCHAR(10) NOT NULL,
	COLUMNNAME		VARCHAR(18) NOT NULL,
	COUNTER			INT8	NOT NULL,
	PREFETCH_SIZE		INT8 DEFAULT 20,
	LOWER_BOUND		INT8 DEFAULT 0,
	UPPER_BOUND 		INT8 DEFAULT 2147483648
);


CREATE TABLE LAPROP (
	PROP_ID			INTEGER NOT NULL,
	NAME			VARCHAR(200) NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	META_NAME		VARCHAR(36) DEFAULT 'DEFAULT' NOT NULL,
	IS_COMPOSITE		INTEGER DEFAULT 0,
	VALUE_LENGTH		INTEGER,
	READ_ONLY		INTEGER DEFAULT 0,
	MULTI_VALUED		INTEGER DEFAULT 1,
	CASE_EXACT_MATCH	INTEGER DEFAULT 1,
	CLASSNAME		LVARCHAR(512),
	DESCRIPTION		LVARCHAR(512),
	APPLICATION_ID		VARCHAR(254) DEFAULT 'com.ibm.websphere.wim' NOT NULL
);


CREATE TABLE LAPROPTYPE (
	TYPE_ID			CHAR(16) NOT NULL,
	DESCRIPTION		VARCHAR(254)
);


CREATE TABLE LAPROPENT (
	PROP_ID			INTEGER	NOT NULL,
	APPLICABLE_ENTTYPE	VARCHAR(36) NOT NULL,
	REQUIRED_ENTTYPE	INTEGER DEFAULT 0 NOT NULL
);
 

CREATE TABLE LALONGPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		INT8,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LABLOBPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		BLOB,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LADBLPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		DOUBLE PRECISION,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LAINTPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		INTEGER,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LAREFPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	REF_UNAME_KEY		VARCHAR(236) NOT NULL,
	REF_UNAME		LVARCHAR(1000) NOT NULL,
	REF_EXT_ID		VARCHAR(200) NOT NULL,
	REF_FULL_EXT_ID		LVARCHAR(1000) NOT NULL,
	REF_REPOS_ID		CHAR(36) NOT NULL,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LASTRPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		LVARCHAR(1500),
	VALUE_KEY		LVARCHAR(1500),
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LATSPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	TYPE_ID			CHAR(16) NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE		INT8,
	PROPVALUE		DATETIME YEAR TO FRACTION,
	META_VALUE		VARCHAR(36)
);


CREATE TABLE LACOMPREL (
	COMPOSITE_ID		INTEGER NOT NULL,
	COMPONENT_ID		INTEGER NOT NULL,
	IS_REQUIRED		INTEGER DEFAULT 0 NOT NULL,
	IS_KEY			INTEGER DEFAULT 0 NOT NULL
);


CREATE TABLE LACOMPPROP (
	VALUE_ID		INT8 NOT NULL,
	PROP_ID			INTEGER NOT NULL,
	ENTITY_ID		INT8 NOT NULL,
	COMPOSITE_ID		INT8,
	META_VALUE		VARCHAR(36)
);
