@echo off

@rem +--------------------------------------------------------------------------+
@rem | THIS PRODUCT CONTAINS RESTRICTED MATERIALS OF IBM                        |
@rem | 5630-A36 (C) COPYRIGHT International Business Machines Corp. 1997, 2009  |
@rem | The source code for this program is not published or otherwise divested  |
@rem | of its trade secrets, irrespective of what has been deposited with the   |
@rem | U.S. Copyright Office.                                                   |
@rem +--------------------------------------------------------------------------+

@setlocal

set INSTALLSRC=%~dp0

@rem +-------------------------------------------------------------------+
@rem | Validate the parameters.                                          |
@rem +-------------------------------------------------------------------+

if "%1" == "" goto parseParamsEnv

:parseParams
if "%1" == "" goto performInstall
if /I "%1" == "-installroot" goto formatPath
if /I "%1" == "-hostname" goto setHostName
if /I "%1" == "-usage" goto usage
goto usageBadParam

:formatPath
set INSTALLROOT=%2
goto goodParam

:setHostName
echo NOTE: The -hostname argument is no longer meaningful and will not be.
echo       supported in a future release.
goto goodParam

:goodParam
shift
shift
goto parseParams

:parseParamsEnv
set INSTALLROOT=%EMBEDDEDEXPRESS_INSTALLROOT%
goto performInstall

@rem +-------------------------------------------------------------------+
@rem | Validate the required variables and target directory, and then    |
@rem | perform the copy.                                                 |
@rem +-------------------------------------------------------------------+

:performInstall
echo.
echo. +---------------------------------------+
echo. +       WEAS Version 6.1 Install        +
echo. +---------------------------------------+
echo.
echo     Validating target directory ...
if not defined INSTALLROOT goto usage
if exist "%INSTALLROOT:"=%" goto usageInstallExists

FOR /f "delims=\/" %%a in ('echo "%INSTALLROOT:"=%"') do Set DRIVE=%%a
set DRIVE=%DRIVE:"=%
if not exist "%DRIVE%" goto usageBadInstallRoot

md "%INSTALLROOT:"=%"
if not %errorlevel% == 0 goto miscErrorPriv

echo     Copying files ...
xcopy /e /i /q /y "%INSTALLSRC:"=%*" "%INSTALLROOT:"=%" > NUL
if not %errorlevel% == 0 goto miscErrorOS
echo     Install is complete!
goto done


:usageInstallExists
set ERRORLEVEL=1
echo.
echo ERROR:  The installation has been aborted because
echo         %INSTALLROOT% already exists.  Please remove
echo         %INSTALLROOT% or choose an alternate installation
echo         location.  %INSTALLROOT% will be automatically
echo         created during installation.
echo.
goto done

:usageBadParam
set ERRORLEVEL=1
echo.
echo ERROR: The command line parameter "%1" is invalid.
echo.
goto usage

:usageBadInstallRoot
set ERRORLEVEL=1
echo ERROR:  %INSTALLROOT% is not a valid install location.
echo Please use a valid full path when specifying installRoot.
goto done

:miscErrorPriv
echo ERROR:  Due to insufficient privileges to write to
echo %INSTALLROOT%, the installation has been aborted.
goto done

:miscErrorOS
echo ERROR:  An error has occurred at the OS level which will
echo prevent proper installation.  Please check the system
echo STDERR and/or STDOUT log(s) for more information
echo which may help determine the possible cause of the error.
goto done

:usage
set ERRORLEVEL=1
echo.
echo Usage:
echo   install.bat [-installRoot installRoot]
echo or
echo   install.bat
echo.
echo Note:  If no command line args are passed in, these environment
echo variables must be set prior to running the install script.
echo. 
echo   EMBEDDEDEXPRESS_INSTALLROOT
echo.
goto done

:done
@endlocal
