// global variable for storing the current language
var language;

// global variable for storing the current language ID
var langID;

// global variable for storing NLS array
var arrayID;
                    
// variables to store language IDs
var eng = "eng";
var por = "por";
var ita = "ita";
var esp = "esp";
var fra = "fra";
var ger = "ger";
var chi = "chi";
var tch = "tch";
var jap = "jap";
var kor = "kor";


// this array contains the language names
var arrayLanguages = new Array("English", "Portugues", "Italiano", "Espanol", "Francais", "Deutsch", 
                               "Chinese", "Traditional Chinese", "Japanese", "Korean");

//the following arrays contain the names of the guides in the NLS names
//Note: english names are used in the other language-specific arrays for simplicity

var arrayGuideNameEng = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNamePor = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameIta = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameEsp = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameFra = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameGer = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameChi = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameTch = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*" , "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameJap = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*" , "Information for Japanese Users", "RMI-IIOP Programmer's Guide");

var arrayGuideNameKor = new Array("SDK Guide", "Installation Guide", "Runtime Environment Guide", 
                         "Redistribution Guide", "Java Security Guide", "Readmefirst", "JavaComm API Guide*", "Information for Japanese Users", "RMI-IIOP Programmer's Guide");


// The following function chooses the language in which to display the guides, based on the choice the user made in the
// startHere.html page - the language is selected depending on the URL of the container page (index.html?language).
// Also, langID, a string containing the 3-character language identifier is returned - this is used in the table of contents
// to compute the correct guide to display.
function chooseLanguage() {
    
    loc = parent.location.href; // get URL of the container page, index.en.html
    
    var langPath;
    //the following if..else block check which language the guides should be displayed in, and sets the variables
    // language, langId, and arrayID to the appropriate values
    if(loc.indexOf(eng) != -1) {
        language = arrayLanguages[0];
        langId = eng;
        arrayID = arrayGuideNameEng;
        langPath="en";
    }
    else if(loc.indexOf(por) != -1){
        language = arrayLanguages[1];
        langId = por;
        arrayID = arrayGuideNamePor;
        langPath="br";
    }
    else if(loc.indexOf(ita) != -1){
        language = arrayLanguages[2];
        langId = ita;
        arrayID = arrayGuideNameIta;
        langPath="it";
    }
    else if(loc.indexOf(esp) != -1){
        language = arrayLanguages[2];
        langId = esp;
        arrayID = arrayGuideNameEsp;
        langPath="es";
    }
    else if(loc.indexOf(fra) != -1){
        language = arrayLanguages[3];
        langId = fra;
        arrayID = arrayGuideNameFra;
        langPath="fr";
    }
    else if(loc.indexOf(ger) != -1){
        language = arrayLanguages[4];
        langId = ger;
        arrayID = arrayGuideNameGer;
        langPath="de";
    }
    else if(loc.indexOf(chi) != -1) {
        language = arrayLanguages[5];
        langId = chi;
        arrayID = arrayGuideNameChi;
        langPath="cn";
    }
    else if(loc.indexOf(tch) != -1) {
        language = arrayLanguages[6];
        langId = tch;
        arrayID = arrayGuideNameTch;
        langPath="tw";
    }
    else if(loc.indexOf(jap) != -1) {
        language = arrayLanguages[7];
        langId = jap;
        arrayID = arrayGuideNameJap;
        langPath="jp";
    }
    else if(loc.indexOf(kor) != -1){
        language = arrayLanguages[8];
        langId =  kor;
        arrayID = arrayGuideNameKor;
        langPath="ko";
    }
//alert("The chosen language is: " + language + "\nLanguage ID: " + langId + "\narrayId: " + arrayID);
    
    return langPath;
}
    

// The following function creates a two-dimensional array that contains the 
// name of a guide with its associated file path and returns that array.
function createAssocArray(guidesArray) {
    chooseLanguage();
    var twoDimArray = new Array;
    for(i=0; i<guidesArray.length; i++) {
        
        if(guidesArray[i].indexOf("sdkguide") != -1) {
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[0];
        }                  
        else if (guidesArray[i].indexOf("installguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[1];
        }
        else if (guidesArray[i].indexOf("runtimeguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[2];
        }
        else if (guidesArray[i].indexOf("distguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[3];
        }
        else if (guidesArray[i].indexOf("securityguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[4];
        }
        else if (guidesArray[i].indexOf("readmefirst") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[5];
        }
        else if (guidesArray[i].indexOf("javacomm") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[6];
        }
        else if (guidesArray[i].indexOf("japanese") != -1){
            if ( (langId.indexOf("jap") != -1) || (langId.indexOf("eng") != -1) ) {
                twoDimArray[i] = new Array(2);
                twoDimArray[i][0] = guidesArray[i];
                twoDimArray[i][1] = arrayID[7];
            }
            else {
                twoDimArray[i] = null;
                //twoDimArray[i][0] = "";
                //twoDimArray[i][1] = "";

            }
        }   
        else if (guidesArray[i].indexOf("rmi") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[8];
        }

    }
    //alert("The chosen language is: " + language + "\nLanguage ID: " + langId + "\narrayId: " + arrayID);
    return twoDimArray;
}

//the following function writes the TOC in the toc.htm file
//first it calls the function createAssocArray() on an array that has a list of the
//file paths to the various user guides. this results in a 2-dimensional array that has the
//path of the user guide and the name to display in the browser. 
//after writing the opening <UL> tag, this function iterates through the 2-dimensional array to
//create the links to the various user guides
function writeToc(arrayGuidePaths) {
    var twoDim = createAssocArray(arrayGuidePaths); // create 2-dimensional array from array containing user guide paths
    document.write("<UL>"); // write opening <UL> tag
    
    //iterate through 2-dim array and write links in toc.htm file  
    for (i=0; i<twoDim.length; i++){
        if(twoDim[i] == null)
            continue;
        document.write("<LI><A href='" + twoDim[i][0] + "' target='Content' title='" + twoDim[i][1] + "' onClick='parent.Content.focus()'>" + twoDim[i][1] + "</A></LI>");
    }
    
    document.write("</UL>"); // write closing </UL> tag

    

}
        

// the following function automatically loads the index page with the table of contents
// use it with the onLoad attribute of the opening <BODY> tag when there are no translations
// (e.g. "<BODY onLoad="loadIndex()">

function loadIndex() {
    location.href = "navigation/index.en.htm?eng"
    //alert(location.href);
}

// SIG // Begin signature block
// SIG // MIIa2QYJKoZIhvcNAQcCoIIayjCCGsYCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFK5fSc1JXmQ0
// SIG // vGps04gXVSgqhgXwoIIWYDCCA8QwggMtoAMCAQICEEe/
// SIG // GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIwMzIz
// SIG // NTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZl
// SIG // cmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2lnbiBU
// SIG // aW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzNIK8K
// SIG // fYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+jNtr
// SIG // 3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g99bbV
// SIG // XV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN3j/H
// SIG // tN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkSud5o
// SIG // L6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyfhOpU
// SIG // wQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvEs0dD
// SIG // mhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2ru66
// SIG // DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQGCCsG
// SIG // AQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29j
// SIG // c3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYBAf8C
// SIG // AQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2NybC52
// SIG // ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5nQ0Eu
// SIG // Y3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB
// SIG // /wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UEAxMM
// SIG // VFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GBAEpr
// SIG // +epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17IypMT
// SIG // 5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGLOIez
// SIG // 6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuFPrWd
// SIG // tdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIID/zCC
// SIG // AuegAwIBAgIQDekr8NTYKYgYMgUJXpp2iDANBgkqhkiG
// SIG // 9w0BAQUFADBTMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
// SIG // VmVyaVNpZ24sIEluYy4xKzApBgNVBAMTIlZlcmlTaWdu
// SIG // IFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EwHhcNMDMx
// SIG // MjA0MDAwMDAwWhcNMDgxMjAzMjM1OTU5WjBXMQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // LzAtBgNVBAMTJlZlcmlTaWduIFRpbWUgU3RhbXBpbmcg
// SIG // U2VydmljZXMgU2lnbmVyMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAslAoSN3TaHqEGERmdV1+xLif
// SIG // Yyb/PUOcfBE4ECVVc9l1J2n9TrkgXNMK+aAbKu1VViFh
// SIG // 2B7b5Lwza8fv3aM3ZY4bkwy2Ux5cfGY1XwWKRf52Tt9T
// SIG // gKKBIJ2uiFyiCPflMPnuIjdMQgrO38YfxNZV6YE/tVKj
// SIG // LKoBevKiqo01/p/mXWoFnz1r47+WwP7MYPlA5wegROuB
// SIG // UW6lKvK2ihAo7Y/cBqCGUJp7SggNMB3KEJ5r9+lYrgSp
// SIG // QJmyKOiPFqw841NvS9M1nbVvZB2zliy7Ped56216+Rbm
// SIG // Jq2v75lTt0Aslbh5qv7UUqspdH5C7DkeomoW5lm7JGjY
// SIG // AIBDEIeAawIDAQABo4HKMIHHMDQGCCsGAQUFBwEBBCgw
// SIG // JjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNp
// SIG // Z24uY29tMAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAo
// SIG // oCagJIYiaHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNz
// SIG // LWNhLmNybDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAO
// SIG // BgNVHQ8BAf8EBAMCBsAwJAYDVR0RBB0wG6QZMBcxFTAT
// SIG // BgNVBAMTDFRTQTIwNDgtMS01NDANBgkqhkiG9w0BAQUF
// SIG // AAOCAQEAh3hw2k5SASBb4HnJgjDE/bkZlr2RAMO9zc3G
// SIG // 9A7Y//lNwDNiMBHF9XQb1JLeX5wgE7F8Rb5QzYPngBeD
// SIG // pyeTZxNG+8q4mEEDzJtRWwWLf6hv8xtQGyQu8mmNbCL3
// SIG // u8oWle0MdMBod9nrmWKHwXOQ+Il0eiOro5h7l7H3jylx
// SIG // TS51G0hB2vC1DSBU1negl4Jjaf0Jz4rwdbsJm9n5EVUm
// SIG // mmEyvnoCsHuGvqLDiyIseNE1drySc1z5ueZMFQojzOTS
// SIG // 1DQuSUAVPA9geiTGpWbvls9w6z7n9A1+3NF8o3ZxacGc
// SIG // T0cwNSGxoq8aYjwr2Y6qKgd72BizXHvinaVv/jyJrTCC
// SIG // BL8wggQooAMCAQICEEGRoVo5eN/PSWVmOB1MdcIwDQYJ
// SIG // KoZIhvcNAQEFBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNV
// SIG // BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
// SIG // cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24g
// SIG // QXV0aG9yaXR5MB4XDTA0MDcxNjAwMDAwMFoXDTE0MDcx
// SIG // NTIzNTk1OVowgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+vO68fu+D
// SIG // 6+A3T/sDEDi+CNKMfZ36kn8ZDMJr7kJSjN7THEgTJerB
// SIG // Y3r5UWXu06o79fCUnCv78mbUJNr39Z9uGTk2vNCjdgge
// SIG // IickbDiRJ+KESa4biqH9JYIsEDDocaso6HdKUfHszfjw
// SIG // VNRvwONtCo/Z2GSNY7ItTif2hQ7+beMpmeKFR3wthn/o
// SIG // V4+tZ8IzMpETIPypIxSabcKES3ZoBNVxLF0h+ogNJv0f
// SIG // LZEr5wFVTfJtNSiC39lrXLbW2aqB/V/Ng7pjndAi/Kk7
// SIG // Qmmyjjq1vLSeD17E6iyCiyj9UwiW3bUBINH5pRjnwO5R
// SIG // cDfhtgVIUkhvOOrD6Gx7RIS7AgMBAAGjggGgMIIBnDAS
// SIG // BgNVHRMBAf8ECDAGAQH/AgEAMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAxBgNVHR8EKjAo
// SIG // MCagJKAihiBodHRwOi8vY3JsLnZlcmlzaWduLmNvbS9w
// SIG // Y2EzLmNybDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYB
// SIG // BQUHAwMwDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIB
// SIG // AQQEAwIAATApBgNVHREEIjAgpB4wHDEaMBgGA1UEAxMR
// SIG // Q2xhc3MzQ0EyMDQ4LTEtNDMwHQYDVR0OBBYEFAj1Uej7
// SIG // /j09ZDZ8aM9beKjfucU3MIGABgNVHSMEeTB3oWOkYTBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCEHC6
// SIG // 5B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQEFBQADgYEA
// SIG // rjoXuEp7VfpkVexApO1JQZCZnIm8ry4dyngj+RwZD3/r
// SIG // aLwy2Yg43tw/04m0P7GClvGkWrrtLibT3nwBbgAKAKQG
// SIG // khFICUD5HBh5ZyMk4LvV4VCuG/UO3eAugc2Ao2xST5F1
// SIG // VYq6IvLS6kF1iC9jVX0eVFqVWcrZNIHAX172erUwggS/
// SIG // MIIEKKADAgECAhBXZG4rVQAj1JBTSlU+qw0KMA0GCSqG
// SIG // SIb3DQEBBQUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3Mg
// SIG // MyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1
// SIG // dGhvcml0eTAeFw0wNDA3MTYwMDAwMDBaFw0wOTA3MTUy
// SIG // MzU5NTlaMIG0MQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
// SIG // VmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWdu
// SIG // IFRydXN0IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9m
// SIG // IHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
// SIG // cnBhIChjKTA0MS4wLAYDVQQDEyVWZXJpU2lnbiBDbGFz
// SIG // cyAzIENvZGUgU2lnbmluZyAyMDA0IENBMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvrzuvH7vg+vg
// SIG // N0/7AxA4vgjSjH2d+pJ/GQzCa+5CUoze0xxIEyXqwWN6
// SIG // +VFl7tOqO/XwlJwr+/Jm1CTa9/Wfbhk5NrzQo3YIHiIn
// SIG // JGw4kSfihEmuG4qh/SWCLBAw6HGrKOh3SlHx7M348FTU
// SIG // b8DjbQqP2dhkjWOyLU4n9oUO/m3jKZnihUd8LYZ/6FeP
// SIG // rWfCMzKREyD8qSMUmm3ChEt2aATVcSxdIfqIDSb9Hy2R
// SIG // K+cBVU3ybTUogt/Za1y21tmqgf1fzYO6Y53QIvypO0Jp
// SIG // so46tby0ng9exOosgoso/VMIlt21ASDR+aUY58DuUXA3
// SIG // 4bYFSFJIbzjqw+hse0SEuwIDAQABo4IBoDCCAZwwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBEBgNVHSAEPTA7MDkGC2CG
// SIG // SAGG+EUBBxcDMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEwMQYDVR0fBCowKDAm
// SIG // oCSgIoYgaHR0cDovL2NybC52ZXJpc2lnbi5jb20vcGNh
// SIG // My5jcmwwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUF
// SIG // BwMDMA4GA1UdDwEB/wQEAwIBBjARBglghkgBhvhCAQEE
// SIG // BAMCAAEwKQYDVR0RBCIwIKQeMBwxGjAYBgNVBAMTEUNs
// SIG // YXNzM0NBMjA0OC0xLTQzMB0GA1UdDgQWBBQI9VHo+/49
// SIG // PWQ2fGjPW3io37nFNzCBgAYDVR0jBHkwd6FjpGEwXzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
// SIG // YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ghBwuuQd
// SIG // ENkpNLY4ynsDzLq/MA0GCSqGSIb3DQEBBQUAA4GBAJpl
// SIG // 9djX4aTQXd7YfXvD7sQIwlbQjNztrCKN51AGDQcsoKRp
// SIG // lcyZ38xjMc+wweSWyzjOIft851gKIyEHLJCXq9iWBJNU
// SIG // U7o6EEhyDYXsGwpBJcx9bKx7A/H3eDzyqEDQVXLbvgso
// SIG // tcjHBf7T4LUh3LxAt768YPW449heO2XdZlZfMIIFCzCC
// SIG // A/OgAwIBAgIQN2qihWynr/+xl9Fg7r+K2TANBgkqhkiG
// SIG // 9w0BAQUFADCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTAeFw0wNjA4
// SIG // MDMwMDAwMDBaFw0wOTA4MTEyMzU5NTlaMIHOMQswCQYD
// SIG // VQQGEwJHQjESMBAGA1UECBMJSGFtcHNoaXJlMRAwDgYD
// SIG // VQQHEwdIdXJzbGV5MRMwEQYDVQQKFApJQk0gVUsgTHRk
// SIG // MT4wPAYDVQQLEzVEaWdpdGFsIElEIENsYXNzIDMgLSBN
// SIG // aWNyb3NvZnQgU29mdHdhcmUgVmFsaWRhdGlvbiB2MjEv
// SIG // MC0GA1UECxQmZS1idXNpbmVzcyBJbmZyYXN0cnVjdHVy
// SIG // ZSBUZWNobm9sb2dpZXMxEzARBgNVBAMUCklCTSBVSyBM
// SIG // dGQwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAObM
// SIG // 344+eq+CYdm9y+Ex1JGxyTeg5Hp78egLSV+WlP+Cp/by
// SIG // 3dF0hK5wiZRQFLUvyxKG2ycBsBjQCpxOkuAWk1E85m5z
// SIG // VNyuhfqDpjfJBIu/7M1Q7QaKVDtbnGWtbRIuo34RO2xh
// SIG // lAGo0KjNy7JJ0zzwMvPJO6c/J+TlcJv51TFNAgMBAAGj
// SIG // ggF/MIIBezAJBgNVHRMEAjAAMA4GA1UdDwEB/wQEAwIH
// SIG // gDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8vQ1NDMy0y
// SIG // MDA0LWNybC52ZXJpc2lnbi5jb20vQ1NDMy0yMDA0LmNy
// SIG // bDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcDMCowKAYI
// SIG // KwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdQYIKwYB
// SIG // BQUHAQEEaTBnMCQGCCsGAQUFBzABhhhodHRwOi8vb2Nz
// SIG // cC52ZXJpc2lnbi5jb20wPwYIKwYBBQUHMAKGM2h0dHA6
// SIG // Ly9DU0MzLTIwMDQtYWlhLnZlcmlzaWduLmNvbS9DU0Mz
// SIG // LTIwMDQtYWlhLmNlcjAfBgNVHSMEGDAWgBQI9VHo+/49
// SIG // PWQ2fGjPW3io37nFNzARBglghkgBhvhCAQEEBAMCBBAw
// SIG // FgYKKwYBBAGCNwIBGwQIMAYBAQABAf8wDQYJKoZIhvcN
// SIG // AQEFBQADggEBAL0KdwtCSpfwuquQVUPhWuL7UR2IkRqT
// SIG // XSynUXRPjWN72DhxbWiX96DZCxozSTJFsHVwWNfXFYy2
// SIG // fZTIr93UoLnF4LCU4MjQSU8aV7uGR5oqb6h8Mhia9no/
// SIG // 7sbajf6HYMRtTUi4aGZDJZl/Ne/gf/snX7OgJkdtr/JT
// SIG // heASE7LHB9P6vxrFxXodtUulzu9nS1fTzoQnF8DtMtuU
// SIG // vQGCP0N2Jbf0DJFYWLHj3yypPrbcfBHl5X0e4VW/G4sT
// SIG // g5hccQsSWJ0tqAYXSC6+eVhekYAgKWn2xv5jgn7avfZo
// SIG // PEqm5yIqpMRFTvGGnWugm01P0yrFw5x2i5jouVCiskRL
// SIG // DZ0xggPlMIID4QIBATCByTCBtDELMAkGA1UEBhMCVVMx
// SIG // FzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL
// SIG // ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQL
// SIG // EzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVy
// SIG // aXNpZ24uY29tL3JwYSAoYykwNDEuMCwGA1UEAxMlVmVy
// SIG // aVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBD
// SIG // QQIQN2qihWynr/+xl9Fg7r+K2TAJBgUrDgMCGgUAoHAw
// SIG // EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwG
// SIG // CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
// SIG // AQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFEaGy4fvJJ7E
// SIG // YqxuKm21TW6wiYUnMA0GCSqGSIb3DQEBAQUABIGAKCue
// SIG // wL4o+kGzBW8/zc8fPPRdq+TVc4AXvNYTnsre7y5wtrRX
// SIG // jP3k+SYgUUSJ1lltrRSYSLQnSwNLAKBUCqG1DqYdUg57
// SIG // SrRQcgvv2tL7drZePDL4zCfMyR5Z7/4wwL+/1e0e8Jzc
// SIG // sukOql3EBTYxEVwQ9KOL5DgrftvgNUntm9ahggH/MIIB
// SIG // +wYJKoZIhvcNAQkGMYIB7DCCAegCAQEwZzBTMQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // KzApBgNVBAMTIlZlcmlTaWduIFRpbWUgU3RhbXBpbmcg
// SIG // U2VydmljZXMgQ0ECEA3pK/DU2CmIGDIFCV6adogwDAYI
// SIG // KoZIhvcNAgUFAKBZMBgGCSqGSIb3DQEJAzELBgkqhkiG
// SIG // 9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTA2MTEyNDAzMjk0
// SIG // OVowHwYJKoZIhvcNAQkEMRIEEIzbFukPI4dKEKEpuA7d
// SIG // lLMwDQYJKoZIhvcNAQEBBQAEggEAGWnpwqGmbz6xcLep
// SIG // hkXt2Jor93NKUsiWARZVMqMvUKpFBm96am1fiuoIpzaD
// SIG // xhMDK5RsZ4wG0ATST0IsCySYecvyib8xUNs/l3+JNMJL
// SIG // j2yDMS28wwANwXC6qkY/MPsNAOoZegMmR7SlczvKOri7
// SIG // PcnK8QZMuXeq0KggKw7VGlbnakSFmQ3TYxwRpEPONHCY
// SIG // TD0qUmtgye7YCjg8hWm3p9wuoYZ/+4brRWVph2G4apGk
// SIG // 2CYpzONPltfbq1a4w+qifmWP9zKKuX4+36C4nNBp6HhL
// SIG // p22PbqNnoXI+wmBhxLGEh4Q1IYcVX+Bm8XuYQkT1ETLk
// SIG // xrF7VKKBnIrgAIYJAQ==
// SIG // End signature block
