/*******************************************************************************
 * Copyright (c) 2004,2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *      2005/11/25 - updated by Jiang LinQuan(IBM Corp.) for uat4i00000041
 *******************************************************************************/
package org.eclipse.core.internal.registry;

/**
 * An object which has the general characteristics of all the nestable elements
 * in a plug-in manifest.
 */
public abstract class RegistryObject implements KeyedElement {
	//Object identifier
	private int objectId = RegistryObjectManager.UNKNOWN;
	//The children of the element
	protected int[] children = RegistryObjectManager.EMPTY_INT_ARRAY;
	//The position of the extra data when available
	protected int extraDataOffset = -1;

	void setRawChildren(int[] values) {
		children = values;
	}

	//This can not return null. It returns the singleton empty array or an array 
	// uat4i00000041 just make this method public
	public int[] getRawChildren() {
		return children;
	}

	// end of uat4i00000041

	void setObjectId(int value) {
		objectId = value;
	}

	int getObjectId() {
		return objectId;
	}

	//Implementation of the KeyedElement interface
	public int getKeyHashCode() {
		return objectId;
	}

	public Object getKey() {
		return new Integer(objectId);
	}

	public boolean compare(KeyedElement other) {
		return objectId == ((RegistryObject) other).objectId;
	}

}
