//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//==================================================================
   
var odc_pingInterval = 0;
var odc_pingIntervalMinut = 0;
var odc_inactive = false;
var odc_isEanbled = false;
var odc_url = null;
var odc_style_url = null;
var odc_timestamp_last_activity = null;

/* JRLI Public
 * This function is used to configure JSL session controller with parameters passed in.
 * @param pingInterval This is the interval (in minutes) in which the session controller will ping the server.
 * @isEanbled The boolean flag to enable or disable session controller.
 * @param pingUrlPrefix The prefix is used to cancanate with a JSP page name to ping the server.
 * @param styleUrlPrefix The prefix is used to cancanate with a css file name to format the dialog box.
 */
function sessionControllerInit(/*int in mimutes*/ pingInterval, /*boolean*/ isEanbled, /*string*/ pingUrlPrefix, /*string*/ styleUrlPrefix)
{
   
   odc_pingIntervalMinut = pingInterval;
   //Convert to milliseconds for setTimeout()
   odc_pingInterval = pingInterval*60*1000;
   odc_isEanbled = isEanbled;
   pingUrlPrefix = checkForwardSlash(pingUrlPrefix);
   odc_url = pingUrlPrefix + "odc_iframe.jsp";
   styleUrlPrefix = checkForwardSlash(styleUrlPrefix);
   odc_style_url = styleUrlPrefix + "sessionCtrlDialog.css";
   
}

/* JRLI Public
 * This function is used to enable JSL session controller.
 */
function enableSessionController()
{
   odc_isEanbled = true;  
}

/* JRLI Public
 * This function is used to disable JSL session controller.
 */
function disableSessionController()
{
   odc_isEanbled = false;  
}

/* JRLI Private
 * This function is used to ping the server using the url passed in to 
 * force the server to keep our session alive.
 */
function pingServer()
{
      
   Log.debug("odcSessionController.js.pingServer()", "entering odc_url:" + odc_url);
   
   //look for an element by id:ODC_PINGIFRAME
   var pingIFrame = document.getElementById("ODC_PINGIFRAME");

   //If the iFrame is found
   if(pingIFrame != null)
   {
      //just use it, do nothing
      Log.debug("odcSessionController.js.pingServer()", "ODC_PINGIFRAME is found");
   }
   //we have to create one and make it invisibe
   else
   {
      Log.debug("odcSessionController.js.pingServer()", "ODC_PINGIFRAME is not found");
      pingIFrame = document.createElement("iframe");
      pingIFrame.setAttribute("id","ODC_PINGIFRAME");
      //pingIFrame.style.display ="none"; 

      //Append this iFrame to the html body
      document.body.appendChild(pingIFrame);
   }
   pingIFrame.setAttribute("src",odc_url);

   Log.debug("odcSessionController.js.pingServer()", "exiting");
        
}


/* JRLI Public
 * This function is used to start JSL session controller.
 */
function startPing()
{
   Log.debug("odcSessionController.js.startPing()", "entering");
   
   //Initialize this varible
   odc_timestamp_last_activity = new Date();
   
   setTimeout("processPing()", odc_pingInterval);

   Log.debug("odcSessionController.js.startPing()", "exiting");
}

/* JRLI Private
 * This function is used to set up timeout based on parameters passed in during configuration.
 * This function will be called recursively until the maximum count is reached.  Before the maximum count is reached, 
 * a dialog box will be presented to the user. The user can click a button within the last period of pingInterval 
 * to keep the session alive for another period of maxAliveTime.  
 */
function processPing()
{
   Log.debug("odcSessionController.js.processPing()", "entering");
     
   //check for isEnabled and check for activity
   if(odc_isEanbled == false || odc_inactive == true)
   {
      Log.debug("odcSessionController.js.processPing()", "odc_isEanbled:" + odc_isEanbled + " odc_inactive: " + odc_inactive);
      return;
   } 
   else
   {       
     
      //Ping the server that keep the session alive
      pingServer();
      
      //If the user has no activity on the browser window for more than a pingInterval
      //we will display a warning
      if((new Date().getTime()- odc_timestamp_last_activity.getTime()) >= odc_pingInterval)
      {
         displayWarningDialog();
         odc_inactive = true;
         Log.debug("odcSessionController.js.processPing()", "inside activity check" + " odc_inactive: " + odc_inactive);
      }

      Log.debug("odcSessionController.js.processPing()", "after check" + " odc_inactive: " + odc_inactive);

      setTimeout("processPing()", odc_pingInterval);

   } 
   Log.debug("odcSessionController.js.processPing()", "exiting");
}

/* JRLI Private
 * This function is used to construct a warning dialog box which will be displayed
 * before the maximumAlive time is reached.
 */
function displayWarningDialog()
{
   Log.debug("odcSessionController.js.displayWarningDialog()", "entering");

   //open a new window, display a warning message.
   //if a user click the button, it will reset the maxCount
   //if the user has no response, the session will be timeouted after the last delay.
   var width =250;
   var height= 160;
   var x =(screen.availWidth-width)/2;
   var y =(screen.availHeight-height)/2;
   var style= "width=" + width +",height=" + height + ",status=no,resizable=no,location=no";
   var dialog = window.open("","ODCDialog", style);
   dialog.moveTo(x,y);
   dialog.focus();

   //Get NLS strings for these messages
   var warningStr = NlsFormatMsg(odc_session_expire_warning, [odc_pingIntervalMinut]);
   var okStr = NlsFormatMsg(odc_session_ok_button, null);
   var warningStr1 = NlsFormatMsg(odc_session_expired_warning, null);
   var title = NlsFormatMsg(odc_session_dialog_title, null);
   
   //create some JS code, so this new window can communicate the status back to the main window
   var jsCode =  "<script type=\"text/javascript\">"
                + "function resetMaxCount()"
                + "{"
                +    "window.opener.odc_inactive = false;"
                +    "window.close();"
                + "} "
                + "function replaceMsg()"
                + "{"
                +    "var newWarningStr =\"" + warningStr1 + "\";"
                +    "var td = document.getElementById(\"WARDINGSTR\");"
                +    "newTxtNode = document.createTextNode(newWarningStr);"
                +    "var kids = td.childNodes;"
                +    "for(var i=0; i<kids.length; i++)"
                +    "{"
                +       "var kid = kids[i];" 
                +       "if(kid.nodeType == 3)" 
                +       "{" 
                +           "kid.parentNode.replaceChild(newTxtNode, kid);"
                +           "return;"
                +       "}"   
                +    "}"  
                + "} "
                + "setTimeout(\"replaceMsg()\"," + odc_pingInterval + "); "
                + "</script>";
                
   var jsPage = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
                +"<html><head><title>" + title +"</title>"
                +"</head>"
                +"<link rel=\"stylesheet\" href=\""+ odc_style_url +"\">"
                +"<body>"
                +"<form> <table> <tr> <td id=\"WARDINGSTR\" class=\"warningMsg\">" + warningStr + "</td> </tr>"
                +"<tr> <td> <spacer type=block width=100 height=100> </td></tr>"
                +"<tr> <td align=\"middle\"> <input type=\"submit\" width=80 Value=\"" 
                   + okStr+ "\" onClick=\"return resetMaxCount()\" class=\"buttonStr\"> </td> </tr>"
                +"</table> </form>";
   dialog.document.write(jsPage);
   dialog.document.write(jsCode);
   dialog.document.write("</body></html>");

   Log.debug("odcSessionController.js.displayWarningDialog()", "exiting");

}

/* JRLI Private
 * This function is used to check a browser type
 * on the browser window.
 */
function isIE()
{
   if(navigator.appName == 'Microsoft Internet Explorer')
   {
      return true;
   }
   else
   {
      return false;
   }
}

//If it is NetScape, capture events differently
if (isIE() == false)
{
   window.captureEvents(Event.KEYDOWN);
   window.captureEvents(Event.MOUSEDOWN);
} 

document.onkeypress = checkEvent;
document.onmousedown= checkEvent;

/* JRLI Private
 * This function is used to record a timestamp at which a user has any activity
 * on the browser window.
 */
function checkEvent()
{
   Log.debug("odcSessionController.js.checkEvent()", "entering");
 
   //Record a timestamp everytime we have an event
   //this is too expensive, we need to optimize it
   odc_timestamp_last_activity = new Date();

   Log.debug("odcSessionController.js.checkEvent()", "exiting");
}








