// progressbar.js
var ODCProgressBar = new ProgressBar();


function ColorHolder(row){
	this.row = row;
	this.changeColor = function(){
		var saveColor = row.cells[0].bgColor;
		for(var i=0; i<row.cells.length; i++){
			if(i==0){
				row.cells[i].bgColor = row.cells[row.cells.length-1].bgColor;
			}
			else{
				var tempColor = row.cells[i].bgColor;
				row.cells[i].bgColor = saveColor;
				saveColor = tempColor;
			}
		}	
	}
}

function ProgressBar(colorArray) {
	
	this.div = null;
	this.table = null;
	this.message = null;
	this.holder = null;
	if(colorArray != null && colorArray != "undefined" && colorArray.length != 0){
		this.colorArray = colorArray;
	}
	else{
		//this.colorArray = ["#ffccff","#ff99ff","#ff66ff","#ff33ff","#ff00ff","#cc00cc","#990099","#660066","#000033"];
		this.colorArray = ["#6666ff","#3333ff","#0066ff","0066cc"];
	}
	
	
	this.setVisible = function(){		
		if(document.forms != null && document.forms !='undefined' && document.forms.length != 0){
			this.div = document.forms[0].appendChild(document.createElement("div"));
		}
		else {
			this.div = document.body.appendChild(document.createElement("div"));
		}		
		
		//from jslutil
		var sizeArr = getWindowSize();
		this.div.style.position = "absolute";
		this.div.style.width = Math.round(sizeArr[0]/3);
		this.div.style.height = Math.round(sizeArr[1]/4);
		this.div.style.left = Math.round((sizeArr[0]/2)-(sizeArr[0]/6));
		this.div.style.top = Math.round((sizeArr[1]/2)-(sizeArr[1]/8));
		this.div.style.zIndex = 1;
		this.div.style.visibility = "visible";
		var formatTable = this.div.appendChild(document.createElement("table"));
		formatTable.bgColor="white";
		formatTable.width = this.div.style.width;
		formatTable.border = 5;
		formatTable.cellPadding = 0;
		formatTable.cellSpacing = 5;
		formatTable.appendChild(document.createElement("tbody"));
		var row1 = formatTable.tBodies[0].appendChild(document.createElement("tr"));
		var td = row1.appendChild(document.createElement("td"));
		td.align = "center";
		td.valign = "middle";
		td.height = 30;
		td.innerHTML = progressbar_header;
		var row2 = formatTable.tBodies[0].appendChild(document.createElement("tr"));
		var td2 = row2.appendChild(document.createElement("td"));
		td2.align = "center";
		td2.valign = "middle";
		this.table = td2.appendChild(document.createElement("table"));
		this.createBar(Math.round(sizeArr[0]/3));
		var row3 = formatTable.tBodies[0].appendChild(document.createElement("tr"));
		var th3 = row3.appendChild(document.createElement("th"));
		th3.align = "center";
		th3.valign = "middle";
		th3.height = 30;
		var statusTable = th3.appendChild(document.createElement("table"));
		statusTable.appendChild(document.createElement("tbody"));
		statusTable.tBodies[0].appendChild(document.createElement("tr"));
		var staticTd = statusTable.tBodies[0].rows[0].appendChild(document.createElement("td"));
		staticTd.innerHTML =status_string;
		this.message = statusTable.tBodies[0].rows[0].appendChild(document.createElement("td"));
	}
	
	
	this.hide = function(){
		this.div.style.visibility = "hidden";
	}
	
	this.setStatus = function(mess){
		if(this.isVisible() && this.message != null){
			this.message.innerHTML = mess;
		}
	}
	
	this.createBar = function(width){
		this.table.width = width;
		this.table.height = 20;
		this.table.cellPadding = 0;
		this.table.cellSpacing = 0;
		this.table.border = 0;
		this.table.appendChild(document.createElement("tbody"));
		var tr = this.table.tBodies[0].appendChild(document.createElement("tr"));
		for(var i=0; i<this.colorArray.length; i++){
			var color = this.colorArray[i];
			var td = tr.appendChild(document.createElement("td"));		
			td.bgColor = color;
		}
	}
	
	this.getRow = function(){
		return this.table.tBodies[0].rows[0];
	}
	
	this.startLoadModel = function(modelName){
		this.setStatus(NlsFormatMsg(start_load_model, this.createArgs(modelName)));
	}
	
	this.endLoadModel = function(modelName){
		this.setStatus(NlsFormatMsg(end_load_model, this.createArgs(modelName)));
	}
	
	this.startLoadDataInstance = function(modelName){
		this.setStatus(NlsFormatMsg(start_load_instance, this.createArgs(modelName)));
	}
	
	this.endLoadDataInstance = function(modelName){
		this.setStatus(NlsFormatMsg(end_load_instance, this.createArgs(modelName)));
	}
	
	this.startRenderControl = function(ctrlName){
		this.setStatus(NlsFormatMsg(start_render_control, this.createArgs(ctrlName)));
	}
	
	this.endRenderControl = function(ctrlName){
		this.setStatus(NlsFormatMsg(end_render_control, this.createArgs(ctrlName)));
	}
	
	this.isVisible = function(){
		return ((this.div != null) && (this.div.style.visibility == "visible"));
	}
	
	this.createArgs = function(value){
		var args = new Array;
		args[0] = value;
		return args;
	}
}