//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//==================================================================

//
// Private 
// SchemaLoader  
//
function JSchemaLoader(urlSchema)
{
	this.Objects = new Array();	
			
	this.CreateModelFromSchema = function(urlSchema)	// private
	{
		if (null == urlSchema)
			return null;
			
		var xmlDoc = LoadXML(urlSchema);
		if (null == xmlDoc)
			return null;
			
		this.Objects = new Array();		
		schema = new XMISchema(xmlDoc);	
		var root = new EClass("ROOT"); 
		for (var i = 0; i < schema.XSDElements.length; ++i) {
			var xsdElement = schema.XSDElements[i];
			var reference = this.LoadEReferenceFromSchema(xsdElement);
			reference.setContainment(false);
			reference.setLowerBound(0);	
			reference.setUpperBound(-1);
			root.getEAllReferences().add(reference);
		}
				
		return root;
	}

	this.LoadEReferenceFromSchema = function(xsdElement,minOccurs,maxOccurs) // private
	{
		var reference = new EReference(xsdElement.Name,null);
		if (xsdElement.MinOccurs != null)
			minOccurs = xsdElement.MinOccurs;
			
		if (xsdElement.MaxOccurs != null)
			maxOccurs = xsdElement.MaxOccurs;	
			
		if (minOccurs != null)
			reference.setLowerBound(minOccurs * 1);
				
		if (maxOccurs != null) {	
			if ("unbounded" == maxOccurs) 	
				reference.setUpperBound(-1);
			else
				reference.setUpperBound(maxOccurs * 1);
		}
				
		if (null == xsdElement.XSDComplexType)
			return reference;

		for (var i = 0; i < this.Objects.length; ++i) {
			if (this.Objects[i].Name == xsdElement.XSDComplexType.Name) {
				reference.EClass = this.Objects[i];
				break;
			}	 
		}
		if (null == reference.getEReferenceType()) {
			reference.EClass = new EClass(xsdElement.XSDComplexType.Name);
			this.Objects[this.Objects.length] = reference.getEReferenceType();
		}
		
		for (var i = 0; i < xsdElement.XSDComplexType.XSDChoiceOrSequences.length; ++i) {
			var xsdChoiceOrSequence = xsdElement.XSDComplexType.XSDChoiceOrSequences[i];
			
			for (var j = 0; j < xsdChoiceOrSequence.XSDElements.length; ++j) {
				if (xsdChoiceOrSequence.XSDElements[j].Name != null) {
					var ref = this.LoadEReferenceFromSchema(xsdChoiceOrSequence.XSDElements[j],
													xsdChoiceOrSequence.MinOccurs,xsdChoiceOrSequence.MaxOccurs);
					reference.setContainment(true);								
					reference.getEReferenceType().getEAllReferences().add(ref);
				}							
			}	
		}
		
		for (var i = 0; i < xsdElement.XSDComplexType.XSDAttributes.length; ++i) {
			var xsdAttribute = xsdElement.XSDComplexType.XSDAttributes[i];
			var name = xsdAttribute.Name;
			if (null == name) 
				name = xsdAttribute.Ref;
				
			var type = xsdAttribute.BaseType;
			if (null == type) {
				type = xsdAttribute.Ref;
				var index = type.indexOf(":");
				if (index != -1)
					type = type.substring(index+1,type.length);
			}	
			if (type == "IDREFS" || type == "IDREF") {
				var ref = new EReference(name,null);
				if (type == "IDREFS") 
					ref.setUpperBound(-1);
					
				ref.setContainment(false);
				reference.getEReferenceType().getEAllReferences().add(ref);	
			}
			else 
				reference.getEReferenceType().getEAllAttributes().add(new EAttribute(name,type));
		}
		
		return reference;
	}
	
	this.EClass = this.CreateModelFromSchema(urlSchema); // public
}

//
// Private 
// XMISchema Object 
//
function XMISchema(xmlDoc)
{
	this.NODE_ELEMENT  = 1;
	this.XSDNS = "http://www.w3.org/2001/XMLSchema";
	this.XSDElements = new Array();	// private
	
	var xsdComplexTypes = new Array(); 
	var element = xmlDoc.documentElement;
	if (null == element)
		return;
			
	for (var i = 0; i < element.childNodes.length; ++i) {
		var node = element.childNodes[i];
		if (node.nodeType == this.NODE_ELEMENT) {
			var name = node.nodeName;
			var index = name.indexOf(":");
			if (index != -1)
				name = name.substring(index+1,name.length);
				
			if ("element" == name) 
				this.XSDElements[this.XSDElements.length] = new XSDElement(node);
			else
			if ("complexType" == name) 
				xsdComplexTypes[xsdComplexTypes.length] = new XSDComplexType(node);
		}	
	}
	
	for (var i = 0; i < xsdComplexTypes.length; ++i) 
		xsdComplexTypes[i].ResolveElementTypes(xsdComplexTypes);
		
	for (var i = 0; i < this.XSDElements.length; ++i) 
		var elem = this.XSDElements[i].ResolveElementType(xsdComplexTypes);
		
	
	this.FindXSDElement = function(name)
	{
		for (var i = 0; i < this.XSDElements.length; ++i) {
			if (this.XSDElements[i].Name == name)
				return this.XSDElements[i];
		}
		return null;
	}		
}

//
// Private 
// XSDComplexType Object 
//
function XSDComplexType(element)
{
	this.NODE_ELEMENT  = 1;
	this.Name = element.getAttribute("name");
	this.XSDChoiceOrSequences = new Array();	// private
	this.XSDAttributes = new Array();	// private
	
	for (var i = 0; i < element.childNodes.length; ++i) {
		var node = element.childNodes[i];
		if (node.nodeType == this.NODE_ELEMENT) {
			var name = node.nodeName;
			var index = name.indexOf(":");
			if (index != -1)
				name = name.substring(index+1,name.length);
				
			if ("choice" == name || "sequence" == name) 
				this.XSDChoiceOrSequences[this.XSDChoiceOrSequences.length] = new XSDChoiceOrSequence(name,node); 
			else
			if ("attribute" == name)  
				this.XSDAttributes[this.XSDAttributes.length] = new XSDAttribute(node); 
		}	
	}	
	
	this.ResolveElementTypes = function(xsdComplexTypes)
	{
		for (var i = 0; i < this.XSDChoiceOrSequences.length; ++i)
			this.XSDChoiceOrSequences[i].ResolveElementTypes(xsdComplexTypes);
	}
	
	this.FindXSDElement = function(name)
	{
		for (var i = 0; i < this.XSDChoiceOrSequences.length; ++i) {
			var e = this.XSDChoiceOrSequences[i].FindXSDElement(name);
			if (e != null)
				return e;
		}	
		return null;
	}
	
	this.FindAttribute = function(name)
	{
		for (var i = 0; i < this.XSDAttributes.length; ++i) {
			if (this.XSDAttributes[i].Name != null && this.XSDAttributes[i].Name != "") { 
				if (this.XSDAttributes[i].Name == name) 
					return this.XSDAttributes[i];
			}
			else {
				if (this.XSDAttributes[i].Ref == name) 
					return this.XSDAttributes[i];
			}
		}				
		return null;
	}
}	

//
// Private 
// XSDChoiceOrSequence Object 
//
function XSDChoiceOrSequence(type,element)
{
	this.NODE_ELEMENT  = 1;
	this.type = type;
	this.MinOccurs = element.getAttribute("minOccurs");
	this.MaxOccurs = element.getAttribute("maxOccurs");
	this.XSDElements = new Array();	// private
	
	for (var i = 0; i < element.childNodes.length; ++i) {
		var node = element.childNodes[i];
		if (node.nodeType == this.NODE_ELEMENT) {
			var name = node.nodeName;
			var index = name.indexOf(":");
			if (index != -1)
				name = name.substring(index+1,name.length);
				
			if ("element" == name) {
				var e = new XSDElement(node); 
				this.XSDElements[this.XSDElements.length] = e;
			}
		}	
	}
	
	this.ResolveElementTypes = function(xsdComplexTypes)
	{
		for (var i = 0; i < this.XSDElements.length; ++i) 
			this.XSDElements[i].ResolveElementType(xsdComplexTypes);
	}	
	
	this.FindXSDElement = function(name)
	{
		for (var i = 0; i < this.XSDElements.length; ++i) {
			if (this.XSDElements[i].Name == name)
				return this.XSDElements[i];
		}	
		return null;
	}
}

//
// Private 
// XSDElement Object 
//
function XSDElement(element)
{
	this.Name = element.getAttribute("name");
	this.MinOccurs = element.getAttribute("minOccurs");
	this.MaxOccurs = element.getAttribute("maxOccurs");
	this.Type = element.getAttribute("type");
	this.XSDComplexType = null;
	this.Ref = element.getAttribute("ref");
	
	this.ResolveElementType = function(xsdComplexTypes)
	{
		for (var i = 0; i < xsdComplexTypes.length; ++i) {
			if (xsdComplexTypes[i].Name == this.Type) {
				this.XSDComplexType = xsdComplexTypes[i];
				break;
			}
		}
	}
	
	this.FindXSDElement = function(name)
	{
		if (this.XSDComplexType != null)
			return this.XSDComplexType.FindXSDElement(name);
			
		return null;
	}	
	
	this.FindAttribute = function(name)
	{
		if (this.XSDComplexType != null)
			return this.XSDComplexType.FindAttribute(name);
			
		return null;
	}	
}

//
// Private 
// XSDAttribute Object 
//
function XSDAttribute(element)
{
	this.Name = element.getAttribute("name");
	this.Type = element.getAttribute("type");
	this.Use = element.getAttribute("use");
	this.Ref = element.getAttribute("ref");
	this.BaseType = this.Type;
	if (this.BaseType != null) {  
		var index = this.BaseType.indexOf(":");
		if (index != -1) 
			this.BaseType = this.BaseType.substring(index+1,this.BaseType.length);
	}
	this.XSDElement = null;
}