//==================================================================
// Licensed Materials - Property of IBM
// (c) Copyright IBM Corp. 2003.  All rights reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with IBM
// Corp.
//
// DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
// sample code created by IBM Corporation.  This sample code is
// not part of any standard or IBM product and is provided to you
// solely for the purpose of assisting you in the development of
// your applications.  The code is provided "AS IS", without
// warranty of any kind.  IBM shall not be liable for any damages
// arising out of your use of the sample code, even if they have
// been advised of the possibility of such damages.
//=================================================================
/**
 * @class public TabAdapter
 * This adapter interfaces with the Tab Control object, and is bound to it at runtime.
 * This constructor will initialize the TabAdapter with it's corresponding tab control
 * @constructor TabAdapter
 * @param tabControl tabCtrl
 *		The tabControl which the tab adapter want to bind.
**/


function TabAdapter(tabCtrl) {

	this.tabControl = tabCtrl;
	this.preDefinedTabs = true; // flag to see if tabs+layout defined by user
	this.activeTab = "1"; // index of Tab that is in current scope
	this.activeTabContentChange = true; // flag indicating of model tab content has been modified
	this.tabContent = new Array(); // latest copy of model data, stored in local array
	this.xmiLoader = null; // loader to deserialize xmi reprentation of object, construct ECore model
	this.activeEobjects = new Array();
	this.activeBinders = new Array();
	this.binderCount = 0;
	this.modelUpdateBinder;
	this.tabMap = null;

	this.eclassroot = null;
	this.xmiUrl;
	this.xmiSchemaUrl;


/**
* @method public setModelSchema
*   Method to set the the shema which the tab control will render
* @param EClass eclass
*   The schema which the tab control will render
**/
	this.setModelSchema = function(eclass) {

		this.eclassroot = eclass;
	}

/**
* @method public setXMIUrl
*   Method to set the the data model which the tab control will render
* @param EObject model
*   The data model which the tab control will render
**/
	this.setXMIUrl= function(model) {

		xmiUrl = model;
	}


/**
* @method private setActiveTab
*   Method to acknowledge that a new tab is now active, and the older one (if any) is now invalid.
* @param int tabNo
*   The number of the tab which will be active.
**/
	this.setActiveTab = function(tabNo) {

		this.activeTab = tabNo;
		this.activeTabContentChange = true;

		// unbind all property binders associated with the old tab
		this.unbindAll();
	}

/**
* @method private generateTable
*   Method to getnerate a new layer of tab
* @return HTMLDivElement divElement
*   The new created html div object
**/
	this.generateTable = function() {

		var tableElement = document.createElement("table");
		var tbodyElement = document.createElement("tbody");
		// pages dont' exist; create default tabs
		for (var i = 0; i < this.tabContent.length; i++) {

			// setting this attribute is a prerequisite in employing a tab control
			var trElement = document.createElement("tr");
			var tdElement1 = document.createElement("td");
			var tdElement2 = document.createElement("td");
			var name = this.tabContent[i][0];
			var value = this.tabContent[i][1];
			var id = this.tabContent[i][0];
			tdElement1.appendChild(document.createTextNode(name));
			var inputElement = document.createElement("input");
			inputElement.name = name;
			inputElement.value = value;
			inputElement.id = id;
			tdElement2.appendChild(inputElement);
			trElement.appendChild(tdElement1);
			trElement.appendChild(tdElement2);
			tbodyElement.appendChild(trElement);
		}
		tableElement.appendChild(tbodyElement);
		var divElement = document.createElement("div");
		divElement.appendChild(tableElement);
		return divElement;

	}


/**
* @method public bind
*   Function to construct the data structure which will be used to populate the tab.
**/
	this.bind = function() {

		if (null == eclassroot){
			var Msg = NlsFormatMsg(missing_model, null);
			Log.error("tabadapter.bind", Msg);
			throw new EObjectError(Msg);

		}

		this.xmiLoader = new XMILoader(eclassroot);

		// initialize xmi loader
		this.xmiLoader.LoadXMI(xmiUrl);




		// see if the TabArray has been populated
		if (this.tabControl.TabArray.length == 0 ) {

			//this loop will go through all the tabs needed as inferred from the length of the tabMap,
			// and will attempt to autogenerate layouts for them all
			for(var j = 0; j < this.tabMap.length; j++) {

				this.setActiveTab(j+1);
				this.activeEobjects = this.getActiveEobjects();
				this.getTabData(this.activeTab);
				var divElement = this.generateTable();
				this.tabControl.containerDiv.parentElement.appendChild(divElement);
				this.tabControl.setTabPage(eval(j+1), divElement, "Tab "+eval(j+1));


			}

		}

		this.setActiveTab(this.tabControl.selectedTab);

		this.activeEobjects = this.getActiveEobjects();

		this.getTabData(this.activeTab);

	}
/**
* @method public refresh
*   Function to get the current activate EOjbect and construct the data structure which
*	will be used to repopulate the tab.
**/
	this.refresh = function() {

		// obtain array of all eobjects associated with the current active tab
		this.activeEobjects = this.getActiveEobjects();
		this.tabContent = new Array();

		// populate the tabContent array with name,value pairings from the eobjects
		this.getTabData(this.activeTab);

	}

	// method to return an array of eobjects for the active tab, as found from the mapping
	this.getActiveEobjects = function() {

		//document.write("<p> tab = "+ activeTab + "</p>");

//Alert to show document skeleton, prior to population with content
//alert("skeleton document");

		// Obtain the root child at the index specified, if valid,
		//	which will be used to populate the tree (if invalid, use 0)

		// access the mapping array to find the set of user-defined xmi ids for the tab
		var xmiIDs = this.tabMap[this.activeTab-1];
		var activeObjectArray = new Array();
		// check to see if the requested tab did not map to any tab content
		if(null == xmiIDs) {
			// just return the existing array
			return activeObjectArray ;
		}


		for (var i = 0; i < xmiIDs.length; i++) {

			// Access the xmiLoader to gain access to all the eobjects
			var xmiObjectArray = this.xmiLoader.Root.GetChildrenEObjects(true);

			// search: find the EObjects relevant to this tab
			for (var j = 0; j < xmiObjectArray.length; j++) {

				if (xmiIDs[i] == xmiObjectArray[j].ID) {
					activeObjectArray[activeObjectArray.length] = xmiObjectArray[j];
					break; // terminate search upon obtaining the required EObject
				}

			}

		}

		// return the populated array
		return activeObjectArray;


	}


/**
* @method private getTabData
*   Function to construct data structure for that particular tab which is specified by tabIndex
* @param int tabIndex
*	it is used to idetify which tab is worked on.
**/
	this.getTabData = function(tabIndex) {


//		if (tabIndex != this.activeTab) {

			// force a tab refresh here?
				// set the tab to be brand new

				// access XMIloader to obtain the new tab

				//		eg.	xmiLoader.Root.GetCar(), "available", document.getElementById("AVAILABLE"), "value", "onchange"

				// set tabContentArray with the new model fragment
				//populateTabArray(activeEobject);

//		} else {

			// working with the same tab. check for model content change

			if (this.activeTabContentChange) {
				// active Tab content has changed;
				// access XMI model in memory, and
				// populate the tabArray with the eobject
				this.tabContent = new Array();
				this.activeEobjects = this.getActiveEobjects();
				this.populateTabArray(this.activeEobjects);

				// reset change flag
				this.activeTabContentChange = false;
				//document.writeln("tabContent.length = " + tabContent.length );
			} else {
				// nothing has changed; work off the local copy of the model content


			}

//		}

		// loop to go through the tabContent array, and see
		//return tabContent;

	}

/**
* @method private populateTabArray
*   Function to populate data structure based on the passed in EObject array
* @param Array eobjectArray
* 	The EObject array to populate the tab.
**/
	this.populateTabArray = function(eobjectArray) {

		// go through the Eobject, and construct an array of all the necessary tab values

		// put tab name into index 0 of tabContent array
		for	(var j = 0; j < eobjectArray.length; j++) {

			this.getObjectMembers(eobjectArray[j]);

		}
	}
/**
* @method private getObjectMembers
*   Function to get the memeber from the the passed in EObject
* @param Array eobject
* 	The EObject to get the member data
**/
	this.getObjectMembers = function(eobject) {

		// [name, value] for all remaining properties. (this will, in effect, flatten the object tree)
		var membersArray = eobject.Members;

		if (membersArray != null) {
			for (var i = 0; i < membersArray.length; ++i) {

				var member = eobject.Members[i];
				var eobjInstance;

				if (member != null) {

					// member can either be an array; another object
					var name = member.Name
					var value = member.Value;
					if (null == value) {
						continue;
					}

					if ("object" == typeof(value)) {
						if (null == value.length) {
							this.getObjectMembers(value);
						} else {
							this.populateTabArray(value);
						}
					} else {

						// Put Member name, value into the tabContent array
						this.tabContent[this.tabContent.length] = new Array();
						this.tabContent[this.tabContent.length-1][0] = name;
						this.tabContent[this.tabContent.length-1][1] = value;
						this.tabContent[this.tabContent.length-1][2] = eobject;
					}


				} else {

					// value is null;
					//tabContent = new Array();

				}

			}
		}

	}


/**
* @method private getValue
*   Enables client to get value of a known attribute;
* @param EObject name
* 	The EObject used to get the value from the name
* @param String element
*	The name of the attribute
**/
	this.getValue = function(name, element) {

		if (this.activeTabContentChange) {
			// the tab content has changed; get a refresh from the model
			this.getTabData(this.activeTab);
			this.activeTabContentChange=false;
		}

		// at this point, latest model content is in the tabContent array.


		for (var i = 0; i < this.tabContent.length; i++) {

			if (this.tabContent[i][0] == name) {


				// attach property binder

				try {
					this.activeBinders[this.binderCount] = new PropertyBinder(this.tabContent[i][2], name, element, "value", "onchange");
					this.activeBinders[this.binderCount].DataBind();
					this.binderCount++;

				} catch (e) {

					alert(e.description);

				}

				return this.tabContent[i][1];

			} else {
				continue;
			}

			return "undefined";

		}

	}
/**
* @method private unbindAll
*   This method is used to seperate the model from the control
**/
	this.unbindAll = function() {

		for (var i = 0; i < this.activeBinders.length; i++) {

			this.activeBinders[i].DataUnbind();

		}
		this.activeBinders = new Array();
		// reset bindercount
		this.binderCount = 0;
	}


/**
* @method private setMap
*	This method would be called immediately after adapter initialization.
*	The tab mapping is a structure which maps the ordering of the tabs
*	(eg. Tab 1, Tab 2, Tab 3), to eobjects in the Ecore model.
*	The user defines the mapping by populating an array element
*	(corresponding to the tab index) with the eObject name.
* @param Array mappingArray
* 	The array which maps the order of the tabs to eobjects in the Ecore model.
**/
	this.setMap = function(mappingArray) {

		this.tabMap = mappingArray;

	}


}

/**
* @method private ModelBinder
*	This method is used to tell tab adapter that model data is changed
* @param Object tabAdapter
* 	The adapter of tab
**/
function ModelBinder(tabAdapter) {

	var adapter = tabAdapter;

	function FireValueChanged(name,value) {

		adapter.activeTabContentChange = true;

	}

}
/**
* @method private TabContentStore
*	This method is use to construct an object which has name/value pair
* @param String member_name
*	The name of the member
* @param String member_value
*	The value of the member
**/
function TabContentStore( member_name, member_value) {

	var name = member_name;
	var value = member_value;

}




