<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:pol="urn:com:ibm:sec:authz:policy-internal"
	xmlns="urn:oasis:names:tc:xacml:1.0:policy">

	<xsl:output method="xml" version="1.0" encoding="iso-8859-1"
		indent="yes" />

	<!-- Strip unwanted spaces, and kill any text except when specified otherwise -->
	<xsl:strip-space elements="*" />
	<xsl:template match="text()" />

	<!-- Setup constants -->
	<xsl:variable name="ibm_xacml_urn"
		select="'urn:ibm:xacml-java-security:'" />
	<xsl:variable name="permissions_prefix" select="'policy'" />
	<xsl:variable name="role_mapping_prefix" select="'role-mapping'" />
	<xsl:variable name="mapping_suffix" select="'mappings'" />
	<xsl:variable name="excluded_suffix" select="'excluded-policy'" />
	<xsl:variable name="unchecked_suffix" select="'unchecked-policy'" />
	<xsl:variable name="role_based_suffix" select="'role-based-policy'" />
	<xsl:variable name="string_urn"
		select="'http://www.w3.org/2001/XMLSchema#string'" />
	<xsl:variable name="principal_urn"
		select="concat($ibm_xacml_urn, 'data-type:java.security.Principal')" />
	<xsl:variable name="permission_match"
		select="concat($ibm_xacml_urn, 'java.security.Permission:match')" />
	<xsl:variable name="permission_bag"
		select="concat($ibm_xacml_urn, 'java.security.Permission:bag')" />
	<xsl:variable name="role_condition_match"
		select="concat($ibm_xacml_urn, 'com.ibm.sec.authz.jaccx.role.RoleCondition:match')" />
	<xsl:variable name="role_condition_bag"
		select="concat($ibm_xacml_urn, 'com.ibm.sec.authz.jaccx.role.RoleCondition:bag')" />
	<xsl:variable name="rule_combining_alg"
		select="'rule-combining-algorithm'" />

	<!-- Policy Configuration -->
	<xsl:template match="pol:Policy">
		<xsl:variable name="context-id">
			<xsl:value-of select="@context-id" />
		</xsl:variable>
		<PolicySet
			PolicyCombiningAlgId="urn:oasis:names:tc:1.0:policy-combining-algorithm:first-applicable">
			<xsl:choose>
				<xsl:when test="pol:PermissionConfig">
					<xsl:attribute name="PolicySetId">
						<xsl:value-of
							select="concat($ibm_xacml_urn, $permissions_prefix, ':', $context-id)" />
					</xsl:attribute>
				</xsl:when>
				<xsl:when test="pol:RoleMappingConfig">
					<xsl:attribute name="PolicySetId">
						<xsl:value-of
							select="concat($ibm_xacml_urn, $role_mapping_prefix, ':', $context-id)" />
					</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:call-template name="empty-target" />
			<xsl:apply-templates>
				<xsl:with-param name="context-id" select="$context-id" />
			</xsl:apply-templates>
		</PolicySet>
	</xsl:template>

	<!-- Match <PermissionConfig> -->
	<xsl:template match="pol:PermissionConfig">
		<xsl:param name="context-id" />
		<xsl:apply-templates>
			<xsl:with-param name="context-id" select="$context-id" />
		</xsl:apply-templates>
	</xsl:template>

	<!--  Match <ExcludedPermissions> -->
	<xsl:template match="pol:ExcludedPermissions">
		<xsl:param name="context-id" />
		<Policy
			RuleCombiningAlgId="urn:oasis:names:tc:1.0:rule-combining-algorithm:first-applicable">
			<xsl:attribute name="PolicyId">
				<xsl:value-of
					select="concat($ibm_xacml_urn, $permissions_prefix, ':', $context-id, ':', $excluded_suffix)" />
			</xsl:attribute>
			<xsl:call-template name="empty-target" />
			<Rule Effect="Deny" RuleId="excluded-rule">
				<xsl:call-template name="empty-target" />
				<xsl:apply-templates />
			</Rule>
		</Policy>
	</xsl:template>

	<!-- Match <UncheckedPermissions> -->
	<xsl:template match="pol:UncheckedPermissions">
		<xsl:param name="context-id" />
		<Policy
			RuleCombiningAlgId="urn:oasis:names:tc:1.0:rule-combining-algorithm:first-applicable">
			<xsl:attribute name="PolicyId">
				<xsl:value-of
					select="concat($ibm_xacml_urn, $permissions_prefix, ':', $context-id, ':', $unchecked_suffix)" />
			</xsl:attribute>
			<xsl:call-template name="empty-target" />
			<Rule Effect="Permit" RuleId="unchecked-rule">
				<xsl:call-template name="empty-target" />
				<xsl:apply-templates />
			</Rule>
		</Policy>
	</xsl:template>

	<!-- Match <RoleBasedPermissions> -->
	<xsl:template match="pol:RoleBasedPermissions">
		<xsl:param name="context-id" />
		<Policy
			RuleCombiningAlgId="urn:oasis:names:tc:1.0:rule-combining-algorithm:first-applicable">
			<xsl:attribute name="PolicyId">
				<xsl:value-of
					select="concat($ibm_xacml_urn, $permissions_prefix, ':', $context-id, ':', $role_based_suffix)" />
			</xsl:attribute>
			<xsl:call-template name="empty-target" />
			<xsl:apply-templates />
		</Policy>
	</xsl:template>

	<!-- Extract the role-name and create matching <Target> -->
	<xsl:template match="pol:Role">
		<Rule Effect="Permit" RuleId="role-based-rule{position()-1}">
			<Target>
				<Subjects>
					<Subject>
						<SubjectMatch
							MatchId="urn:ibm:function:role-match">
<!-- TODO: Update this function URN -->
							<AttributeValue>
								<xsl:attribute name="DataType">
									<xsl:value-of select="$string_urn" />
								</xsl:attribute>
								<xsl:value-of select="@role" />
							</AttributeValue>
							<SubjectAttributeDesignator
								AttributeId="urn:oasis:names:tc:1.0:subject:subject-id">
								<xsl:attribute name="DataType">
									<xsl:value-of
										select="$principal_urn" />
								</xsl:attribute>
							</SubjectAttributeDesignator>
						</SubjectMatch>
					</Subject>
				</Subjects>
				<Resources>
					<AnyResource />
				</Resources>
				<Actions>
					<AnyAction />
				</Actions>
			</Target>
			<xsl:apply-templates />
		</Rule>
	</xsl:template>

	<!-- Convert <PermissionSet> into <Condition><Apply> -->
	<xsl:template match="pol:PermissionSet">
		<Condition>
			<xsl:attribute name="FunctionId">
				<xsl:value-of select="$permission_match" />
			</xsl:attribute>
			<Apply>
				<xsl:attribute name="FunctionId">
					<xsl:value-of select="$permission_bag" />
				</xsl:attribute>
				<xsl:apply-templates />
			</Apply>
		</Condition>
	</xsl:template>

	<!-- Match <RoleMappingConfig> -->
	<xsl:template match="pol:RoleMappingConfig">
		<xsl:param name="context-id" />
		<Policy>
			<xsl:choose>
				<xsl:when test="@CombiningAlgorithm">
					<xsl:variable name="combining-alg">
						<xsl:value-of select="@CombiningAlgorithm" />
					</xsl:variable>
					<xsl:attribute name="RuleCombiningAlgId">
						<xsl:value-of
							select="concat($ibm_xacml_urn, $rule_combining_alg, ':', $combining-alg)" />
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="RuleCombiningAlgId">
						<xsl:text>urn:oasis:names:tc:1.0:rule-combining-algorithm:first-applicable</xsl:text>
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="PolicyId">
				<xsl:value-of
					select="concat($ibm_xacml_urn, $role_mapping_prefix, ':', $context-id, ':', $mapping_suffix)" />
			</xsl:attribute>

			<xsl:call-template name="empty-target" />
			<xsl:apply-templates />

		</Policy>
	</xsl:template>

	<!-- Match <RoleMapping>, convert to <Rule> -->
	<xsl:template match="pol:RoleMapping">
		<Rule Effect="Permit" RuleId="Rule{position()}">
			<Target>
				<Subjects>
					<Subject>
						<SubjectMatch
							MatchId="urn:ibm:xacml-java-security:java.security.Principal:equals">
							<xsl:apply-templates select="pol:Principal" />
							<SubjectAttributeDesignator
								AttributeId="urn:oasis:names:tc:1.0:subject:subject-id">
								<xsl:attribute name="DataType">
									<xsl:value-of
										select="$principal_urn" />
								</xsl:attribute>
							</SubjectAttributeDesignator>
						</SubjectMatch>
					</Subject>
				</Subjects>
				<Resources>
					<AnyResource />
				</Resources>
				<Actions>
					<AnyAction />
				</Actions>
			</Target>

			<xsl:apply-templates select="pol:RoleConditionSet" />

		</Rule>
	</xsl:template>

	<!-- Conver the <RoleConditionSet> into the <Condition> tree -->
	<xsl:template match="pol:RoleConditionSet">
		<Condition>
			<xsl:attribute name="FunctionId">
				<xsl:value-of select="$role_condition_match" />
			</xsl:attribute>
			<Apply>
				<xsl:attribute name="FunctionId">
					<xsl:value-of select="$role_condition_bag" />
				</xsl:attribute>

				<xsl:apply-templates />

			</Apply>
		</Condition>
	</xsl:template>

	<!--  Convert <DataValue> to <AttributeValue> -->
	<xsl:template match="pol:DataValue">
		<!-- Outer <AttributeValue>, containing URN and Name -->
		<AttributeValue>
			<xsl:attribute name="DataType">
				<xsl:value-of select="@DataType" />
			</xsl:attribute>
			<xsl:if test="@Name">
				<xsl:attribute name="Name">
					<xsl:value-of select="@Name" />
				</xsl:attribute>
			</xsl:if>

			<!-- Inner <AttributeValue>, containing class and parameters -->
			<AttributeValue>

				<!-- First find the class-name and string parameters and add them as attributes -->
				<xsl:apply-templates mode="inner-data-value" />
			</AttributeValue>
		</AttributeValue>
	</xsl:template>

	<!-- Process inner <DataValue> elements as usual -->
	<xsl:template match="pol:DataValue" mode="inner-data-value">
		<xsl:apply-templates select="." />
	</xsl:template>

	<xsl:template match="pol:ClassName" mode="inner-data-value">
		<xsl:attribute name="DataType">
			<xsl:value-of select="normalize-space(text())" />
		</xsl:attribute>
	</xsl:template>

	<!-- If we match a SimpleValue while processing the inner portion
		of an <AttributeValue> we should add #strings as attributes otherwise
		process as usual -->
	<xsl:template match="pol:SimpleValue" mode="inner-data-value">
		<xsl:choose>
			<xsl:when test="@DataType=$string_urn and @is-null!='true'">
				<xsl:variable name="attrName">
					<xsl:value-of select="@Name" />
				</xsl:variable>
				<xsl:attribute name="{$attrName}">
					<xsl:value-of select="normalize-space(text())" />
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="pol:SimpleValue">
		<AttributeValue>
			<xsl:attribute name="DataType">
				<xsl:value-of select="@DataType" />
			</xsl:attribute>
			<xsl:if test="@Name">
				<xsl:attribute name="Name">
					<xsl:value-of select="@Name" />
				</xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="@is-null">
					<xsl:attribute name="IsNull">
						<xsl:text>true</xsl:text>						
					</xsl:attribute>
					<xsl:text>null</xsl:text>		
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="normalize-space(text())" />
				</xsl:otherwise>
			</xsl:choose>
		</AttributeValue>
	</xsl:template>

	<!-- Output linked policy contexts -->
	<xsl:template match="pol:LinkedPolicyContext">
		<PolicySetIdReference>
			<xsl:value-of select="normalize-space(text())" />
		</PolicySetIdReference>
	</xsl:template>

	<!-- Output a <Target> tree that matches everything -->
	<xsl:template name="empty-target">
		<Target>
			<Subjects>
				<AnySubject />
			</Subjects>
			<Resources>
				<AnyResource />
			</Resources>
			<Actions>
				<AnyAction />
			</Actions>
		</Target>
	</xsl:template>

</xsl:transform>