<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform version="1.0"
	xmlns="urn:com:ibm:sec:authz:policy-internal"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:x="urn:oasis:names:tc:xacml:1.0:policy">

	<!-- Setup the output format properly -->
	<xsl:output method="xml" version="1.0" encoding="iso-8859-1"
		indent="yes" />

	<!-- Strip spaces from inside elements, and only output text when we specifically want to -->
	<xsl:strip-space elements="*" />
	<xsl:template match="text()" />

	<!-- START constants declaration: namespace prefixes and strings to match etc -->
	<xsl:variable name="ibm_xacml_urn"
		select="'urn:ibm:xacml-java-security:'" />
	<xsl:variable name="permissions_prefix" select="'policy'" />
	<xsl:variable name="role_mapping_prefix" select="'role-mapping'" />
	<xsl:variable name="mapping_suffix" select="'mapping'" />
	<xsl:variable name="excluded_suffix" select="'excluded-policy'" />
	<xsl:variable name="unchecked_suffix" select="'unchecked-policy'" />
	<xsl:variable name="role_based_suffix" select="'role-based-policy'" />
	<xsl:variable name="string_urn"
		select="'http://www.w3.org/2001/XMLSchema#string'" />
	<xsl:variable name="rule_combining_alg"
		select="'rule-combining-algorithm'" />
	<!-- END constants declaration -->

	<!-- Ensure the PolicySetId is prefixed with our ibm_xacml_urn -->
	<xsl:template
		match="x:PolicySet[starts-with(@PolicySetId, $ibm_xacml_urn)]">
		<!-- Extract the PolicySetId attribute and extract the context-id -->
		<xsl:variable name="policy-set-suffix"
			select="substring(@PolicySetId, string-length($ibm_xacml_urn)+1 )" />
		<xsl:variable name="policy-type"
			select="substring-before( $policy-set-suffix, ':' )" />
		<xsl:variable name="context-id"
			select="substring-after( $policy-set-suffix, ':' )" />

		<Policy>
			<xsl:attribute name="context-id">
				<xsl:value-of select="$context-id" />
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$policy-type=$permissions_prefix">
					<PermissionConfig>
						<xsl:apply-templates select="x:Policy" />
					</PermissionConfig>
				</xsl:when>
				<xsl:when test="$policy-type=$role_mapping_prefix">
					<RoleMappingConfig>
						<!-- Extract the combining algorithm -->
						<xsl:if test="starts-with(x:Policy/@RuleCombiningAlgId, $ibm_xacml_urn)">
							<xsl:variable name="combining-alg-suffix">
								<xsl:value-of select="substring( x:Policy/@RuleCombiningAlgId, string-length($ibm_xacml_urn)+1)" />
							</xsl:variable>
							<xsl:attribute name="CombiningAlgorithm">
								<xsl:value-of select="substring-after( $combining-alg-suffix, ':' )" />
							</xsl:attribute>
						</xsl:if>
						<xsl:apply-templates select="x:Policy" />
					</RoleMappingConfig>
				</xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="x:PolicySetIdReference" />
		</Policy>

	</xsl:template>

	<!-- Insert any linked policy context IDs -->
	<xsl:template match="x:PolicySetIdReference">
		<xsl:variable name="policy-set-suffix"
			select="substring(normalize-space(text()), string-length($ibm_xacml_urn)+1 )" />
		<xsl:variable name="context-id"
			select="substring-after( $policy-set-suffix, ':' )" />
		<LinkedPolicyContext>
			<xsl:value-of select="normalize-space($context-id)" />
		</LinkedPolicyContext>
	</xsl:template>

	<!-- Do template for Policy element -->
	<xsl:template
		match="x:Policy[starts-with(@PolicyId, $ibm_xacml_urn)]">
		<xsl:choose>
			<xsl:when test="contains(@PolicyId, $excluded_suffix)">
				<ExcludedPermissions>
					<PermissionSet>
						<xsl:apply-templates select="x:Rule/x:Condition"
							mode="extract-data" />
					</PermissionSet>
				</ExcludedPermissions>
			</xsl:when>
			<xsl:when test="contains(@PolicyId, $unchecked_suffix)">
				<UncheckedPermissions>
					<PermissionSet>
						<xsl:apply-templates select="x:Rule/x:Condition"
							mode="extract-data" />
					</PermissionSet>
				</UncheckedPermissions>
			</xsl:when>
			<xsl:when test="contains(@PolicyId, $role_based_suffix)">
				<RoleBasedPermissions>
					<xsl:apply-templates mode="role-policy" />
				</RoleBasedPermissions>
			</xsl:when>
			<xsl:when test="contains(@PolicyId, $mapping_suffix)">
				<xsl:apply-templates mode="principal-mapping" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Templates with mode for permissions -->
	<xsl:template match="x:Rule" mode="role-policy">
		<Role>
			<xsl:attribute name="role">
				<!-- This is spitting out characters for some reason -->
				<xsl:value-of
					select="normalize-space(x:Target/x:Subjects/x:Subject/x:SubjectMatch/x:AttributeValue/text())" />
			</xsl:attribute>
			<PermissionSet>
				<xsl:apply-templates select="x:Condition"
					mode="extract-data" />
			</PermissionSet>
		</Role>
	</xsl:template>

	<!-- Templates with mode for principal-to-role mapping -->
	<xsl:template match="x:Rule" mode="principal-mapping">
		<RoleMapping>
			<Principal>
				<xsl:apply-templates select="x:Target"
					mode="extract-data" />
			</Principal>
			<RoleConditionSet>
				<xsl:apply-templates select="x:Condition"
					mode="extract-data" />
			</RoleConditionSet>
		</RoleMapping>
	</xsl:template>

	<!-- Templates for extracting data from <AttributeValue> elements -->
	<xsl:template match="x:AttributeValue" mode="extract-data">
		<xsl:choose>
			<!-- Nodes with other elements as children should be a <DataValue> element -->
			<xsl:when test="(*)">
				<DataValue>
					<xsl:attribute name="DataType">
						<xsl:value-of select="@DataType" />
					</xsl:attribute>
					<xsl:if test="@Name">
						<xsl:attribute name="Name">
							<xsl:value-of select="@Name" />
						</xsl:attribute>
					</xsl:if>

					<xsl:apply-templates mode="extract-child" />

				</DataValue>
			</xsl:when>
			<!-- Nodes with text children should simply be output as <SimpleValue> elements -->
 
			<xsl:otherwise>
				<SimpleValue>
					<xsl:attribute name="DataType">
						<xsl:value-of select="@DataType" />
					</xsl:attribute>
					<xsl:if test="@Name">
						<xsl:attribute name="Name">
							<xsl:value-of select="@Name" />
						</xsl:attribute>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="@IsNull">
							<xsl:attribute name="is-null">
								<xsl:value-of select="@IsNull" />
							</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="normalize-space(child::text())" />
						</xsl:otherwise>
					</xsl:choose>
				</SimpleValue>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="x:AttributeValue" mode="extract-child">
		<!-- Extract the <ClassName> and any string parameters from the child -->
		<xsl:for-each select="@*">
			<xsl:choose>
				<xsl:when test="name()='DataType'">
					<ClassName>
						<xsl:value-of select="." />
					</ClassName>
				</xsl:when>
				<xsl:otherwise>
					<SimpleValue>
						<xsl:attribute name="DataType">
							<xsl:value-of select="$string_urn" />
						</xsl:attribute>
						<xsl:attribute name="Name">
							<xsl:value-of select="name()" />
						</xsl:attribute>
						<xsl:value-of select="." />
					</SimpleValue>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

		<!-- Recurse to any grandchild <AttributeValue> elements -->
		<xsl:apply-templates mode="extract-data" />
	</xsl:template>

	<!-- As we are ignoring text by default, but we want text in <AttributeValue> nodes -->
	<xsl:template match="x:AttributeValue/text()" mode="extract-data">
		<xsl:value-of select="normalize-space(.)" />
	</xsl:template>

</xsl:transform>