// ------------------------------------------------
// HxClient_Strings -- JSF Client Localized Strings
// ------------------------------------------------

// Spinner control = tooltips for "increment number" and "decrement number"
hX_3.STR_SPINNER_INCREMENT	= "Increment";		
hX_3.STR_SPINNER_DECREMENT	= "Decrement";	

// Slider control = tooltip for "drop down the slider"
hX_3.STR_SLIDER_LABEL 		= "Show Slider";

// Tabbed panel control = tooltip for "scroll tabs to the left" and "right"
hX_3.STR_TABPANEL_SCROLLLEFT	= "Scroll Left";
hX_3.STR_TABPANEL_SCROLLRIGHT= "Scroll Right";

// Date picker control -- tooltip for "drop down the date navigator"
hX_3.STR_DATE_DN_TOGGLE		= "Show Calendar";

// Date picker control -- tooltips for navigation buttons in calendar
hX_3.STR_DATE_PREVIOUS_YEAR	= "Previous year";
hX_3.STR_DATE_NEXT_YEAR		=" Next year";
hX_3.STR_DATE_PREVIOUS_MONTH	= "Previous month";
hX_3.STR_DATE_NEXT_MONTH		= "Next month";

// Months of the year -- order matters, that is, first entry is first month of the year
hX_3.STR_DATE_MONTHS = new Array ("January","February","March","April","May","June","July","August","September","October","November","December");

// Months of the year as 3 letter abbreviations -- order matters, that is, first entry is first month of the year
hX_3.STR_DATE_SHMONTHS = new Array ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

// Days of the week -- order matters, that is, first entry is first day of the week
hX_3.STR_DATE_DAYS = new Array ("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");

// Days of the week as 3 letter abbreviations -- order matters, that is, first entry is first day of the week
hX_3.STR_DATE_SHDAYS = new Array ("Sun","Mon","Tue","Wed","Thu","Fri","Sat");

// Days of the week as 1 letter abbreviations -- order matters, that is, first entry is first day of the week
hX_3.STR_DATE_SHSHDAYS = new Array ("S","M","T","W","T","F","S" );


// For Date: Epoch Schemes
// An "epoch" is a period of time that starts on a date and continues on to the next "epoch" (or forever)
// Each epoch has a "start date" and a name.  Each epoch scheme is an ordered list of epochs.
// For example, in Christianity, there are two epochs in the scheme -- Before Christ and After Christ
// For example, in Islam, there are two epochs in the scheme -- After Mohammed's Haj and before it
// For example, in Japan, the reign of each emperor is an epoch
// For example, in the Roman Empire, the rule of each proconsul (or pair thereof) is an epoch 
// In the following array, 	For each epoch scheme, each epoch (one line) consists of
// 							the start of the epoch, the full name of the epoch, the abbreviation of the epoch
//							For the start of the epoch, + and - are used for before/after type epochs
//							For "ruler/emperor" epochs, it's the start date of the ruler/emperor (yyyymmdd)
//
// Note:  To add additional epoch schemes (e.g., Hegiri), the corresponding descriptor in the hx constants
// 		  file needs to be added to as well
//
hX_3.DATE_EPOCHS = [
						// Christian Epochs -- religious form
						[["-", "Before Christ", "BC"],
						 ["+", "Anno Domini", 	"AD"]],
						// Christian Epochs -- neutral form
						[["-", "Before Christ Era", "BCE"],
						 ["+", "Christian Era", 	"CE"]],
						// Japanese Epochs -- Meiji period and later
						[["18680908", "Meiji",  "Mei"],				  
						 ["19120731", "Taisho", "Tai"],
						 ["19261226", "Showa",  "Sho"],
						 ["19890108", "Heisei", "Hei"]]
						];

						
// For Time -- Default am and pm suffixes (case matters)
hX_3.STR_AM_SUFFIX  ="AM";
hX_3.STR_PM_SUFFIX  ="PM";

// For Time -- Time Zone schemes
// The standard way of displaying time zones is of the form "GMT +03:00".  For many locales
// there are a well known set of abbreviations for some time zones.  For example, in North
// America, "EST" is the abbreviation for "GMT +05:00".
//
// The following table lists the abbreviations that are common for a locale.  Note that there are locales
// (many) that do not use abbreviations.
//
// Each entry in the table lists (in order):
//	1)	The GMT offset of the form hhmm (hours and minutes) with a plus/minus sign
//	2)	The abbreviation for the time zone (short form, usually 2 to 5 characters)
//	3)	The GMT offset of the form hhmm OF DAYLIGHT SAVINGS TIME for the zone
//	4)	The abbreviation for the time zone when daylight savings time is in effect
//		Note:  	Many locales do not use this kind of abbreviation.  In this case, make it the same
//				as the second entry
//	5)	The time zone in "long form" (non-daylight savings time)
//
//	IMPORTANT:  FOR ALL Locales, you must supply the first line and it MUST BE +0000 that is
// 	it's the definition of the abbreviation used for GMT (or UTC)
hX_3.STR_TIMEZONES = [
[ "+0000", "GMT", "+0000", "GMT",  "Greenwich Mean Time"],
[ "-0400", "AST", "-0300", "ADT",  "Atlantic Standard Time"],
[ "-0500", "EST", "-0400", "EDT",  "Eastern Standard Time"],
[ "-0600", "CST", "-0500", "CDT",  "Central Standard Time"],
[ "-0700", "MST", "-0600", "MDT",  "Mountain Standard Time"],
[ "-0800", "PST", "-0700", "PDT",  "Pacific Standard Time"],
[ "-1000", "HST", "-0900", "HDT",  "Hawaii-Aleutian Standard Time"],
["","","",""]];

// For Numbers -- default decimal character
hX_3.STR_NUMBER_DECIMAL		= ".";
// For Numbers -- default thousands grouping character
hX_3.STR_NUMBER_THOUSANDS	= ",";
// For Numbers -- default currency marker
hX_3.STR_NUMBER_CURRENCY		= "$";

//-----------------------------------------------------------------------------------------------
// Error Messages
//-----------------------------------------------------------------------------------------------

hX_3.ERR_datetime_parse_fail= "\"{0}\" cannot be interpreted as a date or time.";
hX_3.ERR_epoch_name 		= "\"{0}\" cannot be interpreted as a date. The epoch is not correct.";
hX_3.ERR_day_name 			= "\"{0}\" cannot be interpreted as a date. The day name is not correct.";
hX_3.ERR_month_name			= "\"{0}\" cannot be interpreted as a date. The month name is not correct.";
hX_3.ERR_month_range		= "\"{0}\" cannot be interpreted as a date. The month must be between 1 and 12.";
hX_3.ERR_month_rangelimit	= "\"{0}\" cannot be interpreted as a date. {1} doesn't have {2} days.";
hX_3.ERR_epoch_range		= "\"{0}\" cannot be interpreted as a date. Year is not correct for the Emperor."
hX_3.ERR_hour_range_long 	= "\"{0}\" cannot be interpreted as a time. The hour must be between 0 and 23.";
hX_3.ERR_hour_range_short	= "\"{0}\" cannot be interpreted as a time. The hour must be between 1 and 12.";
hX_3.ERR_minute_range 		= "\"{0}\" cannot be interpreted as a time. Minutes must be between 0 and 59.";
hX_3.ERR_second_range 		= "\"{0}\" cannot be interpreted as a time. Seconds must be between 0 and 59.";
hX_3.ERR_ampm_name			= "\"{0}\" cannot be interpreted as a time. The time must have an AM or PM indicator.";
hX_3.ERR_tzone_name			= "\"{0}\" cannot be interpreted as a time. The time zone is not correct.";

hX_3.ERR_empty				= "This value cannot be interpreted as no value was provided.";
hX_3.ERR_minimum			= "The value provided is less than the minimum allowed.";
hX_3.ERR_maximum			= "The value provided is greater than the maximum allowed.";
hX_3.ERR_required			= "This value is required.";
hX_3.ERR_constraint			= "This value cannot be intepreted.  The pattern of digits or alphabetic characters is not correct.";

hX_3.ERR_number_fail		= "\"{0}\" cannot be interpreted as a number.";
hX_3.ERR_number_char		= "\"{0}\" cannot be interpreted as a number. \"{1}\" is not a valid character.";
