#######################################################

#Copyright (C) IBM Corp. 2005-2017, All rights reserved.

#Author:

#Notes: 1. Use elements from MSCluster_ClusterSharedVolume class
#ClusWMI MOF file

#Revision History:

#######################################################

#Get-Module -list
#Import the FailoverClusters module into a Windows PowerShell session 

$ErrorActionPreference = "Stop"

Import-Module FailoverClusters

Echo ""
Echo ""
Echo "CLUSTER DETAILS:"  
Echo =====================START==========================  

TRY
{
    $CName = (Get-ClusterResource "Cluster Name" |  Get-ClusterParameter Name).Value 
    $CIPadd = (Get-ClusterResource "Cluster IP Address" | Get-ClusterParameter Address).Value
}
Catch
{
    Write-Host "Error: No Cluster information present...!!!"
    Break;
}
Write-Host "Cluster Name: $CName "
Write-Host "Cluster IP Address: $CIPadd"
Echo =====================END============================ 

$objs = @()
$csvs = Get-ClusterSharedVolume

Echo ""
Echo ""
Echo "LIST OF ALL DATAPATH VOLUMES:"  
Echo =====================================================START========================================================
foreach ( $csv in $csvs )
{
   Try
   {
        $csvinfos = $csv | select -Property Name -ExpandProperty SharedVolumeInfo -ErrorAction Stop
   }
   Catch
   {
        Write-Host "Error: Invalid cluster disks information...!!!"
        Break;
   }      
   $volcontroller = $csv.OwnerNode.Name
   $csvVol = $csv.SharedVolumeInfo.Partition.Name
   $cimSession = New-CimSession -ComputerName $volcontroller
   $volInfo = Get-Disk -CimSession $cimSession | Get-Partition | Select DiskNumber, @{Name="Volume";Expression={Get-Volume -Partition $_ | Select -ExpandProperty ObjectId}}
   #$volInfo = Get-Disk -CimSession $cimSession
   $csvPhysicalDiskNo = ($volinfo | ? { $_.Volume -eq $csvVol}).Disknumber
   
   foreach ( $csvinfo in $csvinfos )
   {
	  $obj = New-Object PSObject -Property @{
             Name        = $csv.Name
             CSVPath        = $csvinfo.FriendlyVolumeName
             Size        = $csvinfo.Partition.Size
             FreeSpace   = $csvinfo.Partition.FreeSpace
             UsedSpace   = $csvinfo.Partition.UsedSpace
             PercentFree = $csvinfo.Partition.PercentFree
             SytemDisk = $csvPhysicalDiskNo
	 	     PhysicalDisk = "PHYSICALDRIVE"+$csvPhysicalDiskNo
      }
      $objs += $obj
   }
}

	 $app = 'C:\Program Files\IBM\SDDDSM\datapath.exe'
	 $arg1 = 'query'
	 $arg2 = 'device'
	 $arg3 = '-a'
	 #$arg4 = ($obj).SytemDisk-1
	 
	 & $app $arg1 $arg2 $arg3
	 
	 $mpclaimstr = "mpclaim -s -d"

	 Invoke-Expression $mpclaimstr
Echo =====================================================END==========================================================
    
Echo ""    
Echo ""
Echo ""
Echo "LIST OF ALL CLUSTERED VOLUMES (NON-CSV):"  
Echo =====================================================START=========================================================
Get-ClusterGroup | Get-ClusterResource | Where {$_.ResourceType.Name -eq "Physical Disk"}  
Echo =====================================================END===========================================================
Echo ""
Echo ""
Echo ""
Echo "LIST OF ALL CLUSTERED SHARED VOLUMES (CSV):"
Echo =====================================================START========================================================= 
#$objs | ft -auto Name,SytemDisk,CSVPath,PhysicalDisk,SerialNumber, @{ Label = "Size(GB)" ; 
$objs | ft -auto Name,SytemDisk,CSVPath,PhysicalDisk, @{ Label = "Size(GB)" ;
Expression = { "{0:N2}" -f ($_.Size/1024/1024/1024) } },@{ Label = "FreeSpace(GB)" ;
Expression = { "{0:N2}" -f ($_.FreeSpace/1024/1024/1024) } },@{ Label = "UsedSpace(GB)" ; 
Expression = { "{0:N2}" -f ($_.UsedSpace/1024/1024/1024) } },@{ Label = "PercentFree" ; 
Expression = { "{0:N2}" -f ($_.PercentFree)}}
Echo =====================================================END============================================================
Echo ""
Echo ""
Echo ""
Echo "CLUSTERED DISKS TO PHYSICAL SYSTEM DISKS MAPPING:"  
Echo =====================================================START==========================================================
Echo ""
[System.Reflection.Assembly]::LoadWithPartialName("Microsoft.Storage.Vds") | Out-Null
$VdsServiceLoader = New-Object Microsoft.Storage.Vds.ServiceLoader
$VdsService = $VdsServiceLoader.LoadService($null)
$VdsService.WaitForServiceReady()
$VdsService.Reenumerate()

#Build up a collection of all disks presented to the os
$Disks = ($VdsService.Providers |% {$_.Packs}) |% {$_.Disks}

#Import the FailoverClusters module
Import-Module FailoverClusters

#Retreve all of the CSV Luns
Try
{
    $AllCSVs = Get-ClusterGroup | Get-ClusterResource | Where {$_.ResourceType.Name -eq "Physical Disk"} -ErrorAction Stop
}
Catch
{
    Write-Host "Error: No Clustered Shared Volume (CSV) information present ...!!!"
    Break;
}
 
foreach ($Csv in $AllCSVs)
{
    $CSVParams = Get-ClusterParameter -InputObject $Csv

    $DiskType = ($CSVParams | Where-object -FilterScript {$_.Name -eq "DiskIdType"}).Value
    Write-Host "ClusterResourceName:     " $Csv.Name
               
    #Write-Host "DiskType: " $DiskType
   
    $secondfolder = 1

    if ($DiskType -eq $secondfolder) {
        $DiskGUIDString = ($CSVParams | Where-object -FilterScript {$_.Name -eq "DiskIdGuid"}).Value
        #Write-Host $DiskGUIDString
        foreach ( $Disk  in $Disks )
        {
            if($Disk.PartitionStyle -eq "Gpt"){
                if($Disk.DiskGuid -eq $DiskGUIDString){
                     #Write-Host $Disk.DiskGuid
                     Write-Host "DiskName:                " $Disk.Name   
                     Write-Host

                     #Write-Host $Disk.Name
                     break
                }
            }
        }
        
    } else {
        $DiskSig = ($CSVParams | Where-object -FilterScript {$_.Name -eq "DiskSignature"}).Value
        #Write-Host $DiskSig
        foreach ( $Disk  in $Disks )
        {   #Write-Host $Disk.PartitionStyle
            if($Disk.PartitionStyle -eq "Mbr"){
                   #Write-Host ('0x{0:X}' -f $Disk.Signature)
                   #Write-Host $DiskSig
                if(('0x{0:X}' -f $Disk.Signature) -eq $DiskSig){
                     #Write-Host ('0x{0:X}' -f $Disk.Signature)
                     Write-Host "DiskName:                " $Disk.Name                 
                     Write-Host
                     break
                }
            }
        }
    }   
} 

$csvs = Get-ClusterSharedVolume
foreach ( $csv in $csvs )
{
   Try
   {
        $csvinfos = $csv | select -Property Name -ExpandProperty SharedVolumeInfo -ErrorAction Stop
   }
   Catch
   {
        Write-Host "Error1: Invalid cluster disks information...!!!"
        Break;
   }
   #$csvinfos = $csv | select -Property Name -ExpandProperty SharedVolumeInfo
   $volcontroller = $csv.OwnerNode.Name
   $csvVol = $csv.SharedVolumeInfo.Partition.Name
   $cimSession = New-CimSession -ComputerName $volcontroller
   $volInfo = Get-Disk -CimSession $cimSession | Get-Partition | Select DiskNumber, @{Name="Volume";Expression={Get-Volume -Partition $_ | Select -ExpandProperty ObjectId}}
   $csvPhysicalDiskNo = ($volinfo | ? { $_.Volume -eq $csvVol}).Disknumber
   Write-Host "CSV ClusterResourceName: " $csv.Name
   Write-Host "DiskName:                " "\\?\PhysicalDrive"$csvPhysicalDiskNo
   Write-Host
}
Echo ======================================================END===========================================================
Echo ""