@echo off

:: Copyright (C) IBM Corp. 2005-2017, All rights reserved.
::
:: Module Name:
::
::    sddgetdata.bat
::
:: Abstract:
::   
::    This is a Windows Utility for IBM(R) Multipath Subsystem Device 
::    Driver DSM(SDDDSM). This will facilitate the trace collection 
::    functionality for SDDDSM
::
:: Environment:
::
::    Windows 2000 and Above
::

setlocal

ECHO Collecting SDD trace Data
ECHO.

:::: We need to create a unique directory using HostName, Date and Time. 
:::: We need to pasre the date and time to remove the unwanted characters like " ./," to make the directory name Windows Compatible.
FOR /F "tokens=1-4 delims=/.,: " %%m IN ("%date%") DO set Cdate=%%p%%n%%o
::echo %Cdate%
FOR /F "tokens=1-3 delims=/.,: " %%J IN ("%time%") DO set Ctime=%%J%%K%%L
::echo %Ctime%

:: Now we have all the data to construct the directory name.
set datetime=%Cdate%_%Ctime%
set dirname=sdddata_%ComputerName%_%datetime%

:::: 1st we need to move to the dir where SDDDSM is installed then come back to original dir
pushd "%ProgramFiles%\IBM\SDDDSM\"

md %dirname%

ECHO Flushing SDD kernel logs
ECHO.
sddlogflush.exe 

ECHO ***************************************************************************** > dir_list_%datetime%.txt
ECHO ***** List of all files under SDD directory and its sub-directories      **** >> dir_list_%datetime%.txt
ECHO ***************************************************************************** >> dir_list_%datetime%.txt
dir /s |findstr /v "%datetime%" >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO ***************************************************************************** >> dir_list_%datetime%.txt
ECHO ***** List of SDD and HBA Driver Files in drivers directory              **** >> dir_list_%datetime%.txt
ECHO ***************************************************************************** >> dir_list_%datetime%.txt
dir %windir%\system32\drivers\ | findstr /i "sdd mp storport ntfs ql elx" >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO ***************************************************************************** >> dir_list_%datetime%.txt
ECHO ***** SDD version from SDD readme file                                   **** >> dir_list_%datetime%.txt
ECHO ***************************************************************************** >> dir_list_%datetime%.txt
findstr /i /c:"Subsystem Device Driver DSM Version" readme.txt>> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt
ECHO. >> dir_list_%datetime%.txt

move dir_list_%datetime%.txt %dirname% > NUL


ECHO Collecting datapath command outputs
ECHO.
ECHO %DATE% %TIME% >> dpq_%datetime%.txt
ECHO ************************************************* > dpq_%datetime%.txt
ECHO ***** Output of datapath query adapter       **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query adapter >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query device **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query device >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query device -s     **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query device -s >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query essmap        **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query essmap >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query portmap       **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query portmap >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query wwpn          **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query wwpn >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query version -b  **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query version -b >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of datapath query port  **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt
datapath query port >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt
ECHO. >> dpq_%datetime%.txt

ECHO ************************************************* >> dpq_%datetime%.txt
ECHO ***** Output of SddShowCSVLuns  **** >> dpq_%datetime%.txt
ECHO ************************************************* >> dpq_%datetime%.txt

powershell.exe -ExecutionPolicy Bypass -File sddShowCSVLuns.ps1 >> dpq_%datetime%.txt

ECHO ************************************************* >> hba_%datetime%.txt
ECHO ***** HBA Detail                             **** >> hba_%datetime%.txt
ECHO ************************************************* >> hba_%datetime%.txt
gethba detail >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO ************************************************* >> hba_%datetime%.txt
ECHO ***** SAS HBA                                **** >> hba_%datetime%.txt 
ECHO ************************************************* >> hba_%datetime%.txt
cmd /c saswwpn.bat >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO ************************************************* >> hba_%datetime%.txt
ECHO ***** SAS HBA Detail                         **** >> hba_%datetime%.txt
ECHO ************************************************* >> hba_%datetime%.txt
cmd /c saswwpn.bat detail >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt
ECHO. >> hba_%datetime%.txt

ECHO list disk >diskpart.txt
cmd /c diskdata.bat > diskmap_%datetime%.txt 2> NUL
mpclaim -s -d > mpclaim_%datetime%.txt 2> NUL
mpclaim -v mpclaim_conf_%datetime%.txt -n > NUL 2> NUL
diskpart /s diskpart.txt > diskpart_%datetime%.txt
if EXIST diskpart.txt del diskpart.txt
if EXIST serial.txt del serial.txt
if EXIST mpdisk.txt del mpdisk.txt

move dpq_%datetime%.txt %dirname% > NUL 2> NUL
move hba_%datetime%.txt %dirname% > NUL 2> NUL
move diskmap_%datetime%.txt %dirname% > NUL 2> NUL
move mpclaim_%datetime%.txt %dirname% > NUL 
move mpclaim_conf_%datetime%.txt %dirname% > NUL 2> NUL
move diskpart_%datetime%.txt %dirname% > NUL 2> NUL


ECHO Collecting System Information
systeminfo > systeminfo.txt
ECHO.

move systeminfo.txt %dirname% > NUL


ECHO Collecting SDD and SDDSrv logs
ECHO.

copy %windir%\system32\sdd.log* %dirname% > NUL 2> NUL
copy %windir%\system32\sddsrv.log* %dirname% > NUL 2> NUL

ECHO Collecting Most current driver trace
ECHO.

if EXIST trace.out.old del trace.out.old

set traceFilePresent=no
if EXIST trace.out set traceFilePresent=yes
if %traceFilepresent%==yes ren trace.out trace.out.old

if EXIST pathtest_input.txt del pathtest_input.txt
ECHO 20 >>pathtest_input.txt
ECHO 2 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 88 >>pathtest_input.txt
ECHO 13 >>pathtest_input.txt
ECHO 0xdff0000 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 19 >>pathtest_input.txt
ECHO 99 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 99 >>pathtest_input.txt
type pathtest_input.txt | pathtest -d \\.\sddpath > NUL

ECHO Please wait for 30 secs... Writing DETAILED driver trace to trace.out
timeout /t 30 /nobreak > NUL

del pathtest_input.txt
ECHO 20 >>pathtest_input.txt
ECHO 2 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 88 >>pathtest_input.txt
ECHO 22 >>pathtest_input.txt
ECHO 13 >>pathtest_input.txt
ECHO 0xddb0000 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 19 >>pathtest_input.txt
ECHO 99 >>pathtest_input.txt
ECHO. >>pathtest_input.txt
ECHO 99 >>pathtest_input.txt

type pathtest_input.txt | pathtest -d \\.\sddpath > NUL


del pathtest_input.txt
move trace.out %dirname%\sdd_pathtest_trace.log > NUL
if %traceFilepresent%==yes ren trace.out.old trace.out

if EXIST %windir%\cluster\cluster.log ECHO Collecting Cluster Log
if EXIST %windir%\cluster\cluster.log copy %windir%\cluster\cluster.log %dirname% > NUL
if EXIST %windir%\cluster\cluster.log ECHO.

regedit /e sdd_temp_ccs_reg.txt HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\
if EXIST sdd_temp_ccs_reg.txt move sdd_temp_ccs_reg.txt %dirname%\%ComputerName%_CurrentControlSet_Key.txt > NUL

regedit /e sdd_temp_DeviceMap_reg.txt HKEY_LOCAL_MACHINE\HARDWARE\DEVICEMAP\
if EXIST sdd_temp_DeviceMap_reg.txt move sdd_temp_DeviceMap_reg.txt %dirname%\%ComputerName%_DeviceMap_Key.txt > NUL

regedit /e sdd_temp_cluster_reg.txt HKEY_LOCAL_MACHINE\Cluster\
if EXIST sdd_temp_cluster_reg.txt move sdd_temp_cluster_reg.txt %dirname%\%ComputerName%_CLUSTER_Key.txt > NUL

:: Time to collect Eventlog
sddutils getsystemlog > NUL
move system.evt %dirname%\System_%ComputerName%_%datetime%.evt > NUL

ECHO.
ECHO Generating a CAB file for all the Logs

:: generate the cab file
cd %dirname%

ECHO .OPTION EXPLICIT  > sdd_temp_cab.txt
ECHO .Set CabinetNameTemplate=SDDCab.cab >> sdd_temp_cab.txt
ECHO .Set MaxDiskSize=0 >> sdd_temp_cab.txt
ECHO .Set CompressionType=MSZIP >> sdd_temp_cab.txt
ECHO .Set UniqueFiles="OFF" >> sdd_temp_cab.txt
ECHO .Set Cabinet=on >> sdd_temp_cab.txt
ECHO .Set DiskDirectory1=SDDCAB >> sdd_temp_cab.txt
dir /b |findstr /v /i "sdd_temp_cab.txt">> sdd_temp_cab.txt 

makecab.exe /f sdd_temp_cab.txt > NUL

move SDDCAB\SDDCAB.cab ..\ > NUL
cd ..

rd %dirname% /s /q
move SDDCAB.cab %dirname%.cab > NUL

ECHO.
ECHO %dirname%.cab file generated

popd
endlocal
