#!/bin/sh
# Licensed Materials - Property of IBM
# 5648-F10 (C) Copyright International Business Machines Corp. 2010, 2012
# All Rights Reserved
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

targetDir=/tmp/initTool
shSystem=`uname`

refreshTgtDir(){
    if [ -f $targetDir/launchpad/content/build.txt ]; then
        usbVer=`more ./InitTool/launchpad/content/build.txt | awk '{print $2}'`
        existingVer=`more $targetDir/launchpad/content/build.txt |awk '{print $2}'`
        if [ "$usbVer" = "$existingVer" ]; then
            return
        fi

        rm -r $targetDir
    fi

    if [ ! -d $targetDir ]; then
        mkdir $targetDir
    fi

    cp -r InitTool/* $targetDir
}

#Prevent multiple instances
if [ $shSystem = Linux ]; then
    browserHTML=Mozilla.html
else
    browserHTML=WebKit.html
fi

launchPad=`ps -ef | grep IBM_LaunchPad | grep $browserHTML`
if [ -n "$launchPad" ]; then
    echo "An InitTool application instance has existed. Don't try to launch it again."
    exit 0
fi

echo "Copying application to local disk..."

#Go to shell real executing path
rootPath=`echo $0 | grep '^/'`

if [ -n "$rootPath" ]; then
    path=$(dirname "$0")  
else
    path=$(pwd)/$(dirname "$0")
fi

cd "$path" 

refreshTgtDir

echo `pwd` > $targetDir/flashdrivepath.txt

cd $targetDir

echo "Starting system initialization application..."
if [ $shSystem = Linux ]; then
    chmod -R 700 $targetDir
    nohup ./InitTool.sh>>initTool.log 2>&1 &
else
    open InitTool.app
fi
