/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

public class DownloadCSV
extends Thread {
    static final int TS3500_MOUNT_HISTORY_FILE = 0;
    static final int TS3500_LIBRARY_PERFORMANCE_FILE = 1;
    static final int TS3310_MOUNT_HISTORY_FILE = 2;
    static final int TS3310_LIBRARY_PERFORMANCE_FILE = 3;
    static final int MOUNT_HISTORY_RETRY_TIMER = 60000;
    static final int MOUNT_HISTORY_SUCCESS_TIMER = 600000;
    static final int LIBRARY_PERFORMANCE_RETRY_TIMER = 60000;
    static final int LIBRARY_PERFORMANCE_SUCCESS_TIMER = 3600000;
    static final int MAX_RETRY_TIMER = 0x200B20;
    static final int ATEMPT_RETRY_TIMER = 300000;
    static final int MAX_RETRIES = 5;
    private String m_library;
    private int m_csvFileType;
    private StringBuffer m_file = new StringBuffer(0);
    Connection databaseConn = null;
    String databaseDriver = null;
    String databaseUrl = null;
    String databaseUsername = null;
    String databasePassword = null;
    String databaseTable = null;
    String[] columns;

    public DownloadCSV(String library, int m_csvFileType) {
        if (JTsrServer.TSSC) {
            this.databaseDriver = "org.apache.derby.jdbc.ClientDriver";
            this.databaseUrl = "jdbc:derby://localhost/TSRDB";
            this.databaseUsername = "tsr";
            this.databasePassword = "Passw0rd";
            this.databaseTable = "TSRDATA";
        } else {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream("tsrserver.properties"));
                this.databaseDriver = props.getProperty("databaseDriver");
                this.databaseUrl = props.getProperty("databaseUrl");
                this.databaseUsername = props.getProperty("databaseUsername");
                this.databasePassword = props.getProperty("databasePassword");
                this.databaseTable = props.getProperty("databaseTable");
            }
            catch (Exception e) {
                System.out.println("***** ERROR: Invalid properties file *****");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        this.m_library = library;
        this.m_csvFileType = m_csvFileType;
        this.setDaemon(false);
        this.start();
    }

    public void run() {
        while (true) {
            boolean rc = false;
            int retries = 0;
            try {
                Class.forName(this.databaseDriver);
                this.databaseConn = DriverManager.getConnection(this.databaseUrl, this.databaseUsername, this.databasePassword);
                int count = 0;
                retries = 0;
                while (count >= 0 || retries < 5) {
                    this.m_file.delete(0, this.m_file.length());
                    rc = this.download();
                    if (this.m_file.capacity() <= 0) continue;
                    if (this.m_csvFileType == 0 || this.m_csvFileType == 2) {
                        count = this.parseMH(retries + 1);
                        if (count >= 0) {
                            System.out.println("Inserted " + count + " new Mount History entries from " + this.m_library + " on " + new Date().toString());
                            break;
                        }
                        DownloadCSV.sleep(300000L);
                        ++retries;
                        continue;
                    }
                    if (this.m_csvFileType == 1 || this.m_csvFileType == 3) {
                        count = this.parseLP(retries + 1);
                        if (count >= 0) {
                            System.out.println("Inserted " + count + " new Library Performance entries from " + this.m_library + " on " + new Date().toString());
                            break;
                        }
                        DownloadCSV.sleep(300000L);
                        ++retries;
                        continue;
                    }
                    System.out.println("***** ERROR: Invalid download CSV file *****");
                }
                if (retries == 5) {
                    System.out.println("***** ERROR: Too many retries from parse routine for library: " + this.m_library + ".  Will retry in 35 minutes");
                }
                this.databaseConn.close();
            }
            catch (Exception e) {
                System.out.println("***** ERROR: " + e.getMessage());
            }
            if (retries == 5) {
                try {
                    DownloadCSV.sleep(0x200B20L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.m_csvFileType == 0 || this.m_csvFileType == 2) {
                try {
                    if (rc) {
                        DownloadCSV.sleep(600000L);
                        continue;
                    }
                    DownloadCSV.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.m_csvFileType == 1 || this.m_csvFileType == 3) {
                try {
                    if (rc) {
                        DownloadCSV.sleep(3600000L);
                        continue;
                    }
                    DownloadCSV.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            System.out.println("***** ERROR: Invalid CSV File.  Will try again in one minute*****");
            try {
                DownloadCSV.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean download() {
        String libraryURL = null;
        URL url = null;
        URLConnection conn = null;
        InputStream in = null;
        boolean rc = false;
        try {
            if (this.m_csvFileType == 0) {
                libraryURL = "http://" + this.m_library + "/FS/LIBLG_01_CS.bin";
            } else if (this.m_csvFileType == 1) {
                libraryURL = "http://" + this.m_library + "/FS/LIBLG_01_LP.bin";
            } else if (this.m_csvFileType == 2) {
                libraryURL = "http://" + this.m_library + "/download_mount_history.htm";
            } else if (this.m_csvFileType == 3) {
                libraryURL = "http://" + this.m_library + "/download_library_stats.htm";
            } else {
                System.out.println("***** ERROR: Invalid CSV file *****");
                boolean bl = rc;
                return bl;
            }
            try {
                int c;
                url = new URL(libraryURL);
                conn = url.openConnection();
                in = conn.getInputStream();
                while ((c = in.read()) != -1) {
                    if (c == 0) continue;
                    this.m_file.append((char)c);
                }
            }
            catch (Exception e) {
                System.out.println("***** ERROR: " + e.getMessage() + " *****");
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    rc = true;
                }
            }
            catch (IOException ioe) {
                System.out.println("***** ERROR: " + ioe.getMessage());
            }
        }
        return rc;
    }

    private int parseMH(int retries) {
        int insertCount = 0;
        try {
            Statement st = this.databaseConn.createStatement();
            String[] mh = this.m_file.toString().split("\n");
            int i = 5;
            while (i < mh.length) {
                if (mh[i].length() > 0) {
                    int n = i;
                    mh[n] = String.valueOf(mh[n]) + " ";
                    this.columns = mh[i].split(",");
                    String select = null;
                    if (this.databaseUrl.indexOf("derby") > 0 || this.databaseUrl.indexOf("db2") > 0) {
                        select = "SELECT IPADDRESS, DATE, TIME, VOLSER, LOGICAL_LIBRARY FROM " + this.databaseTable + " WHERE IPADDRESS = '" + this.m_library + "' AND ";
                    } else if (this.databaseUrl.indexOf("oracle") > 0) {
                        select = "SELECT IPADDRESS, TO_CHAR(DATES,'yyyy-mm-dd') AS DATES, TO_CHAR(TIME,'hh24:mi:ss') AS TIME, VOLSER, LOGICAL_LIBRARY FROM " + this.databaseTable + " WHERE IPADDRESS = '" + this.m_library + "' AND ";
                    } else {
                        System.out.println("***** ERROR: Invalid database vendor *****");
                        System.exit(-1);
                    }
                    String insert = "INSERT INTO " + this.databaseTable + " VALUES ('" + this.m_library + "',";
                    int j = 0;
                    while (j < this.columns.length) {
                        if (this.columns[j].length() > 0 && this.columns[j].charAt(0) == '_') {
                            this.columns[j] = this.columns[j].substring(1);
                        }
                        this.columns[j] = this.columns[j].trim();
                        if (j == 0) {
                            int index = this.columns[j].indexOf(":");
                            String date = this.columns[j].substring(0, index -= 2);
                            String time = this.columns[j].substring(index);
                            date = date.trim();
                            time = time.trim();
                            time = time.replaceAll("\\.", ":");
                            time = time.replaceAll("\\s+", "");
                            date = date.replaceAll("\\s+", "-");
                            time = time.replaceAll("\\x00+", "");
                            date = date.replaceAll("\\x00+", "");
                            if (this.databaseUrl.indexOf("derby") > 0 || this.databaseUrl.indexOf("db2") > 0) {
                                select = String.valueOf(select) + "DATE = '" + date + "' AND ";
                                select = String.valueOf(select) + "TIME = '" + time + "' AND ";
                                insert = String.valueOf(insert) + "'" + date + "',";
                                insert = String.valueOf(insert) + "'" + time + "'";
                            } else if (this.databaseUrl.indexOf("oracle") > 0) {
                                select = String.valueOf(select) + "DATES = TO_DATE('" + date + "','yyyy-mm-dd') AND ";
                                select = String.valueOf(select) + "TIME = TO_DATE('" + time + "','hh24:mi:ss') AND ";
                                insert = String.valueOf(insert) + "TO_DATE('" + date + "','yyyy-mm-dd'),";
                                insert = String.valueOf(insert) + "TO_DATE('" + time + "','hh24:mi:ss')";
                            } else {
                                System.out.println("***** ERROR: Invalid database vendor *****");
                                System.exit(-1);
                            }
                        } else if (this.columns[j].length() > 0) {
                            if (j == 1) {
                                select = String.valueOf(select) + "VOLSER = '" + this.columns[j] + "'";
                                insert = String.valueOf(insert) + ",'" + this.columns[j] + "'";
                            } else if (j == 4) {
                                select = String.valueOf(select) + " AND LOGICAL_LIBRARY = '" + this.columns[j] + "'";
                                insert = String.valueOf(insert) + ",'" + this.columns[j] + "'";
                            } else {
                                insert = String.valueOf(insert) + "," + this.columns[j];
                            }
                        } else {
                            insert = String.valueOf(insert) + ",null";
                        }
                        ++j;
                    }
                    insert = String.valueOf(insert) + ")";
                    ResultSet selectResults = st.executeQuery(select);
                    if (!selectResults.next()) {
                        selectResults.close();
                        if (st.executeUpdate(insert) > 0) {
                            ++insertCount;
                        } else {
                            System.out.println("***** ERROR: Insert Failure (" + insert + ") *****");
                        }
                    }
                }
                ++i;
            }
            st.close();
        }
        catch (Exception e) {
            System.out.println("***** Warning: Parse Mount History failed.  Attempt " + retries + " of 5");
            e.printStackTrace();
            return -1;
        }
        return insertCount;
    }

    private int parseLP(int retries) {
        int insertCount = 0;
        try {
            Statement st = this.databaseConn.createStatement();
            String[] lp = this.m_file.toString().split("\n");
            int i = 6;
            while (i < lp.length) {
                lp[i] = lp[i].trim().replace('_', ' ');
                if (lp[i].length() > 0) {
                    this.columns = lp[i].split(",");
                    String select = null;
                    if (this.databaseUrl.indexOf("derby") > 0 || this.databaseUrl.indexOf("db2") > 0) {
                        select = "SELECT IPADDRESS, DATE, TIME, LOGICAL_LIBRARY FROM " + this.databaseTable + "_lp" + " WHERE IPADDRESS = '" + this.m_library + "' AND ";
                    } else if (this.databaseUrl.indexOf("oracle") > 0) {
                        select = "SELECT IPADDRESS, TO_CHAR(DATES,'yyyy-mm-dd') AS DATES, TO_CHAR(TIME,'hh24:mi:ss') AS TIME, LOGICAL_LIBRARY FROM " + this.databaseTable + "_lp" + " WHERE IPADDRESS = '" + this.m_library + "' AND ";
                    } else {
                        System.out.println("***** ERROR: Invalid database vendor *****");
                        System.exit(-1);
                    }
                    String insert = "INSERT INTO " + this.databaseTable + "_lp" + " VALUES ('" + this.m_library + "',";
                    int j = 0;
                    while (j < this.columns.length) {
                        this.columns[j] = this.columns[j].trim();
                        if (j == 0) {
                            int index = this.columns[j].indexOf(":");
                            String date = this.columns[j].substring(0, index -= 2);
                            String time = this.columns[j].substring(index);
                            date = date.trim();
                            time = time.trim();
                            time = time.replaceAll("\\s+", "");
                            date = date.replaceAll("\\s+", "-");
                            time = time.replaceAll("\\x00+", "");
                            date = date.replaceAll("\\x00+", "");
                            if (this.databaseUrl.indexOf("derby") > 0 || this.databaseUrl.indexOf("db2") > 0) {
                                select = String.valueOf(select) + "DATE = '" + date + "' AND ";
                                select = String.valueOf(select) + "TIME = '" + time + ":00' AND ";
                                insert = String.valueOf(insert) + "'" + date + "',";
                                insert = String.valueOf(insert) + "'" + time + ":00'";
                            } else if (this.databaseUrl.indexOf("oracle") > 0) {
                                select = String.valueOf(select) + "DATES = TO_DATE('" + date + "','yyyy-mm-dd') AND ";
                                select = String.valueOf(select) + "TIME = TO_DATE('" + time + ":00','hh24:mi:ss') AND ";
                                insert = String.valueOf(insert) + "TO_DATE('" + date + "','yyyy-mm-dd'),";
                                insert = String.valueOf(insert) + "TO_DATE('" + time + ":00','hh24:mi:ss')";
                            } else {
                                System.out.println("***** ERROR: Invalid database vendor *****");
                                System.exit(-1);
                            }
                        } else if (this.columns[j].length() > 0) {
                            if (j == 1) {
                                select = String.valueOf(select) + " LOGICAL_LIBRARY = '" + this.columns[j] + "'";
                                insert = String.valueOf(insert) + ",'" + this.columns[j] + "'";
                            } else {
                                insert = String.valueOf(insert) + "," + this.columns[j];
                            }
                        } else {
                            insert = String.valueOf(insert) + ",null";
                        }
                        ++j;
                    }
                    insert = String.valueOf(insert) + ")";
                    ResultSet selectResults = st.executeQuery(select);
                    if (!selectResults.next()) {
                        selectResults.close();
                        if (st.executeUpdate(insert) > 0) {
                            ++insertCount;
                        } else {
                            System.out.println("***** ERROR: Insert Failure (" + insert + ") *****");
                        }
                    }
                }
                ++i;
            }
            st.close();
        }
        catch (Exception e) {
            System.out.println("***** Warning: Parse Library Performance failed.  Attempt " + retries + " of 5");
            e.printStackTrace();
            return -1;
        }
        return insertCount;
    }
}

