/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class JTsrServer {
    public static final int DELAY = 15000;
    public static boolean TSSC = true;

    public static void main(String[] args) {
        String databaseDriver = null;
        String databaseUrl = null;
        String databaseUsername = null;
        String databasePassword = null;
        String databaseTable = null;
        System.out.println("JTsrServer - 1.1b Build: 20121102 - Started");
        try {
            FileInputStream tempFile = new FileInputStream("/usr/bin/enc/rsENInformation.pl");
            tempFile.close();
        }
        catch (FileNotFoundException e4) {
            TSSC = false;
        }
        catch (IOException e4) {
            // empty catch block
        }
        Connection databaseConn = null;
        Statement st = null;
        ResultSet selectResults = null;
        Properties props = new Properties();
        try {
            if (TSSC) {
                databaseDriver = "org.apache.derby.jdbc.ClientDriver";
                databaseUrl = "jdbc:derby://localhost/TSRDB";
                databaseUsername = "tsr";
                databasePassword = "Passw0rd";
                databaseTable = "TSRDATA";
            } else {
                props.load(new FileInputStream("tsrserver.properties"));
                databaseDriver = props.getProperty("databaseDriver");
                databaseUrl = props.getProperty("databaseUrl");
                databaseUsername = props.getProperty("databaseUsername");
                databasePassword = props.getProperty("databasePassword");
                databaseTable = props.getProperty("databaseTable");
            }
            if (databaseDriver == null || databaseUrl == null || databaseUsername == null || databasePassword == null || databaseTable == null) {
                System.out.println("***** ERROR: Missing properties file field *****");
                System.exit(-1);
            }
            try {
                Class.forName(databaseDriver);
            }
            catch (Exception e3) {
                System.out.println("***** ERROR: Could not find the driver: " + e3.getMessage() + "   Check properties file *****");
                e3.printStackTrace();
                System.exit(-1);
            }
            try {
                databaseConn = DriverManager.getConnection(databaseUrl, databaseUsername, databasePassword);
            }
            catch (Exception e) {
                System.out.print("***** ERROR: " + e.getMessage() + " Check properties file *****");
                e.printStackTrace();
                System.exit(-1);
            }
            st = databaseConn.createStatement();
            try {
                if (databaseUrl.indexOf("derby") > 0 || databaseUrl.indexOf("db2") > 0) {
                    selectResults = st.executeQuery("SELECT * FROM " + databaseTable + " WHERE DATE = CURRENT_DATE");
                } else if (databaseUrl.indexOf("oracle") > 0) {
                    selectResults = st.executeQuery("SELECT * FROM " + databaseTable + " WHERE DATES = CURRENT_DATE");
                } else {
                    System.out.println("***** ERROR: Invalid database vendor *****");
                    System.exit(-1);
                }
                selectResults.close();
            }
            catch (Exception e1) {
                System.out.println("***** INFO: Table does not exist.  Will create now. *****");
                String createMHTable = null;
                String createLPTable = null;
                String createReportsTable = null;
                if (databaseUrl.indexOf("derby") > 0 || databaseUrl.indexOf("db2") > 0) {
                    createMHTable = "CREATE TABLE " + databaseTable + " (ipAddress varchar(64), Date date, Time time, Volser varchar(8), Frame int, Drive int, Logical_Library varchar(30), Element_Address int, Reserved1 int, Reserved2 int, Mount_Host_Write int, Mount_Host_Read int, Mount_Drive_Residency int, Mount_TapeAlert_Media int, Life_Mounts_Media int, Life_Write_Retries_Media int, Life_Write_Perms_Media int, Life_Read_Retries_Media int, Life_Read_Perms_Media int, Mount_Rating_Drive int, Mount_Rating_Media int, Mount_Rating_Ports int, Mount_Rating_Port0 int, Mount_Rating_Port1 int, Reserved3 int, Mount_Write_Perf_Util int, Mount_Write_ERPs_Impct int, Mount_Write_Burst_Util int, Mount_Write_Buffer_Util int, Mount_Read_Perf_Util int, Mount_Read_ERPs_Impct int, Mount_Read_Burst_Util int,Mount_Read_Buffer_Util int, Mount_Capacity_Total_Util int, Mount_Capacity_Writes_Util int, Mount_Capacity_Control_Util int, Mount_Crypto_Status smallint, Mount_Crypto_Rekey smallint)";
                    createLPTable = "CREATE TABLE " + databaseTable + "_lp" + " (ipAddress varchar(64), Date date, Time time, Logical_Library varchar(30), Residency_Max int, Residency_Avg int, Mounts_Total smallint, Mounts_Max smallint, Mounts_Avg smallint, Ejects_Total smallint, Ejects_Max smallint, Ejects_Avg smallint, Inserts_Total smallint)";
                    createReportsTable = "CREATE TABLE " + databaseTable + "_reports" + " (Username varchar(25), Report_Name varchar(50), ipAddress varchar(64), Range smallint, Field_Type varchar(50), Eff_Value varchar(50), Col_Type smallint, Value varchar(512), Report_Type smallint)";
                } else if (databaseUrl.indexOf("oracle") > 0) {
                    createMHTable = "CREATE TABLE " + databaseTable + " (ipAddress varchar2(64), Dates date, Time timestamp, Volser varchar2(8), Frame number, Drive number, Logical_Library varchar2(30), Element_Address number, Reserved1 number, Reserved2 number, Mount_Host_Write number, Mount_Host_Read number, Mount_Drive_Residency number, Mount_TapeAlert_Media number, Life_Mounts_Media number, Life_Write_Retries_Media number, Life_Write_Perms_Media number, Life_Read_Retries_Media number, Life_Read_Perms_Media number, Mount_Rating_Drive number, Mount_Rating_Media number, Mount_Rating_Ports number, Mount_Rating_Port0 number, Mount_Rating_Port1 number, Reserved3 number, Mount_Write_Perf_Util number, Mount_Write_ERPs_Impct number, Mount_Write_Burst_Util number, Mount_Write_Buffer_Util number, Mount_Read_Perf_Util number, Mount_Read_ERPs_Impct number, Mount_Read_Burst_Util number,Mount_Read_Buffer_Util number, Mount_Capacity_Total_Util number, Mount_Capacity_Writes_Util number, Mount_Capacity_Control_Util number, Mount_Crypto_Status number, Mount_Crypto_Rekey number)";
                    createLPTable = "CREATE TABLE " + databaseTable + "_lp" + " (ipAddress varchar2(64), Dates date, Time timestamp, Logical_Library varchar2(30), Residency_Max number, Residency_Avg number, Mounts_Total number, Mounts_Max number, Mounts_Avg number, Ejects_Total number, Ejects_Max number, Ejects_Avg number, Inserts_Total number)";
                    createReportsTable = "CREATE TABLE " + databaseTable + "_reports" + " (Username varchar2(25), Report_Name varchar2(50), ipAddress varchar2(64), Range number, Field_Type varchar2(50), Eff_Value varchar2(50), Col_Type number, Value varchar2(512), Report_Type number)";
                } else {
                    System.out.println("***** ERROR: Invalid database vendor *****");
                    System.exit(-1);
                }
                try {
                    st.executeUpdate(createMHTable);
                    st.executeUpdate(createLPTable);
                    st.executeUpdate(createReportsTable);
                }
                catch (Exception e2) {
                    System.out.println("***** ERROR: " + e2.getMessage().trim() + ". Check database table in properties file *****");
                    e2.printStackTrace();
                    System.exit(-1);
                }
            }
            st.close();
            databaseConn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (TSSC) {
            File dir = new File("/var/enc/config/");
            String[] files = dir.list();
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].indexOf("SS3584") >= 0) {
                    try {
                        String tempLine;
                        FileInputStream tempFile = new FileInputStream("/var/enc/config/" + files[i]);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(tempFile));
                        long delay = 0L;
                        while ((tempLine = reader.readLine()) != null) {
                            if (!tempLine.contains("IP_address")) continue;
                            String address = tempLine.substring(tempLine.indexOf("=") + 1);
                            new CreateThreads(address, delay);
                            delay += 15000L;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        } else {
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream("hosts.properties");
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                long delay = 0L;
                while ((strLine = br.readLine()) != null) {
                    strLine = strLine.trim();
                    new CreateThreads(strLine, delay);
                    delay += 15000L;
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

