/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.anaconda.beans;

import java.util.HashMap;
import java.util.Map;

public class Cartridge {
    private String logicalLibraryName = "";
    private Map<String, String> location = new HashMap<String, String>();
    private String volser = "";
    private String VEA = "";
    private String type = "";
    private String FCRTT = "";
    private String FCRTTL = "";
    public static final HashMap<Integer, String> elementMediaType = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "");
            this.put(1, "LTO");
            this.put(2, "");
            this.put(3, "3592");
        }
    };
    public static final HashMap<Integer, String> elementEncryption = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "Unknown");
            this.put(1, "Not Encrypted");
            this.put(2, "Encrypted");
        }
    };
    public static final HashMap<Integer, String> elementType = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "");
            this.put(1, "Gripper");
            this.put(2, "Slot");
            this.put(3, "I/O Slot");
            this.put(4, "Drive");
            this.put(5, "Shuttle");
            this.put(6, "");
            this.put(7, "");
            this.put(8, "Cleaning");
        }
    };

    public Cartridge() {
    }

    public Cartridge(String frame, String column, String row, String tier) {
        this.location.put("frame", frame);
        this.location.put("column", column);
        this.location.put("row", row);
        this.location.put("tier", tier);
        this.FCRTT = String.valueOf(frame) + column + row + tier;
    }

    public Cartridge(String frame, String column, String row, String tier, String llName) {
        this.location.put("frame", frame);
        this.location.put("column", column);
        this.location.put("row", row);
        this.location.put("tier", tier);
        this.logicalLibraryName = llName;
        this.FCRTT = String.valueOf(frame) + column + row + tier;
    }

    public Cartridge(String volser) {
        this.volser = volser;
        this.location.put("frame", "");
        this.location.put("column", "");
        this.location.put("row", "");
        this.location.put("tier", "");
    }

    public Cartridge(String vea, String ll) {
        this.VEA = vea;
        this.logicalLibraryName = ll;
    }

    public void setType(String t) {
        this.type = t;
        this.FCRTT = String.valueOf(this.FCRTT) + "T" + t;
        this.FCRTTL = String.valueOf(this.getFCRTTForBulk()) + "L" + this.getLL();
    }

    public String getType() {
        return this.type;
    }

    public void setLL(String ll) {
        this.logicalLibraryName = ll;
    }

    public Map<String, String> getLocation() {
        return this.location;
    }

    public String getFCRTT() {
        return this.FCRTT;
    }

    public void setFCRTTForBulk(String newLoc) {
        this.FCRTT = newLoc;
    }

    public String getFCRTTForBulk() {
        String tmp = this.FCRTT;
        tmp = this.FCRTT.replace("F", "F'").replace("C", "C'").replace("R", "R'").replace("T", "T'");
        return tmp;
    }

    public String getFCRTTL() {
        return this.FCRTTL;
    }

    public String getLL() {
        return this.logicalLibraryName;
    }

    public String getVolser() {
        return this.volser;
    }

    public void setVolser(String volser) {
        this.volser = volser;
    }

    public void setLocation(String frame, String column, String row, String tier) {
        this.location.put("frame", frame);
        this.location.put("column", column);
        this.location.put("row", row);
        this.location.put("tier", tier);
    }

    public void setVEA(String vea) {
        this.VEA = vea;
    }

    public String getVEA() {
        return this.VEA;
    }
}

