/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.anaconda.CLI;

import com.ibm.anaconda.CLI.Connection;
import com.ibm.anaconda.CLI.Gen4cli;
import com.ibm.anaconda.CLI.LongRunningTask;
import com.ibm.anaconda.CLI.Messages;
import com.ibm.anaconda.CLI.SSHCommands;
import com.ibm.anaconda.CLI.UtilCLI;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.storage.anaconda.beans.Cartridge;
import com.ibm.storage.anaconda.beans.Drive;
import com.ibm.storage.anaconda.beans.DriveEncrypted;
import com.ibm.storage.anaconda.beans.VolserRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.http.client.ClientProtocolException;

public class Command {
    public static final int ALL_TYPE = 0;
    public static final int MTE_TYPE = 1;
    public static final int STE_TYPE = 2;
    public static final int IEE_TYPE = 3;
    public static final int DTE_TYPE = 4;
    private static String PATH = "";
    private static String BACKUP_SCRIPT = "/com/ibm/anaconda/resources/library_backup.sh";
    private static String RESTORE_SCRIPT = "/com/ibm/anaconda/resources/library_restore.sh";
    private static String MIGRATION_SCRIPT = "/com/ibm/anaconda/resources/db_migration.sh";
    private String name = "";
    private String responseBody = "";
    private Connection connection = null;
    private int lrtIndex = -1;
    private boolean status = false;
    private int percentage = 0;
    private boolean verbose = false;
    private Map<String, String> params = null;

    public Command() {
    }

    public Command(String name, Map<String, String> params) {
        this.name = name;
        this.params = params;
    }

    public void setName(String name) {
        if (this.params.containsKey("verbose")) {
            System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Calling task " + name);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
        if (this.params.containsKey("verbose")) {
            this.verbose = true;
        }
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public boolean getStatus() {
        return this.status;
    }

    private JSONObject getJSONObject(String response) {
        JSONObject object;
        block2: {
            JSONArray LLArray = null;
            object = null;
            try {
                LLArray = JSONArray.parse((String)response.toString());
                object = (JSONObject)LLArray.get(0);
            }
            catch (IOException e) {
                System.out.println("****ERROR: Could not parse JSON string");
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block2;
                e.printStackTrace();
            }
        }
        return object;
    }

    private boolean getResponseBody(String URL2, String strFormat, boolean next) {
        boolean result;
        block6: {
            result = false;
            try {
                this.responseBody = this.connection.doGet(URL2);
                if (this.responseBody.contains("Empty data set")) {
                    System.out.println(strFormat);
                    Gen4cli.returnStatus = 0;
                    result = false;
                } else if (this.responseBody.contains("exception")) {
                    this.handleException(this.responseBody, next);
                } else {
                    result = true;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block6;
                e.printStackTrace();
            }
        }
        return result;
    }

    private void handleException(String response, boolean next) {
        JSONObject result;
        block11: {
            result = null;
            try {
                result = this.getJSONObject(response);
            }
            catch (Exception e) {
                block10: {
                    if (response.contains("Sense Key")) {
                        response = response.replace("{\"errorMessage\":", "");
                        response = response.substring(0, response.length() - 1);
                        try {
                            result = JSONObject.parse((String)response);
                        }
                        catch (IOException e1) {
                            System.out.println("****ERROR: There was a problem parsing the FW response");
                            Gen4cli.returnStatus = 1;
                            if (!this.verbose) break block10;
                            e1.printStackTrace();
                        }
                    }
                }
                if (!this.verbose) break block11;
                e.printStackTrace();
            }
        }
        String msg = "Check logs for more information.";
        if (result.get((Object)"message") != null) {
            msg = (String)result.get((Object)"message");
        } else if (result.get((Object)"errorMessage") != null) {
            msg = (String)result.get((Object)"errorMessage");
        }
        System.out.println("****ERROR: There was a problem in the command execution - " + msg.replace("<br>", ""));
        if (next) {
            System.out.println("****************************************************************");
            System.out.println("Moving to next element...");
        } else {
            Gen4cli.returnStatus = 1;
        }
    }

    private void printSort(Map<String, String> mapOriginal) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(mapOriginal);
        for (String str : treeMap.keySet()) {
            System.out.println((String)treeMap.get(str));
        }
    }

    private void printResultMessage(String msg) {
        block5: {
            try {
                JSONObject result = JSONObject.parse((String)this.responseBody);
                long returnCode = (Long)result.get((Object)"returnCode");
                if (returnCode == 0L) {
                    System.out.println(msg);
                    Gen4cli.returnStatus = 0;
                } else {
                    System.out.println("***** ERROR: There was a problem in the comand execution. Return code = " + returnCode + " *****");
                    Integer ascAscq = Integer.parseInt(result.get((Object)"ascAscq").toString());
                    if (ascAscq != 0 && Messages.SENSE_CODES.containsKey(ascAscq)) {
                        System.out.println("***** " + Messages.SENSE_CODES.get(ascAscq));
                    }
                    Gen4cli.returnStatus = 1;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void libraryFirmwareUpdateTask() throws ClientProtocolException, IOException {
        String fileName = this.params.get("filename");
        System.out.println("Name: " + fileName);
        File f = new File(fileName);
        if (f.exists()) {
            if (fileName.substring(fileName.length() - 5, fileName.length()).toLowerCase().compareTo(".afwz") != 0) {
                System.out.println("*****ERROR: The file extension is not supported.");
                Gen4cli.returnStatus = 1;
            } else {
                System.out.println(">>>Uploading file..");
                this.responseBody = this.connection.doUpload("/CLIUpload", f);
                Gen4cli.returnStatus = 0;
            }
        } else {
            System.out.println("****ERROR: The file cannot be found. The update was cancelled.");
            Gen4cli.returnStatus = 1;
        }
    }

    public void driveFirmwareUpdateTask() throws ClientProtocolException, IOException {
        System.out.println("Name: " + this.params.get("filename"));
        String list = this.params.get("list");
        if (!this.validateListOfDrives(list, this.params.get("filename"))) {
            return;
        }
        String[] drives = list.split(",");
        HashMap<String, String> mapDrives = this.getDrivesTypes(false);
        String newList = "";
        int i = 0;
        while (i < drives.length) {
            if (mapDrives.containsKey(drives[i])) {
                newList = String.valueOf(newList) + drives[i] + ",";
            } else {
                System.out.println("****ERROR: Drive " + drives[i] + " is not available.");
            }
            ++i;
        }
        if (!newList.isEmpty()) {
            list = newList.substring(0, newList.length() - 1);
            System.out.println("\nThese drives will be updated: " + list);
            list = list.replace("F", "0");
            list = list.replace("C", "0");
            list = list.replace("R", "0");
            File f = new File(this.params.get("filename"));
            if (f.exists()) {
                JSONObject result;
                System.out.println(">>>Uploading file..");
                this.responseBody = this.connection.doUpload("/FileUploadServlet", f);
                String name = f.getName();
                String URL2 = "CLIHandler?action=driveCodeUpdate&list=" + list + "&file=/mnt/scratch/" + name + "&options=" + UtilCLI.getTypeReset(this.params.get("reset").toString());
                if (this.getResponseBody(URL2, "", true) && (Long)(result = JSONObject.parse((String)this.responseBody)).get((Object)"returnCode") == 0L) {
                    long index = (Long)result.get((Object)"returnCode");
                    if (index != 0L) {
                        System.out.println("This is a Long Running Task, the completed percentage will be shown:");
                    }
                    System.out.println("The code update has started");
                    System.out.println("-----------------------------------------");
                }
            } else {
                System.out.println("****ERROR: The file cannot be found. The update was cancelled.");
                Gen4cli.returnStatus = 1;
            }
        }
    }

    private boolean validateListOfDrives(String list, String file) {
        boolean result = false;
        ArrayList<String> LTO = new ArrayList<String>();
        ArrayList<String> JAG = new ArrayList<String>();
        String ext = "";
        LTO.add("LTO 5");
        JAG.add("LTO 6");
        JAG.add("LTO 7");
        JAG.add("3592-E04");
        JAG.add("3592-E05");
        JAG.add("3592-E06");
        JAG.add("3592-E07");
        JAG.add("3592-EH7");
        JAG.add("3592-E08");
        JAG.add("3592-EH8");
        String[] drives = list.split(",");
        HashMap<String, String> mapDrives = this.getDrivesTypes(false);
        int i = 0;
        while (i < drives.length) {
            result = false;
            if (mapDrives.containsKey(drives[i])) {
                String type = mapDrives.get(drives[i]);
                if (LTO.indexOf(type) > -1) {
                    ext = ".ro";
                } else if (JAG.indexOf(type) > -1) {
                    ext = ".fmrz";
                } else {
                    System.out.println("*****ERROR: Drive " + drives[i] + " is of a non-supported type");
                    Gen4cli.returnStatus = 1;
                    return result;
                }
            }
            if (ext.compareTo(".ro") == 0) {
                if (file.substring(file.length() - 3, file.length()).compareTo(ext) != 0) {
                    System.out.println("*****ERROR: The file extension is not supported by the drive type: " + drives[i]);
                    Gen4cli.returnStatus = 1;
                    return result;
                }
            } else if (file.substring(file.length() - 5, file.length()).compareTo(ext) != 0 && !ext.isEmpty()) {
                System.out.println("*****ERROR: The file extension is not supported by the drive type: " + drives[i]);
                Gen4cli.returnStatus = 1;
                return result;
            }
            ++i;
        }
        return true;
    }

    private HashMap<String, String> getDrivesTypes(boolean getAll) {
        HashMap<String, String> mapDrives;
        block7: {
            mapDrives = null;
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveSummary";
                mapDrives = new HashMap<String, String>();
                if (this.getResponseBody(URL2, "", false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    JSONObject object = null;
                    if (getAll) {
                        for (Object drive : driveArray) {
                            object = (JSONObject)drive;
                            String location = ((String)object.get((Object)"location")).replace(",", "");
                            String type = UtilCLI.getDriveType((String)object.get((Object)"type"));
                            mapDrives.put(location.replace(" ", ""), type);
                            mapDrives.put(location.replace(" ", ""), type);
                        }
                    } else {
                        for (Object drive : driveArray) {
                            object = (JSONObject)drive;
                            String state = UtilCLI.getDriveState((String)object.get((Object)"state"));
                            if (state.compareTo("OFFLINE") == 0 || state.compareTo("DISCONNECTED") == 0) continue;
                            String location = ((String)object.get((Object)"location")).replace(",", "");
                            String type = UtilCLI.getDriveType((String)object.get((Object)"type"));
                            mapDrives.put(location.replace(" ", ""), type);
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block7;
                e.printStackTrace();
            }
        }
        return mapDrives;
    }

    public void downloadLogTask() throws ClientProtocolException, IOException {
        if (!this.connection.doDownload("/DownloadServlet?type=LogFile", "log")) {
            System.out.println("\nThere was a problem dowloading logs. Try again");
        }
    }

    public void downloadPropertiesFileTask() throws ClientProtocolException, IOException {
        if (!this.connection.doDownloadProperties("/DownloadServlet?type=PropertiesFile")) {
            System.out.println("\nThere was a problem dowloading the file. Please, try again");
        }
    }

    public void downloadSnapshotTask() throws ClientProtocolException, IOException {
        if (!this.connection.doDownload("/DownloadServlet?type=Snapshot&params=" + this.params.get("index"), "snapshot")) {
            System.out.println("\nThere was a problem dowloading the snapshot file. Try again");
        }
    }

    public void checkTimerTask() {
        this.updateStatus();
        LongRunningTask lrt = new LongRunningTask(this);
    }

    public void updateStatus() {
        block5: {
            try {
                this.responseBody = this.connection.doGet(String.valueOf(PATH) + "/CLIHandler?action=getStatus&lrtIndex=" + this.lrtIndex);
                JSONArray eventArray = JSONArray.parse((String)this.responseBody.toString());
                Iterator iterator = eventArray.iterator();
                if (iterator.hasNext()) {
                    Object drive = iterator.next();
                    JSONObject event = (JSONObject)drive;
                    String percentageStr = (String)event.get((Object)"percentcomplete");
                    String activeStr = (String)event.get((Object)"status");
                    if (activeStr.compareTo("1") == 0) {
                        this.status = true;
                        this.percentage = Integer.parseInt(percentageStr);
                    } else {
                        this.status = false;
                        this.percentage = Integer.parseInt(percentageStr);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void viewLogicalLibraryDetailsTask() {
        String strFormat;
        String URL2 = "/CLIHandler?action=viewLogicalLibraryDetails&LogLibIdx='" + this.params.get("logicalLibrary") + "'";
        if (this.getResponseBody(URL2, strFormat = String.format("%20s,%15s,%16s,%20s,%20s", "Name", "Type", "Max Cartridges", "Virtual I/O element address range", "Drive element address range"), false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            if (Gen4cli.returnStatus == 0) {
                System.out.println(strFormat);
                String driveAdd1 = ((String)object.get((Object)"firstdriveea")).isEmpty() ? "0" : (String)object.get((Object)"firstdriveea");
                String driveAdd2 = ((String)object.get((Object)"lastdriveea")).isEmpty() ? "0" : (String)object.get((Object)"lastdriveea");
                String vio1 = ((String)object.get((Object)"firstvioea")).isEmpty() ? "0" : (String)object.get((Object)"firstvioea");
                String vio2 = ((String)object.get((Object)"lastvioea")).isEmpty() ? "0" : (String)object.get((Object)"lastvioea");
                System.out.println(String.format("%20s,%15s,%16s,%20s,%20s", (String)object.get((Object)"name"), UtilCLI.getMediaType((String)object.get((Object)"mediatype")), (String)object.get((Object)"maxcart"), String.valueOf(vio1) + "-" + vio2, String.valueOf(driveAdd1) + "-" + driveAdd2));
                Gen4cli.returnStatus = 0;
            }
        }
    }

    public void viewLogicalLibrariesTask() {
        block4: {
            try {
                String URL2 = "/CLIHandler?action=viewLogicalLibraries";
                String strFormat = String.format("%20s,%15s,%20s,%25s,%10s,%17s,%15s,%20s", "Name", " Type", "Assigned Cartridges", "Virtual I/0 cartridges", "Drives", "Encryption Method", "Queued Exports", "VOLSER Reporting (6/8 characters)");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    HashMap<String, String> mapLL = new HashMap<String, String>();
                    JSONArray LLArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object ll : LLArray) {
                        JSONObject object = (JSONObject)ll;
                        String encryption = UtilCLI.getLLEncryption((String)object.get((Object)"encryption"));
                        String volserChar = "8";
                        volserChar = ((String)object.get((Object)"sixcharvolser")).compareTo("1") == 0 || ((String)object.get((Object)"sixcharvolser")).compareTo("6") == 0 ? "6" : "8";
                        String text = String.format("%20s,%15s,%20s,%25s,%10s,%17s,%15s,%20s", (String)object.get((Object)"name"), UtilCLI.getMediaType((String)object.get((Object)"mediatype")), (String)object.get((Object)"cartassigned"), (String)object.get((Object)"viocartridges"), (String)object.get((Object)"drivers"), encryption, ((String)object.get((Object)"hideloglibexportcart")).compareTo("1") == 0 ? "Hide" : "Show", volserChar);
                        mapLL.put(((String)object.get((Object)"name")).toLowerCase(), text);
                    }
                    this.printSort(mapLL);
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void showQueuedExportsTask() {
        String temp = "";
        temp = this.params.get("value").toUpperCase().trim().compareTo("TRUE") == 0 ? "0" : "1";
        String url = String.valueOf(PATH) + "/CLIHandler?action=showQueuedExports&llName=" + this.params.get("llName") + "&value=" + temp;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("Queued exports flag  was updated successfully");
        }
    }

    public void modifyVolserReportingTask() {
        String value = "";
        value = this.params.get("value").trim().toUpperCase().compareTo("6") == 0 ? "1" : "0";
        String url = String.valueOf(PATH) + "/CLIHandler?action=modifyVolserReporting&llName=" + this.params.get("llName") + "&value=" + value;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("Volser Reporting flag  was updated successfully");
        }
    }

    public void setMaximumVIOCartridgesTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=getIoSlots&llName=&range=&what=numofiees&where=";
        if (this.getResponseBody(url, "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            String numSlots = (String)object.get((Object)"numofiees");
            if (Integer.parseInt(numSlots) < 16) {
                System.out.println("*****ERROR: The number of IO slots is incorrect. ");
                Gen4cli.returnStatus = 1;
                return;
            }
            if (Integer.parseInt(this.params.get("range")) < Integer.parseInt(numSlots) || Integer.parseInt(this.params.get("range")) > 255) {
                System.out.println("***** ERROR: Wrong value. Value must be between:  *****");
                System.out.println("*****  [" + Integer.parseInt(numSlots) + " -255]  *****");
                Gen4cli.returnStatus = 1;
            } else {
                url = String.valueOf(PATH) + "/CLIHandler?action=setMaxVIO&llName=" + this.params.get("llName") + "&range=" + Integer.parseInt(this.params.get("range"));
                if (this.getResponseBody(url, "", false)) {
                    this.printResultMessage("The MAX VIO was updated successfully");
                }
            }
        }
    }

    public boolean checkVIOStatus() {
        JSONObject object;
        String statusStr;
        String url = String.valueOf(PATH) + "/CLIHandler?action=checkVIOStatus&what=VIOEnabled&where=";
        boolean status = false;
        if (this.getResponseBody(url, "", false) && (statusStr = (String)(object = this.getJSONObject(this.responseBody)).get((Object)"vioenabled")).compareTo("1") == 0) {
            status = true;
        }
        return status;
    }

    public void getVIOStatusTask() {
        boolean status = this.checkVIOStatus();
        System.out.println("VIO flag is : " + (status ? "Enabled" : "Disabled"));
    }

    public String getMaxCarts() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=checkVIOStatus&what=(NumLTOStEAMax+NumJagStEAMax) as max&where=";
        String total = "0";
        if (this.getResponseBody(url, "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            String jag = (String)object.get((Object)"max");
            total = String.valueOf(Integer.parseInt(jag) + 1);
        }
        return total;
    }

    public void modifyAdvancedEncSettingsTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=modifyAdvancedEncSettings&llName=" + this.params.get("llName") + "&advmethod=" + this.params.get("advancedMethod") + "&advPolicy=" + this.params.get("advancedPolicy") + "&density=" + this.params.get("density") + "&key=" + this.params.get("keyPath");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The advanced encryption settings for Logical Library '" + this.params.get("llName") + "' were updated successfully");
        }
    }

    public void assignDataCartridgesTask() {
        HashMap<Cartridge, String> cartridges;
        block33: {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            cartridges = new HashMap<Cartridge, String>();
            try {
                try {
                    br = new BufferedReader(new FileReader(this.params.get("filename")));
                    String line = br.readLine();
                    while (line != null) {
                        Cartridge c;
                        String col;
                        String[] temp = line.split(",");
                        if (temp.length == 5) {
                            col = temp[1].trim().replace("C", "");
                            String tier = temp[3].trim().replace("T", "");
                            Cartridge c2 = new Cartridge(temp[0].trim().replace("F", ""), col, temp[2].trim().replace("R", ""), tier);
                            if (col.compareTo("0") == 0 && tier.compareTo("0") == 0) {
                                c2.setType(UtilCLI.IEE_TYPE);
                            } else {
                                c2.setType(UtilCLI.STE_TYPE);
                            }
                            cartridges.put(c2, temp[4].trim());
                        } else if (temp.length == 3) {
                            c = new Cartridge(temp[0].trim().replace("F", ""), "0", temp[1].trim().replace("R", ""), "0");
                            c.setType(UtilCLI.IEE_TYPE);
                            cartridges.put(c, temp[2].trim());
                        } else if (temp.length == 4) {
                            col = temp[1].trim().replace("C", "");
                            Cartridge c3 = new Cartridge(temp[0].trim().replace("F", ""), col, temp[2].trim().replace("R", ""), "0");
                            c3.setType(UtilCLI.DTE_TYPE);
                        } else if (temp.length == 2) {
                            c = new Cartridge(temp[0].trim());
                            if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                                c.setLL(temp[1].trim());
                                cartridges.put(c, temp[1].trim());
                            } else {
                                System.out.println("****ERROR: Cartridge " + temp[0].trim() + " cannot be found.\n");
                            }
                        } else {
                            System.out.println("****ERROR: Wrong format for cartridge. The allowed formats are:\n");
                            System.out.println("\t[Frame],[Column],[Row],[Tier],LogicalLibrary\n");
                            System.out.println("\tVOLSER,LogicalLibrary\n");
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                    System.out.println("Aqui en 1");
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e2.getMessage() + " Class: " + e2.getClass());
                        System.out.println("Aqui en 2");
                        if (this.verbose) {
                            e2.printStackTrace();
                        }
                        break block33;
                    }
                }
            }
            catch (Throwable throwable) {
                block34: {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                        System.out.println("Aqui en 2");
                        if (!this.verbose) break block34;
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                System.out.println("Aqui en 2");
                if (!this.verbose) break block33;
                e.printStackTrace();
            }
        }
        for (Cartridge c : cartridges.keySet()) {
            System.out.println("Aqui en el for");
            String url = String.valueOf(PATH) + "/CLIHandler?action=assignDataCartridges&frameSrc=" + c.getLocation().get("frame") + "&columnSrc=" + (c.getLocation().get("column") == null ? "" : c.getLocation().get("column")) + "&rowSrc=" + c.getLocation().get("row") + "&tierSrc=" + (c.getLocation().get("tier") == null ? "" : c.getLocation().get("tier")) + "&type=" + c.getType() + "&ll=" + (String)cartridges.get(c);
            try {
                if (!this.getResponseBody(url, "", true)) continue;
                if (!c.getVolser().isEmpty()) {
                    this.printResultMessage("The cartridge " + c.getVolser() + " was assigned successfully");
                } else {
                    this.printResultMessage("The cartridge F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier") + " was assigned successfully");
                }
                System.out.println("Moving to next element...");
                System.out.println("-----------------------------------------");
            }
            catch (Exception e) {
                System.out.print("*** Error: There was a problem assigning - ");
                if (!c.getVolser().isEmpty()) {
                    System.out.println(c.getVolser());
                } else {
                    System.out.println(" F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier"));
                }
                System.out.println("****************************************************************");
                System.out.println("Moving to next element...");
            }
        }
        System.out.println("Done.");
    }

    public void assignBulkDataCartridgesTask() {
        String destLL;
        ArrayList<Cartridge> cartridges;
        block34: {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            cartridges = new ArrayList<Cartridge>();
            destLL = this.params.get("llName");
            try {
                try {
                    br = new BufferedReader(new FileReader(this.params.get("filename")));
                    String line = br.readLine();
                    while (line != null) {
                        Cartridge c;
                        String[] temp = line.split(",");
                        if (temp.length == 4) {
                            String col = temp[1].trim();
                            String tier = temp[3].trim();
                            Cartridge c2 = new Cartridge(temp[0].trim(), col, temp[2].trim(), tier);
                            if (col.compareTo("0") == 0 && tier.compareTo("0") == 0) {
                                c2.setType(UtilCLI.IEE_TYPE);
                            } else {
                                c2.setType(UtilCLI.STE_TYPE);
                            }
                            cartridges.add(c2);
                        } else if (temp.length == 2) {
                            c = new Cartridge(temp[0].trim(), "0", temp[1].trim(), "0");
                            c.setType(UtilCLI.IEE_TYPE);
                            cartridges.add(c);
                        } else if (temp.length == 1) {
                            c = new Cartridge(temp[0].trim());
                            if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                                c.setFCRTTForBulk("F" + c.getLocation().get("frame") + "C" + c.getLocation().get("column") + "R" + c.getLocation().get("row") + "T" + c.getLocation().get("tier") + "T" + c.getType());
                                cartridges.add(c);
                            } else {
                                System.out.println("Error: Cartridge " + temp[0].trim() + " cannot be found.\n");
                            }
                        } else {
                            System.out.println("Error: Wrong format for cartridge: " + line.trim());
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e2.getMessage() + " Class: " + e2.getClass());
                        if (this.verbose) {
                            e2.printStackTrace();
                        }
                        break block34;
                    }
                }
            }
            catch (Throwable throwable) {
                block35: {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                        if (!this.verbose) break block35;
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block34;
                e.printStackTrace();
            }
        }
        int MAX_ASSIGN_CARTS = 35;
        int loops = cartridges.size() / MAX_ASSIGN_CARTS;
        int position = 0;
        String listCarts = "";
        int idx = 0;
        while (idx < loops) {
            listCarts = "";
            int i = 0 + idx * MAX_ASSIGN_CARTS;
            while (i < MAX_ASSIGN_CARTS + idx * MAX_ASSIGN_CARTS) {
                listCarts = String.valueOf(listCarts) + ((Cartridge)cartridges.get(i)).getFCRTTForBulk() + ",";
                ++position;
                ++i;
            }
            listCarts = listCarts.substring(0, listCarts.length() - 1);
            String url = String.valueOf(PATH) + "/CLIHandler?action=bulkAssignDataCartridges&list=" + listCarts + "&destinyLLName=" + destLL;
            try {
                if (this.getResponseBody(url, "", true)) {
                    this.printResultMessage("The cartridges were assigned successfully");
                    System.out.println("Moving to next bulk...");
                    System.out.println("-----------------------------------------");
                }
            }
            catch (Exception e) {
                System.out.println("*** Error: There was a problem in the command execution - The cartridges in the bulk were not assigned.");
                System.out.println("****************************************************************");
                System.out.println("Moving to next bulk...");
            }
            ++idx;
        }
        int missing = cartridges.size() - position;
        listCarts = "";
        int i = 0 + position;
        while (i < missing + position) {
            listCarts = String.valueOf(listCarts) + ((Cartridge)cartridges.get(i)).getFCRTTForBulk() + ",";
            ++i;
        }
        listCarts = listCarts.substring(0, listCarts.length() - 1);
        if (missing > 0) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=bulkAssignDataCartridges&list=" + listCarts + "&destinyLLName=" + destLL;
            try {
                if (this.getResponseBody(url, "", true)) {
                    this.printResultMessage("The cartridges were assigned successfully");
                    System.out.println("Moving to next bulk...");
                    System.out.println("-----------------------------------------");
                }
            }
            catch (Exception e) {
                System.out.println("*** Error: There was a problem in the command execution - The cartridges in the bulk were not assigned.");
                System.out.println("****************************************************************");
                System.out.println("Moving to next bulk...");
            }
        }
        System.out.println("Done.");
    }

    public void assignBulkDataCartridgesByLLTask() {
        ArrayList<Cartridge> cartridges;
        block34: {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            cartridges = new ArrayList<Cartridge>();
            try {
                try {
                    br = new BufferedReader(new FileReader(this.params.get("filename")));
                    String line = br.readLine();
                    while (line != null) {
                        Cartridge c;
                        String[] temp = line.split(",");
                        if (temp.length == 5) {
                            String col = temp[1].trim();
                            String tier = temp[3].trim();
                            Cartridge c2 = new Cartridge(temp[0].trim(), col, temp[2].trim(), tier, "'" + temp[4].trim() + "'");
                            if (col.compareTo("0") == 0 && tier.compareTo("0") == 0) {
                                c2.setType(UtilCLI.IEE_TYPE);
                            } else {
                                c2.setType(UtilCLI.STE_TYPE);
                            }
                            cartridges.add(c2);
                        } else if (temp.length == 3) {
                            c = new Cartridge(temp[0].trim(), "0", temp[1].trim(), "0", "'" + temp[2].trim() + "'");
                            c.setType(UtilCLI.IEE_TYPE);
                            cartridges.add(c);
                        } else if (temp.length == 2) {
                            c = new Cartridge(temp[0].trim());
                            if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                                Cartridge d = new Cartridge("F" + c.getLocation().get("frame"), "C" + c.getLocation().get("column"), "R" + c.getLocation().get("row"), "T" + c.getLocation().get("tier"), "'" + temp[1].trim() + "'");
                                d.setType(c.getType());
                                cartridges.add(d);
                            } else {
                                System.out.println("****ERROR: Cartridge " + temp[0].trim() + " cannot be found.\n");
                            }
                        } else {
                            System.out.println("****ERROR: Wrong format for cartridge: " + line.trim());
                            System.out.println("\t[Volser],LogicalLibrary\n");
                            System.out.println("\t[Frame],[Column],[Row],[Tier],DestinyLLName\n");
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e2.getMessage() + " Class: " + e2.getClass());
                        if (this.verbose) {
                            e2.printStackTrace();
                        }
                        break block34;
                    }
                }
            }
            catch (Throwable throwable) {
                block35: {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                        if (!this.verbose) break block35;
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem reading the input file: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block34;
                e.printStackTrace();
            }
        }
        int MAX_ASSIGN_CARTS = 35;
        int loops = cartridges.size() / MAX_ASSIGN_CARTS;
        int position = 0;
        String listCarts = "";
        int idx = 0;
        while (idx < loops) {
            listCarts = "";
            int i = 0 + idx * MAX_ASSIGN_CARTS;
            while (i < MAX_ASSIGN_CARTS + idx * MAX_ASSIGN_CARTS) {
                listCarts = String.valueOf(listCarts) + ((Cartridge)cartridges.get(i)).getFCRTTL() + ",";
                ++position;
                ++i;
            }
            listCarts = listCarts.substring(0, listCarts.length() - 1);
            String url = String.valueOf(PATH) + "/CLIHandler?action=bulkAssignDataCartridgesByLL&list=" + listCarts;
            try {
                if (this.getResponseBody(url, "", true)) {
                    this.printResultMessage("The cartridges were assigned successfully");
                    System.out.println("Moving to next bulk...");
                    System.out.println("-----------------------------------------");
                }
            }
            catch (Exception e) {
                System.out.println("*** Error: There was a problem in the command execution - The cartridges in the bulk were not assigned.");
                System.out.println("****************************************************************");
                System.out.println("Moving to next bulk...");
            }
            ++idx;
        }
        int missing = cartridges.size() - position;
        listCarts = "";
        int i = 0 + position;
        while (i < missing + position) {
            listCarts = String.valueOf(listCarts) + ((Cartridge)cartridges.get(i)).getFCRTTL() + ",";
            ++i;
        }
        listCarts = listCarts.substring(0, listCarts.length() - 1);
        if (missing > 0) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=bulkAssignDataCartridgesByLL&list=" + listCarts;
            try {
                if (this.getResponseBody(url, "", true)) {
                    this.printResultMessage("The cartridges were assigned successfully");
                    System.out.println("Moving to next bulk...");
                    System.out.println("-----------------------------------------");
                }
            }
            catch (Exception e) {
                System.out.println("*** Error: There was a problem in the command execution - The cartridges in the bulk were not assigned.");
                System.out.println("****************************************************************");
                System.out.println("Moving to next bulk...");
            }
        }
        System.out.println("Done.");
    }

    private boolean getVolserDataTask(String volser, String table, Cartridge cart) {
        String url = String.valueOf(PATH) + "/CLIHandler?action=getVolserData&volser=" + volser + "&table=";
        boolean result = false;
        if (this.getResponseBody(url, "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            if (Gen4cli.returnStatus == 0) {
                cart.setLocation((String)object.get((Object)"frame"), (String)object.get((Object)"column"), (String)object.get((Object)"row"), (String)object.get((Object)"tier"));
                cart.setType((String)object.get((Object)"type"));
                cart.setVEA((String)object.get((Object)"vea"));
                cart.setLL((String)object.get((Object)"loglib"));
                result = true;
            } else {
                result = false;
            }
        } else if (this.responseBody.contains("Empty")) {
            result = false;
        }
        return result;
    }

    private static String getLogLib(Object obj) {
        String library = obj.toString().trim();
        if (library.isEmpty()) {
            return "Unassigned";
        }
        return library;
    }

    public void viewDataCartridgesTask() throws ClientProtocolException, IOException {
        block8: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDataCartridges";
                String strFormat = String.format("%15s,%20s,%15s,%25s,%26s,%20s,%30s", "Volume Serial", "Logical Library", "Element Address", "Media Type", "Location(F,C,R)", "Encryption", "Most Recent use");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    HashMap mapCart = new HashMap();
                    for (Object drive : driveArray) {
                        List<String> temp;
                        JSONObject object = (JSONObject)drive;
                        String location = Cartridge.elementType.get(Integer.parseInt((String)object.get((Object)"type")));
                        location = String.valueOf(location) + "(F" + (String)object.get((Object)"frame") + ",C" + (String)object.get((Object)"column") + ",R" + (String)object.get((Object)"row") + ",T" + (String)object.get((Object)"tier") + ")";
                        String volser = (String)object.get((Object)"volumetag");
                        Long timeSecs = Long.parseLong((String)object.get((Object)"lru_time"));
                        String date = "0";
                        date = timeSecs > 0L ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timeSecs * 1000L)) : "Unknown";
                        if (volser.trim().isEmpty()) {
                            volser = "Unknown";
                        }
                        String output = String.format("%15s,%20s,%15s,%25s,%26s,%20s,%30s", volser, Command.getLogLib((String)object.get((Object)"libraryname")), (String)object.get((Object)"elementaddress"), Cartridge.elementMediaType.get(Integer.parseInt((String)object.get((Object)"mediatype"))), location, Cartridge.elementEncryption.get(Integer.parseInt((String)object.get((Object)"encryptstatus"))), date);
                        if (mapCart.containsKey(volser)) {
                            temp = (List)mapCart.get(volser);
                            temp.add(output);
                            mapCart.put(volser, temp);
                            continue;
                        }
                        temp = new ArrayList();
                        temp.add(output);
                        mapCart.put(volser, temp);
                    }
                    TreeMap treeMapCart = new TreeMap(mapCart);
                    for (String str : treeMapCart.keySet()) {
                        for (String element : (List)treeMapCart.get(str)) {
                            System.out.println(element);
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block8;
                e.printStackTrace();
            }
        }
    }

    public void viewCleaningCartridgesTask() {
        block7: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDataCartridges";
                String strFormat = String.format("%15s,%20s,%15s,%25s,%26s,%15s,%30s", "Volume Serial", "Logical Library", "Element Address", "Media Type", "Location(F,C,R)", "Cleans remaining", "Most Recent use");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    HashMap mapCart = new HashMap();
                    for (Object drive : driveArray) {
                        List<String> temp;
                        JSONObject object = (JSONObject)drive;
                        String location = Cartridge.elementType.get(Integer.parseInt((String)object.get((Object)"type")));
                        location = String.valueOf(location) + "(F" + (String)object.get((Object)"frame") + ",C" + (String)object.get((Object)"column") + ",R" + (String)object.get((Object)"row") + ",T" + (String)object.get((Object)"tier") + ")";
                        String volser = (String)object.get((Object)"volumetag");
                        Long timeSecs = Long.parseLong((String)object.get((Object)"lru_time"));
                        String date = "0";
                        date = timeSecs > 0L ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timeSecs * 1000L)) : "31 December 1969 06:00:00";
                        if (volser.trim().isEmpty() || volser.trim().substring(0, 3).compareTo("CLN") != 0) continue;
                        String output = String.format("%15s,%20s,%15s,%25s,%26s,%15s,%30s", volser, Command.getLogLib((String)object.get((Object)"loglib")), (String)object.get((Object)"elementaddress"), Cartridge.elementMediaType.get(Integer.parseInt((String)object.get((Object)"mediatype"))), location, (String)object.get((Object)"clncart"), date);
                        if (mapCart.containsKey(volser)) {
                            temp = (List)mapCart.get(volser);
                            temp.add(output);
                            mapCart.put(volser, temp);
                            continue;
                        }
                        temp = new ArrayList();
                        temp.add(output);
                        mapCart.put(volser, temp);
                    }
                    TreeMap treeMapCart = new TreeMap(mapCart);
                    for (String str : treeMapCart.keySet()) {
                        for (String element : (List)treeMapCart.get(str)) {
                            System.out.println(element);
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block7;
                e.printStackTrace();
            }
        }
    }

    public boolean isIoEmpty() {
        boolean result = false;
        String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewIoStation&param1=1&param2=";
        if (!this.getResponseBody(URL2, "", false)) {
            Gen4cli.returnStatus = 1;
            result = true;
        }
        return result;
    }

    public void viewIoStationTask() {
        block8: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewIoStation&param1=1&param2=";
                String strFormat = "I/O Station Empty\nThere are no data or cleaning cartridges in any I/O station";
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(String.format("%15s,%20s,%15s,%25s,%26s,%20s", "Volume Serial", "Logical Library", "Element Address", "Media Type", "Location(F,C,R)", "Encryption"));
                    HashMap mapCart = new HashMap();
                    for (Object drive : driveArray) {
                        List<String> temp;
                        JSONObject object = (JSONObject)drive;
                        String location = Cartridge.elementType.get(Integer.parseInt((String)object.get((Object)"type")));
                        location = String.valueOf(location) + "(F" + (String)object.get((Object)"frame") + ",C" + (String)object.get((Object)"column") + ",R" + (String)object.get((Object)"row") + ",T" + (String)object.get((Object)"tier") + ")";
                        String volser = (String)object.get((Object)"volumetag");
                        if (volser.trim().isEmpty()) {
                            volser = "Unknown";
                        }
                        String output = String.format("%15s,%20s,%15s,%25s,%26s,%20s", volser, Command.getLogLib((String)object.get((Object)"libraryname")), (String)object.get((Object)"vea"), Cartridge.elementMediaType.get(Integer.parseInt((String)object.get((Object)"mediatype"))), location, Cartridge.elementEncryption.get(Integer.parseInt((String)object.get((Object)"encryptstatus"))));
                        if (mapCart.containsKey(volser)) {
                            temp = (List)mapCart.get(volser);
                            temp.add(output);
                            mapCart.put(volser, temp);
                            continue;
                        }
                        temp = new ArrayList();
                        temp.add(output);
                        mapCart.put(volser, temp);
                    }
                    TreeMap treeMapCart = new TreeMap(mapCart);
                    for (String str : treeMapCart.keySet()) {
                        for (String element : (List)treeMapCart.get(str)) {
                            System.out.println(element);
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block8;
                e.printStackTrace();
            }
        }
    }

    public void viewDriveSummaryTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveSummary";
                String strFormat = String.format("%15s,%20s,%16s,%16s,%12s,%15s,%18s,%16s,%8s", "Location(F,C,R)", "State", "Type", "Contents", "Firmware", "Serial", "WWWNN", "Element Address", "Logical Library");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object drive : driveArray) {
                        JSONObject object = (JSONObject)drive;
                        String location = (String)object.get((Object)"location");
                        String type = UtilCLI.getDriveType((String)object.get((Object)"type"));
                        String serialNumber = (String)object.get((Object)"serial");
                        String temp = (String)object.get((Object)"serial");
                        String[] driveids = temp.trim().replaceAll("\\s+", " ").split(" ");
                        serialNumber = driveids[2];
                        System.out.println(String.format("%15s,%20s,%16s,%16s,%12s,%15s,%18s,%16s,%8s", location, UtilCLI.getDriveState((String)object.get((Object)"state")), type, UtilCLI.getDriveContents((String)object.get((Object)"contents")), (String)object.get((Object)"firmware"), serialNumber, (String)object.get((Object)"wwnn") == null ? "" : (String)object.get((Object)"wwnn"), (String)object.get((Object)"elementaddress"), UtilCLI.getDriveLogicalLibrary((String)object.get((Object)"logicallibrary"))));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void viewDriveDetailsTask() {
        String strFormat;
        String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveDetails&frame=" + this.params.get("frame") + "&column=" + this.params.get("column") + "&row=" + this.params.get("row");
        if (this.getResponseBody(URL2, strFormat = String.format("%25s\n%16s\n%16s\n%16s\n%16s\n%12s\n%8s\n%16s\n%15s\n%15s\n%15s\n%15s\n%16s\n%15s\n%15s\n%15s\n", "Location(F,C,R)", "State", "Type", "Logical Library", "Control path", "Contents", "Firmware", "WWNN", "Element Address", "Drive Display", "Port 0", "Loop ID", "WWPN", "Port 1", "Loop ID", "WWPN"), false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            int isControlPath = Integer.parseInt((String)object.get((Object)"iscontrolpath"));
            String location = (String)object.get((Object)"location");
            System.out.println(String.format("%16s%20s", "Location(F,C,R)", location));
            System.out.println(String.format("%16s%20s", "State", UtilCLI.getDriveState((String)object.get((Object)"state"))));
            System.out.println(String.format("%16s%20s", "Type", UtilCLI.getDriveType((String)object.get((Object)"type"))));
            System.out.println(String.format("%16s%20s", "Logical Library", (String)object.get((Object)"logicallibrary")));
            System.out.println(String.format("%16s%20s", "Control Path", isControlPath == 1 ? "Enabled" : "Disabled"));
            System.out.println(String.format("%16s%20s", "Contents", UtilCLI.getDriveContents((String)object.get((Object)"contents"))));
            System.out.println(String.format("%16s%20s", "Firmware", (String)object.get((Object)"firmware")));
            System.out.println(String.format("%16s%20s", "WWNN", (String)object.get((Object)"wwnn")));
            System.out.println(String.format("%16s%20s", "Element Address", (String)object.get((Object)"elementaddress")));
            System.out.println(String.format("%16s%20s", "Drive Display", (String)object.get((Object)"drivedisplay")));
            System.out.println(String.format("%16s", "Port 0"));
            System.out.println(String.format("%16s%20s", "Loop ID", (String)object.get((Object)"port1id") == null ? "" : (String)object.get((Object)"port1id")));
            System.out.println(String.format("%16s%20s", "WWPN", (String)object.get((Object)"port1wwpn") == null ? "" : (String)object.get((Object)"port1wwpn")));
            System.out.println(String.format("%16s", "Port 1"));
            System.out.println(String.format("%16s%20s", "Loop ID", (String)object.get((Object)"port2id") == null ? "" : (String)object.get((Object)"port2id")));
            System.out.println(String.format("%16s%20s", "WWPN", (String)object.get((Object)"port2wwpn") == null ? "" : (String)object.get((Object)"port2wwpn")));
        }
    }

    public void viewDriveVPDTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveSummary";
                String strFormat = String.format("%16s,%16s,%16s,%16s,%15s", "Location(F,C,R)", "Drive Type", "Firmware Version", "Machine Type", "Serial number");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object drive : driveArray) {
                        JSONObject object = (JSONObject)drive;
                        String location = (String)object.get((Object)"location");
                        String serialNumber = (String)object.get((Object)"serial");
                        String temp = (String)object.get((Object)"serial");
                        temp = temp.trim();
                        serialNumber = temp.substring(temp.length() - 10, temp.length());
                        System.out.println(String.format("%16s,%16s,%16s,%16s,%15s", location, UtilCLI.getDriveType((String)object.get((Object)"type")), (String)object.get((Object)"firmware"), Drive.driveMachineType.get(Integer.parseInt((String)object.get((Object)"type"))), serialNumber));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void viewVolserRangesTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewVolserRanges";
                String strFormat = String.format("%27s,%12s,%12s,%12s", "Volser start - Volser end", "Logical Library", "Media Type", "Number of cartridges");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    HashMap<String, String> mapRanges = new HashMap<String, String>();
                    JSONArray list = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object element : list) {
                        JSONObject object = (JSONObject)element;
                        String text = String.format("%27s,%12s,%12s,%12s", (String)object.get((Object)"volserRange"), (String)object.get((Object)"LogicalLibrary"), (String)object.get((Object)"mediaType"), (String)object.get((Object)"numberofcartridges"));
                        mapRanges.put((String)object.get((Object)"volserRange"), text);
                    }
                    this.printSort(mapRanges);
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void viewFibreChannelTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveSummary";
                String strFormat = String.format("%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s", "Drive", "Location(F,C,R)", "Logical Library", "Type", "Port(1,2)", "Link Status", "Configured Link Speed", "Configured Topology", "Actual Link Speed", "Actual Topology");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray list = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object element : list) {
                        JSONObject object = (JSONObject)element;
                        String serialNumber = (String)object.get((Object)"serial");
                        String temp = (String)object.get((Object)"serial");
                        String[] driveids = temp.trim().replaceAll("\\s+", " ").split(" ");
                        serialNumber = driveids.length > 1 ? driveids[2] : "";
                        Object[] objectArray = new Object[10];
                        objectArray[0] = (String)object.get((Object)"wwnn") == null ? "" : (String)object.get((Object)"wwnn");
                        objectArray[1] = (String)object.get((Object)"location");
                        objectArray[2] = (String)object.get((Object)"logicallibrary");
                        objectArray[3] = UtilCLI.getDriveType((String)object.get((Object)"type"));
                        Object object2 = objectArray[4] = (String)object.get((Object)"port1wwpn") == null ? "" : (String)object.get((Object)"port1wwpn");
                        objectArray[5] = (String)object.get((Object)"port1state") == null ? "" : (((String)object.get((Object)"port1state")).compareTo("0") == 0 ? "No light" : "Light Detected");
                        objectArray[6] = (String)object.get((Object)"port1speed") == null ? "" : UtilCLI.getSpeedPort((String)object.get((Object)"port1speed"));
                        objectArray[7] = (String)object.get((Object)"port1topology") == null ? "" : UtilCLI.getTopologyPort((String)object.get((Object)"port1topology"));
                        objectArray[8] = (String)object.get((Object)"port1speedactual") == null ? "" : UtilCLI.getSpeedPort((String)object.get((Object)"port1speedactual"));
                        objectArray[9] = (String)object.get((Object)"port1topologyactual") == null ? "" : UtilCLI.getTopologyPort((String)object.get((Object)"port1topologyactual"));
                        String text = String.format("%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s", objectArray);
                        System.out.println(text);
                        Object[] objectArray2 = new Object[10];
                        objectArray2[0] = "";
                        objectArray2[1] = "";
                        objectArray2[2] = "";
                        objectArray2[3] = "";
                        Object object3 = objectArray2[4] = (String)object.get((Object)"port2wwpn") == null ? "" : (String)object.get((Object)"port2wwpn");
                        objectArray2[5] = (String)object.get((Object)"port2state") == null ? "" : (((String)object.get((Object)"port2state")).compareTo("0") == 0 ? "No light" : "Light Detected");
                        objectArray2[6] = (String)object.get((Object)"port2speed") == null ? "" : UtilCLI.getSpeedPort((String)object.get((Object)"port2speed"));
                        objectArray2[7] = (String)object.get((Object)"port2topology") == null ? "" : UtilCLI.getTopologyPort((String)object.get((Object)"port2topology"));
                        objectArray2[8] = (String)object.get((Object)"port2speedactual") == null ? "" : UtilCLI.getSpeedPort((String)object.get((Object)"port2speedactual"));
                        objectArray2[9] = (String)object.get((Object)"port2topologyactual") == null ? "" : UtilCLI.getTopologyPort((String)object.get((Object)"port2topologyactual"));
                        String textID2 = String.format("%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s,%15s", objectArray2);
                        System.out.println(textID2);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void viewVolserRangesByLLTask() {
        block5: {
            try {
                String url = String.valueOf(PATH) + "/CLIHandler?action=viewVolserRangesByLL&param1=&param2";
                String strFormat = String.format("%12s,%12s,%12s", "Logical Library", "Cartridges", "Media Type");
                if (this.getResponseBody(url, strFormat, false)) {
                    JSONArray list = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object element : list) {
                        JSONObject object = (JSONObject)element;
                        System.out.println(String.format("%25s,%15s,%15s", (String)object.get((Object)"name"), (String)object.get((Object)"cartridges"), (String)object.get((Object)"type")));
                        JSONArray ranges = JSONArray.parse((String)object.get((Object)"children").toString());
                        for (Object range : ranges) {
                            JSONObject rangeJson = (JSONObject)range;
                            if (range == null) continue;
                            System.out.println(String.format("\t%25s,%15s", (String)rangeJson.get((Object)"volserRange"), (String)rangeJson.get((Object)"numberofcartridges")));
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void createVolserRangesTask() {
        block8: {
            HashMap<Integer, VolserRange> ranges = new HashMap<Integer, VolserRange>();
            if (!this.validateCreateVolserRangesFile(ranges)) {
                Gen4cli.returnStatus = 1;
                return;
            }
            try {
                int idx = 1;
                while (idx <= ranges.keySet().size()) {
                    String url = String.valueOf(PATH) + "/CLIHandler?action=createVolserRanges&loglibName=" + ((VolserRange)ranges.get(idx)).getNameLL() + "&start=" + ((VolserRange)ranges.get(idx)).getStart() + "&end=" + ((VolserRange)ranges.get(idx)).getEnd() + "&media=" + ((VolserRange)ranges.get(idx)).getMediaType() + "&enable=" + ((VolserRange)ranges.get(idx)).getEnableNew() + "&op=" + (Object)((Object)VOLSER_ACTION.CREATE);
                    if (this.getResponseBody(url, "", true)) {
                        JSONObject result = JSONObject.parse((String)this.responseBody);
                        if (Gen4cli.returnStatus == 0 && (Long)result.get((Object)"returnCode") == 0L) {
                            long index = (Long)result.get((Object)"returnCode");
                            if (index != 0L) {
                                System.out.println("This is a Long Running Task, the completed percentage will be shown:");
                                System.out.println("LTRIDX = " + index);
                                this.lrtIndex = (int)index;
                                this.updateStatus();
                                while (this.percentage != 100) {
                                }
                            }
                            System.out.println("The Volser Range was created successfully");
                            System.out.println("-----------------------------------------");
                        }
                    }
                    ++idx;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block8;
                e.printStackTrace();
            }
        }
        System.out.println("Done.");
    }

    public void modifyVolserRangeTask() {
        HashMap<Integer, VolserRange> ranges = new HashMap<Integer, VolserRange>();
        if (!this.validateCreateVolserRangesFile(ranges)) {
            System.exit(-1);
        }
        for (Integer idx : ranges.keySet()) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=modifyVolserRange&LL=" + ((VolserRange)ranges.get(idx)).getNameLL() + "&start=" + ((VolserRange)ranges.get(idx)).getStart() + "&end=" + ((VolserRange)ranges.get(idx)).getEnd() + "&mediaType=" + ((VolserRange)ranges.get(idx)).getMediaType() + "&enable=" + ((VolserRange)ranges.get(idx)).getEnableNew() + "&volserAction=" + (Object)((Object)VOLSER_ACTION.MODIFY);
            try {
                this.responseBody = this.connection.doGet(url);
                JSONObject result = JSONObject.parse((String)this.responseBody);
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, true);
                    continue;
                }
                if ((Long)result.get((Object)"returnCode") != 0L) continue;
                System.out.println("The Volser Range was modified successfully");
                System.out.println("-----------------------------------------");
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) continue;
                e.printStackTrace();
            }
        }
        System.out.println("Done.");
    }

    public void deleteVolserRangesTask() {
        HashMap<Integer, VolserRange> volsers;
        block13: {
            BufferedReader br;
            block12: {
                volsers = new HashMap<Integer, VolserRange>();
                int i = 0;
                br = null;
                try {
                    br = new BufferedReader(new FileReader(this.params.get("filename")));
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        String[] temp = line.split(",");
                        if (temp.length == 3) {
                            volsers.put(i, new VolserRange(temp[1].trim(), temp[2].trim(), temp[0].trim()));
                            ++i;
                        } else {
                            System.out.println("****ERROR: Wrong format for Volser Range:\n");
                            System.out.println("\t[LogicalLibraryName],[volserStart],[volserEnd]\n");
                            System.exit(-1);
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem reading the file: " + e.getMessage() + " Class: " + e.getClass());
                    if (!this.verbose) break block12;
                    e.printStackTrace();
                }
            }
            try {
                br.close();
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem reading the file: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block13;
                e.printStackTrace();
            }
        }
        for (VolserRange volser : volsers.values()) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=deleteVolserRanges&LL=" + volser.getNameLL() + "&start=" + volser.getStart() + "&end=" + volser.getEnd() + "&mediaType=&xy=&op=" + (Object)((Object)VOLSER_ACTION.DELETE);
            try {
                JSONObject result;
                if (!this.getResponseBody(url, "", true) || (Long)(result = JSONObject.parse((String)this.responseBody)).get((Object)"returnCode") != 0L) continue;
                long index = (Long)result.get((Object)"returnCode");
                if (index != 0L) {
                    System.out.println("This is a Long Running Task, the completed percentage will be shown:");
                    String statusCode = (String)result.get((Object)"lrtIndex");
                    this.lrtIndex = Integer.parseInt(statusCode);
                    this.updateStatus();
                    while (this.percentage != 100) {
                    }
                }
                System.out.println("The Volser Range was removed successfully");
                System.out.println("-----------------------------------------");
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) continue;
                e.printStackTrace();
            }
        }
        System.out.println("Done.");
    }

    public void resetDriveTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=resetDrive&frameDrive=" + this.params.get("frame") + "&columnDrive=" + this.params.get("column") + "&rowDrive=" + this.params.get("row");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The drive was reset successfully");
        }
    }

    public void cleanDriveTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=cleanDrive&frameDrive=" + this.params.get("frame") + "&columnDrive=" + this.params.get("column") + "&rowDrive=" + this.params.get("row");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The drive was cleaned successfully");
        }
    }

    public void createKeyLabelMappingTask() {
        String url;
        if (!this.validateKeyFrom("0", this.params.get("keyLabelFrom"))) {
            System.out.println("****ERROR: The name for Map From Key label already exists.");
            Gen4cli.returnStatus = 1;
            return;
        }
        if (this.params.get("keyModeFrom").compareTo("WRAPPED-DEFAULT") == 0) {
            this.params.put("keyLabelTo", "0");
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=createKeyLabelMapping&idx=0&keyLabelFrom=" + this.params.get("keyLabelFrom") + "&keyModeFrom=" + UtilCLI.getKeyMode(this.params.get("keyModeFrom")) + "&keyLabelTo=" + this.params.get("keyLabelTo") + "&keyModeTo=0", "", false)) {
            System.out.println("The Key Label Mapping was created successfully");
        }
    }

    public void editKeyLabelMappingTask() {
        String url;
        String index = this.params.get("index").toString();
        if (!this.validateIndexKLM(index)) {
            System.out.println("****ERROR: The key label was not found.");
            Gen4cli.returnStatus = 1;
            return;
        }
        if (!this.validateKeyFrom(index, this.params.get("keyLabelFrom"))) {
            System.out.println("****ERROR: The name for Map From Key label already exists.");
            Gen4cli.returnStatus = 1;
            return;
        }
        if (this.params.get("keyModeFrom").compareTo("WRAPPED-DEFAULT") == 0) {
            this.params.put("keyLabelTo", "0");
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=editKeyLabelMapping&idx=" + index + "&keyLabelFrom=" + this.params.get("keyLabelFrom") + "&keyModeFrom=" + UtilCLI.getKeyMode(this.params.get("keyModeFrom")) + "&keyLabelTo=" + this.params.get("keyLabelTo") + "&keyModeTo=0", "", false)) {
            System.out.println("The Key Label Mapping was updated successfully");
        }
    }

    public void deleteKeyLabelMappingTask() {
        String index = this.params.get("index").toString();
        if (!this.validateIndexKLM(index)) {
            System.out.println("****ERROR: The key label was not found.");
            Gen4cli.returnStatus = 1;
            return;
        }
        String url = String.valueOf(PATH) + "/CLIHandler?action=deleteKeyLabelMapping&idx=" + index + "&keyLabelFrom=" + "&keyModeFrom=&keyLabelTo=&keyModeTo=";
        if (this.getResponseBody(url, "", false)) {
            System.out.println("The Key Label Mapping was deleted successfully");
        }
    }

    private boolean validateKeyFrom(String index, String input) {
        boolean result;
        block3: {
            result = true;
            try {
                String URL2 = "/CLIHandler?action=viewKeyLabelMapping";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray KLMArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object klm : KLMArray) {
                    JSONObject object = (JSONObject)klm;
                    if (input.trim().toUpperCase().compareTo(object.get((Object)"fromkeylabel").toString().toUpperCase()) != 0) continue;
                    result = index.compareTo(object.get((Object)"keylabelmapidx").toString()) == 0;
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean validateIndexKLM(String index) {
        boolean result;
        block3: {
            result = false;
            try {
                String URL2 = "/CLIHandler?action=viewKeyLabelMapping";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray KLMArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object klm : KLMArray) {
                    JSONObject object = (JSONObject)klm;
                    if (index.compareTo(object.get((Object)"keylabelmapidx").toString().toUpperCase()) != 0) continue;
                    result = true;
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public void viewKLMTask() {
        block4: {
            try {
                String URL2 = "/CLIHandler?action=viewKeyLabelMapping";
                String strFormat = String.format("%10s,%25s,%25s,%25s", "Index", "Map From Key Label", "Key Mode ", "Map To Key Label");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray KLMArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object klm : KLMArray) {
                        JSONObject object = (JSONObject)klm;
                        System.out.println(String.format("%10s,%25s,%25s,%25s", (String)object.get((Object)"keylabelmapidx"), (String)object.get((Object)"fromkeylabel"), UtilCLI.getKeyModeStr((String)object.get((Object)"keymode")), (String)object.get((Object)"tokeylabel")));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateCreateVolserRangesFile(Map<Integer, VolserRange> ranges) {
        boolean rc = true;
        int index = 1;
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.params.get("filename")));
            while (true) {
                String line;
                if ((line = in.readLine()) == null) {
                    in.close();
                    break;
                }
                if (line.trim().length() == 0) continue;
                String[] fields = line.split(",");
                if (fields.length != 5) {
                    System.out.println("***** ERROR: Wrong number of parameters. *****");
                    System.out.println("             starRange,endRange,LL name, media Type [LTO,DLT,3592], Enable [true/false]. *****");
                    System.out.println("             [startRange,endRange] are the only values that cannot be changed. You must included all the parameters event if they are not changing.*****");
                    Gen4cli.returnStatus = 1;
                    return false;
                }
                String startRange = fields[0].trim().toUpperCase();
                String endRange = fields[1].trim().toUpperCase();
                String logicalLibrary = fields[2].trim();
                String mediaType = fields[3].trim().toUpperCase();
                String enableForNew = fields[4].trim().toUpperCase();
                if (startRange.length() != 6 || endRange.length() != 6) {
                    System.out.println("***** ERROR: Ranges (" + startRange + " - " + endRange + ") has to be only 6 characters long *****");
                    rc = false;
                }
                if (startRange.compareTo(endRange) > 0) {
                    System.out.println("***** ERROR: Starting range is greater than ending range (" + startRange + " - " + endRange + ") *****");
                    rc = false;
                }
                if (logicalLibrary.isEmpty()) {
                    System.out.println("***** ERROR: " + logicalLibrary + " not a valid logical library *****");
                    rc = false;
                }
                if (mediaType.isEmpty()) {
                    System.out.println("***** ERROR: " + mediaType + " not a valid media type [LTO, DLT, 3592] *****");
                    rc = false;
                }
                if (enableForNew.compareTo("TRUE") != 0 && enableForNew.compareTo("FALSE") != 0) {
                    System.out.println("***** ERROR: " + enableForNew + " is not a valid value for the Enable parameter [true, false] *****");
                    rc = false;
                }
                if (!rc) continue;
                String temp = enableForNew.compareTo("TRUE") == 0 ? "1" : "0";
                ranges.put(index, new VolserRange(startRange, endRange, logicalLibrary, temp, String.valueOf(UtilCLI.getMediaTypeInt(mediaType))));
                ++index;
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("***** ERROR: " + fnfe.getMessage() + " Class: " + fnfe.getClass() + " *****");
            if (this.verbose) {
                fnfe.printStackTrace();
            }
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("***** ERROR: " + ioe.getMessage() + " Class: " + ioe.getClass() + " *****");
            if (this.verbose) {
                ioe.printStackTrace();
            }
            System.exit(-1);
        }
        catch (ArrayIndexOutOfBoundsException iobe) {
            System.out.println("***** ERROR: Each line in file must have a start range, end range, logical library  and enable separated by commas *****");
            if (this.verbose) {
                iobe.printStackTrace();
            }
            System.exit(-1);
        }
        if (index > 300) {
            System.out.println("***** NOTICE: The maximum number of volser ranges for a Logical Library is 300. Some volser ranges will not be created if the Logical Library reaches this number");
        }
        return rc;
    }

    private Map<Integer, DriveEncrypted> checkAdvancedEncSettings(String filename) {
        boolean rc = true;
        HashMap<Integer, DriveEncrypted> listEncrypted = new HashMap<Integer, DriveEncrypted>();
        int i = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.params.get("filename")));
            ++i;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String[] fields = line.split(",");
                if (fields.length != 5) {
                    System.out.println("***** ERROR: Wrong number of parameters. *****");
                    System.out.println("             Logical Library Name");
                    System.out.println("\t\t\t Advanced Method: [TRUE / FALSE]\n\t\t\t Advanced Policy: \n                             No advanced setting \t\t\t\t\t= 0\n\t\t\t\t\t\t\t Don't Encrypt if No policy \t\t\t= 1\n                             Encrypt if no policy \t\t\t\t\t= 2\n\t\t\t\t\t\t\t Policy required \t\t\t\t\t\t= 3\n                             Never encrypt ( policy override) \t\t= 4\n\t\t\t\t\t\t\t Always encrypt ( policy overrride) \t= 5\n                             Internal Label - Selective Encryption = 6\n\t\t\t\t\t\t\t Internal Label - Encrypt All \t\t\t= 7\n \t\t\tDensity code: \n                             No advanced setting \t\t\t\t\t= 0\n\t\t\t\t\t\t\t Shows Encryption \t\t\t\t\t\t= 1\n                             Masks Encryption \t\t\t\t\t\t= 2\n \t\t\tKey Path:\n                             No advanced setting \t\t\t\t\t= 1\n\t\t\t\t\t\t\t System \t\t\t\t\t\t\t\t= 2\n                             Application (IBM)\t\t\t\t\t\t= 3\n                             Application (T10)\t\t\t\t\t\t= 4\n                             Library\t\t\t\t\t\t\t\t= 6\n");
                    System.out.println("Advanced Policy [0-7], Density code [0-2], KeyPath[1,2,3,4,6].*****");
                    System.exit(-1);
                }
                String llName = fields[0].trim();
                String advancedMethod = fields[1].trim().toUpperCase();
                String advancedPolicy = fields[2].trim();
                String density = fields[3].trim();
                String keyPath = fields[4].trim();
                int key = Integer.parseInt(keyPath);
                if (advancedMethod.compareTo("TRUE") != 0 && advancedMethod.compareTo("FALSE") != 0) {
                    System.out.println("***** ERROR: " + advancedMethod + " is not a valid value for the Advanced Method parameter [true, false] *****");
                    rc = false;
                } else {
                    advancedMethod = advancedMethod.compareTo("TRUE") == 0 ? "1" : "0";
                }
                if (Integer.parseInt(advancedPolicy) < 0 || Integer.parseInt(advancedPolicy) > 7) {
                    System.out.println("***** ERROR: Advanced Policy has to be a value between 0 and 7  *****");
                    System.out.println("\t\t\t Advanced Policy: \n                             No advanced setting \t\t\t\t\t= 0\n\t\t\t\t\t\t\t Don't Encrypt if No policy \t\t\t= 1\n                             Encrypt if no policy \t\t\t\t\t= 2\n\t\t\t\t\t\t\t Policy required \t\t\t\t\t\t= 3\n                             Never encrypt ( policy override) \t\t= 4\n\t\t\t\t\t\t\t Always encrypt ( policy overrride) \t= 5\n                             Internal Label - Selective Encryption = 6\n\t\t\t\t\t\t\t Internal Label - Encrypt All \t\t\t= 7\n");
                    rc = false;
                }
                if (Integer.parseInt(density) < 0 || Integer.parseInt(density) > 2) {
                    System.out.println("***** ERROR: Density code has to be a value between 0 and 2  *****");
                    System.out.println(" \t\t\tDensity code: \n                             No advanced setting \t\t\t\t\t= 0\n\t\t\t\t\t\t\t Shows Encryption \t\t\t\t\t\t= 1\n                             Masks Encryption \t\t\t\t\t\t= 2\n");
                    rc = false;
                }
                if (key != 1 && key != 2 && key != 3 && key != 4 && key != 6) {
                    System.out.println("***** ERROR: Key path possible values are:  *****");
                    System.out.println(" \t\t\tKey Path:\n                             No advanced setting \t\t\t\t\t= 1\n\t\t\t\t\t\t\t System \t\t\t\t\t\t\t\t= 2\n                             Application (IBM)\t\t\t\t\t\t= 3\n                             Application (T10)\t\t\t\t\t\t= 4\n                             Library\t\t\t\t\t\t\t\t= 6\n");
                    rc = false;
                }
                if (!rc) {
                    System.exit(-1);
                    continue;
                }
                listEncrypted.put(i, this.createDriveAdvancedSettings(llName, advancedMethod, advancedPolicy, density, keyPath));
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("***** ERROR: " + fnfe.getMessage() + fnfe.getClass() + " *****");
            if (this.verbose) {
                fnfe.printStackTrace();
            }
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("***** ERROR: " + ioe.getMessage() + ioe.getClass() + " *****");
            if (this.verbose) {
                ioe.printStackTrace();
            }
            System.exit(-1);
        }
        catch (ArrayIndexOutOfBoundsException iobe) {
            System.out.println("***** ERROR: Each line in file must have a Logical Library Name,Advanced method,Advanced policy, Density code, Key Path,  separated by commas *****");
            if (this.verbose) {
                iobe.printStackTrace();
            }
            System.exit(-1);
        }
        return listEncrypted;
    }

    private DriveEncrypted createDriveAdvancedSettings(String llName, String advancedMethod, String advancedPolicy, String density, String keyPath) {
        DriveEncrypted settings = new DriveEncrypted(llName, "", "", "", "", "", "", "", "");
        settings.setAdvancedSettings(advancedMethod, advancedPolicy, density, keyPath);
        return settings;
    }

    private DriveEncrypted getDriveEncryptedSettings(String llName, DriveEncrypted settings) {
        block4: {
            try {
                this.responseBody = this.connection.doGet(String.valueOf(PATH) + "/CLIHandler?action=getDriveEncrypted&llName=");
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, false);
                    System.exit(-1);
                }
                if (this.responseBody.contains("Empty data set")) {
                    System.out.println("***There are no encryption settings for Logical Library: " + llName + "*****");
                    System.exit(-1);
                }
                JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                Object drive = driveArray.get(0);
                JSONObject object = (JSONObject)drive;
                settings.setNormalSettings((String)object.get((Object)"method"), (String)object.get((Object)"scratch"), (String)object.get((Object)"km1"), (String)object.get((Object)"km2"));
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response.");
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
        return settings;
    }

    public void viewNodeCardsTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewNodeCards";
                String strFormat = String.format("%35s,%25s,%16s,%16s,%25s", "Card name", "Location", "Part number", "Serial number", "Firmware version");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object drive : driveArray) {
                        JSONObject object = (JSONObject)drive;
                        String location = UtilCLI.getLocationNodeCard((String)object.get((Object)"nodeidx"));
                        System.out.println(String.format("%35s,%25s,%16s,%16s,%25s", UtilCLI.getNodeCardName((String)object.get((Object)"nodeidx")), location, (String)object.get((Object)"nodepartnumber"), (String)object.get((Object)"nodeserialnumber"), (String)object.get((Object)"firmwareversion")));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void resetNodeCardsTask() {
        String nodeList = UtilCLI.getNodeIdsByName(this.params.get("nodeList"));
        String url = String.valueOf(PATH) + "/CLIHandler?action=resetNodeCards&nodes=" + nodeList;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The card was reset successfully");
        }
    }

    public void viewSystemSummary() {
        block20: {
            try {
                this.responseBody = this.connection.doGet("/CLIHandler?action=viewSystemSummary");
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, false);
                    return;
                }
                if (this.responseBody.contains("Empty data set")) {
                    System.out.println("<Empty>");
                    System.exit(-1);
                    return;
                }
                JSONArray frameArray = JSONArray.parse((String)this.responseBody.toString());
                int totalStorageSlots = 0;
                int totalCartridges = 0;
                int totalIOSlots = 0;
                int totalIOCartridges = 0;
                int totalDrives = 0;
                int totalFrames = 0;
                int idxFrame = 0;
                for (Object ll : frameArray) {
                    String lowJAG;
                    String upJAG;
                    int accessorSeverity;
                    ++totalFrames;
                    JSONObject object = (JSONObject)ll;
                    System.out.println(String.format("%26s%16s", "Frame:", (String)object.get((Object)"frameidx")));
                    int n = accessorSeverity = object.get((Object)"accsr1status") != null ? Integer.parseInt(object.get((Object)"accsr1status").toString()) : 0;
                    if (++idxFrame == frameArray.size()) {
                        System.out.println(String.format("%26s%16s", "Accessors:", this.getAccessorStatus(accessorSeverity)));
                    }
                    System.out.println(String.format("%26s%16s", "State:", UtilCLI.getDoorState((String)object.get((Object)"maindoorstate"))));
                    System.out.println(String.format("%26s%16s", "Media Type:", UtilCLI.getMediaType((String)object.get((Object)"frametype"))));
                    System.out.println(String.format("%26s%16s", "Data Cartridges:", (String)object.get((Object)"cartused")));
                    totalCartridges += Integer.parseInt((String)object.get((Object)"cartused"));
                    System.out.println(String.format("%26s%16s", "Storage Slots:", (String)object.get((Object)"maxslot")));
                    totalStorageSlots += Integer.parseInt((String)object.get((Object)"maxslot"));
                    System.out.println(String.format("%26s%16s", "Drives:", (String)object.get((Object)"maxdrive")));
                    totalDrives += Integer.parseInt((String)object.get((Object)"maxdrive"));
                    int upper = object.get((Object)"upmagazine") != null && !((String)object.get((Object)"upmagazine")).isEmpty() ? Integer.parseInt(object.get((Object)"upmagazine").toString()) : 0;
                    int lower = object.get((Object)"lowmagazine") != null && !((String)object.get((Object)"lowmagazine")).isEmpty() ? Integer.parseInt(object.get((Object)"lowmagazine").toString()) : 0;
                    String upperIOCartridges = "0";
                    String lowerIOCartridges = "0";
                    String upperIOSlots = "";
                    String lowerIOSlots = "";
                    String medType = "";
                    String upLTO = object.get((Object)"upiocarlto") != null ? object.get((Object)"upiocarlto").toString() : "0";
                    String string = upJAG = object.get((Object)"upiocarjag") != null ? object.get((Object)"upiocarjag").toString() : "0";
                    if (Integer.parseInt(upLTO) > 0) {
                        upperIOCartridges = upLTO;
                    } else if (Integer.parseInt(upJAG) > 0) {
                        upperIOCartridges = upJAG;
                    }
                    totalIOCartridges += Integer.parseInt(upperIOCartridges);
                    String lowLTO = object.get((Object)"lowiocarlto") != null ? object.get((Object)"lowiocarlto").toString() : "0";
                    String string2 = lowJAG = object.get((Object)"lowiocarjag") != null ? object.get((Object)"lowiocarjag").toString() : "0";
                    if (Integer.parseInt(lowLTO) > 0) {
                        lowerIOCartridges = lowLTO;
                    } else if (Integer.parseInt(lowJAG) > 0) {
                        lowerIOCartridges = lowJAG;
                    }
                    totalIOCartridges += Integer.parseInt(lowerIOCartridges);
                    if (upper > 0) {
                        if (upper == 1) {
                            upperIOSlots = "18";
                            medType = "LTO";
                        } else if (upper == 3) {
                            upperIOSlots = "16";
                            medType = "3592";
                        }
                        totalIOSlots += Integer.parseInt(upperIOSlots);
                        System.out.println(String.format("%26s%16s", "Upper IO cartridges:", upperIOCartridges));
                        System.out.println(String.format("%26s%16s", "Upper IO door slots:", upperIOSlots));
                        System.out.println(String.format("%26s%16s", "Upper IO door media type:", medType));
                    }
                    if (lower > 0) {
                        if (lower == 1) {
                            lowerIOSlots = "18";
                            medType = "LTO";
                        } else if (lower == 3) {
                            lowerIOSlots = "16";
                            medType = "3592";
                        }
                        totalIOSlots += Integer.parseInt(lowerIOSlots);
                        System.out.println(String.format("%26s%16s", "Lower IO cartridges:", lowerIOCartridges));
                        System.out.println(String.format("%26s%16s", "Lower IO door slots:", lowerIOSlots));
                        System.out.println(String.format("%26s%16s", "Lower IO door media type:", medType));
                    }
                    System.out.println(String.format("%26s%16s", "MTM:", (String)object.get((Object)"col3info")));
                    System.out.println(String.format("%26s%16s", "S/N:", (String)object.get((Object)"serialnumber")));
                    System.out.println("-------------------------------------------------------------------");
                }
                System.out.println(String.format("%26s%16s", "Total storage slots:", totalStorageSlots));
                System.out.println(String.format("%26s%16s", "Total storage cartridges", totalCartridges));
                System.out.println(String.format("%26s%16s", "Total IO slots:", totalIOSlots));
                System.out.println(String.format("%26s%16s", "Total IO cartridges", totalIOCartridges));
                System.out.println(String.format("%26s%16s", "Total Drives:", totalDrives));
                System.out.println(String.format("%26s%16s", "Total Frames", totalFrames));
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block20;
                e.printStackTrace();
            }
        }
    }

    public void viewSystemSummaryDetailsTask() {
        block20: {
            try {
                this.responseBody = this.connection.doGet("/CLIHandler?action=viewSystemSummary");
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, false);
                    return;
                }
                if (this.responseBody.contains("Empty data set")) {
                    System.out.println("<Empty>");
                    Gen4cli.returnStatus = 0;
                    return;
                }
                JSONArray frameArray = JSONArray.parse((String)this.responseBody.toString());
                int idFrame = Integer.parseInt(this.params.get("frame"));
                for (Object ll : frameArray) {
                    String lowJAG;
                    String upJAG;
                    int accessorSeverity;
                    JSONObject object = (JSONObject)ll;
                    if (((String)object.get((Object)"frameidx")).compareTo(this.params.get("frame")) != 0) continue;
                    System.out.println(String.format("%26s%16s", "Frame:", (String)object.get((Object)"frameidx")));
                    int n = accessorSeverity = object.get((Object)"accsr1status") != null ? Integer.parseInt(object.get((Object)"accsr1status").toString()) : 0;
                    if (idFrame == frameArray.size()) {
                        System.out.println(String.format("%26s%16s", "Accessors:", this.getAccessorStatus(accessorSeverity)));
                    }
                    System.out.println(String.format("%26s%16s", "State:", UtilCLI.getDoorState((String)object.get((Object)"maindoorstate"))));
                    System.out.println(String.format("%26s%16s", "Media Type:", UtilCLI.getMediaType((String)object.get((Object)"frametype"))));
                    System.out.println(String.format("%26s%16s", "Data Cartridges:", (String)object.get((Object)"cartused")));
                    System.out.println(String.format("%26s%16s", "Storage Slots:", (String)object.get((Object)"maxslot")));
                    System.out.println(String.format("%26s%16s", "Drives:", (String)object.get((Object)"maxdrive")));
                    int upper = object.get((Object)"upmagazine") != null && !((String)object.get((Object)"upmagazine")).isEmpty() ? Integer.parseInt(object.get((Object)"upmagazine").toString()) : 0;
                    int lower = object.get((Object)"lowmagazine") != null && !((String)object.get((Object)"lowmagazine")).isEmpty() ? Integer.parseInt(object.get((Object)"lowmagazine").toString()) : 0;
                    String upperIOCartridges = "0";
                    String lowerIOCartridges = "0";
                    String upperIOSlots = "";
                    String lowerIOSlots = "";
                    String medType = "";
                    String upLTO = object.get((Object)"upiocarlto") != null ? object.get((Object)"upiocarlto").toString() : "0";
                    String string = upJAG = object.get((Object)"upiocarjag") != null ? object.get((Object)"upiocarjag").toString() : "0";
                    if (Integer.parseInt(upLTO) > 0) {
                        upperIOCartridges = upLTO;
                    } else if (Integer.parseInt(upJAG) > 0) {
                        upperIOCartridges = upJAG;
                    }
                    String lowLTO = object.get((Object)"lowiocarlto") != null ? object.get((Object)"lowiocarlto").toString() : "0";
                    String string2 = lowJAG = object.get((Object)"lowiocarjag") != null ? object.get((Object)"lowiocarjag").toString() : "0";
                    if (Integer.parseInt(lowLTO) > 0) {
                        lowerIOCartridges = lowLTO;
                    } else if (Integer.parseInt(lowJAG) > 0) {
                        lowerIOCartridges = lowJAG;
                    }
                    if (upper > 0) {
                        if (upper == 1) {
                            upperIOSlots = "18";
                            medType = "LTO";
                        } else if (upper == 3) {
                            upperIOSlots = "16";
                            medType = "3592";
                        }
                        System.out.println(String.format("%26s%16s", "Upper IO cartridges:", upperIOCartridges));
                        System.out.println(String.format("%26s%16s", "Upper IO door slots:", upperIOSlots));
                        System.out.println(String.format("%26s%16s", "Upper IO door media type:", medType));
                    }
                    if (lower > 0) {
                        if (lower == 1) {
                            lowerIOSlots = "18";
                            medType = "LTO";
                        } else if (lower == 3) {
                            lowerIOSlots = "16";
                            medType = "3592";
                        }
                        System.out.println(String.format("%26s%16s", "Lower IO cartridges:", lowerIOCartridges));
                        System.out.println(String.format("%26s%16s", "Lower IO door slots:", lowerIOSlots));
                        System.out.println(String.format("%26s%16s", "Lower IO door media type:", medType));
                    }
                    System.out.println(String.format("%26s%16s", "MTM:", (String)object.get((Object)"col3info")));
                    System.out.println(String.format("%26s%16s", "S/N:", (String)object.get((Object)"serialnumber")));
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block20;
                e.printStackTrace();
            }
        }
    }

    public void viewLibraryVPDTask() {
        block5: {
            try {
                this.responseBody = this.connection.doGet("/CLIHandler?action=viewSystemSummary");
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, false);
                    return;
                }
                if (this.responseBody.contains("Empty data set")) {
                    System.out.println("<Empty>");
                    System.exit(-1);
                    return;
                }
                JSONArray frameArray = JSONArray.parse((String)this.responseBody.toString());
                System.out.println(String.format("%15s,%20s,%10s,%20s,%10s", "Location", "Machine Type", "Model", "Serial Number", "Media Type"));
                for (Object ll : frameArray) {
                    JSONObject object = (JSONObject)ll;
                    System.out.println(String.format("%15s,%20s,%10s,%20s,%10s", "Frame " + (String)object.get((Object)"frameidx"), ((String)object.get((Object)"col3info")).substring(0, 4), ((String)object.get((Object)"col3info")).substring(4, 7), (String)object.get((Object)"serialnumber"), UtilCLI.getMediaType((String)object.get((Object)"frametype"))));
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void setVIOStatusTask() {
        block8: {
            String value = "";
            if (!this.isIoEmpty()) {
                System.out.println("****ERROR: There are cartridges in IO station(s). The command cannot be executed.");
                System.exit(-1);
            }
            if (this.params.get("vioStatus").toUpperCase().compareTo("ENABLED") == 0) {
                value = "1";
            } else if (this.params.get("vioStatus").toUpperCase().compareTo("DISABLED") == 0) {
                value = "0";
            } else {
                System.out.println("*** ERROR: Parameter not valid. Value should be \"Enabled\" or \"Disabled\"");
                System.out.println("***************************************");
                Gen4cli.returnStatus = 1;
                return;
            }
            String url = String.valueOf(PATH) + "/CLIHandler?action=setVIOStatus&status=" + value;
            try {
                this.responseBody = this.connection.doGet(url);
                if (this.responseBody.contains("exception") || this.responseBody.contains("error")) {
                    this.handleException(this.responseBody, false);
                    return;
                }
                System.out.println("The VIO Status was set successfully");
                System.out.println("-----------------------------------------");
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block8;
                e.printStackTrace();
            }
        }
    }

    public String getAccessorStatus(int severity) {
        String status = "";
        switch (severity) {
            case 0: 
            case 1: {
                status = accessorStatus.MINOR_WARNING.toString();
                status = String.valueOf(status) + " - Offline";
                break;
            }
            case 2: 
            case 5: {
                status = accessorStatus.ERROR.toString();
                status = String.valueOf(status) + " - Offline";
                break;
            }
            case 3: 
            case 4: {
                status = accessorStatus.OK.toString();
                status = String.valueOf(status) + " - Online";
                break;
            }
            default: {
                status = accessorStatus.ERROR.toString();
                status = String.valueOf(status) + " - Offline";
            }
        }
        return status;
    }

    public void moveFromDriveTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=moveFromDrive&frameDrive=" + this.params.get("frameDrive") + "&columnDrive=" + this.params.get("columnDrive") + "&rowDrive=" + this.params.get("rowDrive") + "&tierDrive=0&srcType=" + 4;
        if (this.getResponseBody(url = String.valueOf(url) + "&frame=0&column=0&row=0&tier=0&destType=2", "", false)) {
            this.printResultMessage("The cartridge was ejected successfully");
        }
    }

    public void moveFromIoTask() {
        String url = "";
        String frame = "";
        String column = "";
        String row = "";
        String tier = "";
        if (this.params.containsKey("volser")) {
            Cartridge c = new Cartridge(this.params.get("volser"));
            if (this.getVolserDataTask(this.params.get("volser"), "", c)) {
                frame = c.getLocation().get("frame");
                column = c.getLocation().get("column");
                row = c.getLocation().get("row");
                tier = c.getLocation().get("tier");
                url = "good";
                if (Integer.parseInt(c.getType()) != 3) {
                    url = "";
                }
            }
        } else {
            frame = this.params.get("frame");
            row = this.params.get("row");
            url = "good";
        }
        if (!url.isEmpty()) {
            url = String.valueOf(PATH) + "/CLIHandler?action=unassignDataCartridges&frameSrc=" + frame + "&columnSrc=" + "0" + "&rowSrc=" + row + "&tierSrc=" + "0&type=" + 3;
            if (this.getResponseBody(url, "", false)) {
                this.printResultMessage("The cartridge was moved successfully");
            }
        } else {
            System.out.println("****ERROR: VOLSER " + this.params.get("volser") + " cannot be found in IO locations");
            System.exit(-1);
        }
    }

    public void moveToDriveTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=moveToDrive";
        switch (this.params.size()) {
            case 7: {
                Cartridge c = new Cartridge(this.params.get("volser"));
                if (this.getVolserDataTask(this.params.get("volser"), "", c)) {
                    url = String.valueOf(url) + "&frame=" + c.getLocation().get("frame");
                    url = String.valueOf(url) + "&column=" + c.getLocation().get("column");
                    url = String.valueOf(url) + "&row=" + c.getLocation().get("row");
                    url = String.valueOf(url) + "&tier=" + c.getLocation().get("tier");
                    url = String.valueOf(url) + "&typeSrc=2";
                    if (Integer.parseInt(c.getType()) == 2) break;
                    url = "";
                    break;
                }
                url = "";
                break;
            }
            case 9: 
            case 10: {
                url = String.valueOf(url) + "&frame=" + this.params.get("frame");
                url = String.valueOf(url) + "&column=" + this.params.get("column");
                url = String.valueOf(url) + "&row=" + this.params.get("row");
                url = this.params.containsKey("tier") ? String.valueOf(url) + "&tier=" + this.params.get("tier") : String.valueOf(url) + "&tier=0";
                url = String.valueOf(url) + "&typeSrc=2";
                break;
            }
        }
        if (!url.isEmpty()) {
            if (this.getResponseBody(url = String.valueOf(url) + "&frameDrive=" + this.params.get("frameDrive") + "&columnDrive=" + this.params.get("columnDrive") + "&rowDrive=" + this.params.get("rowDrive") + "&tierDrive=0&destType=" + 4, "", false)) {
                if (this.params.containsKey("volser")) {
                    this.printResultMessage("The cartridge " + this.params.get("volser") + " was mounted successfully");
                } else {
                    this.printResultMessage("The cartridge  was mounted successfully");
                }
            }
        } else {
            System.out.println("****ERROR: VOLSER " + this.params.get("volser") + " cannot be found in Storage locations");
            Gen4cli.returnStatus = 1;
        }
    }

    public void prestageDataCartridgesTask() throws ClientProtocolException, IOException {
        HashMap<Cartridge, String> cartridges = new HashMap<Cartridge, String>();
        BufferedReader br = null;
        if (!this.checkInlineParamsPreDestage(this.params.get("filename"), cartridges, true)) {
            br = new BufferedReader(new FileReader(this.params.get("filename")));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                String row = "";
                String column = "";
                String frame = "";
                String tier = "";
                while (line != null) {
                    String[] temp = line.split(",");
                    if (temp.length == 4) {
                        tier = temp[3].trim().replace("T", "");
                        if (Integer.parseInt(tier) >= 3) {
                            frame = temp[0].trim().replace("F", "");
                            column = temp[0].trim().replace("C", "");
                            row = temp[0].trim().replace("R", "");
                            cartridges.put(new Cartridge(temp[0].trim().replace("F", ""), temp[1].trim().replace("C", ""), temp[2].trim().replace("R", ""), temp[3].trim().replace("T", "")), "");
                        } else {
                            System.out.println("Tier = " + temp[3].trim().replace("T", "") + "  Prestage command requires cartridges in Tier >= 3");
                        }
                    } else if (temp.length == 1) {
                        Cartridge c = new Cartridge(temp[0].trim());
                        if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                            if (Integer.parseInt(c.getLocation().get("tier")) >= 3) {
                                cartridges.put(c, "");
                            } else {
                                System.out.println("Tier = " + c.getLocation().get("tier") + " for VOLSER = " + temp[0].trim() + "  Prestage command requires cartridges in Tier >= 3");
                            }
                        } else {
                            System.out.println("****ERROR: VOLSER " + temp[0].trim() + " cannot be found in Storage location");
                        }
                    } else {
                        System.out.println("****ERROR: Wrong format for cartridge. The valid formats are:\n");
                        System.out.println("\t[Volser]\n");
                        System.out.println("\t[Frame],[Column],[Row],[Tier]\n");
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        for (Cartridge c : cartridges.keySet()) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=prestageDataCartridges&frameSrc=" + c.getLocation().get("frame") + "&columnSrc=" + c.getLocation().get("column") + "&rowSrc=" + c.getLocation().get("row") + "&tierSrc=" + c.getLocation().get("tier") + "&srcType=" + 2 + "&frameDst=0&columnDst=0&rowDst=0&tierDst=0&destType=" + 2;
            if (!this.getResponseBody(url, "", false)) continue;
            String location = "F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier");
            if (c.getVolser().isEmpty()) {
                this.printResultMessage("The cartridge " + location + " was moved successfully. Next cartridge...");
                continue;
            }
            this.printResultMessage("The cartridge " + c.getVolser() + " was moved successfully. Next cartridge...");
        }
        System.out.println("Done.");
    }

    public void destageDataCartridgesTask() throws ClientProtocolException, IOException {
        HashMap<Cartridge, String> cartridges = new HashMap<Cartridge, String>();
        BufferedReader br = null;
        if (!this.checkInlineParamsPreDestage(this.params.get("filename"), cartridges, false)) {
            br = new BufferedReader(new FileReader(this.params.get("filename")));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] temp = line.split(",");
                    if (temp.length == 4) {
                        if (temp[3].trim().replace("T", "").compareTo("0") == 0) {
                            cartridges.put(new Cartridge(temp[0].trim().replace("F", ""), temp[1].trim().replace("C", ""), temp[2].trim().replace("R", ""), temp[3].trim().replace("T", "")), "");
                        } else {
                            System.out.println("Tier = " + temp[3].trim().replace("T", "") + " Destage command requires cartridges in Tier = 0");
                        }
                    } else if (temp.length == 1) {
                        Cartridge c = new Cartridge(temp[0].trim());
                        if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                            if (Integer.parseInt(c.getLocation().get("tier")) == 0) {
                                cartridges.put(c, "");
                            } else {
                                System.out.println("Tier = " + c.getLocation().get("tier") + " for VOLSER " + c.getVolser() + " Destage command requires cartridges in Tier = 0");
                            }
                        } else {
                            System.out.println("****ERROR: VOLSER " + temp[0].trim() + " cannot be found in Storage location");
                        }
                    } else {
                        System.out.println("****ERROR: Wrong format for cartridge. The valid formats are:\n");
                        System.out.println("\t[Volser]\n");
                        System.out.println("\t[Frame],[Column],[Row],[Tier]\n");
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        for (Cartridge c : cartridges.keySet()) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=destageDataCartridges&frameSrc=" + c.getLocation().get("frame") + "&columnSrc=" + c.getLocation().get("column") + "&rowSrc=" + c.getLocation().get("row") + "&tierSrc=" + c.getLocation().get("tier") + "&srcType=" + 2 + "&frameDst=0&columnDst=0&rowDst=0&tierDst=0&destType=" + 2;
            if (!this.getResponseBody(url, "", false)) continue;
            String location = "F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier");
            if (c.getVolser().isEmpty()) {
                this.printResultMessage("The cartridge " + location + " was moved successfully. Next cartridge...");
                continue;
            }
            this.printResultMessage("The cartridge " + c.getVolser() + " was moved successfully. Next cartridge...");
        }
        System.out.println("Done.");
    }

    public void moveFromAllDrivesTask() {
        block4: {
            String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewDriveSummary";
            if (this.getResponseBody(URL2, "", false)) {
                try {
                    JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                    for (Object drive : driveArray) {
                        JSONObject object = (JSONObject)drive;
                        String location = (String)object.get((Object)"location");
                        String contents = UtilCLI.getDriveContents((String)object.get((Object)"contents"));
                        if (contents.compareTo("Empty") == 0) continue;
                        String[] position = location.replace("F", "").replace("C", "").replace("R", "").split(",");
                        String url = String.valueOf(PATH) + "/CLIHandler?action=moveFromAllDrives&frameDrive=" + position[0] + "&columnDrive=" + position[1] + "&rowDrive=" + position[2] + "&tierDrive=0&srcType=" + 4;
                        if (!this.getResponseBody(url = String.valueOf(url) + "&frame=0&column=0&row=0&tierDest=0&destType=2", "", false)) continue;
                        this.printResultMessage("The drive " + location + " is empty now. Moving to next drive...");
                    }
                    System.out.println("Done.");
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    if (!this.verbose) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    public void removeDataCartridgesTask() throws ClientProtocolException, IOException {
        HashMap<Cartridge, String> cartridges = new HashMap<Cartridge, String>();
        BufferedReader br = null;
        if (!this.checkInlineParams(this.params.get("filename"), cartridges)) {
            br = new BufferedReader(new FileReader(this.params.get("filename")));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    String[] temp = line.split(",");
                    Cartridge c = null;
                    if (temp.length == 4) {
                        c = new Cartridge(temp[0].trim().replace("F", ""), temp[1].trim().replace("C", ""), temp[2].trim().replace("R", ""), temp[3].trim().replace("T", ""));
                        c.setType("2");
                        cartridges.put(c, "");
                    } else if (temp.length == 3) {
                        c = new Cartridge(temp[0].trim().replace("F", ""), null, temp[2].trim().replace("R", ""), null);
                        c.setType("3");
                        cartridges.put(c, "");
                    } else if (temp.length == 1) {
                        c = new Cartridge(temp[0].trim());
                        if (this.getVolserDataTask(temp[0].trim(), "", c)) {
                            cartridges.put(c, temp[0].trim());
                        } else {
                            System.out.println("****ERROR: Cartridge " + temp[0].trim() + " cannot be found.\n");
                        }
                    } else {
                        System.out.println("****ERROR: Wrong format for cartridge. The allowed formats are:\n");
                        System.out.println("\t[Volser]\n");
                        System.out.println("\t[Frame],[Column],[Row],[Tier]\n");
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        for (Cartridge c : cartridges.keySet()) {
            String url = "";
            int type = Integer.parseInt(c.getType());
            if (this.checkVIOStatus() && (type == 2 || type == 3)) {
                url = String.valueOf(PATH) + "/CLIHandler?action=removeDataCartridges&frameSrc=" + c.getLocation().get("frame") + "&columnSrc=" + (c.getLocation().get("column") == null ? "0" : c.getLocation().get("column")) + "&rowSrc=" + c.getLocation().get("row") + "&tierSrc=" + (c.getLocation().get("tier") == null ? "0" : c.getLocation().get("tier")) + "&type=" + Integer.parseInt(c.getType());
            } else if (Integer.parseInt(c.getType()) == 2) {
                url = String.valueOf(PATH) + "/CLIHandler?action=moveFromIo&frameSrc=" + c.getLocation().get("frame") + "&columnSrc=" + c.getLocation().get("column") + "&rowSrc=" + c.getLocation().get("row") + "&tierSrc=" + (c.getLocation().get("tier") == null ? "0" : c.getLocation().get("tier")) + "&srcType=" + 2 + "&frameDst=0&columnDst=0&rowDst=0&tierDst=0&destType=" + 3;
            } else {
                url = "";
                if (!c.getVolser().isEmpty()) {
                    System.out.println("****ERROR: Cartridge " + c.getVolser() + " is not of a valid type for this command.");
                } else {
                    System.out.println("****ERROR: Cartridge  F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier") + "is not of a valid type for this command.");
                }
                System.out.println("Usage: VIO disable :  removeDataCartridges only works for storage locations\n");
                System.out.println("Usage: VIO enable  :  removeDataCartridges  works for storage and IO locations\n");
            }
            if (url.isEmpty() || !this.getResponseBody(url, "", false)) continue;
            if (!c.getVolser().isEmpty()) {
                this.printResultMessage("The cartridge " + c.getVolser() + " was removed successfully");
                continue;
            }
            this.printResultMessage("The cartridge F" + c.getLocation().get("frame") + ",C" + c.getLocation().get("column") + ",R" + c.getLocation().get("row") + ",T" + c.getLocation().get("tier") + " was removed successfully");
        }
        System.out.println("Done.");
    }

    private boolean checkInlineParams(String param, Map<Cartridge, String> cartridges) {
        boolean result = false;
        if (!param.contains(".")) {
            String[] volsers = param.split(",");
            int i = 0;
            while (i < volsers.length) {
                Cartridge c = new Cartridge(volsers[i].trim());
                if (this.getVolserDataTask(volsers[i].trim(), "", c)) {
                    cartridges.put(c, volsers[i].trim());
                } else {
                    System.out.println("****ERROR: Cartridge " + volsers[i].trim() + " cannot be found.\n");
                }
                ++i;
            }
            if (cartridges.size() > 0) {
                result = true;
            }
        }
        return result;
    }

    private boolean checkInlineParamsPreDestage(String param, Map<Cartridge, String> cartridges, boolean isPrestage) {
        boolean result = false;
        if (!param.contains(".")) {
            String[] volsers = param.split(",");
            int i = 0;
            while (i < volsers.length) {
                Cartridge c = new Cartridge(volsers[i].trim());
                if (this.getVolserDataTask(volsers[i].trim(), "", c)) {
                    if (isPrestage) {
                        if (Integer.parseInt(c.getLocation().get("tier")) >= 3) {
                            cartridges.put(c, "");
                        } else {
                            System.out.println("Tier = " + c.getLocation().get("tier") + " for VOLSER " + c.getVolser() + "  Prestage command requires cartridges in Tier >= 3");
                        }
                    } else if (Integer.parseInt(c.getLocation().get("tier")) == 0) {
                        cartridges.put(c, "");
                    } else {
                        System.out.println("Tier = " + c.getLocation().get("tier") + " for VOLSER " + c.getVolser() + " Destage command requires cartridges in Tier = 0");
                    }
                } else {
                    System.out.println("****ERROR: VOLSER " + volsers[i].trim() + " cannot be found in Storage location");
                }
                ++i;
            }
            if (cartridges.size() > 0) {
                result = true;
            }
        }
        return result;
    }

    public void viewUsersTask() {
        block6: {
            try {
                String URL2 = "/CLIHandler?action=viewUsers";
                String strFormat = String.format("%20s,%5s,%15s,%15s,%25s,%40s", "Name", " Locked", "State", "Role", "Email", "Last login");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    HashMap<String, String> mapObjects = new HashMap<String, String>();
                    JSONArray objectsArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object ll : objectsArray) {
                        JSONObject object = (JSONObject)ll;
                        Long timeSecs = Long.parseLong((String)object.get((Object)"lastlogin"));
                        String date = "0";
                        date = timeSecs > 0L ? new SimpleDateFormat("EEEE, MMMM d, yyyy, hh:mm:ss a z").format(new Date(timeSecs * 1000L)) : "";
                        String connect = "Disconnected";
                        Integer sessions = Integer.parseInt((String)object.get((Object)"activesessions"));
                        if (sessions > 0) {
                            connect = "Connected ";
                            if (sessions > 1) {
                                connect = String.valueOf(connect) + "(" + sessions + ")";
                            }
                        }
                        String text = String.format("%20s,%5s,%15s,%15s,%25s,%40s", (String)object.get((Object)"username"), ((String)object.get((Object)"active")).compareTo("1") == 0 ? "" : "Yes", connect, (String)object.get((Object)"rolename"), (String)object.get((Object)"email"), date);
                        mapObjects.put(((String)object.get((Object)"username")).toLowerCase(), text);
                    }
                    this.printSort(mapObjects);
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: Could not parse JSON string");
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block6;
                e.printStackTrace();
            }
        }
    }

    public void viewRolesTask() {
        block9: {
            try {
                String URL2 = "/CLIHandler?action=viewRoles";
                String strFormat = String.format("%20s,%10s", "Role", "Mapped users");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    HashMap<String, String> mapObjects = new HashMap<String, String>();
                    JSONArray objectsArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object ll : objectsArray) {
                        JSONObject object = (JSONObject)ll;
                        String text = String.format("%20s,%10s", (String)object.get((Object)"name"), (String)object.get((Object)"users"));
                        mapObjects.put(((String)object.get((Object)"name")).toLowerCase(), text);
                    }
                    ArrayList keys = new ArrayList(mapObjects.keySet());
                    Collections.sort(keys, new Comparator<String>(){

                        @Override
                        public int compare(String role1, String role2) {
                            ArrayList<String> presetRoles = new ArrayList<String>();
                            presetRoles.add("administrator");
                            presetRoles.add("superuser");
                            presetRoles.add("service");
                            presetRoles.add("monitor");
                            if (presetRoles.contains(role1) || presetRoles.contains(role2)) {
                                return 0;
                            }
                            return role1.compareTo(role2);
                        }
                    });
                    if (keys.contains("administrator")) {
                        System.out.println((String)mapObjects.get("administrator"));
                        keys.remove("administrator");
                    }
                    if (keys.contains("superuser")) {
                        System.out.println((String)mapObjects.get("superuser"));
                        keys.remove("superuser");
                    }
                    if (keys.contains("service")) {
                        System.out.println((String)mapObjects.get("service"));
                        keys.remove("service");
                    }
                    if (keys.contains("monitor")) {
                        System.out.println((String)mapObjects.get("monitor"));
                        keys.remove("monitor");
                    }
                    for (String str : keys) {
                        System.out.println((String)mapObjects.get(str));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block9;
                e.printStackTrace();
            }
        }
    }

    public void viewRolePermissionsTask() {
        block4: {
            try {
                String URL2 = "/CLIHandler?action=viewRolePermissions&id=&name=" + this.params.get("role");
                String strFormat = String.format("%35s,%15s", "Action", "Access Level");
                if (this.getResponseBody(URL2, "", false)) {
                    JSONArray objectsArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object ll : objectsArray) {
                        JSONObject object = (JSONObject)ll;
                        String text = String.format("%35s,%15s", (String)object.get((Object)"task"), UtilCLI.getAccessLevel((String)object.get((Object)"accesslevel")));
                        System.out.println(text);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void setRolePermissionsTask() {
        block7: {
            BufferedReader br = null;
            try {
                String URL2 = "/CLIHandler?action=getPagesAccess";
                br = new BufferedReader(new FileReader(this.params.get("filename")));
                if (this.getResponseBody(URL2, "", false)) {
                    JSONArray objectsArray = JSONArray.parse((String)this.responseBody.toString());
                    HashMap<String, String> pagesName = new HashMap<String, String>();
                    for (Object o : objectsArray) {
                        JSONObject object = (JSONObject)o;
                        pagesName.put(((String)object.get((Object)"pagename")).toLowerCase(), (String)object.get((Object)"pageidx"));
                    }
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    String newPermissions = "";
                    while (line != null) {
                        String pageName;
                        String[] temp = line.split(",");
                        if (temp.length == 2 && pagesName.containsKey((pageName = temp[0].trim()).toLowerCase())) {
                            String accessLevel = UtilCLI.getAccessLevelID(temp[1].trim().toUpperCase());
                            newPermissions = String.valueOf(newPermissions) + (String)pagesName.get(pageName.toLowerCase()) + "," + accessLevel + ",";
                        }
                        line = br.readLine();
                    }
                    br.close();
                    newPermissions = newPermissions.substring(0, newPermissions.length() - 1);
                    String role = this.params.get("role").toString();
                    URL2 = "/CLIHandler?action=setRolePermissions&role=" + role + "&list=" + newPermissions;
                    if (this.getResponseBody(URL2, "", false)) {
                        this.printResultMessage("The permissions were updated successfully");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                Gen4cli.returnStatus = 1;
                if (!this.verbose) break block7;
                e.printStackTrace();
            }
        }
    }

    public void setLibraryTimeTask() {
        Date actual = new Date();
        long secs = actual.getTime() / 1000L;
        TimeZone tz = Calendar.getInstance().getTimeZone();
        String url = String.valueOf(PATH) + "/CLIHandler?action=setLibraryTime&secs=" + secs + "&timezone=" + tz.getID();
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The library date and time were updated successfully to " + actual.toString() + ", time zone: " + tz.getID());
        }
    }

    public void setNMADetectionTask() {
        String url;
        String flag = this.params.get("nma");
        int value = 0;
        if (flag.trim().toUpperCase().compareTo("TRUE") == 0) {
            value = 1;
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=setNMADetection&nma=" + value, "", false)) {
            this.printResultMessage("The NMA detection flag was updated successfully");
        }
    }

    public void viewSnapshotsTask() {
        block5: {
            String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewSnapshots";
            try {
                this.responseBody = this.connection.doGet(URL2);
                if (!this.responseBody.contains("exception")) {
                    String output = this.responseBody.replace("snapshots=", "");
                    output = output.replace("[", "");
                    output = output.replace("]", "");
                    String[] files = output.split(",");
                    int i = 0;
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        System.out.println(i + 1 + " - " + file);
                        ++i;
                        ++n2;
                    }
                } else {
                    System.out.println("There are no snapshots available.");
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void modifyFibreChannelSettings() {
        String[] settings = this.params.get("settings").split(",");
        String url = String.valueOf(PATH) + "/CLIHandler?action=modifyFibreChannelSettings&frame=" + this.params.get("frame") + "&column=" + this.params.get("column") + "&row=" + this.params.get("row") + "&p1Top=" + UtilCLI.getTopologyValue(settings[1]) + "&p1S=" + UtilCLI.getSpeedValue(settings[0]) + "&p2T=" + UtilCLI.getTopologyValue(settings[1]) + "&p2S=" + UtilCLI.getSpeedValue(settings[0]);
        if (this.getResponseBody(url, "", false) && this.getResponseBody(url, "", false)) {
            this.printResultMessage("The Fibre channel settings were updated successfully");
        }
    }

    public void setDrivePortsIDTask() {
        String[] settings = this.params.get("ids").split(",");
        String url = String.valueOf(PATH) + "/CLIHandler?action=setDrivePortsID&frame=" + this.params.get("frame") + "&column=" + this.params.get("column") + "&row=" + this.params.get("row") + "&port1ID=" + settings[0] + "&port2ID=" + settings[1];
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The ports IDs were updated successfully");
        }
    }

    public void createBEPTask() {
        boolean rc = false;
        String url = "";
        String klm2 = "";
        if (this.validateIndexKLM(this.params.get("klm1"))) {
            rc = true;
            if (this.params.containsKey("klm2") && this.validateIndexKLM(this.params.get("klm2"))) {
                rc = true;
                klm2 = this.params.get("klm2");
            }
        }
        if (!rc) {
            System.out.println("****ERROR: The KLM index(es) are invalid");
            System.exit(-1);
        }
        if (rc && this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=viewLogicalLibraryDetails&LogLibIdx='" + this.params.get("logicalLibrary") + "'", "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            if (Gen4cli.returnStatus == 0 && UtilCLI.getMediaTypeInt(this.params.get("mediaType")) != Integer.parseInt((String)object.get((Object)"mediatype"))) {
                rc = false;
                System.out.println("****ERROR: Media type for BEP is incorrect");
                System.exit(-1);
            }
        }
        if (rc && this.validateVolserRange(this.params.get("volserStart"), this.params.get("volserEnd"))) {
            url = String.valueOf(PATH) + "/CLIHandler?action=createCEP&index=0&frame=&column=&row=&action=1" + "&LL=" + this.params.get("logicalLibrary") + "&mediaType=" + UtilCLI.getMediaTypeInt(this.params.get("mediaType")) + "&bep=1&volserStart=" + this.params.get("volserStart") + "&volserEnd=" + this.params.get("volserEnd") + "&klm1=" + this.params.get("klm1") + "&klm2=" + klm2;
            if (this.getResponseBody(url, "", false)) {
                this.printResultMessage("The cartridge encryption policy was created sucessfully");
            }
        } else {
            System.out.println("****ERROR: The VOLSER ranges are invalid");
            System.exit(-1);
        }
    }

    private boolean validateVolserRange(String start, String end) {
        boolean result;
        block3: {
            result = true;
            try {
                String URL2 = "/CLIHandler?action=viewCEP";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray CEPArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object cep : CEPArray) {
                    JSONObject object = (JSONObject)cep;
                    if (start.compareTo((String)object.get((Object)"volserstart")) != 0 && (start.compareTo((String)object.get((Object)"volserstart")) <= 0 || start.compareTo((String)object.get((Object)"volserend")) > 0) && start.compareTo((String)object.get((Object)"volserend")) != 0 && end.compareTo((String)object.get((Object)"volserstart")) != 0) continue;
                    result = false;
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public void viewCEPTask() {
        block4: {
            try {
                String URL2 = "/CLIHandler?action=viewCEP";
                String strFormat = String.format("%8s,%12s,%12s,%18s,%12s,%8s,%8s,%5s", "Index", "Volser Start", "Volser End", "Logical Library", "Media Type", "KLM1", "KLM2", "BEP");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray CEPArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object cep : CEPArray) {
                        JSONObject object = (JSONObject)cep;
                        System.out.println(String.format("%8s,%12s,%12s,%18s,%12s,%8s,%8s,%5s", (String)object.get((Object)"volserrangeidx"), (String)object.get((Object)"volserstart"), (String)object.get((Object)"volserend"), (String)object.get((Object)"name"), UtilCLI.getMediaType((String)object.get((Object)"mediatype")), (String)object.get((Object)"klm_1"), (String)object.get((Object)"klm_2"), (String)object.get((Object)"bep_enabled")));
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public boolean validateIndexCEP(String index) {
        boolean result;
        block3: {
            result = false;
            try {
                String URL2 = "/CLIHandler?action=viewCEP";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray CEPArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object cep : CEPArray) {
                    JSONObject object = (JSONObject)cep;
                    String indexTable = object.get((Object)"volserrangeidx").toString();
                    if (indexTable.compareTo(index) != 0) continue;
                    result = true;
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public void editCEPTask() {
        boolean rc = false;
        String url = "";
        String bep = "";
        VolserRange vr = null;
        if (this.validateIndexCEP(this.params.get("index"))) {
            vr = this.getVRByIndex(this.params.get("index").toString());
            if (vr != null) {
                rc = true;
            }
            if (this.params.containsKey("KLM1")) {
                if (this.validateIndexKLM(this.params.get("KLM1"))) {
                    rc = true;
                    vr.setKLM1(this.params.get("KLM1"));
                } else {
                    rc = false;
                }
            }
            if (rc) {
                if (this.params.containsKey("KLM2")) {
                    if (this.validateIndexKLM(this.params.get("KLM2")) || this.params.get("KLM2").toString().compareTo("0") == 0) {
                        rc = true;
                        vr.setKLM2(this.params.get("KLM2"));
                    } else {
                        rc = false;
                    }
                }
                if (this.params.containsKey("BEP")) {
                    bep = this.params.get("BEP").toString().compareTo("TRUE") == 0 ? "1" : "0";
                    vr.setBEP(bep);
                }
            }
        }
        if (rc) {
            url = String.valueOf(PATH) + "/CLIHandler?action=editCEP&index=" + this.params.get("index") + "&frame=&column=&row=&action=2" + "&LL=" + vr.getNameLL() + "&mediaType=" + vr.getMediaType() + "&bep=" + vr.getBEP() + "&volserStart=" + vr.getStart() + "&volserEnd=" + vr.getEnd() + "&klm1=" + vr.getKLM1() + "&klm2=" + vr.getKLM2();
            if (this.getResponseBody(url, "", false)) {
                this.printResultMessage("The cartridge encryption policy was updated successfully");
            }
        } else {
            System.out.println("****ERROR: Wrong parameters. One or more indexes were not found.");
            System.exit(-1);
        }
    }

    public void deleteCEPTask() {
        String url = "";
        if (this.validateIndexCEP(this.params.get("index"))) {
            VolserRange vr = this.getVRByIndex(this.params.get("index").toString());
            if (vr != null) {
                url = String.valueOf(PATH) + "/CLIHandler?action=deleteVolserRanges&index=" + this.params.get("index") + "&LL=" + vr.getIdxLL() + "&volserStart=" + vr.getStart() + "&volserEnd=" + vr.getEnd() + "&mediaType=" + vr.getMediaType() + "&p1=&p2=&p3=";
                if (this.getResponseBody(url, "", false)) {
                    this.printResultMessage("The cartridge encryption policy was deleted sucessfully");
                }
            } else {
                System.out.println("****ERROR: The index was not found.");
            }
        } else {
            System.out.println("****ERROR: The index was not found.");
            System.exit(-1);
        }
    }

    private VolserRange getVRByIndex(String index) {
        VolserRange vr;
        block3: {
            vr = null;
            try {
                String URL2 = "/CLIHandler?action=viewCEP";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray CEPArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object cep : CEPArray) {
                    JSONObject object = (JSONObject)cep;
                    if (index.compareTo((String)object.get((Object)"volserrangeidx")) != 0) continue;
                    vr = new VolserRange(Integer.parseInt((String)object.get((Object)"loglib")), (String)object.get((Object)"volserstart"), (String)object.get((Object)"volserend"), (String)object.get((Object)"mediatype"));
                    vr.setNameLL((String)object.get((Object)"name"));
                    vr.setBEP((String)object.get((Object)"bep_enabled"));
                    vr.setKLM1((String)object.get((Object)"klm_1"));
                    vr.setKLM2((String)object.get((Object)"klm_2"));
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return vr;
    }

    public void saveConfigurationTask() throws ClientProtocolException, IOException {
        if (!this.connection.doDownload("/DownloadServlet?type=Configuration", "configuration")) {
            System.out.println("\nThere was a problem dowloading the configuration file. Try again");
        }
    }

    public void restoreConfigurationTask() {
        block5: {
            System.out.println("Name: " + this.params.get("filename"));
            File f = new File(this.params.get("filename"));
            if (f.exists()) {
                String name = f.getName();
                try {
                    System.out.println(">>>Uploading file..");
                    this.responseBody = this.connection.doUpload("/FileUploadServlet", f);
                    String URL2 = "/CLIHandler?action=restoreConfiguration&file=/mnt/scratch/" + name;
                    if (!this.getResponseBody(URL2, "", true)) break block5;
                    JSONObject result = JSONObject.parse((String)this.responseBody);
                    Integer senseKey = Integer.parseInt(result.get((Object)"senseKey").toString());
                    if (senseKey > 1) {
                        System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 *****");
                        System.out.println("***** Download logs for more information.");
                        System.exit(-1);
                        break block5;
                    }
                    System.out.println("The Configuration DB was restored successfully");
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    break block5;
                }
            }
            System.out.println("The file cannot be found. The command was cancelled.");
        }
    }

    public void setAutoEjectCleaningCartsTask() {
        String value = "";
        if (this.params.get("flag").toUpperCase().compareTo("ENABLED") == 0) {
            value = "1";
        } else if (this.params.get("flag").toUpperCase().compareTo("DISABLED") == 0) {
            value = "0";
        } else {
            System.out.println("*** ERROR: Parameter not valid. Value should be \"Enabled\" or \"Disabled\"");
            System.out.println("***************************************");
            System.exit(-1);
        }
        String url = String.valueOf(PATH) + "/CLIHandler?action=setAutoEjectClean&status=" + value;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The auto eject cleaning cartridges flag was set successfully");
        }
    }

    public void viewAccessorTask() {
        block5: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewAccessor&what=gripper1status&where=";
                String strFormat = String.format("%20s%15s", "                 ,", "Accessor A");
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray list = JSONArray.parse((String)this.responseBody.toString());
                    JSONObject accA = (JSONObject)list.get(0);
                    int gripper1 = Integer.parseInt(accA.get((Object)"gripper1status").toString());
                    URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewAccessor&what=gripper2status&where=";
                    if (this.getResponseBody(URL2, strFormat, false)) {
                        list = JSONArray.parse((String)this.responseBody.toString());
                        accA = (JSONObject)list.get(0);
                        int gripper2 = Integer.parseInt(accA.get((Object)"gripper2status").toString());
                        System.out.println("Availability");
                        System.out.println(strFormat);
                        int accStatus = gripper1 + gripper2;
                        System.out.println(String.format("%20s%15s", "Accessor,", this.getAccessorStatus(accStatus)));
                        System.out.println(String.format("%20s%15s", "Gripper 1,", this.getAccessorStatus(gripper1)));
                        System.out.println(String.format("%20s%15s", "Gripper 2,", this.getAccessorStatus(gripper2)));
                        URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewAccessorStats";
                        if (this.getResponseBody(URL2, strFormat, false)) {
                            list = JSONArray.parse((String)this.responseBody.toString());
                            accA = (JSONObject)list.get(0);
                            System.out.println("\nUsage Statistics");
                            System.out.println(String.format("%25s%25s", "                 ,", "Accessor A Component"));
                            System.out.println(String.format("%25s%25s", "Pivots,", accA.get((Object)"totalnumberofgoodpivots").toString()));
                            System.out.println(String.format("%25s%25s", "Gripper 1 gets,", accA.get((Object)"totalnumberofgoodpicks_1").toString()));
                            System.out.println(String.format("%25s%25s", "Gripper 1 puts,", accA.get((Object)"totalnumberofgoodplaces_1").toString()));
                            System.out.println(String.format("%25s%25s", "Gripper 2 gets,", accA.get((Object)"totalnumberofgoodpicks_2").toString()));
                            System.out.println(String.format("%25s%25s", "Gripper 2 puts,", accA.get((Object)"totalnumberofgoodplaces_2").toString()));
                            System.out.println(String.format("%25s%25s", "Bar code scans,", accA.get((Object)"numberofgoodscans").toString()));
                            System.out.println(String.format("%25s%25s", "X travel (meters),", accA.get((Object)"xdistancetraveledmeters").toString()));
                            System.out.println(String.format("%25s%25s", "Y travel (meters),", accA.get((Object)"ydistancetraveledmeters").toString()));
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block5;
                e.printStackTrace();
            }
        }
    }

    public void setScannerSpeedTask() {
        String speed = this.params.get("speed");
        String url = String.valueOf(PATH) + "/CLIHandler?action=setScannerSpeed&speed=" + speed;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The Scanner Speed was updated successfully");
        }
    }

    public void setSSLTask() {
        String url;
        String value = this.params.get("flag");
        String flag = "0";
        if (value.compareTo("ENABLED") == 0) {
            flag = "1";
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=setSSL&flag=" + flag, "", false)) {
            this.printResultMessage("The SSL flag was updated successfully");
            System.exit(0);
        }
    }

    public void viewStorageCapacityTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=viewStorageCapacity&param=" + "GET_STORAGE_CAPACITY";
        if (this.getResponseBody(url, "", false)) {
            System.out.println(this.responseBody);
        }
    }

    public void viewDrivePodTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=viewDrivesUtilization";
        if (this.getResponseBody(url, "", false)) {
            System.out.println(this.responseBody);
        }
    }

    public void viewEventTableTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=viewEventTable";
        if (this.getResponseBody(url, "", false)) {
            try {
                JSONArray driveArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object drive : driveArray) {
                    JSONObject object = (JSONObject)drive;
                    System.out.println(object);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void installLicensedFunctionTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=installLicensedFunction&flag=" + this.params.get("flag") + "&key=" + this.params.get("key");
        if (this.getResponseBody(url, "", false)) {
            String msg = this.params.get("flag").compareTo("1") == 0 ? "installed" : "uninstalled";
            this.printResultMessage("The licensed feature was " + msg + " successfully");
        }
    }

    public void sendMessageTask() {
        String url;
        String targetNode = "0";
        String targetTask = "0";
        String sourceNode = "0";
        String sourceTask = "0";
        String msgType = "0";
        String control = "0";
        String msgkey = "0";
        String index = "0";
        String flowControl = "0";
        String dataSize = "0";
        String data = "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00";
        int size = 0;
        UtilCLI.updateMaps();
        if (this.params.containsKey("targetNode")) {
            if (UtilCLI.NODE_TYPES.containsKey(this.params.get("targetNode"))) {
                targetNode = "" + UtilCLI.NODE_TYPES.get(this.params.get("targetNode"));
            } else {
                try {
                    Integer.parseInt(this.params.get("targetNode"), 16);
                    targetNode = UtilCLI.hexStringToDecString(this.params.get("targetNode"));
                }
                catch (Exception e) {
                    System.out.println("***** ERROR: TargetNode value has no valid format. Valid format are Strings in node_id.h or a hex value like this: 47");
                    System.exit(-1);
                }
            }
        }
        if (this.params.containsKey("targetTask")) {
            if (UtilCLI.TASK_TYPES.containsKey(this.params.get("targetTask"))) {
                targetTask = "" + UtilCLI.TASK_TYPES.get(this.params.get("targetTask"));
            } else {
                try {
                    Integer.parseInt(this.params.get("targetTask"), 16);
                    targetTask = UtilCLI.hexStringToDecString(this.params.get("targetTask"));
                }
                catch (Exception e) {
                    System.out.println("***** ERROR: targetTask value has no valid format. Valid format are Strings in task_id.h or a hex value like this: 47");
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        }
        if (this.params.containsKey("sourceNode")) {
            if (UtilCLI.NODE_TYPES.containsKey(this.params.get("sourceNode"))) {
                sourceNode = "" + UtilCLI.NODE_TYPES.get(this.params.get("sourceNode"));
            } else {
                try {
                    Integer.parseInt(this.params.get("sourceNode"), 16);
                    sourceNode = UtilCLI.hexStringToDecString(this.params.get("sourceNode"));
                }
                catch (Exception e) {
                    System.out.println("***** ERROR: sourceNode value has no valid format. Valid format are Strings in node_id.h or a hex value like this: 47");
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        }
        if (this.params.containsKey("sourceTask")) {
            if (UtilCLI.TASK_TYPES.containsKey(this.params.get("sourceTask"))) {
                sourceTask = "" + UtilCLI.TASK_TYPES.get(this.params.get("sourceTask"));
            } else {
                try {
                    Integer.parseInt(this.params.get("sourceTask"), 16);
                    sourceTask = UtilCLI.hexStringToDecString(this.params.get("sourceTask"));
                }
                catch (Exception e) {
                    System.out.println("***** ERROR: sourceTask value has no valid format. Valid format are Strings in task_id.h or a hex value like this: 47");
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        }
        if (this.params.containsKey("msgType")) {
            if (UtilCLI.MESSAGES_TYPES.containsKey(this.params.get("msgType"))) {
                msgType = "" + UtilCLI.MESSAGES_TYPES.get(this.params.get("msgType"));
            } else {
                try {
                    Integer.parseInt(this.params.get("msgType"), 16);
                    msgType = UtilCLI.hexStringToDecString(this.params.get("msgType"));
                }
                catch (Exception e) {
                    System.out.println("***** ERROR: msgType value has no valid format. Valid format are Strings in task_id.h or a hex value like this: 47");
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        }
        if (this.params.containsKey("control")) {
            control = UtilCLI.hexStringToDecString(this.params.get("control"));
        }
        if (this.params.containsKey("msgkey")) {
            msgkey = UtilCLI.hexStringToDecString(this.params.get("msgkey"));
        }
        if (this.params.containsKey("flowControl")) {
            flowControl = UtilCLI.hexStringToDecString(this.params.get("flowControl"));
        }
        if (this.params.containsKey("dataSize")) {
            dataSize = this.params.get("dataSize");
            size = Integer.parseInt(dataSize);
        }
        if (this.params.containsKey("data")) {
            data = this.params.get("data");
        }
        String[] messageBody = data.split(" ");
        StringBuilder encodedMsg = new StringBuilder(size * 2);
        int i = 0;
        while (i < size) {
            encodedMsg.append(UtilCLI.hexStringToDecString(messageBody[i]));
            encodedMsg.append(",");
            ++i;
        }
        if (encodedMsg.length() > 0) {
            encodedMsg.setLength(encodedMsg.length() - 1);
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=sendMessage&targetNode=" + targetNode + "&targetTask=" + targetTask + "&sourceNode=" + sourceNode + "&sourceTask=" + sourceTask + "&msgType=" + msgType + "&control=" + control + "&msgKey=" + msgkey + "&index=" + index + "&flowControl=" + flowControl + "&dataSize=" + dataSize + "&data=" + encodedMsg.toString(), "", false)) {
            this.printResultMessage("The message was send correctly");
        }
    }

    public void setBaseWWNNTask() {
        String wwnn = this.params.get("wwnn");
        String url = String.valueOf(PATH) + "/CLIHandler?action=setBaseWWNN&wwnn=" + wwnn;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The Base WWNN was set successfully");
        }
    }

    public void sendEnableSSHTask(boolean flag, boolean maincommand) {
        String control = "0";
        String msgkey = "0";
        String index = "0";
        String flowControl = "0";
        String dataSize = "0";
        String data = "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00";
        int size = 0;
        String[] messageBody = data.split(" ");
        StringBuilder encodedMsg = new StringBuilder(size * 2);
        int i = 0;
        while (i < size) {
            encodedMsg.append(UtilCLI.hexStringToDecString(messageBody[i]));
            encodedMsg.append(",");
            ++i;
        }
        if (encodedMsg.length() > 0) {
            encodedMsg.setLength(encodedMsg.length() - 1);
        }
        String url = String.valueOf(PATH) + "/CLIHandler?action=sendMessage&targetNode=" + UtilCLI.NODE_TYPES.get("NODE_LCA_PLUS") + "&targetTask=" + UtilCLI.TASK_TYPES.get("TID_NWM") + "&sourceNode=" + UtilCLI.hexStringToDecString("41") + "&sourceTask=" + UtilCLI.hexStringToDecString("47");
        url = flag ? String.valueOf(url) + "&msgType=" + UtilCLI.MESSAGES_TYPES.get("MT_NWM_ENABLE_SSH") : String.valueOf(url) + "&msgType=" + UtilCLI.MESSAGES_TYPES.get("MT_NWM_DISABLE_SSH");
        if (this.getResponseBody(url = String.valueOf(url) + "&control=" + control + "&msgKey=" + msgkey + "&index=" + index + "&flowControl=" + flowControl + "&dataSize=" + dataSize + "&data=" + encodedMsg.toString(), "", false) && maincommand) {
            this.printResultMessage("The message was send correctly");
        }
    }

    public void downloadDrivesLogTask() throws ClientProtocolException, IOException {
        String list = this.params.get("list");
        String url = String.valueOf(PATH) + "/CLIHandler?action=downloadDrivesLog";
        if (this.getResponseBody(url, "", false)) {
            if (list.compareTo("ALL") == 0) {
                list = "";
                HashMap<String, String> mapDrives = this.getDrivesTypes(true);
                for (String l : mapDrives.keySet()) {
                    list = String.valueOf(list) + l + ",";
                }
                list = list.substring(0, list.length() - 1);
            }
            list = list.replace(",", "|");
            list = list.replace("F", "");
            list = list.replace("C", ",");
            if (!this.connection.doDownload("/DownloadServlet?type=LogDrives&params={\"drivesId\":\"" + (list = list.replace("R", ",")) + "\"}", "drivelog")) {
                System.out.println("\nThere was a problem dowloading logs. Try again");
            }
        }
    }

    public void startCalibrationTask() {
        String url;
        String library = "";
        String frame = "";
        String column = "";
        String row = "";
        String io = "";
        String accessor = "";
        if (this.params.containsKey("LIBRARY")) {
            library = "1";
        }
        if (this.params.containsKey("FRAME")) {
            frame = this.params.get("FRAME");
        }
        if (this.params.containsKey("COLUMN")) {
            column = this.params.get("COLUMN");
        }
        if (this.params.containsKey("ROW")) {
            row = this.params.get("ROW");
        }
        if (this.params.containsKey("IO")) {
            io = this.params.get("IO");
        }
        if (this.params.containsKey("ACCESSOR")) {
            accessor = this.params.get("ACCESSOR");
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=startCalibration&library=" + library + "&frame=" + frame + "&column=" + column + "&row=" + row + "&io=" + io + "&accessor=" + accessor + "&shuttle=", "", false)) {
            this.printResultMessage("Calibration has started");
        }
    }

    public void startDiscoverHWTask() {
        String url;
        String overwrite = "0";
        HashMap<String, String> mapFrames = new HashMap<String, String>();
        if (this.params.containsKey("OVERWRITE")) {
            overwrite = "255";
        }
        String[] list = this.params.get("list").split(",");
        int i = 1;
        while (i <= 18) {
            mapFrames.put("" + i, "0");
            ++i;
        }
        i = 0;
        while (i < list.length) {
            if (list[i].compareToIgnoreCase("OVERWRITE") != 0) {
                mapFrames.put(list[i], "1");
            }
            ++i;
        }
        if (list.length <= 1) {
            System.out.println("***** ERROR: There are parameters missing. *****");
            System.exit(-1);
        }
        if (this.getResponseBody(url = String.valueOf(PATH) + "/CLIHandler?action=startDiscoverHW&overwrite=" + overwrite + "&f1=" + (String)mapFrames.get("1") + "&f2=" + (String)mapFrames.get("2") + "&f3=" + (String)mapFrames.get("3") + "&f4=" + (String)mapFrames.get("4") + "&f5=" + (String)mapFrames.get("5") + "&f6=" + (String)mapFrames.get("6") + "&f7=" + (String)mapFrames.get("7") + "&f8=" + (String)mapFrames.get("8") + "&f9=" + (String)mapFrames.get("9") + "&f10=" + (String)mapFrames.get("10") + "&f11=" + (String)mapFrames.get("11") + "&f12=" + (String)mapFrames.get("12") + "&f13=" + (String)mapFrames.get("13") + "&f14=" + (String)mapFrames.get("14") + "&f15=" + (String)mapFrames.get("15") + "&f16=" + (String)mapFrames.get("16") + "&f17=" + (String)mapFrames.get("17") + "&f18=" + (String)mapFrames.get("18"), "", false)) {
            this.printResultMessage("Discover HW has started");
        }
    }

    public void startInventoryTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=startInventory&library=" + this.params.get("library") + "&audit=" + this.params.get("audit") + "&frame=" + this.params.get("frame");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("Inventory has started");
        }
    }

    public void testMoveSlotTask() {
        Integer retries = Integer.parseInt(this.params.get("retry"));
        String url = String.valueOf(PATH) + "/CLIHandler?action=slotMove&command=" + this.params.get("command") + "&frameidx=" + this.params.get("frameIdx") + "&column=" + this.params.get("columnIdx") + "&rowidx=" + this.params.get("rowIdx") + "&tier=" + this.params.get("tier") + "&type=" + this.params.get("type") + "&gripper=" + this.params.get("gripper");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The test was successful");
        }
        while (Gen4cli.returnStatus == 1 && retries > 0) {
            retries = retries - 1;
            System.out.println("Retrying...");
            if (!this.getResponseBody(url, "", false)) continue;
            this.printResultMessage("The test was successful");
        }
    }

    public void createLLTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=createLL&index=0" + "&mediaType=" + this.params.get("mediaType") + "&name=" + this.params.get("name") + "&null=";
        String name = this.params.get("name");
        String max = this.getMaxCarts();
        if (Integer.parseInt(max) > 0) {
            if (this.getResponseBody(url, "", false)) {
                url = String.valueOf(PATH) + "/CLIHandler?action=viewLogicalLibraryDetails&LogLibIdx='" + this.params.get("name") + "'";
                if (this.getResponseBody(url, "", false)) {
                    JSONObject object = this.getJSONObject(this.responseBody);
                    if (Gen4cli.returnStatus == 0) {
                        String index;
                        String string = index = ((String)object.get((Object)"loglibidx")).isEmpty() ? "0" : (String)object.get((Object)"loglibidx");
                        if (index.compareTo("0") != 0) {
                            url = String.valueOf(PATH) + "/CLIHandler?action=setMaxCarts&LogLibIdx=" + index + "&max=" + max;
                            if (this.getResponseBody(url, "", false)) {
                                url = String.valueOf(PATH) + "/CLIHandler?action=setOnlyEncryptionMethod&llName=" + this.params.get("name") + "&method=1";
                                if (this.getResponseBody(url, "", false)) {
                                    this.printResultMessage("The logical library was created successfully");
                                } else {
                                    Gen4cli.returnStatus = 1;
                                    System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
                                }
                            }
                        } else {
                            Gen4cli.returnStatus = 1;
                            System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
                        }
                    } else {
                        Gen4cli.returnStatus = 1;
                        System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
                    }
                }
            } else {
                Gen4cli.returnStatus = 1;
                System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
            }
        } else {
            Gen4cli.returnStatus = 1;
            System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
        }
    }

    public void assignDriveToLLTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=viewLogicalLibraryDetails&LogLibIdx='" + this.params.get("name") + "'";
        if (this.getResponseBody(url, "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            if (Gen4cli.returnStatus == 0) {
                String index;
                String string = index = ((String)object.get((Object)"loglibidx")).isEmpty() ? "0" : (String)object.get((Object)"loglibidx");
                if (index.compareTo("0") != 0) {
                    String location = String.format("%02d%02d%02d", Integer.parseInt(this.params.get("frame")), Integer.parseInt(this.params.get("column")), Integer.parseInt(this.params.get("row")));
                    url = String.valueOf(PATH) + "/CLIHandler?action=assignDriveToLL&ll=" + index + "&controlPath=1&location=" + location;
                    if (this.getResponseBody(url, "", false)) {
                        this.printResultMessage("The drive was assigned successfully");
                    }
                }
            }
        } else {
            Gen4cli.returnStatus = 1;
            System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
        }
    }

    public void unassignDriveTask() {
        String location = String.format("%02d%02d%02d", Integer.parseInt(this.params.get("frame")), Integer.parseInt(this.params.get("column")), Integer.parseInt(this.params.get("row")));
        String url = String.valueOf(PATH) + "/CLIHandler?action=assignDriveToLL&ll=255" + "&controlPath=255&location=" + location;
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The drive was unassigned successfully");
        }
    }

    public void startLibraryVerifyTask() {
        block8: {
            String url = String.valueOf(PATH) + "/CLIHandler?action=startLibraryVerify&io=1&dt=0&do=0&sf=0&sc=0&sr=0&ef=0&ec=0&er=0&a=0";
            try {
                if (!this.getResponseBody(url, "", false)) break block8;
                String status = "0";
                url = String.valueOf(PATH) + "/CLIHandler?action=statusLibraryVerify";
                JSONArray statusArray = null;
                JSONObject object = null;
                Thread.sleep(3000L);
                while (Integer.parseInt(status) == 0) {
                    if (!this.getResponseBody(url, "", false)) continue;
                    try {
                        statusArray = JSONArray.parse((String)this.responseBody.toString());
                    }
                    catch (IOException e) {
                        System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    }
                    object = (JSONObject)statusArray.get(0);
                    status = (String)object.get((Object)"status");
                    System.out.print("..");
                    Thread.sleep(3000L);
                }
                System.out.println("Library verify - IO stations -  has started...");
                System.out.print("Library verify in progress ...");
                while (Integer.parseInt(status) != 4) {
                    if (!this.getResponseBody(url, "", false)) continue;
                    try {
                        statusArray = JSONArray.parse((String)this.responseBody.toString());
                    }
                    catch (IOException e) {
                        System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    }
                    object = (JSONObject)statusArray.get(0);
                    status = (String)object.get((Object)"status");
                    System.out.print("..");
                    Thread.sleep(3000L);
                }
                System.out.print("..Done!");
                System.out.println("\nNext step:  OPEN all IO doors , and then use \"continueLibraryVerify\" command to continue the test.");
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void statusLibraryVerifyTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=statusLibraryVerify";
        this.getResponseBody(url, "", false);
    }

    public void continueLibraryVerifyTask() {
        String status = "1";
        String url = String.valueOf(PATH) + "/CLIHandler?action=continueLibraryVerify";
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("IO doors opened. Library verify continues now...");
        }
        url = String.valueOf(PATH) + "/CLIHandler?action=statusLibraryVerify";
        JSONArray statusArray = null;
        JSONObject object = null;
        try {
            Thread.sleep(3000L);
            while (Integer.parseInt(status) == 1 || Integer.parseInt(status) == 4) {
                if (!this.getResponseBody(url, "", false)) continue;
                try {
                    statusArray = JSONArray.parse((String)this.responseBody.toString());
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                }
                object = (JSONObject)statusArray.get(0);
                status = (String)object.get((Object)"status");
                System.out.print("..");
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.print("..Done!");
        if (Integer.parseInt(status) == 5) {
            System.out.println("\nNext step: CLOSE all IO doors, and then use \"continueCloseLibraryVerify\" command to continue the test.");
        } else if (Integer.parseInt(status) == 3) {
            System.out.println("****ERROR: The test has FAILED. Please, restart the test using \"startLibraryVerify\" command.");
        } else if (Integer.parseInt(status) == 7) {
            System.out.println("****ERROR: There are doors detected as closed when should be opened. Doors are: ");
            JSONArray errorArray = null;
            try {
                errorArray = JSONArray.parse((String)this.responseBody.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int i = 0;
            for (Object error : errorArray) {
                JSONObject obj = (JSONObject)error;
                String io1 = (String)obj.get((Object)"ioDoor1");
                String io2 = (String)obj.get((Object)"ioDoor2");
                if (io1.compareTo("1") == 0 || io2.compareTo("1") == 0) {
                    String msg = "Frame: " + (i + 1) + " Upper IO station: ";
                    msg = String.valueOf(msg) + (Integer.parseInt(io1) == 1 ? "closed" : "opened");
                    msg = String.valueOf(msg) + " Lower IO station: " + (Integer.parseInt(io2) == 1 ? "closed" : "opened");
                    System.out.println(msg);
                }
                ++i;
            }
        } else {
            System.out.println("****ERROR: The test has FAILED. The error code is: " + Integer.parseInt(status) + ".Please, restart the test using \"startLibraryVerify\" command.");
        }
    }

    public void continueCloseLibraryVerifyTask() {
        String status = "1";
        String url = String.valueOf(PATH) + "/CLIHandler?action=continueLibraryVerify";
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("IO doors closed. Library verify continues now...");
        }
        url = String.valueOf(PATH) + "/CLIHandler?action=statusLibraryVerify";
        JSONArray statusArray = null;
        JSONObject object = null;
        try {
            Thread.sleep(3000L);
            while (Integer.parseInt(status) == 1 || Integer.parseInt(status) == 5) {
                if (this.getResponseBody(url, "", false)) {
                    block27: {
                        try {
                            statusArray = JSONArray.parse((String)this.responseBody.toString());
                        }
                        catch (IOException e) {
                            System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                            if (!this.verbose) break block27;
                            e.printStackTrace();
                        }
                    }
                    object = (JSONObject)statusArray.get(0);
                    status = (String)object.get((Object)"status");
                    System.out.println("RB polling status = " + status);
                }
                System.out.print("..");
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (Integer.parseInt(status) == 2 || Integer.parseInt(status) == 0) {
            System.out.println("The test has been completed successfully.");
        } else if (Integer.parseInt(status) == 3) {
            System.out.println("****ERROR: The test has FAILED. Please, restart the test using \"startLibraryVerify\" command.");
        } else if (Integer.parseInt(status) == 6) {
            System.out.println("****ERROR: There are doors detected as opened when should be closed. Doors are: ");
            JSONArray errorArray = null;
            try {
                errorArray = JSONArray.parse((String)this.responseBody.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int i = 0;
            for (Object error : errorArray) {
                JSONObject obj = (JSONObject)error;
                String io1 = (String)obj.get((Object)"ioDoor1");
                String io2 = (String)obj.get((Object)"ioDoor2");
                if (io1.compareTo("1") == 0 || io2.compareTo("1") == 0) {
                    String msg = "Frame: " + (i + 1) + " Upper IO station: ";
                    msg = String.valueOf(msg) + (Integer.parseInt(io1) == 1 ? "opened" : "closed");
                    msg = String.valueOf(msg) + " Lower IO station: " + (Integer.parseInt(io2) == 1 ? "opened" : "closed");
                    System.out.println(msg);
                }
                ++i;
            }
        } else if (Integer.parseInt(status) == 10) {
            System.out.println("****ERROR: The test has FAILED. There was an error during PUT TO IO test. Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        } else if (Integer.parseInt(status) == 11) {
            System.out.println("****ERROR: The test has FAILED. There was an error during PUT TO STORAGE FROM IO test. Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        } else if (Integer.parseInt(status) == 12) {
            System.out.println("****ERROR: The test has FAILED. There was an error during MOTION test. Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        } else if (Integer.parseInt(status) == 13) {
            System.out.println("****ERROR: The test has FAILED. There was an error during GRIPPER test. Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        } else if (Integer.parseInt(status) == 14) {
            System.out.println("****ERROR: The test has FAILED. There was an error during SCANNER test. Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        } else {
            System.out.println("****ERROR: The test has FAILED. The error code is: " + Integer.parseInt(status) + ". Please, restart the test using \"startLibraryVerify\" command.");
            System.exit(1);
        }
    }

    public void setStorageSlotStatusTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=setStorageSlotStatus&action=" + this.params.get("action") + "&frame=" + this.params.get("frame") + "&col=" + this.params.get("col") + "&row=" + this.params.get("row") + "&value=0";
        if (this.getResponseBody(url, "", false)) {
            String status = "";
            status = this.params.get("action").compareToIgnoreCase("4") == 0 ? "online" : "offline";
            this.printResultMessage("Storage Slot was set " + status);
        }
    }

    public void viewOfflineComponentsTask() {
        block4: {
            try {
                String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewOfflineComponents&param1=3&param2=";
                String strFormat = String.format("%8s,%8s,%8s,%12s", "Frame", "Column", "Row", "Status");
                HashMap<String, String> noRepeated = new HashMap<String, String>();
                if (this.getResponseBody(URL2, strFormat, false)) {
                    JSONArray cartArray = JSONArray.parse((String)this.responseBody.toString());
                    System.out.println(strFormat);
                    for (Object cart : cartArray) {
                        JSONObject object = (JSONObject)cart;
                        if (noRepeated.containsKey("F" + (String)object.get((Object)"frame") + "C" + (String)object.get((Object)"column") + "R" + (String)object.get((Object)"row"))) continue;
                        System.out.println(String.format("%8s,%8s,%8s,%12s", (String)object.get((Object)"frame"), (String)object.get((Object)"column"), (String)object.get((Object)"row"), "Offline"));
                        noRepeated.put("F" + (String)object.get((Object)"frame") + "C" + (String)object.get((Object)"column") + "R" + (String)object.get((Object)"row"), "true");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
    }

    public void getFWVersionTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=getFWVersion";
        if (this.getResponseBody(url, "", false)) {
            JSONArray array;
            block3: {
                array = null;
                try {
                    array = JSONArray.parse((String)this.responseBody.toString());
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    if (!this.verbose) break block3;
                    e.printStackTrace();
                }
            }
            JSONObject object = (JSONObject)array.get(0);
            System.out.println("Firmware Version: " + object.get((Object)"firmwareVersion"));
        }
    }

    public void setSerialNumberTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=setSerialNumber&lframe=" + this.params.get("frameIndex") + "&number=" + this.params.get("numberFrames") + "&serial=" + this.params.get("serial");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("The serial number has been set correctly.");
        }
    }

    public void setSlotOnlineTask() {
        String col = this.params.get("column");
        String row = this.params.get("row");
        String url = String.valueOf(PATH) + "/CLIHandler?action=setStorageSlotStatus&action=4&frame=" + this.params.get("frame") + "&col=" + col + "&row=" + row + "&value=0";
        if (this.getResponseBody(url, "", false)) {
            if (row.compareTo("0") == 0) {
                this.printResultMessage("All rows for column " + col + " were set online");
            } else {
                this.printResultMessage("Storage Slot was set online");
            }
        }
    }

    public void setSlotOfflineTask() {
        String col = this.params.get("column");
        String row = this.params.get("row");
        String url = String.valueOf(PATH) + "/CLIHandler?action=setStorageSlotStatus&action=5&frame=" + this.params.get("frame") + "&col=" + col + "&row=" + row + "&value=0";
        if (this.getResponseBody(url, "", false)) {
            if (row.compareTo("0") == 0) {
                this.printResultMessage("All rows for column " + col + " were set offline");
            } else {
                this.printResultMessage("Storage Slot was set offline");
            }
        }
    }

    private String getLLIndex(String name) {
        String index;
        block4: {
            String URL2 = "/CLIHandler?action=viewLogicalLibraries";
            index = "";
            try {
                if (this.getResponseBody(URL2, "", false)) {
                    JSONArray LLArray = JSONArray.parse((String)this.responseBody.toString());
                    for (Object ll : LLArray) {
                        JSONObject object = (JSONObject)ll;
                        String nameLL = ((String)object.get((Object)"name")).toLowerCase();
                        if (nameLL.compareTo(name.toLowerCase()) != 0) continue;
                        index = (String)object.get((Object)"loglibidx");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block4;
                e.printStackTrace();
            }
        }
        return index;
    }

    public void viewAdvancedEncryptionSettingsTask() {
        String llName = this.params.get("llName");
        String index = this.getLLIndex(llName);
        if (!index.isEmpty()) {
            String URL2 = String.valueOf(PATH) + "/CLIHandler?action=viewAdvancedEncryptionSettings&name=" + llName;
            if (this.getResponseBody(URL2, "", false)) {
                try {
                    JSONArray array = JSONArray.parse((String)this.responseBody.toString());
                    for (Object obj : array) {
                        JSONObject object = (JSONObject)obj;
                        System.out.println(String.format("%25s%35s", "Name:", llName));
                        System.out.println(String.format("%25s%35s", "Advanced Method:", ((String)object.get((Object)"advancedmethod")).compareTo("0") == 0 ? "No advanced setting" : "Custom method"));
                        System.out.println(String.format("%25s%35s", "Advanced Policy:", UtilCLI.getAdvancedSetting((String)object.get((Object)"advancedpolicy"))));
                        System.out.println(String.format("%25s%35s", "Density Code:", UtilCLI.getDensityCode((String)object.get((Object)"densitycode"))));
                        System.out.println(String.format("%25s%35s", "Key Path:", UtilCLI.getKeyPath((String)object.get((Object)"keypath"))));
                    }
                }
                catch (IOException e) {
                    System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("****ERROR: Logical Library '" + llName + "' cannot be found.");
            System.exit(-1);
        }
    }

    public void logout() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=logout";
        this.getResponseBody(url, "", false);
    }

    public void sendPMRTask() {
        String url = String.valueOf(PATH) + "/CLIHandler?action=sendPMR&id=" + this.params.get("id") + "&pmr=" + this.params.get("pmr");
        if (this.getResponseBody(url, "", false)) {
            this.printResultMessage("PMR sent successfully");
        }
    }

    public void setSleep() {
        Integer miliseconds = Integer.parseInt(this.params.get("seconds")) * 1000;
        System.out.println("Sleeping..");
        try {
            Thread.sleep(miliseconds.intValue());
            Gen4cli.returnStatus = 0;
            System.out.println("Running..");
        }
        catch (InterruptedException e) {
            System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
            if (this.verbose) {
                e.printStackTrace();
            }
            Gen4cli.returnStatus = 1;
        }
    }

    public void unpackFile(String fileName) {
        InputStream inputResource = this.getClass().getResourceAsStream(fileName);
        String[] listTemp = fileName.split("/");
        File fileScript = new File(listTemp[listTemp.length - 1]);
        try {
            FileOutputStream outFile = new FileOutputStream(fileScript);
            while (inputResource.available() > 0) {
                outFile.write(inputResource.read());
            }
            outFile.close();
            inputResource.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("****ERROR: File could not be found");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("****ERROR: IO exception");
            e.printStackTrace();
        }
    }

    public void libraryBackupTask() {
        System.out.print("Starting DB backup process...");
        String[] temp = BACKUP_SCRIPT.split("/");
        String fileNameLocal = temp[temp.length - 1];
        String fileNameRemote = "/fw/tools/library_backup.sh";
        this.unpackFile(BACKUP_SCRIPT);
        System.out.print("...");
        File f = new File(fileNameLocal);
        if (!f.exists()) {
            System.out.println("****ERROR:  File could not be found");
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SSHCommands sshCmd = new SSHCommands(this.params.get("ip"));
        sshCmd.setSession();
        sshCmd.scpToExecute(fileNameLocal, fileNameRemote);
        System.out.print("...");
        sshCmd.closeChannel();
        boolean success = new File(fileNameLocal).delete();
        if (success) {
            System.out.print("...");
        }
        sshCmd.runExecute("chmod 755 " + fileNameRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        sshCmd.runExecute("dos2unix " + fileNameRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        sshCmd.runExecute(fileNameRemote);
        sshCmd.closeChannel();
        System.out.print("Done...");
        sshCmd.scpFromExecute("/mnt/scratch/*.dbz");
        sshCmd.closeChannel();
        sshCmd.closeSession();
        System.out.println("...");
        System.out.println("The library DB backup process has finished successfully.");
    }

    public void libraryRestoreTask() {
        System.out.print("Starting DB restore process...");
        String[] temp = RESTORE_SCRIPT.split("/");
        String restoreLocal = temp[temp.length - 1];
        String restoreRemote = "/fw/tools/library_restore.sh";
        temp = MIGRATION_SCRIPT.split("/");
        String migrationLocal = temp[temp.length - 1];
        String migrationRemote = "/fw/db/db_migration.sh";
        int result = 0;
        this.unpackFile(RESTORE_SCRIPT);
        System.out.print("...");
        this.unpackFile(MIGRATION_SCRIPT);
        System.out.print("...");
        File f = new File(restoreLocal);
        if (!f.exists()) {
            System.out.println("****ERROR:  File could not be found: " + restoreLocal);
            return;
        }
        f = new File(migrationLocal);
        if (!f.exists()) {
            System.out.println("****ERROR:  File could not be found: " + migrationLocal);
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SSHCommands sshCmd = new SSHCommands(this.params.get("ip"));
        sshCmd.setSession();
        sshCmd.scpToExecute(restoreLocal, restoreRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        boolean success = new File(restoreLocal).delete();
        if (success) {
            System.out.print("...");
        } else {
            System.out.println("****ERROR: File " + restoreLocal + " could not be deleted. Need to be removed manually.");
        }
        sshCmd.runExecute("chmod 755 " + restoreRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        sshCmd.runExecute("dos2unix " + restoreRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        sshCmd.scpToExecute(migrationLocal, migrationRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        success = new File(migrationLocal).delete();
        if (success) {
            System.out.print("...");
        } else {
            System.out.println("****ERROR: File " + restoreLocal + " could not be deleted. Need to be removed manually.");
        }
        sshCmd.runExecute("chmod 755 " + migrationRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        sshCmd.runExecute("dos2unix " + migrationRemote);
        sshCmd.closeChannel();
        System.out.print("...");
        File fileDB = new File(this.params.get("filename"));
        if (fileDB.exists()) {
            sshCmd.scpToExecute(this.params.get("filename"), "/mnt/scratch/" + fileDB.getName());
            sshCmd.closeChannel();
            System.out.print("...");
            result = sshCmd.runExecute(String.valueOf(restoreRemote) + " -p " + "/mnt/scratch/" + fileDB.getName());
            sshCmd.closeChannel();
            if (result == 0) {
                System.out.println("...");
                System.out.println("The library DB restore process has finished successfully.");
                System.exit(0);
            } else {
                Gen4cli.returnStatus = 1;
                System.out.println("****ERROR: Restore process has failed. Check logs for more information.");
            }
        } else {
            System.out.println("****ERROR: File: " + this.params.get("filename") + " could not be found.");
            Gen4cli.returnStatus = 1;
        }
        sshCmd.closeSession();
    }

    public boolean validateEKM(String ip) {
        boolean result;
        block3: {
            result = false;
            try {
                String URL2 = "/CLIHandler?action=getEKMList";
                if (!this.getResponseBody(URL2, "", false)) break block3;
                JSONArray EKMArray = JSONArray.parse((String)this.responseBody.toString());
                for (Object ekm : EKMArray) {
                    JSONObject object = (JSONObject)ekm;
                    String indexTable = object.get((Object)"ip").toString();
                    if (indexTable.compareTo(ip) != 0) continue;
                    result = true;
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("****ERROR: There was a problem parsing the command response: " + e.getMessage() + " Class: " + e.getClass());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setSSLForEKMTask() {
        String flag = "0";
        String value = this.params.get("flag");
        if (value.compareTo("ENABLED") == 0) {
            flag = "1";
        }
        if (this.validateEKM(this.params.get("ekm"))) {
            String url = String.valueOf(PATH) + "/CLIHandler?action=setSSLForEKM&ip=" + this.params.get("ekm") + "&flag=" + flag;
            if (this.getResponseBody(url, "", false)) {
                this.printResultMessage("The SSL flag was updated successfully ");
            }
        } else {
            System.out.println("****ERROR: The IP is not valid.");
            Gen4cli.returnStatus = 1;
        }
    }

    public void setCreateUserTask() {
        String name = this.params.get("name");
        String email = this.params.get("email");
        String password = this.params.get("password");
        String role = this.params.get("role");
        boolean rc = false;
        String url = "";
    }

    public void deleteLLTask() {
        String name = this.params.get("name");
        String url = String.valueOf(PATH) + "/CLIHandler?action=viewLogicalLibraryDetails&LogLibIdx='" + this.params.get("name") + "'";
        if (this.getResponseBody(url, "", false)) {
            JSONObject object = this.getJSONObject(this.responseBody);
            if (Gen4cli.returnStatus == 0) {
                String index;
                String string = index = ((String)object.get((Object)"loglibidx")).isEmpty() ? "0" : (String)object.get((Object)"loglibidx");
                if (index.compareTo("0") != 0) {
                    String driveAdd2;
                    String driveAdd1 = ((String)object.get((Object)"firstdriveea")).isEmpty() ? "0" : (String)object.get((Object)"firstdriveea");
                    String string2 = driveAdd2 = ((String)object.get((Object)"lastdriveea")).isEmpty() ? "0" : (String)object.get((Object)"lastdriveea");
                    if (driveAdd1.compareTo("0") == 0 && driveAdd2.compareTo("0") == 0) {
                        url = String.valueOf(PATH) + "/CLIHandler?action=deleteLL&index=" + index + "&mediaType=&name=&null=";
                        if (this.getResponseBody(url, "", false)) {
                            this.printResultMessage("The Logical Library was removed successfully ");
                        } else {
                            Gen4cli.returnStatus = 1;
                            System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
                        }
                    } else {
                        Gen4cli.returnStatus = 1;
                        System.out.println("***** ERROR: There are still drives assigned to this logical library. Need to unassign them first. *****");
                    }
                } else {
                    Gen4cli.returnStatus = 1;
                    System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
                }
            } else {
                Gen4cli.returnStatus = 1;
                System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
            }
        } else {
            Gen4cli.returnStatus = 1;
            System.out.println("***** ERROR: There was a problem in the comand execution. Return code = 1 . *****");
        }
    }

    public static enum KeyMode {
        WRAPPED_DEFAULT,
        WRAPPED_CLEAR,
        WRAPPED_HASH,
        DIRECT_DEFAULT_SET,
        DIRECT_SPECIFIC;

    }

    public static enum State {
        CLEANING,
        ONLINE,
        INITIALIZING,
        OFFLINE,
        READING,
        WRITING,
        LOADING,
        REWINDING,
        UNLOADING;

    }

    public static enum VOLSER_ACTION {
        CREATE,
        MODIFY,
        REASSIGN,
        DELETE;

    }

    public static enum accessorStatus {
        OK,
        MINOR_WARNING,
        ERROR;

    }
}

