/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.anaconda.CLI;

import com.ibm.anaconda.CLI.DateUtils;
import com.ibm.anaconda.CLI.FileBodyCustom;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class Connection {
    private UrlEncodedFormEntity entity;
    private HttpClient httpclient;
    private HttpGet httpget;
    private HttpPost httpost;
    private HttpResponse response;
    private static String responseBody;
    private List<NameValuePair> formparams = new ArrayList<NameValuePair>();
    private int statusCode;
    private String ip = "";
    private String name = "";
    private String password = "";
    private String url = "";
    private String PATH = "web";
    private boolean ssl = false;

    public Connection() {
    }

    public Connection(String ip, String name, String password) {
        this.ip = ip;
        this.name = name;
        this.password = password;
    }

    public boolean openHttp() throws ClientProtocolException, IOException {
        boolean result = true;
        this.httpclient = new DefaultHttpClient();
        this.httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"best-match");
        this.url = "http://" + this.ip + "/" + this.PATH;
        String response = this.doGet(this.url);
        if (response.isEmpty()) {
            result = false;
        }
        return result;
    }

    public boolean openHttps() throws ClientProtocolException, IOException {
        boolean result = true;
        this.ssl = true;
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)new BasicHttpParams());
        this.httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"best-match");
        this.url = "https://" + this.ip + "/" + this.PATH;
        String response = this.doGet(this.url);
        if (response.isEmpty()) {
            result = false;
        }
        return result;
    }

    public void close() {
        this.httpclient.getConnectionManager().shutdown();
    }

    public boolean performLogin() throws ClientProtocolException, IOException {
        boolean result = false;
        this.formparams.clear();
        this.formparams.add((NameValuePair)new BasicNameValuePair("user", this.name));
        this.formparams.add((NameValuePair)new BasicNameValuePair("password", this.password));
        this.formparams.add((NameValuePair)new BasicNameValuePair("submit", "Log In"));
        responseBody = this.doPost("/login");
        if (this.statusCode == 302 || responseBody.contains("\"OK\"")) {
            this.doGet(this.url);
            result = true;
        } else if (responseBody.contains("NOT_OK")) {
            System.out.println("****ERROR: User name or password incorrect");
            System.exit(1);
        } else {
            System.out.println("****ERROR: Invalid HTTP Status Code (" + this.statusCode + ")");
        }
        return result;
    }

    public String doGet(String get) throws ClientProtocolException, IOException {
        String responseBody = "";
        String newURL = "";
        try {
            if (get.equals(this.url)) {
                this.httpget = new HttpGet(this.url);
            } else {
                newURL = String.valueOf(this.url) + "/" + get;
                newURL = newURL.replaceAll(" ", "%20");
                newURL = newURL.replaceAll("\\|", "%7C");
                this.httpget = new HttpGet(newURL);
            }
            this.response = this.httpclient.execute((HttpUriRequest)this.httpget);
            this.statusCode = this.response.getStatusLine().getStatusCode();
            if (this.statusCode == 200) {
                responseBody = EntityUtils.toString((HttpEntity)this.response.getEntity());
            } else {
                System.out.println("***** ERROR: There was a problem with the connection. The status code is: " + this.statusCode + "*****");
                System.out.println("*****************************************************");
                System.exit(-1);
            }
        }
        catch (UnknownHostException e) {
            System.out.println("***** ERROR: " + e.getMessage() + " unknown host *****");
            System.out.println("*****************************************************");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IllegalArgumentException e) {
            System.out.println("***** ERROR: " + e.getMessage() + " Illegal Argument *****");
            System.out.println("*****************************************************");
            e.printStackTrace();
            System.exit(-1);
        }
        return responseBody;
    }

    private String doPost(String post) throws ClientProtocolException, IOException {
        String responseBody = "";
        this.httpost = new HttpPost(String.valueOf(this.url) + "/" + post);
        this.entity = new UrlEncodedFormEntity(this.formparams, "UTF-8");
        this.httpost.setHeader("User-Agent", "CLI-HttpClient");
        this.httpost.setEntity((HttpEntity)this.entity);
        try {
            this.response = this.httpclient.execute((HttpUriRequest)this.httpost);
            this.statusCode = this.response.getStatusLine().getStatusCode();
            responseBody = EntityUtils.toString((HttpEntity)this.response.getEntity());
        }
        catch (ClientProtocolException e) {
            System.out.println("***** ERROR: " + e.getMessage() + " " + this.url + " - problem with protocol *****");
            System.out.println("************************************************************************************");
            e.printStackTrace();
            System.exit(-1);
        }
        return responseBody;
    }

    public String doUpload(String context, File file) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(String.valueOf(this.url) + context);
        this.response = null;
        FileBodyCustom fileUp = null;
        MultipartEntity entity = new MultipartEntity();
        try {
            entity.addPart("title", (ContentBody)new StringBody("file", Charset.forName("UTF-8")));
            fileUp = new FileBodyCustom(file);
            entity.addPart("file", (ContentBody)fileUp);
            post.setEntity((HttpEntity)entity);
            this.response = this.httpclient.execute((HttpUriRequest)post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("****ERROR: There was a problem uploading the file: " + e.getMessage());
        }
        this.statusCode = this.response.getStatusLine().getStatusCode();
        responseBody = EntityUtils.toString((HttpEntity)this.response.getEntity());
        return responseBody;
    }

    private String getName(String type) {
        String name = "";
        if (type.compareTo("log") == 0) {
            name = "TS4500_FWLOGS_" + DateUtils.now("yyyy-MM-dd_hh.mm.ss") + ".zip";
        } else if (type.compareTo("snapshot") == 0) {
            name = "TS4500_SNAPSHOT_" + DateUtils.now("yyyy-MM-dd_hh.mm.ss") + ".zip";
        } else if (type.compareTo("configuration") == 0) {
            name = "configuration_backup.db";
        } else if (type.compareTo("drivelog") == 0) {
            name = "TS4500_DRIVELOGS_" + DateUtils.now("yyyy-MM-dd_hh.mm.ss") + ".zip";
        }
        return name;
    }

    private void trustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean doDownload(String context, String type) throws ClientProtocolException, IOException {
        boolean result;
        block20: {
            result = false;
            OutputStream out = null;
            int readSize = 1024;
            URL downloadURL = new URL(String.valueOf(this.url) + context);
            if (type.contains("log")) {
                System.out.println("Gathering logs...");
            }
            if (this.ssl) {
                this.trustManager();
            }
            HttpURLConnection conn = (HttpURLConnection)downloadURL.openConnection();
            conn.setRequestMethod("GET");
            int totalSize = conn.getContentLength();
            if (totalSize <= 0) {
                System.out.println("**** There was a problem. The file cannot be found or is empty.");
            }
            InputStream in = null;
            try {
                try {
                    int numRead;
                    String name = this.getName(type);
                    out = new BufferedOutputStream(new FileOutputStream(name));
                    in = conn.getInputStream();
                    byte[] buffer = new byte[readSize];
                    int totalRead = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        System.out.print("Downloading..." + (totalRead += numRead) + "/" + totalSize + " bytes\r");
                    }
                    if (totalRead != 0) {
                        System.out.println("\nThe " + type + " file: " + name + " has been downloaded.");
                        result = true;
                        break block20;
                    }
                    System.out.println("\nFile cannot be found");
                    result = false;
                }
                catch (Exception exception) {
                    System.out.println("****ERROR: There was a problem downloading the file: " + exception.getMessage());
                    exception.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("****ERROR: There was a problem uploading the file: " + ioe.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("****ERROR: There was a problem uploading the file: " + ioe.getMessage());
                }
            }
        }
        return result;
    }

    public boolean doDownloadProperties(String context) throws ClientProtocolException, IOException {
        boolean result;
        block18: {
            result = false;
            OutputStream out = null;
            int readSize = 1024;
            URL downloadURL = new URL(String.valueOf(this.url) + context);
            if (this.ssl) {
                this.trustManager();
            }
            System.out.println("Starting...");
            HttpURLConnection conn = (HttpURLConnection)downloadURL.openConnection();
            conn.setRequestMethod("GET");
            int totalSize = conn.getContentLength();
            InputStream in = null;
            try {
                try {
                    int numRead;
                    String name = "LIBLG_01_VP_" + DateUtils.now("yyyy-MM-dd_hh.mm.ss");
                    out = new BufferedOutputStream(new FileOutputStream(name));
                    in = conn.getInputStream();
                    byte[] buffer = new byte[readSize];
                    int totalRead = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        System.out.print("Downloading..." + (totalRead += numRead) + "/" + totalSize + " bytes\r");
                    }
                    if (totalRead != 0) {
                        System.out.println("\nThe file: " + name + " has been downloaded.");
                        result = true;
                        break block18;
                    }
                    System.out.println("\nFile cannot be found");
                    result = false;
                }
                catch (Exception exception) {
                    System.out.println("****ERROR: There was a problem downloading the file: " + exception.getMessage());
                    exception.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("****ERROR: There was a problem uploading the file: " + ioe.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("****ERROR: There was a problem uploading the file: " + ioe.getMessage());
                }
            }
        }
        return result;
    }
}

