/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.anaconda.CLI;

import com.ibm.anaconda.CLI.Command;
import com.ibm.anaconda.CLI.Connection;
import com.ibm.anaconda.CLI.UtilCLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.http.client.ClientProtocolException;

public class Gen4cli {
    private static String PATH = "web";
    private static boolean codeupdate = false;
    private static boolean driveCodeUpdate = false;
    private static boolean downloadLog = false;
    private static boolean assignDataCartridges = false;
    private static boolean bulkAssignDataCartridges = false;
    private static boolean bulkAssignDataCartridgesByLL = false;
    private static boolean viewDataCartridges = false;
    private static boolean viewDriveSummary = false;
    private static boolean viewDriveDetails = false;
    private static boolean viewLogicalLibraries = false;
    private static boolean viewLogicalLibraryDetails = false;
    private static boolean moveToDrive = false;
    private static boolean moveFromIo = false;
    private static boolean moveFromDrive = false;
    private static boolean checkTimer = false;
    private static boolean createVolserRanges = false;
    private static boolean modifyVolserRange = false;
    private static boolean resetDrive = false;
    private static boolean moveFromAllDrives = false;
    private static boolean prestageDataCartridges = false;
    private static boolean destageDataCartridges = false;
    private static boolean removeDataCartridges = false;
    private static boolean viewVolserRanges = false;
    private static boolean viewNodeCards = false;
    private static boolean viewVolserRangesByLL = false;
    private static boolean resetNodeCards = false;
    private static boolean version = false;
    private static boolean viewSystemSummary = false;
    private static boolean viewSystemSummaryDetails = false;
    private static boolean deleteVolserRanges = false;
    private static boolean createKeyLabelMapping = false;
    private static boolean editKeyLabelMapping = false;
    private static boolean deleteKeyLabelMapping = false;
    private static boolean viewKeyLabelMapping = false;
    private static boolean setMaximumVIOCartridges = false;
    private static boolean downloadPropertiesFile = false;
    private static boolean showQueuedExports = false;
    private static boolean modifyVolserReporting = false;
    private static boolean modifyAdvancedEncSettings = false;
    private static boolean getVIOStatus = false;
    private static boolean setVIOStatus = false;
    private static boolean viewIoStation = false;
    private static boolean viewLibraryVPD = false;
    private static boolean viewCleaningCartridges = false;
    private static boolean viewFibreChannel = false;
    private static boolean viewDriveVPD = false;
    private static boolean viewRoles = false;
    private static boolean viewRolePermissions = false;
    private static boolean setRolePermissions = false;
    private static boolean sendMessage = false;
    private static boolean cleanDrive = false;
    private static boolean viewUsers = false;
    private static boolean setLibraryTime = false;
    private static boolean setNMADetection = false;
    private static boolean viewSnapshots = false;
    private static boolean downloadSnapshot = false;
    private static boolean modifyFibreChannelSettings = false;
    private static boolean setDrivePortsID = false;
    private static boolean createBEP = false;
    private static boolean modifyBEP = false;
    private static boolean deleteBEP = false;
    private static boolean viewBEP = false;
    private static boolean saveConfiguration = false;
    private static boolean restoreConfiguration = false;
    private static boolean setAutoEjectCleaningCarts = false;
    private static boolean viewAccessor = false;
    private static boolean viewStorageCapacity = false;
    private static boolean viewDrivePod = false;
    private static boolean viewEventTable = false;
    private static boolean batch = false;
    private static boolean batchRunning = false;
    private static boolean setScannerSpeed = false;
    private static boolean installLicensedFunction = false;
    private static boolean setSSL = false;
    private static boolean setBaseWWNN = false;
    private static boolean enableSSH = false;
    private static boolean disableSSH = false;
    private static boolean verbose = false;
    private static boolean downloadDrivesLog = false;
    private static boolean startDiscoverHW = false;
    private static boolean startCalibration = false;
    private static boolean startInventory = false;
    private static boolean testMoveSlot = false;
    private static boolean createLL = false;
    private static boolean assignDriveToLL = false;
    private static boolean unassignDrive = false;
    private static boolean startLibraryVerify = false;
    private static boolean statusLibraryVerify = false;
    private static boolean continueLibraryVerify = false;
    private static boolean continueCloseLibraryVerify = false;
    private static boolean setStorageSlotStatus = false;
    private static boolean setSlotOnline = false;
    private static boolean setSlotOffline = false;
    private static boolean viewOfflineComponents = false;
    private static boolean viewAdvancedEncryptionSettings = false;
    private static boolean getFWVersion = false;
    private static boolean setSerialNumber = false;
    private static boolean sendPMR = false;
    private static boolean setSleep = false;
    private static boolean libraryBackup = false;
    private static boolean libraryRestore = false;
    private static boolean setSSLForEKM = false;
    private static boolean ssl = false;
    private static boolean deleteLL = false;
    private static String username = "";
    private static String password = "";
    private static String filename = "";
    private static String ip = "";
    private static String frame = "";
    private static String column = "";
    private static String row = "";
    private static boolean setCreateUser = false;
    private static OptionParser parser;
    private static OptionSet options;
    private static String logicalLibrary;
    private static String moveSourceOption;
    private static String[] argsGlobal;
    public static int returnStatus;
    static Map<String, String> paramsList;
    String url = "";
    String page = "";
    Command command = null;
    Connection connection = new Connection(ip, username, password);

    static {
        logicalLibrary = "";
        moveSourceOption = "";
        returnStatus = 0;
        paramsList = new HashMap<String, String>();
    }

    private Gen4cli() throws ClientProtocolException, IOException {
        boolean connected = false;
        connected = ssl ? this.connection.openHttps() : this.connection.openHttp();
        if (connected) {
            if (verbose) {
                System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Connection established");
            }
            if (this.connection.performLogin()) {
                if (verbose) {
                    System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Login successful");
                }
            } else {
                if (verbose) {
                    System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Could not login. Try again");
                } else {
                    System.out.println("There was a problem with the login. Please try again");
                }
                System.exit(1);
            }
        } else {
            if (verbose) {
                System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Connection refused. Please try again.");
            } else {
                System.out.println("Connection refused. Please try again.");
            }
            System.exit(1);
        }
        this.callTask();
    }

    public static void main(String[] args) throws ClientProtocolException, IOException {
        argsGlobal = args;
        try {
            parser = new OptionParser(){
                {
                    this.acceptsAll(Arrays.asList("h", "?"), "Show Help");
                    this.acceptsAll(Arrays.asList("v", "verbose"), "Verbose");
                    this.accepts("u", "Required if security is enabled").withRequiredArg().ofType(String.class).describedAs("Username");
                    this.accepts("p", "Required if security is enabled").withRequiredArg().ofType(String.class).describedAs("Password");
                    this.accepts("ip", "Required if security is enabled").withRequiredArg().ofType(String.class).describedAs("IPAddress");
                    this.accepts("d", "OPTIONAL: Enables additional debug logging");
                    this.accepts("BEP", "OPTIONAL: Sets the BEP flag for a given CEP ").withRequiredArg().ofType(String.class).describedAs("BEP");
                    this.accepts("l", "Required if driveCodeUpdate is selected").withRequiredArg().ofType(String.class).describedAs("DriveLocations");
                    this.accepts("reset", "Required if driveCodeUpdate is selected").withRequiredArg().ofType(String.class).describedAs("ResetOption");
                    this.accepts("codeUpdate", "ACTION: Updates the library firmware").withRequiredArg().ofType(File.class).describedAs("Firmware");
                    this.accepts("driveCodeUpdate", "ACTION: Updates drives firmware").withRequiredArg().ofType(File.class).describedAs("Firmware");
                    this.accepts("downloadLog", "ACTION: Downloads library log");
                    this.accepts("downloadDrivesLog", "ACTION: Downloads drives log. Location: F1C1R1,F1C2R2... or ALL").withRequiredArg().ofType(String.class).describedAs("Location");
                    this.accepts("downloadPropertiesFile", "ACTION: Downloads Properties File");
                    this.accepts("resetNodeCards", "ACTION: Reset all specified node cards (multiples must be separated by commas without spaces)").withRequiredArg().ofType(String.class).describedAs("ALL,ALLLCA,ALLACC,ALLSMC,ALLXYC,ALLPLUS,XYCPLUS,ACCPLUS,LCAPLUS,XYA,XYB,OPC1,SMC[2-16],ACCA,ACCB,LCA[1-31],LCAB[1-31]");
                    this.accepts("resetDrive", "ACTION: Power cycle the drive at the given frame, column and row");
                    this.accepts("createVolserRanges", "ACTION: Create new volser ranges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("modifyVolserRanges", "ACTION: Modifies  volser ranges specified within file").withRequiredArg().ofType(File.class).describedAs("FileName");
                    this.accepts("assignDataCartridges", "ACTION: Assign the data cartridges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("moveToDrive", "ACTION: Move the specified cartridge to a drive").withRequiredArg().ofType(String.class).describedAs("Location (F,C,R,[T for HD libraries])");
                    this.accepts("moveFromDrive", "ACTION: Move a cartridge from the specified drive");
                    this.accepts("moveFromAllDrives", "ACTION: Demount all full drives");
                    this.accepts("prestageDataCartridges", "ACTION: Prestage the data cartridges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("destageDataCartridges", "ACTION: Destage the data cartridges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("removeDataCartridges", "ACTION: Remove the data cartridges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("deleteVolserRanges", "ACTION: Remove all the Volser Ranges specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("createKeyLabelMapping", "ACTION: Creates a Key Label Mapping with the specified arguments").withRequiredArg().ofType(String.class).describedAs("KeyLabelFrom, KeyMode [Wrapped-Hash,Wrapped-Default,Wrapped-Clear,Direct-Default Set,Direct-Specific], KeyLabelTo");
                    this.accepts("editKeyLabelMapping", "ACTION: Updates the Key Label Mapping specified by index, with the given parameters. Use viewKeyLabelMapping before to get the index").withRequiredArg().ofType(String.class).describedAs("Index,KeyLabelFrom, KeyMode, KeyLabelTo");
                    this.accepts("deleteKeyLabelMapping", "ACTION: Deletes the Key Label Mapping specified by index. Use viewKeyLabelMapping before to get the index").withRequiredArg().ofType(String.class).describedAs("Index");
                    this.accepts("setMaximumVIOCartridges", "ACTION: Update the number of Virtual I/O slots for the logical library. Value must be between 32 and 255. Parameters need to be inside quotation marks: \"[LL name],[Value]\"").withRequiredArg().ofType(String.class).describedAs("Logical Library Name, Value");
                    this.accepts("showQueuedExports", "ACTION: Set flag to Show/Hide (true, false) queued exports. Parameters need to be inside quotation marks: \"[LL name],[TRUE/FALSE]\"").withRequiredArg().ofType(String.class).describedAs("Logical Library Name, [TRUE/FALSE]");
                    this.accepts("modifyVolserReporting", "ACTION: Modifies Volser Reporting value (6 or 8). Parameters need to be inside quotation marks: \"[LL name],[6/8]\"").withRequiredArg().ofType(String.class).describedAs("Logical Library Name, [6/8]");
                    this.accepts("modifyAdvancedEncSettings", "ACTION: Modifies Advanced Encryption Settings of Logical Libraries with the specified parameters. Parameters are ").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("setVIOStatus", "ACTION: Set VIO status (Enabled/Disabled)").withRequiredArg().ofType(String.class).describedAs("Status");
                    this.accepts("cleanDrive", "ACTION: Cleans the drive at the given frame, column and row");
                    this.accepts("setRolePermissions", "ACTION: Modifies  permissions for a given role").withRequiredArg().ofType(File.class).describedAs("FileName");
                    this.accepts("setLibraryTime", "ACTION: Set System data and time");
                    this.accepts("setNMADetection", "ACTION: Set NMA detection flag [TRUE/FALSE]").withRequiredArg().ofType(String.class).describedAs("[TRUE/FALSE]");
                    this.accepts("downloadSnapshot", "ACTION: Download a given snapthos. Use first \"viewSnapshots\". The parameter is the index of the file").withRequiredArg().ofType(String.class).describedAs("File index shown in \"viewSnapshots\" command.");
                    this.accepts("modifyFibreChannelSettings", "ACTION: Sets ports speed and topology for the given drive").withRequiredArg().ofType(String.class).describedAs("[Speed ,Topology] -f [frame] -c [column] -r [row].\n For Speed valid values are: Auto,1,2,4,8. The values are in Gb/s.\nFor Topology valid values are: Auto-L,L,N,Auto-N");
                    this.accepts("setDrivePortsID", "ACTION: Set Drive Port 1 and Port 2 IDs").withRequiredArg().ofType(String.class).describedAs("IDs [Port1ID,Port2ID]  -f [frame] -c [column] -r [row]");
                    this.accepts("createBEP", "ACTION: Create Cartridge encryption policy").withRequiredArg().ofType(String.class).describedAs("volser Start, volser End, Logical Lib, media Type, KLM1, KLM2");
                    this.accepts("modifyBEP", "ACTION: Updates a Cartridge encryption policy").withRequiredArg().ofType(String.class).describedAs("Index, [KLM1] [KLM2] [BEP]");
                    this.accepts("deleteBEP", "ACTION: Deletes a Cartridge encryption policy").withRequiredArg().ofType(String.class).describedAs("Index");
                    this.accepts("saveConfiguration", "ACTION: Run a library DB backup");
                    this.accepts("restoreConfiguration", "ACTION: Run a library DB restore with the given file").withRequiredArg().ofType(String.class).describedAs("File");
                    this.accepts("setAutoEjectCleaningCarts", "ACTION: Set auto eject flag for cleaning cartridges (Enabled/Disabled)").withRequiredArg().ofType(String.class).describedAs("Status");
                    this.accepts("bulkAssignDataCartridges", "ACTION: Assign all the data cartridges specified within file to the given logical library").withRequiredArg().ofType(String.class).describedAs("Filename, LL Name");
                    this.accepts("bulkAssignDataCartridgesByLL", "ACTION: Assign  data cartridges  within file to a Logical library specific for each cartridge").withRequiredArg().ofType(String.class).describedAs("Filename");
                    this.accepts("setScannerSpeed", "ACTION: Set scanner speed [30%-100%]").withRequiredArg().ofType(String.class).describedAs("Speed in multiples of 10. i.e: 30,40..,100 and 0 for nominal speed");
                    this.accepts("setSSL", "ACTION: Set SSL enabled/disabled").withRequiredArg().ofType(String.class).describedAs("Enabled/disabled");
                    this.accepts("setBaseWWNN", "ACTION: Set the WWNN").withRequiredArg().ofType(String.class).describedAs("WWN");
                    this.accepts("startLibraryVerify", "ACTION: Starts library verify for IO stations");
                    this.accepts("continueLibraryVerify", "ACTION: Close IO doors library verify ");
                    this.accepts("continueCloseLibraryVerify", "ACTION: Close IO doors library verify ");
                    this.accepts("setSlotOnline", "ACTION: Sets online a given slot:  -f -c -r");
                    this.accepts("setSlotOffline", "ACTION: Sets offline a given slot: -f -c -r");
                    this.accepts("sendPMR", "ACTION: Sends a Call Home PMR:  -id -pmr [optional]");
                    this.accepts("setSSLForEKM", "ACTION: Sets SSL flag to Enable / Disable for a given EKM (ip)").withRequiredArg().ofType(String.class).describedAs("IP for EKM");
                    this.accepts("setCreateUser", "ACTION: Create a new user").withRequiredArg().ofType(String.class).describedAs("name email password role");
                    this.accepts("viewBEP", "ACTION:  View all cartridge encryption policies");
                    this.accepts("viewDataCartridges", "ACTION:  View all data cartridges");
                    this.accepts("viewDriveSummary", "ACTION:  View all drives");
                    this.accepts("viewDriveDetails", "ACTION: View detailed information about a drive at the given frame and row");
                    this.accepts("viewLogicalLibraries", "ACTION: View all the logical library settings");
                    this.accepts("viewLogicalLibraryDetails", "ACTION:  View the detailed information about a given logical library").withRequiredArg().ofType(String.class).describedAs("Logical Library");
                    this.accepts("viewVolserRanges", "ACTION:  View all volser ranges in the physical library");
                    this.accepts("viewVolserRangesByLL", "ACTION:  View all volser ranges assigned to each logical library");
                    this.accepts("viewNodeCards", "ACTION: View the node card information");
                    this.accepts("viewSystemSummary", "ACTION: Views the physical library system summary");
                    this.accepts("viewKeyLabelMapping", "ACTION: Views all the stored key label mappings");
                    this.accepts("getVIOStatus", "ACTION: Views the actual VIO status (Enabled/Disabled)");
                    this.accepts("viewSystemSummaryDetails", "ACTION: View physical library system summary for the specified frame").withRequiredArg().ofType(String.class).describedAs("Frame");
                    this.accepts("viewIoStation", "ACTION: View all cartridges in I/O stations");
                    this.accepts("viewLibraryVPD", "ACTION: View the library VPD information");
                    this.accepts("viewCleaningCartridges", "ACTION: View all cleaning cartridges");
                    this.accepts("viewFibreChannel", "ACTION: View the fibre channel settings");
                    this.accepts("viewDriveVPD", "ACTION: View the drive VPD information");
                    this.accepts("viewUsers", "ACTION: View the list of users");
                    this.accepts("viewRoles", "ACTION: View the list of roles");
                    this.accepts("viewRolePermissions", "ACTION: View the current permissions for the given role").withRequiredArg().ofType(String.class).describedAs("Role");
                    this.accepts("viewSnapshots", "ACTION: View the list of available snapshots ");
                    this.accepts("viewAccessor", "ACTION: View accessor status and usage statistics");
                    this.accepts("viewOfflineComponents", "ACTION: View offline components");
                    this.accepts("viewAdvancedEncryptionSettings", "ACTION: View Advanced Encryption settings for a given logical library").withRequiredArg().ofType(String.class).describedAs("Logical Library Name");
                    this.accepts("installLicensedFunction", "ACTION: Install/uninstall a licensed function given by key. Parameters: [install,uninstall],[key]").withRequiredArg().ofType(String.class).describedAs("[flag,key]");
                    this.accepts("sendMessage", "ACTION: Set debug message");
                    this.accepts("enableSSH", "ACTION: Enables SSH port");
                    this.accepts("disableSSH", "ACTION: Disables SSH port");
                    this.accepts("startDiscoverHW", "ACTION: Starts discover HW command").withRequiredArg().ofType(String.class).describedAs("[OVERWRITE optional], List of frame indexes where DH will run.Example: OVERWRITE,2,3,4");
                    this.accepts("startInventory", "ACTION: Starts inventory command");
                    this.accepts("startCalibration", "ACTION: Starts calibration command").withRequiredArg().ofType(String.class).describedAs("LIBRARY,FRAME,DRIVE,IO,ACCESSOR,SHUTTLE. For frame we need to include the frame index: FRAME,1 . For Drive we need to include the location of the drive:  DRIVE,F1C1R1. For accessor we need to include 1 for Accessor A and 2 for Accesor B: ACCESSOR,1");
                    this.accepts("testMoveSlot", "ACTION: Performs a PUT / GET operation to the given location. Parameters: [PUT/GET],FCRTT,[GRIPPER_1/GRIPPER_2]").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("createLL", "ACTION: Creates a new LL with the given name. Parametes: [LLName],MediaType[LTO, JAG]").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("deleteLL", "ACTION: Deletes an existing LL with the given name. Parametes: [LLName]").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("assignDriveToLL", "ACTION: Assign a drive to a given LL. Parameters: [LLName],[FCR - Drive Location]").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("getFWVersion", "ACTION: Shows current Firmware version");
                    this.accepts("setSerialNumber", "ACTION: Set Serial Number for L Frame.").withRequiredArg().ofType(String.class).describedAs("[L frame Index],[Number Frames],[Serial Number]");
                    this.accepts("setSleep", "ACTION: Sleep thread for given seconds").withRequiredArg().ofType(String.class).describedAs("seconds");
                    this.accepts("unassignDrive", "ACTION: Unssign a drive,[FCR - Drive Location]").withRequiredArg().ofType(String.class).describedAs("Parameters");
                    this.accepts("viewStorageCapacity", "ACTION: View accessor status and usage statistics");
                    this.accepts("viewDrivePod", "ACTION: View accessor status and usage statistics");
                    this.accepts("viewEventTable", "ACTION: View accessor status and usage statistics");
                    this.accepts("batch", "ACTION: Execute actions specified within file").withRequiredArg().ofType(File.class).describedAs("Filename");
                    this.accepts("version", "ACTION: Show the current version of the Gen 4 TS3500 Web Interface CLI program");
                    this.accepts("f", "OPTIONAL: Designates a frame").withRequiredArg().ofType(String.class).describedAs("Frame");
                    this.accepts("c", "OPTIONAL: Designates a column").withRequiredArg().ofType(String.class).describedAs("Column");
                    this.accepts("r", "OPTIONAL: Designates a row").withRequiredArg().ofType(String.class).describedAs("Row");
                    this.accepts("id", "Designates the event id").withRequiredArg().ofType(String.class).describedAs("ID");
                    this.accepts("pmr", "Designates a PMR id, if there is an error sending it, this parameter will not be used").withRequiredArg().ofType(String.class).describedAs("PMR");
                    this.accepts("library", "OPTIONAL: Option for startInventory. Possible values are [SINGLE, NO].").withRequiredArg().ofType(String.class).describedAs("taret node");
                    this.accepts("audit", "OPTIONAL: Option for startInventory. Possible values are [FIRST, ALL]").withRequiredArg().ofType(String.class).describedAs("taret node");
                    this.accepts("frame", "OPTIONAL: Option for startInventory. Possible values are [ALL, # ( frame index)]").withRequiredArg().ofType(String.class).describedAs("taret node");
                    this.accepts("targetNode", "OPTIONAL: Designates a target node").withRequiredArg().ofType(String.class).describedAs("taret node");
                    this.accepts("targetTask", "OPTIONAL: Designates a target task").withRequiredArg().ofType(String.class).describedAs("target task");
                    this.accepts("sourceNode", "OPTIONAL: Designates a source node").withRequiredArg().ofType(String.class).describedAs("source node");
                    this.accepts("sourceTask", "OPTIONAL: Designates a source task").withRequiredArg().ofType(String.class).describedAs("source task");
                    this.accepts("msgType", "OPTIONAL: Designates a msg type").withRequiredArg().ofType(String.class).describedAs("msg type");
                    this.accepts("control", "OPTIONAL: Designates a control").withRequiredArg().ofType(String.class).describedAs("control");
                    this.accepts("msgKey", "OPTIONAL: Designates a msg key").withRequiredArg().ofType(String.class).describedAs("msg key");
                    this.accepts("index", "OPTIONAL: Designates a index").withRequiredArg().ofType(String.class).describedAs("index");
                    this.accepts("flowControl", "OPTIONAL: Designates a flow control").withRequiredArg().ofType(String.class).describedAs("flow control");
                    this.accepts("dataSize", "OPTIONAL: Designates a data size [0-32]").withRequiredArg().ofType(String.class).describedAs("data size");
                    this.accepts("data", "OPTIONAL: Designates a data").withRequiredArg().ofType(String.class).describedAs("data");
                    this.accepts("role", "OPTIONAL: Designates a role").withRequiredArg().ofType(String.class).describedAs("role");
                    this.accepts("KLM1", "OPTIONAL: Sets the new KLM1 for a given CEP ").withRequiredArg().ofType(String.class).describedAs("KLM1");
                    this.accepts("KLM2", "OPTIONAL: Sets the new KLM2 for a given CEP ").withRequiredArg().ofType(String.class).describedAs("KLM2");
                    this.accepts("EKM", "OPTIONAL: IP for the EKM ").withRequiredArg().ofType(String.class).describedAs("EKM");
                    this.accepts("ssl", "OPTIONAL: Use a HTTPS connection");
                    this.accepts("retry", "OPTIONAL: Retries for a failed command").withRequiredArg().ofType(String.class).describedAs("Retries");
                    this.accepts("no", "OPTIONAL: flag to allow any hex string for setBaseWWNN");
                }
            };
            options = parser.parse(args);
            Gen4cli.setOptions();
            if (version) {
                System.out.println("CLI GEN 4 Version: 1.20");
                System.out.println("Build: 11/10/2015");
                System.exit(0);
            }
            new Gen4cli();
        }
        catch (OptionException oe) {
            System.out.println("***** ERROR: " + oe.getMessage() + " *****");
            try {
                UtilCLI.getHelp().printHelpOn((OutputStream)System.out);
                System.exit(1);
            }
            catch (IOException ioe) {
                System.out.println("***** ERROR: " + ioe.getMessage() + " *****");
                if (verbose) {
                    ioe.printStackTrace();
                }
                System.exit(1);
            }
        }
        catch (ClientProtocolException cpe) {
            System.out.println("***** ERROR: " + cpe.getMessage() + " *****");
            if (verbose) {
                cpe.printStackTrace();
            }
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("***** ERROR: " + ioe.getMessage() + " *****");
            System.out.println("Response Body: Not available");
            if (verbose) {
                ioe.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static void setOptions() throws IOException {
        String ll;
        Object list;
        String flag;
        Object input;
        if (options.has("?")) {
            UtilCLI.getHelp().printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if (options.has("ssl")) {
            ssl = true;
        }
        if (options.has("v") || options.has("verbose")) {
            verbose = true;
            paramsList.put("verbose", "true");
        }
        if (options.has("u")) {
            username = options.valueOf("u").toString();
            paramsList.put("username", username);
        }
        if (options.has("p")) {
            password = options.valueOf("p").toString();
            paramsList.put("password", password);
        }
        if (options.has("ip")) {
            ip = options.valueOf("ip").toString();
            paramsList.put("ip", ip);
        }
        if (options.has("batch")) {
            batch = true;
            paramsList.put("batchfile", options.valueOf("batch").toString());
        }
        if (options.has("targetNode")) {
            paramsList.put("targetNode", options.valueOf("targetNode").toString());
        }
        if (options.has("targetTask")) {
            paramsList.put("targetTask", options.valueOf("targetTask").toString());
        }
        if (options.has("sourceNode")) {
            paramsList.put("sourceNode", options.valueOf("sourceNode").toString());
        }
        if (options.has("sourceTask")) {
            paramsList.put("sourceTask", options.valueOf("sourceTask").toString());
        }
        if (options.has("msgType")) {
            paramsList.put("msgType", options.valueOf("msgType").toString());
        }
        if (options.has("control")) {
            paramsList.put("control", options.valueOf("control").toString());
        }
        if (options.has("msgKey")) {
            paramsList.put("msgKey", options.valueOf("msgKey").toString());
        }
        if (options.has("index")) {
            paramsList.put("index", options.valueOf("index").toString());
        }
        if (options.has("flowControl")) {
            paramsList.put("flowControl", options.valueOf("flowControl").toString());
        }
        if (options.has("dataSize")) {
            paramsList.put("dataSize", options.valueOf("dataSize").toString());
        }
        if (options.has("data")) {
            paramsList.put("data", options.valueOf("data").toString());
        }
        if (options.has("sendMessage")) {
            sendMessage = true;
        }
        if (options.has("saveConfiguration")) {
            libraryBackup = true;
        }
        if (options.has("restoreConfiguration")) {
            libraryRestore = true;
            paramsList.put("filename", options.valueOf("restoreConfiguration").toString());
        }
        if (options.has("codeUpdate")) {
            codeupdate = true;
            filename = options.valueOf("codeUpdate").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("driveCodeUpdate")) {
            driveCodeUpdate = true;
            filename = options.valueOf("driveCodeUpdate").toString();
            paramsList.put("filename", filename);
            if (options.has("l")) {
                paramsList.put("list", options.valueOf("l").toString());
            } else {
                System.out.println("***** ERROR: -l option is missing *****");
                System.exit(1);
            }
            if (options.has("reset")) {
                String reset = options.valueOf("reset").toString();
                if (reset.toUpperCase().compareTo("IMMEDIATE") != 0 && reset.toUpperCase().compareTo("UNLOAD") != 0 && reset.toUpperCase().compareTo("MANUAL") != 0) {
                    System.out.println("***** ERROR: reset option is invalid. Valid values are: IMMEDIATE, UNLOAD and MANUAL *****");
                    System.exit(1);
                }
                paramsList.put("reset", reset);
            } else {
                System.out.println("***** ERROR: -reset option is missing *****");
                System.exit(1);
            }
        }
        if (options.has("checkTimer")) {
            checkTimer = true;
        }
        if (options.has("deleteVolserRanges")) {
            deleteVolserRanges = true;
            filename = options.valueOf("deleteVolserRanges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("downloadLog")) {
            downloadLog = true;
        }
        if (options.has("downloadPropertiesFile")) {
            downloadPropertiesFile = true;
        }
        if (options.has("downloadSnapshot")) {
            downloadSnapshot = true;
            String index = options.valueOf("downloadSnapshot").toString();
            int i = 0;
            try {
                i = Integer.parseInt(index);
                paramsList.put("index", index);
            }
            catch (NumberFormatException e) {
                System.out.println("**** ERROR: The index is not a valid value");
                System.exit(1);
            }
        }
        if (options.has("downloadDrivesLog")) {
            downloadDrivesLog = true;
            paramsList.put("list", options.valueOf("downloadDrivesLog").toString());
        }
        if (options.has("setRolePermissions")) {
            setRolePermissions = true;
            paramsList.put("filename", options.valueOf("setRolePermissions").toString());
            if (options.has("role")) {
                paramsList.put("role", options.valueOf("role").toString());
            } else {
                System.out.println("***** ERROR: -role option must be included *****");
                System.exit(1);
            }
        }
        if (options.has("resetNodeCards")) {
            resetNodeCards = true;
            paramsList.put("nodeList", options.valueOf("resetNodeCards").toString());
        }
        if (options.has("createVolserRanges")) {
            createVolserRanges = true;
            filename = options.valueOf("createVolserRanges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("resetDrive")) {
            resetDrive = true;
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
        }
        if (options.has("cleanDrive")) {
            cleanDrive = true;
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
        }
        if (options.has("assignDataCartridges")) {
            assignDataCartridges = true;
            filename = options.valueOf("assignDataCartridges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("moveToDrive")) {
            moveToDrive = true;
            moveSourceOption = options.valueOf("moveToDrive").toString();
            Gen4cli.checkMoveToDriveOption(moveSourceOption, paramsList);
            Gen4cli.checkDriveArgs(paramsList);
        }
        if (options.has("moveFromDrive")) {
            moveFromDrive = true;
            Gen4cli.checkDriveArgs(paramsList);
        }
        if (options.has("moveFromIo")) {
            moveFromIo = true;
            Gen4cli.checkIOArgs(paramsList);
        }
        if (options.has("moveFromAllDrives")) {
            moveFromAllDrives = true;
        }
        if (options.has("prestageDataCartridges")) {
            prestageDataCartridges = true;
            filename = options.valueOf("prestageDataCartridges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("destageDataCartridges")) {
            destageDataCartridges = true;
            filename = options.valueOf("destageDataCartridges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("removeDataCartridges")) {
            removeDataCartridges = true;
            filename = options.valueOf("removeDataCartridges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("createKeyLabelMapping")) {
            createKeyLabelMapping = true;
            Gen4cli.checkKLMArgs((String)options.valueOf("createKeyLabelMapping"), paramsList);
        }
        if (options.has("editKeyLabelMapping")) {
            editKeyLabelMapping = true;
            Gen4cli.checkKLMArgsEdit((String)options.valueOf("editKeyLabelMapping"), paramsList);
        }
        if (options.has("deleteKeyLabelMapping")) {
            deleteKeyLabelMapping = true;
            paramsList.put("index", options.valueOf("deleteKeyLabelMapping").toString());
        }
        if (options.has("setMaximumVIOCartridges")) {
            setMaximumVIOCartridges = true;
            Gen4cli.checkMaxVIOParams(paramsList);
        }
        if (options.has("modifyVolserRanges")) {
            modifyVolserRange = true;
            filename = options.valueOf("modifyVolserRanges").toString();
            paramsList.put("filename", filename);
        }
        if (options.has("showQueuedExports")) {
            showQueuedExports = true;
            Gen4cli.checkFlagParams(paramsList, "showQueuedExports");
        }
        if (options.has("modifyVolserReporting")) {
            modifyVolserReporting = true;
            Gen4cli.checkFlagParams(paramsList, "modifyVolserReporting");
        }
        if (options.has("modifyAdvancedEncSettings")) {
            modifyAdvancedEncSettings = true;
            Gen4cli.validateAdvancedSettings(paramsList, options.valueOf("modifyAdvancedEncSettings").toString());
        }
        if (options.has("setVIOStatus")) {
            setVIOStatus = true;
            paramsList.put("vioStatus", options.valueOf("setVIOStatus").toString());
        }
        if (options.has("setLibraryTime")) {
            setLibraryTime = true;
        }
        if (options.has("modifyFibreChannelSettings")) {
            modifyFibreChannelSettings = true;
            paramsList.put("settings", options.valueOf("modifyFibreChannelSettings").toString());
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
            Gen4cli.checkFibreParams(options.valueOf("modifyFibreChannelSettings").toString());
        }
        if (options.has("setDrivePortsID")) {
            setDrivePortsID = true;
            paramsList.put("ids", options.valueOf("setDrivePortsID").toString());
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
            Gen4cli.checkPortsIDs(options.valueOf("setDrivePortsID").toString());
        }
        if (options.has("createBEP")) {
            createBEP = true;
            Gen4cli.checkCEPParams(paramsList, options.valueOf("createBEP").toString());
        }
        if (options.has("modifyBEP")) {
            modifyBEP = true;
            paramsList.put("index", options.valueOf("modifyBEP").toString());
            if (!(options.has("BEP") || options.has("KLM1") || options.has("KLM2"))) {
                System.out.println("****ERROR: There are missing parameters. At least one of these parameters must be included: ");
                System.out.println("\t\t\tBEP:  [True/False]");
                System.out.println("\t\t\tKLM1: index taken from viewKeyLabelMapping");
                System.out.println("\t\t\tKLM2: index taken from viewKeyLabelMapping");
                System.exit(1);
            }
            if (options.has("BEP")) {
                if (options.valueOf("BEP").toString().toUpperCase().compareTo("TRUE") == 0 || options.valueOf("BEP").toString().toUpperCase().compareTo("FALSE") == 0) {
                    paramsList.put("BEP", options.valueOf("BEP").toString().toUpperCase());
                } else {
                    System.out.println("****ERROR: Wrong value. BEP parameter valid values are: ");
                    System.out.println("\t\t\tBEP:  [True/False]");
                    System.exit(1);
                }
            }
            if (options.has("KLM1")) {
                paramsList.put("KLM1", options.valueOf("KLM1").toString());
            }
            if (options.has("KLM2")) {
                paramsList.put("KLM2", options.valueOf("KLM2").toString());
            }
        }
        if (options.has("deleteBEP")) {
            deleteBEP = true;
            paramsList.put("index", options.valueOf("deleteBEP").toString());
        }
        if (options.has("setAutoEjectCleaningCarts")) {
            setAutoEjectCleaningCarts = true;
            paramsList.put("flag", options.valueOf("setAutoEjectCleaningCarts").toString());
        }
        if (options.has("bulkAssignDataCartridges")) {
            bulkAssignDataCartridges = true;
            input = options.valueOf("bulkAssignDataCartridges").toString().split(",");
            if (((String[])input).length < 2) {
                System.out.println("****ERROR: Missing parameters:  [filename],[logical library Name]");
                System.exit(1);
            }
            paramsList.put("filename", input[0]);
            paramsList.put("llName", input[1]);
        }
        if (options.has("bulkAssignDataCartridgesByLL")) {
            bulkAssignDataCartridgesByLL = true;
            paramsList.put("filename", options.valueOf("bulkAssignDataCartridgesByLL").toString());
        }
        if (options.has("setScannerSpeed")) {
            setScannerSpeed = true;
            Integer speed = Integer.parseInt(options.valueOf("setScannerSpeed").toString());
            if (speed >= 30 && speed <= 100 && speed % 10 == 0 || speed == 0) {
                paramsList.put("speed", options.valueOf("setScannerSpeed").toString());
            } else {
                System.out.println("***** ERROR: " + speed + " is not a valid value for  Scanner speed *****");
                System.out.println("***** Valid values are: 0,30,40,50,60,70,80,90 and 100 *****");
                System.exit(1);
            }
        }
        if (options.has("setSSL")) {
            setSSL = true;
            flag = options.valueOf("setSSL").toString();
            if (flag.toUpperCase().compareTo("ENABLED") == 0 || flag.toUpperCase().compareTo("DISABLED") == 0) {
                paramsList.put("flag", flag);
            } else {
                System.out.println("***** ERROR: " + flag + " is not a valid value for setSSL *****");
                System.out.println("***** Valid values are: ENABLED, DISABLED *****");
                System.exit(1);
            }
        }
        if (options.has("setSSLForEKM")) {
            setSSLForEKM = true;
            if (!options.has("EKM")) {
                System.out.println("***** ERROR: EKM paramer is missing *****");
                System.out.println("***** --setSSLForEKM [ENABLED/DISABLED] -EKM [IP] *****");
                System.exit(1);
            } else {
                paramsList.put("ekm", options.valueOf("EKM").toString());
            }
            flag = options.valueOf("setSSLForEKM").toString();
            if (flag.toUpperCase().compareTo("ENABLED") == 0 || flag.toUpperCase().compareTo("DISABLED") == 0) {
                paramsList.put("flag", flag);
            } else {
                System.out.println("***** ERROR: " + flag + " is not a valid value for setSSL *****");
                System.out.println("***** Valid values are: ENABLED, DISABLED *****");
                System.exit(1);
            }
        }
        if (options.has("setBaseWWNN")) {
            setBaseWWNN = true;
            String wwnn = options.valueOf("setBaseWWNN").toString();
            Integer value = 0;
            try {
                value = Integer.parseInt(wwnn, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (options.has("no")) {
                if (wwnn.length() == 8) {
                    paramsList.put("wwnn", wwnn);
                } else {
                    System.out.println("***** ERROR: " + wwnn + " is not a valid value for Base WWNN *****");
                    System.exit(1);
                }
            } else if (value >= 0x60440000 && value <= 1615331327 || value >= 1661927424 && value <= 1661943807) {
                paramsList.put("wwnn", wwnn);
            } else {
                System.out.println("***** ERROR: " + wwnn + " is not a valid value for Base WWNN *****");
                System.out.println("***** Valid values are in Hexadecimal abd within these ranges: 60440000 to 6047FFFF and 630F0000 to 630F3FFF*****");
                System.exit(1);
            }
        }
        options.has("setCreateUser");
        if (options.has("startLibraryVerify")) {
            startLibraryVerify = true;
        }
        if (options.has("statusLibraryVerify")) {
            statusLibraryVerify = true;
        }
        if (options.has("continueLibraryVerify")) {
            continueLibraryVerify = true;
        }
        if (options.has("continueCloseLibraryVerify")) {
            continueCloseLibraryVerify = true;
        }
        if (options.has("setStorageSlotStatus")) {
            setStorageSlotStatus = true;
            String param = options.valueOf("setStorageSlotStatus").toString();
            String[] list2 = param.split(",");
            if (list2.length == 4) {
                paramsList.put("frame", list2[0]);
                paramsList.put("col", list2[1]);
                paramsList.put("row", list2[2]);
                paramsList.put("action", list2[3].compareToIgnoreCase("ON") == 0 ? "4" : "5");
            } else {
                System.out.println("***** ERROR: " + param + ". List of parameters is incompleted. *****");
                System.out.println("***** Required parameters are: frame,column,row,[ON/OFF] *****");
                System.exit(1);
            }
        }
        if (options.has("setSlotOffline")) {
            setSlotOffline = true;
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
        }
        if (options.has("setSlotOnline")) {
            setSlotOnline = true;
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            } else {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
        }
        if (options.has("getFWVersion")) {
            getFWVersion = true;
        }
        if (options.has("sendPMR")) {
            sendPMR = true;
            if (options.has("id")) {
                paramsList.put("id", options.valueOf("id").toString());
            } else {
                System.out.println("***** ERROR: ID parameter must be included *****");
                System.exit(1);
            }
            if (options.has("pmr")) {
                paramsList.put("pmr", options.valueOf("pmr").toString());
            } else {
                paramsList.put("pmr", "0");
            }
        }
        if (options.has("viewStorageCapacity")) {
            viewStorageCapacity = true;
        }
        if (options.has("viewDrivePod")) {
            viewDrivePod = true;
        }
        if (options.has("viewEventTable")) {
            viewEventTable = true;
        }
        if (options.has("setSleep")) {
            setSleep = true;
            paramsList.put("seconds", options.valueOf("setSleep").toString());
        }
        if (options.has("installLicensedFunction")) {
            installLicensedFunction = true;
            input = options.valueOf("installLicensedFunction").toString();
            String[] list3 = ((String)input).split(",");
            if (list3.length < 2 || list3.length > 2) {
                System.out.println("***** ERROR:  Wrong parameters *****");
                System.out.println("***** Valid values are: [install/uninstall],[key] *****");
                System.exit(1);
            } else if (list3[0].trim().toUpperCase().compareTo("INSTALL") == 0 || list3[0].trim().toUpperCase().compareTo("UNINSTALL") == 0) {
                paramsList.put("flag", list3[0].trim().toUpperCase().compareTo("INSTALL") == 0 ? "1" : "0");
                paramsList.put("key", list3[1].trim().toUpperCase());
            } else {
                System.out.println("***** ERROR: " + list3[0] + " is not a valid value for the first parameter *****");
                System.out.println("***** Valid values are: install/uninstall *****");
                System.exit(1);
            }
        }
        if (options.has("enableSSH")) {
            enableSSH = true;
        }
        if (options.has("disableSSH")) {
            disableSSH = true;
        }
        if (options.has("startCalibration")) {
            startCalibration = true;
            String component = options.valueOf("startCalibration").toString();
            String[] list4 = component.split(",");
            if (list4.length == 1) {
                if (list4[0].compareToIgnoreCase("LIBRARY") == 0 || list4[0].compareToIgnoreCase("SHUTTLE") == 0) {
                    paramsList.put(list4[0].toUpperCase(), "1");
                } else {
                    System.out.println("***** ERROR: " + list4[0] + " is not a valid value for the first parameter. It must be just one value. *****");
                    System.out.println("***** Valid values are: LIBRARY,FRAME[index],DRIVE[location],IO[frameIndex,IOIndex],ACCESSOR[1=A,2=B],SHUTTLE *****");
                    System.exit(1);
                }
            } else if (list4[0].compareToIgnoreCase("FRAME") == 0) {
                paramsList.put(list4[0].toUpperCase(), list4[1]);
            } else if (list4[0].compareToIgnoreCase("DRIVE") == 0) {
                String drive = list4[1];
                drive = drive.replace("F", "");
                drive = drive.replace("C", ",");
                drive = drive.replace("R", ",");
                String[] location = drive.split(",");
                paramsList.put("FRAME", location[0]);
                paramsList.put("COLUMN", location[1]);
                paramsList.put("ROW", location[2]);
            } else if (list4[0].compareToIgnoreCase("ACCESSOR") == 0) {
                paramsList.put(list4[0], list4[1]);
            } else if (list4[0].compareToIgnoreCase("IO") == 0) {
                paramsList.put("IO", list4[2]);
                paramsList.put("FRAME", list4[1]);
            } else {
                System.out.println("***** ERROR: " + list4[0] + " is not a valid value for the first parameter *****");
                System.out.println("***** Valid values are: LIBRARY,FRAME[index],DRIVE[location],IO[Frameindex,IOIndex],ACCESSOR[1=A,2=B],SHUTTLE *****");
                System.exit(1);
            }
        }
        if (options.has("startDiscoverHW")) {
            startDiscoverHW = true;
            list = options.valueOf("startDiscoverHW").toString();
            if (((String)list).toUpperCase().contains("OVERWRITE")) {
                paramsList.put("OVERWRITE", "255");
            }
            paramsList.put("list", (String)list);
        }
        if (options.has("startInventory")) {
            startInventory = true;
            if (options.has("library") && options.has("audit") && options.has("frame")) {
                paramsList.put("library", options.valueOf("library").toString().compareToIgnoreCase("SINGLE") == 0 ? "0" : "1");
                paramsList.put("audit", options.valueOf("audit").toString().compareToIgnoreCase("FIRST") == 0 ? "0" : "1");
                paramsList.put("frame", options.valueOf("frame").toString().compareToIgnoreCase("ALL") == 0 ? "0" : options.valueOf("frame").toString());
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** \"startInventory\" requires --library [SINGLE, NO] --audit [FIRST, ALL] --frame [ALL, frameIdx]*****");
                System.exit(1);
            }
        }
        if (options.has("testMoveSlot")) {
            testMoveSlot = true;
            list = options.valueOf("testMoveSlot").toString().split(",");
            String retries = options.valueOf("retry").toString();
            if (((String[])list).length == 3 && !retries.isEmpty()) {
                paramsList.put("retry", retries);
                if (((String)list[0]).compareToIgnoreCase("put") == 0 || ((String)list[0]).compareToIgnoreCase("get") == 0) {
                    paramsList.put("command", ((String)list[0]).compareToIgnoreCase("put") == 0 ? "2" : "1");
                    String location = ((String)list[1]).replace("C", ",");
                    location = location.replace("F", "");
                    location = location.replace("R", ",");
                    location = location.replace("T", ",");
                    String[] index = location.split(",");
                    paramsList.put("frameIdx", index[0]);
                    paramsList.put("columnIdx", index[1]);
                    paramsList.put("rowIdx", index[2]);
                    paramsList.put("tier", index[3]);
                    paramsList.put("type", index[4]);
                    paramsList.put("gripper", ((String)list[2]).compareToIgnoreCase("GRIPPER_1") == 0 ? "1" : "2");
                } else {
                    System.out.println("***** ERROR: There are missing parameters *****");
                    System.out.println("***** --testMoveSlot [PUT/GET],FCRTT,[GRIPPER_1,GRIPPER_2]*****");
                    System.exit(1);
                }
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** --testMoveSlot [PUT/GET],FCRTT,[GRIPPER_1,GRIPPER_2] --retry [# of retries]*****");
                System.exit(1);
            }
        }
        if (options.has("createLL")) {
            createLL = true;
            list = options.valueOf("createLL").toString().split(",");
            if (((String[])list).length == 2) {
                String type = "0";
                paramsList.put("name", list[0]);
                if (((String)list[1]).compareToIgnoreCase("LTO") == 0) {
                    type = "1";
                } else if (((String)list[1]).compareToIgnoreCase("JAG") == 0) {
                    type = "3";
                }
                paramsList.put("mediaType", type);
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** --createLL  [LL Name],[MediaType]*****");
                System.out.println("***** Media Type values are: LTO , JAG*****");
                System.exit(1);
            }
        }
        if (options.has("deleteLL")) {
            deleteLL = true;
            ll = options.valueOf("deleteLL").toString();
            if (!ll.isEmpty()) {
                paramsList.put("name", ll);
            } else {
                System.out.println("***** ERROR: There is a missing parameter *****");
                System.out.println("***** --deleteLL  [LL Name]*****");
            }
        }
        if (options.has("assignDriveToLL")) {
            assignDriveToLL = true;
            list = options.valueOf("assignDriveToLL").toString().split(",");
            if (((String[])list).length == 2) {
                String[] location = ((String)list[1]).replace("C", ",").replace("R", ",").replace("F", "").split(",");
                paramsList.put("name", (String)list[0]);
                paramsList.put("frame", location[0]);
                paramsList.put("column", location[1]);
                paramsList.put("row", location[2]);
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** --assignDriveToLL  FCR,[LL Name]*****");
                System.exit(1);
            }
        }
        if (options.has("unassignDrive")) {
            unassignDrive = true;
            list = options.valueOf("unassignDrive").toString();
            if (!((String)list).isEmpty()) {
                String[] location = ((String)list).replace("C", ",").replace("R", ",").replace("F", "").split(",");
                paramsList.put("frame", location[0]);
                paramsList.put("column", location[1]);
                paramsList.put("row", location[2]);
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** --unassignDrive  FCR*****");
                System.exit(1);
            }
        }
        if (options.has("setSerialNumber")) {
            setSerialNumber = true;
            list = options.valueOf("setSerialNumber").toString().split(",");
            if (((Object)list).length == 3) {
                paramsList.put("frameIndex", (String)list[0]);
                paramsList.put("numberFrames", (String)list[1]);
                paramsList.put("serial", (String)list[2]);
            } else {
                System.out.println("***** ERROR: There are missing parameters *****");
                System.out.println("***** --setSerialNumber  [L frame index],[number frames],[serial number for L frame]*****");
                System.exit(1);
            }
        }
        if (options.has("viewBEP")) {
            viewBEP = true;
        }
        if (options.has("viewVolserRanges")) {
            viewVolserRanges = true;
        }
        if (options.has("viewDataCartridges")) {
            viewDataCartridges = true;
        }
        if (options.has("viewDriveSummary")) {
            viewDriveSummary = true;
        }
        if (options.has("viewDriveDetails")) {
            viewDriveDetails = true;
            if (!(options.has("f") || options.has("c") || options.has("r"))) {
                System.out.println("***** ERROR: Frame, Column and Row number must be included *****");
                System.exit(1);
            }
            if (options.has("f")) {
                frame = options.valueOf("f").toString();
                paramsList.put("frame", frame);
            }
            if (options.has("c")) {
                column = options.valueOf("c").toString();
                paramsList.put("column", column);
            }
            if (options.has("r")) {
                row = options.valueOf("r").toString();
                paramsList.put("row", row);
            }
        }
        if (options.has("viewLogicalLibraries")) {
            viewLogicalLibraries = true;
        }
        if (options.has("viewLogicalLibraryDetails")) {
            viewLogicalLibraryDetails = true;
            logicalLibrary = options.valueOf("viewLogicalLibraryDetails").toString();
            paramsList.put("logicalLibrary", logicalLibrary);
        }
        if (options.has("viewNodeCards")) {
            viewNodeCards = true;
        }
        if (options.has("version")) {
            version = true;
        }
        if (options.has("viewSystemSummary")) {
            viewSystemSummary = true;
        }
        if (options.has("viewKeyLabelMapping")) {
            viewKeyLabelMapping = true;
        }
        if (options.has("viewVolserRangesByLL")) {
            viewVolserRangesByLL = true;
        }
        if (options.has("getVIOStatus")) {
            getVIOStatus = true;
        }
        if (options.has("viewSystemSummaryDetails")) {
            viewSystemSummaryDetails = true;
            paramsList.put("frame", options.valueOf("viewSystemSummaryDetails").toString());
        }
        if (options.has("viewIoStation")) {
            viewIoStation = true;
        }
        if (options.has("viewLibraryVPD")) {
            viewLibraryVPD = true;
        }
        if (options.has("viewCleaningCartridges")) {
            viewCleaningCartridges = true;
        }
        if (options.has("viewFibreChannel")) {
            viewFibreChannel = true;
        }
        if (options.has("viewDriveVPD")) {
            viewDriveVPD = true;
        }
        if (options.has("viewUsers")) {
            viewUsers = true;
        }
        if (options.has("viewRoles")) {
            viewRoles = true;
        }
        if (options.has("viewRolePermissions")) {
            viewRolePermissions = true;
            paramsList.put("role", options.valueOf("viewRolePermissions").toString());
        }
        if (options.has("viewSnapshots")) {
            viewSnapshots = true;
        }
        if (options.has("setNMADetection")) {
            setNMADetection = true;
            String value = options.valueOf("setNMADetection").toString();
            paramsList.put("nma", value);
            if (value.trim().toUpperCase().compareTo("TRUE") != 0 && value.trim().toUpperCase().compareTo("FALSE") != 0) {
                System.out.println("***** ERROR: " + value + " is not a valid value for  NMA flag [true, false] *****");
                System.exit(1);
            }
        }
        if (options.has("viewAccessor")) {
            viewAccessor = true;
        }
        if (options.has("viewOfflineComponents")) {
            viewOfflineComponents = true;
        }
        if (options.has("viewAdvancedEncryptionSettings")) {
            ll = options.valueOf("viewAdvancedEncryptionSettings").toString();
            if (!ll.isEmpty()) {
                viewAdvancedEncryptionSettings = true;
                paramsList.put("llName", ll);
            } else {
                System.out.println("***** ERROR: Parameter missing: Logical Library name *****");
                System.exit(1);
            }
        }
        if (options.has("setCreateUser")) {
            setCreateUser = true;
            Gen4cli.checkCEPParams(paramsList, options.valueOf("setCreateUser").toString());
        }
    }

    private static void checkCEPParams(Map<String, String> paramsList, String CEPParams) {
        String[] fields = CEPParams.split(",");
        String startRange = "";
        String endRange = "";
        String mediaType = "";
        String logicalLibrary = "";
        String klm1 = "";
        String klm2 = "";
        boolean rc = true;
        if (fields.length == 5 || fields.length == 6) {
            startRange = fields[0].trim().toUpperCase();
            endRange = fields[1].trim().toUpperCase();
            logicalLibrary = fields[2].trim();
            mediaType = fields[3].trim().toUpperCase();
            klm1 = fields[4].trim().toUpperCase();
            if (startRange.length() != 6 || endRange.length() != 6) {
                System.out.println("***** ERROR: Ranges (" + startRange + " - " + endRange + ") has to be only 6 characters long *****");
                rc = false;
            }
            if (startRange.compareTo(endRange) > 0) {
                System.out.println("***** ERROR: Starting range is greater than ending range (" + startRange + " - " + endRange + ") *****");
                rc = false;
            }
            if (logicalLibrary.isEmpty()) {
                System.out.println("***** ERROR: " + logicalLibrary + " not a valid logical library *****");
                rc = false;
            }
            if (mediaType.compareTo("LTO") != 0 && mediaType.compareTo("3592") != 0) {
                System.out.println("***** ERROR: " + mediaType + " not a valid media type [LTO, 3592] *****");
                rc = false;
            }
            if (klm1.isEmpty()) {
                System.out.println("***** ERROR: " + klm1 + " not a valid value *****");
                rc = false;
            }
            if (fields.length == 6) {
                paramsList.put("klm2", fields[5].trim());
            }
            if (rc) {
                paramsList.put("volserStart", startRange);
                paramsList.put("volserEnd", endRange);
                paramsList.put("logicalLibrary", logicalLibrary);
                paramsList.put("mediaType", mediaType);
                paramsList.put("klm1", klm1);
            } else {
                System.exit(1);
            }
        } else {
            System.out.println("***** ERROR: There are missing parameters:");
            System.out.println("***** \t\tVOLSER start");
            System.out.println("***** \t\tVOLSER end");
            System.out.println("***** \t\tLogLib name");
            System.out.println("***** \t\tMedia type (LTO,3592)");
            System.out.println("***** \t\tKLM 1 index");
            System.out.println("***** \t\tKLM 2 index (optional)");
            System.exit(1);
        }
    }

    private static void checkPortsIDs(String str) {
        String[] fields = str.split(",");
        if (fields.length != 2) {
            System.out.println("***** ERROR: Wrong number of parameters. *****");
            System.out.println("             [Port 1 ID, Port 2 ID]\n");
            System.out.println("      Accepted values are in the range [0,127] \n");
            System.exit(1);
        } else {
            String regex = "[0-9]+";
            if (!fields[0].matches(regex) || !fields[1].matches(regex) || Integer.parseInt(fields[0]) < 0 && Integer.parseInt(fields[0]) > 127 || Integer.parseInt(fields[1]) < 0 && Integer.parseInt(fields[1]) > 127) {
                System.out.println("***** ERROR: Wrong values for parameters. *****");
                System.out.println("             [Port 1 ID, Port 2 ID]\n");
                System.out.println("      Accepted values are in the range [0,127]: \n");
                System.exit(1);
            }
        }
    }

    private static void checkFibreParams(String strParams) {
        int totalFields;
        String[] fields = strParams.split(",");
        if (fields.length != (totalFields = 2)) {
            System.out.println("***** ERROR: Wrong number of parameters. *****");
            System.out.println("             [Port Speed, Port Topology]");
            System.out.println("      where:\nPort1 Speed, Port2 Speed (Gb/s):\n \t\t\t\t\t\t\tAuto\n\t\t\t\t\t\t\t1\n\t\t\t\t\t\t\t2\n\t\t\t\t\t\t\t4\n\t\t\t\t\t\t\t8\nPort1 Topology,Port2 Topology:\n\t\t\t\t\t\t\tAuto-L\n\t\t\t\t\t\t\tL\n\t\t\t\t\t\t\tN\n\t\t\t\t\t\t\tAuto-N\n");
            System.exit(1);
        } else if (fields[0].toUpperCase().compareTo("AUTO") != 0 && fields[0].toUpperCase().compareTo("1") != 0 && fields[0].toUpperCase().compareTo("2") != 0 && fields[0].toUpperCase().compareTo("4") != 0 && fields[0].toUpperCase().compareTo("8") != 0 || fields[1].toUpperCase().compareTo("AUTO-L") != 0 && fields[1].toUpperCase().compareTo("L") != 0 && fields[1].toUpperCase().compareTo("N") != 0 && fields[1].toUpperCase().compareTo("AUTO-N") != 0) {
            System.out.println("***** ERROR: Wrong values. *****");
            System.out.println("             [Port Speed, Port Topology]");
            System.out.println("      where:\nPort1 Speed, Port2 Speed (Gb/s):\n \t\t\t\t\t\t\tAuto\n\t\t\t\t\t\t\t1\n\t\t\t\t\t\t\t2\n\t\t\t\t\t\t\t4\n\t\t\t\t\t\t\t8\nPort1 Topology,Port2 Topology:\n\t\t\t\t\t\t\tAuto-L\n\t\t\t\t\t\t\tL\n\t\t\t\t\t\t\tN\n\t\t\t\t\t\t\tAuto-N\n");
            System.exit(1);
        }
    }

    private static void validateAdvancedSettings(Map<String, String> params, String strParams) {
        boolean rc = true;
        if (strParams.trim().length() != 0) {
            String[] fields = strParams.split(",");
            if (fields.length != 5) {
                System.out.println("***** ERROR: Wrong number of parameters. *****");
                System.out.println("\t\t\tLogical Library Name");
                System.out.println("\t\t\tAdvanced Method: [TRUE / FALSE]\n\t\t\tAdvanced Policy: \n\t\t\t\tNo advanced setting\t\t\t= 0\n\t\t\t\tDon't Encrypt if No policy\t\t= 1\n\t\t\t\tEncrypt if no policy\t\t\t= 2\n\t\t\t\tPolicy required\t\t\t\t= 3\n\t\t\t\tNever encrypt ( policy override)\t= 4\n\t\t\t\tAlways encrypt ( policy overrride)\t= 5\n\t\t\t\tInternal Label - Selective Encryption\t= 6\n\t\t\t\tInternal Label - Encrypt All\t\t= 7\n\t\t\tDensity code: \n\t\t\t\tNo advanced setting\t\t\t= 0\n\t\t\t\tShows Encryption\t\t\t= 1\n\t\t\t\tMasks Encryption\t\t\t= 2\n\t\t\tKey Path:\n\t\t\t\tNo advanced setting\t\t\t= 1\n\t\t\t\tSystem\t\t\t\t\t= 2\n\t\t\t\tApplication (IBM)\t\t\t= 3\n\t\t\t\tApplication (T10)\t\t\t= 4\n\t\t\t\tLibrary\t\t\t\t\t= 6\n");
                System.out.println("Advanced Policy [0-7], Density code [0-2], KeyPath[1,2,3,4,6].*****");
                System.exit(1);
            }
            String llName = fields[0].trim();
            String advancedMethod = fields[1].trim().toUpperCase();
            String advancedPolicy = fields[2].trim();
            String density = fields[3].trim();
            String keyPath = fields[4].trim();
            int key = Integer.parseInt(keyPath);
            if (advancedMethod.compareTo("TRUE") != 0 && advancedMethod.compareTo("FALSE") != 0) {
                System.out.println("***** ERROR: " + advancedMethod + " is not a valid value for the Advanced Method parameter [true, false] *****");
                rc = false;
            } else {
                advancedMethod = advancedMethod.compareTo("TRUE") == 0 ? "1" : "0";
            }
            if (Integer.parseInt(advancedPolicy) < 0 || Integer.parseInt(advancedPolicy) > 7) {
                System.out.println("***** ERROR: Advanced Policy has to be a value between 0 and 7  *****");
                System.out.println(String.format("Advanced Policy:\n%40s = 0\n%40s = 1\n%40s = 2\n%40s = 3\n%40s = 4\n%40s = 5\n%40s = 6\n%40s = 7\n", "No advanced setting", "Don't Encrypt if No policy", "Encrypt if no policy", "Policy required", "Never encrypt ( policy override)", "Always encrypt ( policy overrride)", "Internal Label - Selective Encryption", "Internal Label - Encrypt All"));
                rc = false;
            }
            if (Integer.parseInt(density) < 0 || Integer.parseInt(density) > 2) {
                System.out.println("***** ERROR: Density code has to be a value between 0 and 2  *****");
                System.out.println(String.format("Density code:\n%40s = 0\n%40s = 1\n%40s = 2\n", "No advanced setting", "Shows Encryption", "Masks Encryption"));
                rc = false;
            }
            if (key != 1 && key != 2 && key != 3 && key != 4 && key != 6) {
                System.out.println("***** ERROR: Key path possible values are:  *****");
                System.out.println(String.format("Key Path:\n%40s = 1\n%40s = 2\n%40s = 3\n%40s = 4\n%40s = 6\n", "No advanced setting", "System", "Application (IBM)", "Application (T10)", "Library"));
                rc = false;
            }
            if (!rc) {
                System.exit(1);
            } else {
                params.put("llName", llName);
                params.put("advancedMethod", advancedMethod);
                params.put("advancedPolicy", advancedPolicy);
                params.put("density", density);
                params.put("keyPath", keyPath);
            }
        } else {
            System.out.println("**** ERROR: Empty string *******");
            System.exit(1);
        }
    }

    private static void checkFlagParams(Map<String, String> paramsList, String commandStr) {
        String line = options.valueOf(commandStr).toString();
        if (line.trim().length() != 0) {
            String[] fields = line.split(",");
            if (fields.length != 2) {
                System.out.println("***** ERROR: Wrong number of parameters. *****");
                System.out.println("             Parameters need to be inside quotation marks: \"[LL name],[Value]\". *****");
                System.exit(1);
            }
            String logicalLibrary = fields[0].trim();
            String value = fields[1].trim().toUpperCase();
            if (logicalLibrary.isEmpty()) {
                System.out.println("***** ERROR: " + logicalLibrary + " not a valid logical library *****");
                System.exit(1);
            } else {
                paramsList.put("llName", logicalLibrary);
            }
            if (commandStr.compareTo("showQueuedExports") == 0) {
                if (value.isEmpty() || value.toUpperCase().trim().compareTo("TRUE") != 0 && value.toUpperCase().trim().compareTo("FALSE") != 0) {
                    System.out.println("***** ERROR: " + value + " not a valid value *****");
                    System.out.println("Parameters need to be inside quotation marks: \"[LL name],[TRUE/FALSE]\"");
                    System.exit(1);
                } else {
                    paramsList.put("value", value);
                }
            } else if (commandStr.compareTo("modifyVolserReporting") == 0) {
                if (value.isEmpty() || value.toUpperCase().trim().compareTo("6") != 0 && value.toUpperCase().trim().compareTo("8") != 0) {
                    System.out.println("***** ERROR: " + value + " not a valid value *****");
                    System.out.println("Parameters need to be inside quotation marks: \"[LL name],[6/8]\"");
                    System.exit(1);
                } else {
                    paramsList.put("value", value);
                }
            }
        } else {
            System.out.println("***** ERROR: Wrong number of parameters. *****");
            System.out.println("Parameters need to be inside quotation marks: \"LL name, value\". *****");
            System.exit(1);
        }
    }

    private static void checkVolserRangeParams(Map<String, String> paramsList) {
        String line = options.valueOf("modifyVolserRange").toString();
        if (line.trim().length() != 0) {
            String[] fields = line.split(",");
            if (fields.length != 5) {
                System.out.println("***** ERROR: Wrong number of parameters. *****");
                System.out.println("             index,starRange,endRange,LL name, media Type [LTO,3592]. *****");
                System.exit(1);
            }
            String index = fields[0].trim().toUpperCase();
            String startRange = fields[1].trim().toUpperCase();
            String endRange = fields[2].trim().toUpperCase();
            String logicalLibrary = fields[3].trim();
            String mediaType = fields[4].trim().toUpperCase();
            if (startRange.length() != 6 || endRange.length() != 6) {
                System.out.println("***** ERROR: Ranges (" + startRange + " - " + endRange + ") has to be only 6 characters long *****");
                System.exit(1);
            }
            if (startRange.compareTo(endRange) > 0) {
                System.out.println("***** ERROR: Starting range is greater than ending range (" + startRange + " - " + endRange + ") *****");
            } else {
                paramsList.put("index", index);
                paramsList.put("start", startRange);
                paramsList.put("end", endRange);
            }
            if (logicalLibrary.isEmpty()) {
                System.out.println("***** ERROR: " + logicalLibrary + " not a valid logical library *****");
                System.exit(1);
            } else {
                paramsList.put("llName", logicalLibrary);
            }
            if (mediaType.isEmpty()) {
                System.out.println("***** ERROR: " + mediaType + " not a valid media type [LTO, 3592] *****");
                System.exit(1);
            } else {
                paramsList.put("mediaType", mediaType);
            }
        } else {
            System.out.println("***** ERROR: Wrong number of parameters. *****");
            System.out.println("             index,starRange,endRange,LL name, media Type [LTO,3592]. *****");
            System.exit(1);
        }
    }

    private static void checkMaxVIOParams(Map<String, String> paramsList2) {
        String maxvioparams = options.valueOf("setMaximumVIOCartridges").toString();
        if (maxvioparams.contains(",")) {
            String[] params = maxvioparams.split(",");
            if (params.length == 2) {
                paramsList.put("llName", params[0].trim());
                if (Integer.parseInt(params[1].trim()) > 255) {
                    System.out.println("***** ERROR: Wrong value. Parameters need to be inside quotation marks: \"[LL name],[Value]\"  *****");
                    System.out.println("***** where Value must be <= 255  *****");
                    System.exit(1);
                } else {
                    paramsList.put("range", params[1].trim());
                }
            } else {
                System.out.println("***** ERROR: Missing parameters (need to be inside quotation marks ): \"[LL name],[Value]\"  *****");
                System.exit(1);
            }
        } else {
            System.out.println("***** ERROR: Missing parameters (need to be inside quotation marks ): \"[LL name],[Value]\"  *****");
            System.exit(1);
        }
    }

    private static void checkIOArgs(Map<String, String> paramsList) {
        String volser = options.valueOf("moveFromIo").toString();
        if (volser.contains(",")) {
            if (!volser.matches("^F\\d\\d?,R\\d\\d?$")) {
                System.out.println("***** ERROR: Cartridge locations in I/O must be in the form F#,R# where # is a number *****");
                System.exit(1);
            }
            String[] params = volser.split(",");
            paramsList.put("frame", params[0].substring(1, params[0].length()));
            paramsList.put("row", params[1].substring(1, params[1].length()));
        } else {
            paramsList.put("volser", volser);
        }
    }

    private static void checkKLMArgs(String paramsString, Map<String, String> paramsList) {
        if (paramsString.contains(",")) {
            String[] params = paramsString.split(",");
            if (params.length == 3 || params.length == 2) {
                paramsList.put("keyLabelFrom", params[0].trim());
                paramsList.put("keyModeFrom", params[1].trim());
                String modeFrom = params[1].trim().toUpperCase();
                if (params.length == 3) {
                    paramsList.put("keyLabelTo", params[2].trim());
                    if (modeFrom.compareTo("WRAPPED-DEFAULT") == 0) {
                        System.out.println("***** NOTE: KeyLabelTo will be ignored.  *****");
                        System.out.println("*****       When using WRAPPED-DEFAULT keyLabelTo is disabled  *****");
                        System.out.println("********************************************************************");
                        paramsList.put("keyLabelTo", "");
                    }
                } else if (modeFrom.compareTo("WRAPPED-DEFAULT") != 0) {
                    System.out.println("***** ERROR: Missing parameter:  *****");
                    System.out.println("*****       [KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
                    System.exit(1);
                }
                if (modeFrom.compareTo("WRAPPED-HASH") != 0 && modeFrom.compareTo("WRAPPED-DEFAULT") != 0 && modeFrom.compareTo("WRAPPED-CLEAR") != 0 && modeFrom.compareTo("DIRECT-DEFAULT-SET") != 0 && modeFrom.compareTo("DIRECT-SPECIFIC") != 0) {
                    System.out.println("***** ERROR: KLM parameter: Key Mode  not allowed. Mode types accepted are:  *****");
                    System.out.println("*****        [Wrapped-Hash, Wrapped-Default, Wrapped-Clear, Direct-Default-Set,Direct-Specific]  *****");
                    System.exit(1);
                }
            } else {
                System.out.println("***** ERROR: KLM parameters in wrong format. Required parameters should be separated by comma:  *****");
                System.out.println("*****        [KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
                System.exit(1);
            }
        } else {
            System.out.println("***** ERROR: KLM parameters in wrong format. Required parameters should be separated by comma: *****");
            System.out.println("*****        [KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
            System.exit(1);
        }
    }

    private static void checkKLMArgsEdit(String paramsString, Map<String, String> paramsList) {
        if (paramsString.contains(",")) {
            String[] params = paramsString.split(",");
            if (params.length == 4 || params.length == 3) {
                paramsList.put("index", params[0].trim());
                paramsList.put("keyLabelFrom", params[1].trim());
                paramsList.put("keyModeFrom", params[2].trim());
                String modeFrom = params[2].trim().toUpperCase();
                if (params.length == 4) {
                    paramsList.put("keyLabelTo", params[3].trim());
                    if (modeFrom.compareTo("WRAPPED-DEFAULT") == 0) {
                        System.out.println("***** NOTE: KeyLabelTo will be ignored.  *****");
                        System.out.println("*****       When using WRAPPED-DEFAULT keyLabelTo is disabled  *****");
                        System.out.println("********************************************************************");
                        paramsList.put("keyLabelTo", "");
                    }
                } else if (modeFrom.compareTo("WRAPPED-DEFAULT") != 0) {
                    System.out.println("***** ERROR: Missing parameter:  *****");
                    System.out.println("*****       [Index,KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
                    System.exit(1);
                }
                if (modeFrom.compareTo("WRAPPED-HASH") != 0 && modeFrom.compareTo("WRAPPED-DEFAULT") != 0 && modeFrom.compareTo("WRAPPED-CLEAR") != 0 && modeFrom.compareTo("DIRECT-DEFAULT-SET") != 0 && modeFrom.compareTo("DIRECT-SPECIFIC") != 0) {
                    System.out.println("***** ERROR: KLM parameter: Key Mode  not allowed. Mode types accepted are:  *****");
                    System.out.println("*****        [Index,Wrapped-Hash, Wrapped-Default, Wrapped-Clear, Direct-Default-Set,Direct-Specific]  *****");
                    System.exit(1);
                }
            } else {
                System.out.println("***** ERROR: KLM parameters in wrong format. Required parameters should be separated by comma:  *****");
                System.out.println("*****        [Index,KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
                System.exit(1);
            }
        } else {
            System.out.println("***** ERROR: KLM parameters in wrong format. Required parameters should be separated by comma: *****");
            System.out.println("*****        [Index,KeyLabelFrom,KeyMode,KeyLabelTo]  *****");
            System.exit(1);
        }
    }

    private static void checkDriveArgs(Map<String, String> list) {
        String rowDrive = "";
        String columnDrive = "";
        String frameDrive = "";
        if (options.has("r") && options.has("f") && options.has("c")) {
            if (!options.has("w")) {
                rowDrive = options.valueOf("r").toString();
                frameDrive = options.valueOf("f").toString();
                columnDrive = options.valueOf("c").toString();
                list.put("frameDrive", frameDrive);
                list.put("columnDrive", columnDrive);
                list.put("rowDrive", rowDrive);
            } else {
                System.out.println("***** ERROR: Options ['f','c','r'] and ['w'] can not be used together *****");
            }
        } else if (!options.has("w")) {
            block7: {
                System.out.println("***** ERROR: Option ['f','c','r'] or ['w'] is required *****");
                try {
                    UtilCLI.getHelp().printHelpOn((OutputStream)System.out);
                }
                catch (IOException e) {
                    System.out.println("***** ERROR: IOException *****");
                    if (!verbose) break block7;
                    e.printStackTrace();
                }
            }
            System.exit(1);
        }
    }

    private static void checkMoveToDriveOption(String parameter, Map<String, String> list) {
        String[] fields = parameter.split(",");
        switch (fields.length) {
            case 1: {
                list.put("volser", fields[0]);
                break;
            }
            case 3: 
            case 4: {
                if (fields[0].matches("^F\\d\\d?") && fields.length > 1) {
                    list.put("frame", fields[0].substring(1, fields[0].length()));
                    list.put("column", fields[1].substring(1, fields[1].length()));
                    list.put("row", fields[2].substring(1, fields[2].length()));
                    if (fields.length <= 3) break;
                    list.put("tier", fields[3].substring(1, fields[3].length()));
                    break;
                }
                System.out.println("****ERROR: Wrong format for location: [F0,C1,R2] or [F0,C1,R2,T3] for HD libraries*****");
                System.exit(1);
                break;
            }
            default: {
                System.out.println("****ERROR: Wrong format. Valid options are: *****");
                System.out.println("**** location [FCR] or [FCRT]                  *****");
                System.out.println("**** Volser                                    *****");
                System.exit(1);
            }
        }
    }

    private void callTask() {
        try {
            this.command = new Command();
            if (paramsList != null) {
                this.command.setParams(paramsList);
            } else {
                System.out.println("Error: list of parameters is null");
            }
            if (this.connection != null) {
                this.command.setConnection(this.connection);
            } else {
                if (verbose) {
                    System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: ERROR: Connection is dead");
                } else {
                    System.out.println("**** ERROR: Connection is dead");
                }
                System.exit(1);
            }
            if (codeupdate) {
                this.command.setName("codeupdate");
                this.command.libraryFirmwareUpdateTask();
            } else if (driveCodeUpdate) {
                this.command.setName("driveCodeUpdate");
                this.command.driveFirmwareUpdateTask();
            } else if (restoreConfiguration) {
                this.command.setName("restoreConfiguration");
                this.command.restoreConfigurationTask();
            } else if (checkTimer) {
                this.command.setName("checkTimer");
                this.command.checkTimerTask();
            } else if (downloadLog) {
                this.command.setName("downloadLog");
                this.command.downloadLogTask();
            } else if (downloadPropertiesFile) {
                this.command.setName("downloadPropertiesFile");
                this.command.downloadPropertiesFileTask();
            } else if (downloadSnapshot) {
                this.command.setName("downloadSnapshot");
                this.command.downloadSnapshotTask();
            } else if (saveConfiguration) {
                this.command.setName("saveConfiguration");
                this.command.saveConfigurationTask();
            } else if (resetDrive) {
                this.command.setName("resetDrive");
                this.command.resetDriveTask();
            } else if (cleanDrive) {
                this.command.setName("cleanDrive");
                this.command.cleanDriveTask();
            } else if (assignDataCartridges) {
                this.command.setName("assignDataCartridges");
                this.command.assignDataCartridgesTask();
            } else if (moveToDrive) {
                this.command.setName("moveToDrive");
                this.command.moveToDriveTask();
            } else if (moveFromDrive) {
                this.command.setName("moveFromDrive");
                this.command.moveFromDriveTask();
            } else if (moveFromIo) {
                this.command.setName("moveFromIo");
                this.command.moveFromIoTask();
            } else if (moveFromAllDrives) {
                this.command.setName("moveFromAllDrives");
                this.command.moveFromAllDrivesTask();
            } else if (prestageDataCartridges) {
                this.command.setName("prestageDataCartridges");
                this.command.prestageDataCartridgesTask();
            } else if (destageDataCartridges) {
                this.command.setName("destageDataCartridges");
                this.command.destageDataCartridgesTask();
            } else if (removeDataCartridges) {
                this.command.setName("removeDataCartridges");
                this.command.removeDataCartridgesTask();
            } else if (createVolserRanges) {
                this.command.setName("createVolserRanges");
                this.command.createVolserRangesTask();
            } else if (modifyVolserRange) {
                this.command.setName("modifyVolserRange");
                this.command.modifyVolserRangeTask();
            } else if (resetNodeCards) {
                this.command.setName("resetNodeCards");
                this.command.resetNodeCardsTask();
            } else if (deleteVolserRanges) {
                this.command.setName("deleteVolserRanges");
                this.command.deleteVolserRangesTask();
            } else if (createKeyLabelMapping) {
                this.command.setName("createKeyLabelMapping");
                this.command.createKeyLabelMappingTask();
            } else if (editKeyLabelMapping) {
                this.command.setName("editKeyLabelMapping");
                this.command.editKeyLabelMappingTask();
            } else if (deleteKeyLabelMapping) {
                this.command.setName("deleteKeyLabelMapping");
                this.command.deleteKeyLabelMappingTask();
            } else if (setMaximumVIOCartridges) {
                this.command.setName("setMaximumVIOCartridges");
                this.command.setMaximumVIOCartridgesTask();
            } else if (showQueuedExports) {
                this.command.setName("showQueuedExports");
                this.command.showQueuedExportsTask();
            } else if (modifyVolserReporting) {
                this.command.setName("modifyVolserReporting");
                this.command.modifyVolserReportingTask();
            } else if (modifyAdvancedEncSettings) {
                this.command.setName("modifyAdvancedEncSettings");
                this.command.modifyAdvancedEncSettingsTask();
            } else if (setVIOStatus) {
                this.command.setName("setVIOStatus");
                this.command.setVIOStatusTask();
            } else if (setRolePermissions) {
                this.command.setName("setRolePermissions");
                this.command.setRolePermissionsTask();
            } else if (setLibraryTime) {
                this.command.setName("setLibraryTime");
                this.command.setLibraryTimeTask();
            } else if (setNMADetection) {
                this.command.setName("setNMADetection");
                this.command.setNMADetectionTask();
            } else if (modifyFibreChannelSettings) {
                this.command.setName("modifyFibreChannelSettings");
                this.command.modifyFibreChannelSettings();
            } else if (setDrivePortsID) {
                this.command.setName("setDrivePortsID");
                this.command.setDrivePortsIDTask();
            } else if (createBEP) {
                this.command.setName("createBEP");
                this.command.createBEPTask();
            } else if (modifyBEP) {
                this.command.setName("modifyBEP");
                this.command.editCEPTask();
            } else if (deleteBEP) {
                this.command.setName("deleteBEP");
                this.command.deleteCEPTask();
            } else if (setAutoEjectCleaningCarts) {
                this.command.setName("setAutoEjectCleaningCarts");
                this.command.setAutoEjectCleaningCartsTask();
            } else if (bulkAssignDataCartridges) {
                this.command.setName("bulkAssignDataCartridges");
                this.command.assignBulkDataCartridgesTask();
            } else if (bulkAssignDataCartridgesByLL) {
                this.command.setName("bulkAssignDataCartridgesByLL");
                this.command.assignBulkDataCartridgesByLLTask();
            } else if (setScannerSpeed) {
                this.command.setName("setScannerSpeed");
                this.command.setScannerSpeedTask();
            } else if (setSSL) {
                this.command.setName("setSSL");
                this.command.setSSLTask();
            } else if (setBaseWWNN) {
                this.command.setName("setBaseWWNN");
                this.command.setBaseWWNNTask();
            } else if (viewBEP) {
                this.command.setName("viewBEP");
                this.command.viewCEPTask();
            } else if (viewDataCartridges) {
                this.command.setName("viewDataCartridges");
                this.command.viewDataCartridgesTask();
            } else if (viewDriveSummary) {
                this.command.setName("viewDriveSummary");
                this.command.viewDriveSummaryTask();
            } else if (viewDriveDetails) {
                this.command.setName("viewDriveDetails");
                this.command.viewDriveDetailsTask();
            } else if (viewLogicalLibraries) {
                this.command.setName("viewLogicalLibraries");
                this.command.viewLogicalLibrariesTask();
            } else if (viewLogicalLibraryDetails) {
                this.command.setName("viewLogicalLibraryDetails");
                this.command.viewLogicalLibraryDetailsTask();
            } else if (viewVolserRanges) {
                this.command.setName("viewVolserRanges");
                this.command.viewVolserRangesTask();
            } else if (viewVolserRangesByLL) {
                this.command.setName("viewVolserRangesByLL");
                this.command.viewVolserRangesByLLTask();
            } else if (viewNodeCards) {
                this.command.setName("viewNodeCards");
                this.command.viewNodeCardsTask();
            } else if (installLicensedFunction) {
                this.command.setName("installLicensedFunction");
                this.command.installLicensedFunctionTask();
            } else if (!version) {
                if (batch) {
                    this.command.setName("batch");
                    this.batchTask();
                } else if (viewSystemSummary) {
                    this.command.setName("viewSystemSummary");
                    this.command.viewSystemSummary();
                } else if (viewKeyLabelMapping) {
                    this.command.setName("viewKeyLabelMapping");
                    this.command.viewKLMTask();
                } else if (getVIOStatus) {
                    this.command.setName("getVIOStatus");
                    this.command.getVIOStatusTask();
                } else if (viewSystemSummaryDetails) {
                    this.command.setName("viewSystemSummaryDetails");
                    this.command.viewSystemSummaryDetailsTask();
                } else if (viewIoStation) {
                    this.command.setName("viewIoStation");
                    this.command.viewIoStationTask();
                } else if (viewLibraryVPD) {
                    this.command.setName("viewLibraryVPD");
                    this.command.viewLibraryVPDTask();
                } else if (viewCleaningCartridges) {
                    this.command.setName("viewCleaningCartridges");
                    this.command.viewCleaningCartridgesTask();
                } else if (viewFibreChannel) {
                    this.command.setName("viewFibreChannel");
                    this.command.viewFibreChannelTask();
                } else if (viewDriveVPD) {
                    this.command.setName("viewDriveVPD");
                    this.command.viewDriveVPDTask();
                } else if (viewUsers) {
                    this.command.setName("viewUsers");
                    this.command.viewUsersTask();
                } else if (viewRoles) {
                    this.command.setName("viewRoles");
                    this.command.viewRolesTask();
                } else if (viewRolePermissions) {
                    this.command.setName("viewRolePermissions");
                    this.command.viewRolePermissionsTask();
                } else if (viewSnapshots) {
                    this.command.setName("viewSnapshots");
                    this.command.viewSnapshotsTask();
                } else if (viewAccessor) {
                    this.command.setName("viewAccessor");
                    this.command.viewAccessorTask();
                } else if (viewStorageCapacity) {
                    this.command.setName("viewStorageCapacity");
                    this.command.viewStorageCapacityTask();
                } else if (viewDrivePod) {
                    this.command.setName("viewDrivePod");
                    this.command.viewDrivePodTask();
                } else if (viewEventTable) {
                    this.command.setName("viewEventTable");
                    this.command.viewEventTableTask();
                } else if (sendMessage) {
                    this.command.setName("sendMessage");
                    this.command.sendMessageTask();
                } else if (enableSSH) {
                    this.command.setName("enableSSH");
                    this.command.sendEnableSSHTask(true, true);
                } else if (disableSSH) {
                    this.command.setName("disableSSH");
                    this.command.sendEnableSSHTask(false, true);
                } else if (downloadDrivesLog) {
                    this.command.setName("downloadDrivesLog");
                    this.command.downloadDrivesLogTask();
                } else if (startCalibration) {
                    this.command.setName("startCalibration");
                    this.command.startCalibrationTask();
                } else if (startDiscoverHW) {
                    this.command.setName("startDiscoverHW");
                    this.command.startDiscoverHWTask();
                } else if (startInventory) {
                    this.command.setName("startInventory");
                    this.command.startInventoryTask();
                } else if (testMoveSlot) {
                    this.command.setName("testMoveSlot");
                    this.command.testMoveSlotTask();
                } else if (createLL) {
                    this.command.setName("createLL");
                    this.command.createLLTask();
                } else if (deleteLL) {
                    this.command.setName("deleteLL");
                    this.command.deleteLLTask();
                } else if (assignDriveToLL) {
                    this.command.setName("assignDriveToLL");
                    this.command.assignDriveToLLTask();
                } else if (startLibraryVerify) {
                    this.command.setName("startLibraryVerify");
                    this.command.startLibraryVerifyTask();
                } else if (statusLibraryVerify) {
                    this.command.setName("statusLibraryVerify");
                    this.command.statusLibraryVerifyTask();
                } else if (continueLibraryVerify) {
                    this.command.setName("continueLibraryVerify");
                    this.command.continueLibraryVerifyTask();
                } else if (continueCloseLibraryVerify) {
                    this.command.setName("continueCloseLibraryVerify");
                    this.command.continueCloseLibraryVerifyTask();
                } else if (setStorageSlotStatus) {
                    this.command.setName("setStorageSlotStatus");
                    this.command.setStorageSlotStatusTask();
                } else if (setSlotOnline) {
                    this.command.setName("setSlotOnline");
                    this.command.setSlotOnlineTask();
                } else if (setSlotOffline) {
                    this.command.setName("setSlotOffline");
                    this.command.setSlotOfflineTask();
                } else if (viewOfflineComponents) {
                    this.command.setName("viewOfflineComponents");
                    this.command.viewOfflineComponentsTask();
                } else if (viewAdvancedEncryptionSettings) {
                    this.command.setName("viewAdvancedEncryptionSettings");
                    this.command.viewAdvancedEncryptionSettingsTask();
                } else if (getFWVersion) {
                    this.command.setName("getFWVersion");
                    this.command.getFWVersionTask();
                } else if (setSerialNumber) {
                    this.command.setName("setSerialNumber");
                    this.command.setSerialNumberTask();
                } else if (sendPMR) {
                    this.command.setName("sendPMR");
                    this.command.sendPMRTask();
                } else if (setSleep) {
                    this.command.setName("setSleep");
                    this.command.setSleep();
                } else if (libraryBackup) {
                    this.command.setName("enableSSH");
                    this.command.sendEnableSSHTask(true, false);
                    this.command.setName("libraryBackup");
                    this.command.libraryBackupTask();
                    this.command.setName("disableSSH");
                    this.command.sendEnableSSHTask(false, false);
                } else if (libraryRestore) {
                    this.command.setName("enableSSH");
                    this.command.sendEnableSSHTask(true, false);
                    this.command.setName("libraryRestore");
                    this.command.libraryRestoreTask();
                    this.command.setName("disableSSH");
                    this.command.sendEnableSSHTask(false, false);
                } else if (setSSLForEKM) {
                    this.command.setName("setSSLForEKM");
                    this.command.setSSLForEKMTask();
                } else if (unassignDrive) {
                    this.command.setName("unassignDrive");
                    this.command.unassignDriveTask();
                } else if (setCreateUser) {
                    this.command.setName("setCreateUser");
                    this.command.setCreateUserTask();
                } else {
                    if (verbose) {
                        System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: ERROR :: Command cannot be found.");
                    } else {
                        System.out.println("***** ERROR: Command cannot be found. *******");
                    }
                    this.command.logout();
                    this.connection.close();
                    System.exit(1);
                }
            }
            if (returnStatus == 1 && verbose) {
                System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: There was an exception in the command execution.");
            }
            if (returnStatus == 0 && verbose) {
                System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: " + this.command.getName() + " is done.");
            }
        }
        catch (ClientProtocolException e) {
            returnStatus = 1;
            System.out.println("****ERROR: ClientProtocolException: " + e.getMessage() + " Class: " + ((Object)((Object)e)).getClass() + " *****");
            if (verbose) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            returnStatus = 1;
            System.out.println("****ERROR: IOException: " + e.getMessage() + " Class: " + e.getClass() + " *****");
            if (verbose) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            returnStatus = 1;
            System.out.println("****ERROR: Exception: " + e.getMessage() + " Class: " + e.getClass() + " *****");
            e.printStackTrace();
        }
        if (!batchRunning || returnStatus == 1) {
            this.command.logout();
            this.connection.close();
            if (verbose) {
                System.out.println(String.valueOf(Gen4cli.getDateTime()) + ":: INFO :: Connection is closed");
            }
            System.exit(returnStatus);
        }
    }

    public String getVersion() {
        String result = "";
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            result = "" + new Date(jarFile.lastModified());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return result;
    }

    public static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private void batchTask() {
        if (verbose) {
            System.out.println("Excuting all actions within " + paramsList.get("batchfile") + " at " + Gen4cli.getDateTime());
        }
        batchRunning = true;
        String file = paramsList.get("batchfile");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                this.resetActions();
                String[] arg = line.split("\\s+");
                options = parser.parse(arg);
                Gen4cli.setOptions();
                this.callTask();
                System.out.println("------------------------------");
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("***** ERROR: " + fnfe.getMessage() + " *****");
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("***** ERROR: " + ioe.getMessage() + " *****");
            System.exit(1);
        }
    }

    private void resetActions() {
        codeupdate = false;
        driveCodeUpdate = false;
        downloadLog = false;
        assignDataCartridges = false;
        bulkAssignDataCartridges = false;
        bulkAssignDataCartridgesByLL = false;
        viewDataCartridges = false;
        viewDriveSummary = false;
        viewDriveDetails = false;
        viewLogicalLibraries = false;
        viewLogicalLibraryDetails = false;
        moveToDrive = false;
        moveFromIo = false;
        moveFromDrive = false;
        checkTimer = false;
        createVolserRanges = false;
        modifyVolserRange = false;
        resetDrive = false;
        moveFromAllDrives = false;
        prestageDataCartridges = false;
        destageDataCartridges = false;
        removeDataCartridges = false;
        viewVolserRanges = false;
        viewNodeCards = false;
        viewVolserRangesByLL = false;
        resetNodeCards = false;
        version = false;
        viewSystemSummary = false;
        viewSystemSummaryDetails = false;
        deleteVolserRanges = false;
        createKeyLabelMapping = false;
        editKeyLabelMapping = false;
        deleteKeyLabelMapping = false;
        viewKeyLabelMapping = false;
        setMaximumVIOCartridges = false;
        downloadPropertiesFile = false;
        showQueuedExports = false;
        modifyVolserReporting = false;
        modifyAdvancedEncSettings = false;
        getVIOStatus = false;
        setVIOStatus = false;
        viewIoStation = false;
        viewLibraryVPD = false;
        viewCleaningCartridges = false;
        viewFibreChannel = false;
        viewDriveVPD = false;
        viewRoles = false;
        viewRolePermissions = false;
        setRolePermissions = false;
        sendMessage = false;
        cleanDrive = false;
        viewUsers = false;
        setLibraryTime = false;
        setNMADetection = false;
        viewSnapshots = false;
        downloadSnapshot = false;
        modifyFibreChannelSettings = false;
        setDrivePortsID = false;
        createBEP = false;
        modifyBEP = false;
        deleteBEP = false;
        viewBEP = false;
        saveConfiguration = false;
        restoreConfiguration = false;
        setAutoEjectCleaningCarts = false;
        viewAccessor = false;
        verbose = false;
        batch = false;
        setScannerSpeed = false;
        setSSL = false;
        installLicensedFunction = false;
        setBaseWWNN = false;
        enableSSH = false;
        disableSSH = false;
        downloadDrivesLog = false;
        startDiscoverHW = false;
        startCalibration = false;
        startInventory = false;
        testMoveSlot = false;
        createLL = false;
        assignDriveToLL = false;
        setStorageSlotStatus = false;
        getFWVersion = false;
        setSerialNumber = false;
        setSlotOnline = false;
        setSlotOffline = false;
        viewAdvancedEncryptionSettings = false;
        setSleep = false;
        setCreateUser = false;
        returnStatus = 0;
        paramsList.clear();
        this.command = null;
    }
}

