/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.anaconda.CLI;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class SSHCommands {
    JSch jsch = new JSch();
    String user = "root";
    String host = "";
    String password = "lets8it";
    int port = 22;
    Session session = null;
    Properties config = null;
    Channel channel = null;

    public SSHCommands(String ip) {
        this.host = ip;
        try {
            this.session = this.jsch.getSession(this.user, this.host, this.port);
        }
        catch (JSchException e) {
            System.out.println("****ERROR: Could not connect to remote host: " + this.host);
            e.printStackTrace();
        }
        this.session.setPassword(this.password);
        this.config = new Properties();
        this.config.put("StrictHostKeyChecking", "no");
    }

    public void setSession() {
        this.session.setConfig(this.config);
        try {
            this.session.connect();
        }
        catch (JSchException e) {
            System.out.println("****ERROR: Could not connect to remote host: " + this.host);
            e.printStackTrace();
        }
    }

    public int runExecute(String command) {
        int result = 0;
        InputStream in = null;
        try {
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            this.channel.setInputStream(null);
            ((ChannelExec)this.channel).setErrStream((OutputStream)System.err);
            in = this.channel.getInputStream();
            this.channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                if (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i >= 0) {
                        System.out.print(new String(tmp, 0, i));
                        continue;
                    }
                }
                if (this.channel.isClosed()) {
                    if (in.available() > 0) continue;
                    result = this.channel.getExitStatus();
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (JSchException e) {
            System.out.println("****ERROR: Could not connect to remote host: " + this.host);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void scpToExecute(String lFile, String rFile) {
        FileInputStream fis = null;
        boolean ptimestamp = true;
        try {
            int len;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + rFile;
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            OutputStream out = this.channel.getOutputStream();
            InputStream in = this.channel.getInputStream();
            this.channel.connect();
            if (SSHCommands.checkAck(in) != 0) {
                System.exit(0);
            }
            File _lfile = new File(lFile);
            if (ptimestamp) {
                command = "T " + _lfile.lastModified() / 1000L + " 0";
                command = String.valueOf(command) + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(command.getBytes());
                out.flush();
                if (SSHCommands.checkAck(in) != 0) {
                    System.out.println("****ERROR: Wrong ACK from remote server");
                    System.exit(0);
                }
            }
            long filesize = _lfile.length();
            command = "C0644 " + filesize + " ";
            command = lFile.lastIndexOf(47) > 0 ? String.valueOf(command) + lFile.substring(lFile.lastIndexOf(47) + 1) : String.valueOf(command) + lFile;
            command = String.valueOf(command) + "\n";
            out.write(command.getBytes());
            out.flush();
            if (SSHCommands.checkAck(in) != 0) {
                System.out.println("****ERROR: Wrong ACK from remote server");
                System.exit(0);
            }
            fis = new FileInputStream(lFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (SSHCommands.checkAck(in) != 0) {
                System.out.println("****ERROR: Wrong ACK from remote server");
                System.exit(0);
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void scpFromExecute(String rFile) {
        FileOutputStream fos = null;
        String lFile = ".";
        String prefix = null;
        if (new File(lFile).isDirectory()) {
            prefix = String.valueOf(lFile) + File.separator;
        }
        try {
            int c;
            String command = "scp -f " + rFile;
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            OutputStream out = this.channel.getOutputStream();
            InputStream in = this.channel.getInputStream();
            this.channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SSHCommands.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (true) {
                    if (in.read(buf, 0, 1) < 0) {
                        System.out.println("**** ERROR: There was a problem with the communication");
                        break;
                    }
                    if (buf[0] == 32) break;
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? lFile : String.valueOf(prefix) + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) {
                        System.out.println(">> ERROR");
                        break;
                    }
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (SSHCommands.checkAck(in) != 0) {
                    System.out.println(">> Error exit");
                    System.exit(0);
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ee) {
                System.out.println(">> SCP From remote to local last excp");
            }
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public void closeChannel() {
        this.channel.disconnect();
    }

    public void closeSession() {
        this.session.disconnect();
    }
}

