#-------------------------------------------------------------------------------------------------
# Copyright (c) International Business Machines Corp., 2011
#
# IBM XIV Storage System Software
#
# Licensed materials provided under the terms of the IBM International Program
# License Agreement. See the Software
# licensing materials that came with the IBM XIV Storage System for terms and
# conditions.
#
#-------------------------------------------------------------------------------------------------
"""This is a generic runner of python scripts. It can be copied between projects and shouldn't be altered.
The project_specific_pyrunner.py module, that should be placed in the same directory, contains the project specific
settings.
"""

import sys

from project_specific_pyrunner import get_correct_main_method
from hak.hak_env_config import initialize_project, general_exception, set_locale

initialize_project()

@general_exception
def start():

    # Setting locale only now and not before because of the license display
    set_locale()

    sys.argv.pop(0)
    main = get_correct_main_method(sys.argv[0].lower())
    rc = main()
    sys.exit(rc)

start()

