#-------------------------------------------------------------------------------------------------
# Copyright (c) International Business Machines Corp., 2011
#
# IBM XIV Storage System Software
#
# Licensed materials provided under the terms of the IBM International Program
# License Agreement. See the Software
# licensing materials that came with the IBM XIV Storage System for terms and
# conditions.
#
#------------------------------------------------------------------------------------------------- 

# This is a project specific pyrunner implementation for the host attachment kit
# If you want to copy the runner mechanism to your own project, you should edit this file to match the needed 
# executables

import os

_ARGV0_TO_MODULE = {"xiv_attach" : "hak.host_attach.xiv_attach",
                    "xiv_detach" : "hak.host_attach.xiv_detach",
                    "xiv_devlist" : "hak.xiv_devlist.main",
                    "xiv_diag" : "hak.xiv_diag.main",
                    "xiv_syslist" : "hak.xiv_syslist.main",
                    "xiv_host_profiler" : "hak.xiv_host_profiler.main",
                    "xiv_fc_admin" : "hak.host_attach.xiv_fc_admin",
                    "xiv_iscsi_admin" : "hak.host_attach.xiv_iscsi_admin",
                    "uninstall" : "hak.common.uninstall",
                    "lappy" : "lappy.main"}

def get_correct_main_method(argv0):
    """Will translate the given argv0 to the correct main method"""
    imported_mod = __import__(_ARGV0_TO_MODULE[argv0], fromlist = [_ARGV0_TO_MODULE[argv0]])
    return imported_mod.main
