#!/bin/sh

PYRUNNER_EXEC_NAME=pyrunner.py

argv0=$0
executable_name=`basename $argv0`
args=$*

real_argv0=$argv0
while [ -h $real_argv0 ]; do
    deref=`ls -l $real_argv0 | sed "s/^.*-> \(.*\)$/\1/"`
    
    # check if it's a relative symlink
    if [ "`echo "$deref" | cut -b1`" != "/" ]; then
        deref=`dirname $real_argv0`/$deref
    fi
    real_argv0=$deref
done

# Try to find XPyV in a subdirectory
root_project_dir=`dirname $real_argv0`/../

xpyv_exe=$root_project_dir/xpyv/bin/xpyv
if [ ! -f "$xpyv_exe" ]; then
    xpyv_exe=`which xpyv 2>/dev/null`
    if [ -z "$xpyv_exe" ]; then
        echo "FATAL: Could not find XPyV executable"
        exit 1
    fi
fi

# dereference symlinks (can't use readlink - not cross-platform)

pyrunner_path=$root_project_dir/bin/$PYRUNNER_EXEC_NAME

if [ ! -f "$pyrunner_path" ]; then
    echo "FATAL: Could not find $PYRUNNER_EXEC_NAME"
    exit 2
fi

$xpyv_exe $pyrunner_path $executable_name $args

