#-------------------------------------------------------------------------------------------------
# Copyright (c) International Business Machines Corp., 2009
#
# IBM XIV Storage System Software
#
# Licensed materials provided under the terms of the IBM International Program
# License Agreement. See the Software
# licensing materials that came with the IBM XIV Storage System for terms and
# conditions.
#
#-------------------------------------------------------------------------------------------------

import os
import time

from hak.common.definitions import PROJECT_ROOT_PATH

# Ignore all warnings of type DeprecationWarning:
import warnings
warnings.filterwarnings('ignore', category=DeprecationWarning)

project_root = os.path.normpath(PROJECT_ROOT_PATH)

def backup_baseline(project_root):
    data_dir = os.path.normpath(os.path.join(project_root, 'data'))
    baseline_path = os.path.join(data_dir, 'baseline.xml')
    if os.path.isfile(baseline_path):
        now = time.localtime()
        backup_name = "_baseline.xml.%4d%02d%02d_%02d%02d%02d" % (now.tm_year,
                      now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec)
        os.rename(baseline_path, os.path.join(data_dir, backup_name))
