/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class BatchUpdateDaemon
extends RealTimeDaemon {
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private static final HashMap EMPTY_MAP = new HashMap();
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private HashMap updates = new HashMap();
    private long lastCachePerf_maxNumberCacheEntries = 0L;
    private long lastCachePerf_entryHashtableSize = 0L;

    public BatchUpdateDaemon(int n) {
        super(n);
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setInvalidationAuditDaemon(InvalidationAuditDaemon invalidationAuditDaemon) {
        this.invalidationAuditDaemon = invalidationAuditDaemon;
    }

    public void start() {
        if (this.externalCacheServices == null || this.invalidationAuditDaemon == null) {
            throw new IllegalStateException("externalCacheServices and invalidationAuditDaemon must be set before start()");
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateByTemplate(String string, boolean bl, Cache cache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            batchUpdateList.invalidateByTemplateEvents.put(string, new InvalidateByTemplateEvent(string, 5, cache));
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCommandClear(boolean bl, Cache cache) {
        String string = cache.getCacheName();
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            InvalidateByTemplateEvent invalidateByTemplateEvent = new InvalidateByTemplateEvent(string, 5, cache);
            invalidateByTemplateEvent.setCacheCommandClear();
            batchUpdateList.invalidateByTemplateEvents.put(string, invalidateByTemplateEvent);
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateById(Object object, int n, boolean bl, Cache cache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(cache);
            batchUpdateList.invalidateByIdEvents.put(object, new InvalidateByIdEvent(object, n, 5, cache));
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object object, boolean bl, Cache cache) {
        this.invalidateById(object, 1, bl, cache);
    }

    public synchronized void pushCacheEntry(CacheEntry cacheEntry, Cache cache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(cache);
        batchUpdateList.pushCacheEntryEvents.add(cacheEntry);
    }

    public synchronized void pushExternalCacheFragment(ExternalCacheFragment externalCacheFragment, Cache cache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(cache);
        batchUpdateList.pushECFEvents.add(externalCacheFragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void wakeUp(long l, long l2) {
        try {
            BatchUpdateList[] batchUpdateListArray;
            int n;
            Object object = this;
            synchronized (object) {
                n = this.updates.size();
                if (n <= 0) return;
                batchUpdateListArray = new BatchUpdateList[n];
                this.updates.values().toArray(batchUpdateListArray);
                this.updates.clear();
            }
            object = new ArrayList();
            n = 0;
            while (n < batchUpdateListArray.length) {
                Iterator iterator;
                Object var11_8;
                BatchUpdateList batchUpdateList = null;
                try {
                    batchUpdateList = batchUpdateListArray[n];
                    ((ArrayList)object).addAll(batchUpdateList.pushCacheEntryEvents);
                    this.cleanUpEventLists(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents, batchUpdateList.pushECFEvents);
                    if (batchUpdateList.invalidateByIdEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(batchUpdateList.invalidateByIdEvents.values().iterator());
                    }
                    this.cleanUpInvalidationIdEvents(batchUpdateList.invalidateByIdEvents);
                    if (batchUpdateList.invalidateByTemplateEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(batchUpdateList.invalidateByTemplateEvents.values().iterator());
                    }
                    if (batchUpdateList.pushCacheEntryEvents.size() > 0) {
                        batchUpdateList.pushCacheEntryEvents = this.invalidationAuditDaemon.filterEntryList(batchUpdateList.pushCacheEntryEvents);
                    }
                    if (batchUpdateList.pushECFEvents.size() > 0) {
                        batchUpdateList.pushECFEvents = this.invalidationAuditDaemon.filterExternalCacheFragmentList(batchUpdateList.pushECFEvents);
                    }
                    if (batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0 || batchUpdateList.pushCacheEntryEvents.size() > 0) {
                        RemoteServices remoteServices = batchUpdateList.cache.getRemoteServices();
                        remoteServices.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents);
                    }
                    if (batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0) {
                        batchUpdateList.cache.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, EMPTY_ARRAYLIST);
                    }
                    if ((batchUpdateList.invalidateByIdEvents.size() > 0 || batchUpdateList.invalidateByTemplateEvents.size() > 0 || batchUpdateList.pushECFEvents.size() > 0) && batchUpdateList.cache.cacheName.equalsIgnoreCase("baseCache")) {
                        this.externalCacheServices.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushECFEvents);
                    }
                    var11_8 = null;
                    iterator = ((ArrayList)object).iterator();
                }
                catch (Throwable throwable) {
                    var11_8 = null;
                    iterator = ((ArrayList)object).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            ((ArrayList)object).clear();
                            throw throwable;
                        }
                        batchUpdateList.cache.finish((CacheEntry)iterator.next());
                    }
                }
                while (iterator.hasNext()) {
                    batchUpdateList.cache.finish((CacheEntry)iterator.next());
                }
                ((ArrayList)object).clear();
                ++n;
            }
            return;
        }
        finally {
            if (ServerCache.cachePerf.isPMIEnabled()) {
                this.refreshCachePerf();
            }
        }
    }

    private void refreshCachePerf() {
        if (this.lastCachePerf_maxNumberCacheEntries != (long)ServerCache.cache.getMaxNumberCacheEntries() || this.lastCachePerf_entryHashtableSize != (long)ServerCache.cache.getNumberCacheEntries()) {
            ServerCache.cachePerf.updateCacheSizes((long)ServerCache.cache.getMaxNumberCacheEntries(), (long)ServerCache.cache.getNumberCacheEntries());
            this.lastCachePerf_maxNumberCacheEntries = ServerCache.cache.getMaxNumberCacheEntries();
            this.lastCachePerf_entryHashtableSize = ServerCache.cache.getNumberCacheEntries();
        }
    }

    private void cleanUpEventLists(HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2) {
        Object object;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)iterator.next();
            object = invalidateByIdEvent.getId();
            CacheEntry cacheEntry = invalidateByIdEvent.cache.getEntryFromMemory(object);
            if (cacheEntry == null || invalidateByIdEvent.getTimeStamp() >= cacheEntry.getTimeStamp()) continue;
            iterator.remove();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n;
            boolean bl = false;
            object = (CacheEntry)iterator.next();
            if (hashMap.containsKey(((CacheEntry)object).id)) {
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object)._dataIds.length; ++n) {
                if (!hashMap.containsKey(((CacheEntry)object)._dataIds[n])) continue;
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object)._templates.length; ++n) {
                if (!hashMap2.containsKey(((CacheEntry)object)._templates[n])) continue;
                bl = true;
            }
            if (!bl && !((CacheEntry)object).prepareForSerialization()) {
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string;
            boolean bl = false;
            object = (ExternalCacheFragment)iterator.next();
            Enumeration enumeration = ((ExternalCacheFragment)object).getTemplates();
            while (!bl && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!hashMap2.containsKey(string)) continue;
                bl = true;
            }
            enumeration = ((ExternalCacheFragment)object).getInvalidationIds();
            while (!bl && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!hashMap.containsKey(string)) continue;
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private void cleanUpInvalidationIdEvents(HashMap hashMap) {
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)iterator.next();
            if (invalidateByIdEvent.prepareForSerialization()) continue;
            iterator.remove();
        }
    }

    private final BatchUpdateList getUpdateList(Cache cache) {
        BatchUpdateList batchUpdateList = (BatchUpdateList)this.updates.get(cache);
        if (batchUpdateList == null) {
            batchUpdateList = new BatchUpdateList();
            batchUpdateList.cache = cache;
            this.updates.put(cache, batchUpdateList);
        }
        return batchUpdateList;
    }

    static class BatchUpdateList {
        public Cache cache;
        public HashMap invalidateByIdEvents = new HashMap();
        public HashMap invalidateByTemplateEvents = new HashMap();
        public ArrayList pushCacheEntryEvents = new ArrayList();
        public ArrayList pushECFEvents = new ArrayList();

        BatchUpdateList() {
        }
    }
}

