/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.CacheStatisticsListener;
import com.ibm.ws.cache.DCEventSource;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.EventSourceIntf;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Cache
implements com.ibm.websphere.cache.Cache {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$Cache == null ? (class$com$ibm$ws$cache$Cache = Cache.class$("com.ibm.ws.cache.Cache")) : class$com$ibm$ws$cache$Cache, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final boolean FIRE_INVALIDATION_LISTENER = true;
    public static final int DEFAULT_CACHE_SIZE = 1000;
    public static final String DEFAULT_CACHE_NAME = "baseCache";
    public static final String DEFAULT_DISTRIBUTED_MAP_NAME = "default";
    String cacheName;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private CacheStatisticsListener cacheStatisticsListener = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private CacheEntryObjectPool cacheEntryPool = null;
    private DependencyTable dataDependencyTable = null;
    private DependencyTable templateDependencyTable = null;
    private FastHashtable entryHashtable = null;
    private int maxNumberCacheEntries = 1000;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;
    protected boolean swapToDisk = false;
    protected DynacacheOnDisk diskCache = null;
    private boolean flushToDiskComplete = false;
    private boolean flushToDiskOnStop = false;
    CachePerf cachePerf = ServerCache.cachePerf;
    CacheEntry.LRUHead[] lruBuckets = null;
    int lruTop = 0;
    protected boolean bEnableListener = false;
    private boolean bUseListenerContext = false;
    protected EventSourceIntf eventSource = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$Cache;

    protected Cache(String string, CacheConfig cacheConfig) {
        this.cacheName = string;
        this.maxNumberCacheEntries = cacheConfig.cacheSize;
        this.swapToDisk = cacheConfig.enableDiskOffload;
        this.bUseListenerContext = cacheConfig.useListenerContext;
        this.flushToDiskOnStop = cacheConfig.flushToDiskOnStop;
        String string2 = cacheConfig.diskOffloadLocation;
        int n = cacheConfig.diskHashBuckets;
        int n2 = cacheConfig.htodCleanupHour;
        long l = cacheConfig.htodInvalInterval;
        int n3 = Math.min(1000, this.maxNumberCacheEntries / 10);
        this.cacheEntryPool = new CacheEntryObjectPool(n3);
        this.lruBuckets = new CacheEntry.LRUHead[CacheEntry.MAX_PRIORITY + 1];
        for (int i = 0; i < this.lruBuckets.length; ++i) {
            this.lruBuckets[i] = new CacheEntry.LRUHead();
            this.lruBuckets[i].priority = i;
        }
        this.entryHashtable = new FastHashtable(this.maxNumberCacheEntries);
        this.dataDependencyTable = new DependencyTable(this.maxNumberCacheEntries);
        this.templateDependencyTable = new DependencyTable(this.maxNumberCacheEntries);
        if (this.swapToDisk) {
            this.diskCache = new CacheOnDisk(string2, n, n2, l, this);
            if (!this.swapToDisk) {
                this.diskCache = null;
            }
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    protected void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    protected CacheStatisticsListener getCacheStatisticsListener() {
        return this.cacheStatisticsListener;
    }

    protected void setCacheStatisticsListener(CacheStatisticsListener cacheStatisticsListener) {
        this.cacheStatisticsListener = cacheStatisticsListener;
    }

    protected void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        this.timeLimitDaemon = timeLimitDaemon;
    }

    protected void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    protected RemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    protected void setDefaultPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultPriority must be nonnegative");
        }
        this.defaultPriority = n;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    protected void start() {
        if (this.timeLimitDaemon == null || this.batchUpdateDaemon == null || this.cacheStatisticsListener == null || this.remoteServices == null) {
            throw new IllegalStateException("batchUpdateDaemon, cacheStatisticsListener, remoteServices, and timeLimitDaemon must all be set before start()");
        }
        this.flushToDiskComplete = false;
    }

    public CacheEntry setEntry(CacheEntry cacheEntry) {
        return this.setEntry(cacheEntry, 5);
    }

    public CacheEntry setEntry(CacheEntry cacheEntry, int n) {
        return this.setEntry(cacheEntry, n, false);
    }

    public CacheEntry setEntry(CacheEntry cacheEntry, int n, boolean bl) {
        CacheEntry cacheEntry2 = null;
        if (!bl) {
            this.cacheStatisticsListener.setEntry(cacheEntry.id);
        }
        cacheEntry2 = this._syncSetEntry(cacheEntry, n, bl);
        if (cacheEntry.timeLimit > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime);
        }
        return cacheEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCacheEntry(Object object, boolean bl, boolean bl2, String string, boolean bl3) {
        CacheEntry cacheEntry;
        if (bl3) {
            Cache cache = this;
            synchronized (cache) {
                cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
                if (cacheEntry != null && !cacheEntry.invalid && !cacheEntry.removeWhenUnpinned) {
                    this.updateLruLocation(cacheEntry);
                }
            }
        } else {
            cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
        }
        if (cacheEntry != null) {
            if (!bl2) {
                this.cacheStatisticsListener.getValueLocalHit(object);
                if (this.cachePerf.isPMIEnabled() && cacheEntry != null && cacheEntry.getValue() != null) {
                    this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 1);
                }
            }
            return cacheEntry;
        }
        if (cacheEntry == null && this.swapToDisk && (cacheEntry = this.diskCache.readCacheEntry(object)) != null) {
            if (bl3) {
                ++cacheEntry.refCount;
            }
            cacheEntry.loadedFromDisk = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" found on disk for id " + object + ", monitor = " + bl2));
            }
            if (!bl2) {
                this.cacheStatisticsListener.getValueLocalHit(object);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 3);
            }
            cacheEntry = this.setEntry(cacheEntry, 3, bl2);
            return cacheEntry;
        }
        if (cacheEntry == null && bl) {
            cacheEntry = this.remoteServices.getEntry(object);
            if (cacheEntry != null) {
                if (bl3) {
                    ++cacheEntry.refCount;
                }
                if (!bl2) {
                    this.cacheStatisticsListener.getValueRemoteHit(object);
                }
                this.setEntry(cacheEntry, 2, bl2);
            } else {
                if (!bl2) {
                    this.cacheStatisticsListener.getValueCacheMiss(object);
                }
                if (this.cachePerf.isPMIEnabled() && !bl2) {
                    this.cachePerf.onCacheMiss(string, 5);
                }
            }
        } else {
            if (!bl2) {
                this.cacheStatisticsListener.getValueCacheMiss(object);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheMiss(string, 5);
            }
        }
        return cacheEntry;
    }

    private synchronized CacheEntry _syncSetEntry(CacheEntry cacheEntry, int n, boolean bl) {
        int n2 = 2;
        CacheEntry cacheEntry2 = (CacheEntry)this.entryHashtable.get(cacheEntry.id);
        if (!bl && this.cachePerf.isPMIEnabled() && n != 3) {
            if ((cacheEntry.getSharingPolicy() == 3 || cacheEntry.getSharingPolicy() == 4) && n == 2) {
                this.cachePerf.onCacheHit(cacheEntry.getTemplate(), n);
            } else if (cacheEntry.getSharingPolicy() == 2 && n == 2) {
                if (cacheEntry2 == null) {
                    this.cachePerf.onEntryCreation(cacheEntry.getTemplate(), n);
                }
            } else {
                this.cachePerf.onEntryCreation(cacheEntry.getTemplate(), n);
            }
        }
        if (cacheEntry2 == null) {
            CacheEntry cacheEntry3;
            cacheEntry2 = this.getFreeLruEntry();
            this.entryHashtable.put(cacheEntry.id, cacheEntry2);
            if (this.swapToDisk && !cacheEntry.loadedFromDisk && (cacheEntry3 = this.diskCache.readCacheEntry(cacheEntry.id)) != null) {
                this.diskCache.delCacheEntry(cacheEntry3);
                n2 = 1;
            }
        } else {
            n2 = 1;
            if (cacheEntry2.timeStamp > cacheEntry.timeStamp) {
                Tr.debug((TraceComponent)tc, (String)("ERROR: attempting to overwrite cacheEntry with older cacheEntry: " + cacheEntry.id));
            }
            if (this.swapToDisk && cacheEntry2.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry2);
            }
            this.removeInvalidationInfo(cacheEntry2);
        }
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry2.copy(cacheEntry);
        this.updateLruLocation(cacheEntry2);
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0 && n != 3) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            Object object = null;
            object = cacheEntry2.serializedValue != null ? cacheEntry2.serializedValue : (Object)cacheEntry2.getValue();
            ChangeEvent changeEvent = new ChangeEvent(cacheEntry2.id, object, n2, n3, this.cacheName);
            this.eventSource.cacheEntryChanged(changeEvent);
        }
        return cacheEntry2;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        CacheEntry cacheEntry;
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        boolean bl2 = false;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if (bl) {
            bl2 = this.shouldPull(entryInfo.getSharingPolicy(), object);
        }
        if ((cacheEntry = this.getCacheEntry(object, bl2, false, entryInfo.getTemplate(), true)) == null) {
            this.cacheStatisticsListener.getEntryMiss(object);
            return null;
        }
        this.cacheStatisticsListener.getEntryHit(object);
        return cacheEntry;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo) {
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        return this.getEntry(entryInfo, true);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(String string) {
        return this.getEntry((Object)string);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object) {
        if (object == null) {
            return null;
        }
        return this.getCacheEntry(object, false, true, null, false);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object, int n) {
        CacheEntry cacheEntry;
        if (object == null) {
            return null;
        }
        if (n == 2 && this.cachePerf.isPMIEnabled() && (cacheEntry = this.getCacheEntry(object, false, false, null, false)) != null) {
            this.cachePerf.onRequest(cacheEntry.getTemplate(), 2);
        }
        return this.getCacheEntry(object, false, true, null, false);
    }

    public void itsUncacheable(String string) {
        this.remoteServices.itsUncacheable(string);
    }

    public synchronized void refreshEntry(CacheEntry cacheEntry) {
        this.updateLruLocation(cacheEntry);
    }

    private final synchronized void updateLruLocation(CacheEntry cacheEntry) {
        if (cacheEntry.lruHead == null) {
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        } else if (cacheEntry.lruHead.priority != cacheEntry.priority || cacheEntry.lruHead.priority == cacheEntry.priority && !cacheEntry.lruHead.isLast(cacheEntry)) {
            cacheEntry.lruHead.remove(cacheEntry);
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        }
    }

    public void setValue(EntryInfo entryInfo, Object object) {
        this.setValue(entryInfo, object, !this.shouldPull(entryInfo.getSharingPolicy(), entryInfo.id));
    }

    public void setValue(EntryInfo entryInfo, Object object, boolean bl) {
        if (entryInfo == null) {
            throw new NullPointerException("input parameter entryInfo is null.");
        }
        if (entryInfo.getIdObject() == null) {
            throw new NullPointerException("entryInfo.getId() is null.");
        }
        this.cacheStatisticsListener.setValue(entryInfo.getIdObject());
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry = null;
        cacheEntry = this._syncSetValue(entryInfo, object);
        if (cacheEntry.timeLimit > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime);
        }
        if (entryInfo.isNotShared()) {
            this.finish(cacheEntry);
            return;
        }
        if (bl) {
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(cacheEntry);
                this.finish(cacheEntry);
            } else {
                this.batchUpdateDaemon.pushCacheEntry(cacheEntry, this);
            }
        } else {
            this.finish(cacheEntry);
        }
    }

    private synchronized CacheEntry _syncSetValue(EntryInfo entryInfo, Object object) {
        Serializable serializable;
        int n = 2;
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(entryInfo.getIdObject());
        if (cacheEntry == null) {
            cacheEntry = this.getFreeLruEntry();
            this.entryHashtable.put(entryInfo.getIdObject(), cacheEntry);
            if (this.swapToDisk && (serializable = this.diskCache.readCacheEntry(entryInfo.getIdObject())) != null) {
                this.diskCache.delCacheEntry((CacheEntry)serializable);
                n = 1;
            }
        } else {
            n = 1;
            if (this.swapToDisk && cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry);
            }
            this.removeInvalidationInfo(cacheEntry);
        }
        if (this.cachePerf.isPMIEnabled() && cacheEntry.getValue() == null) {
            this.cachePerf.onEntryCreation(entryInfo.getTemplate(), 5);
        }
        cacheEntry.copyMetaData(entryInfo);
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry.setValue(object);
        this.updateLruLocation(cacheEntry);
        cacheEntry.timeStamp = System.currentTimeMillis();
        ++cacheEntry.refCount;
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            serializable = new ChangeEvent(cacheEntry.id, cacheEntry.getValue(), n, 1, this.cacheName);
            this.eventSource.cacheEntryChanged((ChangeEvent)serializable);
        }
        return cacheEntry;
    }

    private void updateInvalidationHashtable(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        for (n = 0; n < cacheEntry._dataIds.length; ++n) {
            this.dataDependencyTable.add(cacheEntry._dataIds[n], object);
        }
        for (n = 0; n < cacheEntry._templates.length; ++n) {
            this.templateDependencyTable.add(cacheEntry._templates[n], object);
        }
    }

    private void removeInvalidationInfo(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        for (n = 0; n < cacheEntry._dataIds.length; ++n) {
            this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n], object);
        }
        for (n = 0; n < cacheEntry._templates.length; ++n) {
            this.templateDependencyTable.removeEntry(cacheEntry._templates[n], object);
        }
    }

    public boolean isValid(String string) {
        CacheEntry cacheEntry = this.getCacheEntry(string, false, true, null, false);
        if (cacheEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache.isValid 1: cacheEntry == null");
            }
            return false;
        }
        if (cacheEntry.invalid) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache.isValid 2: cacheEntry.invalid");
            }
            return false;
        }
        return !cacheEntry.removeWhenUnpinned;
    }

    public Object getValue(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl, boolean bl2) {
        CacheEntry cacheEntry;
        if (entryInfo == null) {
            return null;
        }
        Object object = entryInfo.getIdObject();
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if ((cacheEntry = this.getCacheEntry(object, bl, bl2, entryInfo.getTemplate(), true)) != null) {
            this.updateLruLocation(cacheEntry);
            Object object2 = cacheEntry.getValue();
            this.finish(cacheEntry);
            return object2;
        }
        return null;
    }

    public Object invalidateAndSet(EntryInfo entryInfo, Object object, boolean bl) {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invalidateAndSet: " + entryInfo.getIdObject()));
        }
        Object object2 = null;
        if (entryInfo == null) {
            return null;
        }
        Object object3 = entryInfo.getIdObject();
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if ((cacheEntry = this.getCacheEntry(object3, false, true, null, true)) != null) {
            object2 = cacheEntry.getValue();
            this.finish(cacheEntry);
        } else {
            object2 = null;
        }
        if (entryInfo.getSharingPolicy() == 4 || entryInfo.getSharingPolicy() == 3) {
            this.invalidateById(object3, true);
        }
        this.cacheStatisticsListener.setValue(entryInfo.getIdObject());
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry2 = this._syncSetValue(entryInfo, object);
        if (cacheEntry2.timeLimit > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry2.id, cacheEntry2.expirationTime);
        }
        if (entryInfo.isNotShared()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Cache.InvalidateAndSet, entry info not shared: " + object3));
            }
            this.finish(cacheEntry2);
            return object2;
        }
        if (bl) {
            if (!cacheEntry2.isBatchEnabled()) {
                this.remoteServices.setEntry(cacheEntry2);
                this.finish(cacheEntry2);
            } else {
                this.batchUpdateDaemon.pushCacheEntry(cacheEntry2, this);
            }
        } else {
            this.finish(cacheEntry2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Cache.InvalidateAndSet: " + object3));
        }
        return object2;
    }

    public Object getValue(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        return this.getValue(entryInfo, bl, false);
    }

    public Object getValue(String string, boolean bl) {
        return this.getValue((Object)string, bl);
    }

    public Object getValue(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CacheEntry cacheEntry = this.getCacheEntry(object, bl, false, null, true);
        if (cacheEntry != null) {
            this.updateLruLocation(cacheEntry);
            Object object2 = cacheEntry.getValue();
            this.finish(cacheEntry);
            return object2;
        }
        return null;
    }

    public void invalidateById(String string, boolean bl) {
        this.invalidateById((Object)string, bl);
    }

    public void invalidateById(Object object, boolean bl) {
        if (object == null) {
            return;
        }
        this.invalidateById(object, 1, bl);
    }

    public void invalidateById(Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        this.batchUpdateDaemon.invalidateById(object, n, bl, this);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.batchUpdateDaemon.invalidateByTemplate(string, bl, this);
    }

    protected void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        Externalizable externalizable;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            externalizable = (InvalidateByIdEvent)iterator.next();
            if (((InvalidateByIdEvent)externalizable).causeOfInvalidation == 2 && ((InvalidateByIdEvent)externalizable).source == 5) continue;
            this.internalInvalidateById(((InvalidateByIdEvent)externalizable).getId(), ((InvalidateByIdEvent)externalizable).causeOfInvalidation, ((InvalidateByIdEvent)externalizable).source, true);
        }
        iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            externalizable = (InvalidateByTemplateEvent)iterator.next();
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommandClear()) {
                this.clearLocal(((InvalidateByTemplateEvent)externalizable).source);
                continue;
            }
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommandInvalidateByTemplate()) {
                this.internalInvalidateByTemplate((InvalidateByTemplateEvent)externalizable);
                continue;
            }
            throw new IllegalStateException("Program check - cache command unknown.");
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            externalizable = (CacheEntry)iterator.next();
            this.setEntry((CacheEntry)externalizable, 2);
        }
    }

    public synchronized void internalInvalidateByTemplate(InvalidateByTemplateEvent invalidateByTemplateEvent) {
        Object object;
        String string = invalidateByTemplateEvent.getTemplate();
        int n = invalidateByTemplateEvent.source;
        ValueSet valueSet = this.templateDependencyTable.removeDependency(string);
        if (this.swapToDisk) {
            object = this.diskCache.readTemplate(string, true);
            if (valueSet == null) {
                valueSet = object;
            } else {
                valueSet.union((ValueSet)object);
            }
            int n2 = ((HashSet)object).size();
            if (n2 > 0 && this.cachePerf.isPMIEnabled()) {
                this.cachePerf.batchOnInvalidate(string, 1, 3, n, n2);
            }
        }
        if (valueSet == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("internalInvalidateByTemplate: " + string));
        }
        invalidateByTemplateEvent.addRemovedIds(valueSet);
        object = valueSet.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            this.remove(e, 1, n, true);
        }
    }

    protected void internalInvalidateById(Object object) {
        throw new IllegalStateException("who is using this old internalInvalidateById id =" + object);
    }

    protected synchronized void internalInvalidateById(Object object, int n, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
        }
        this.remove(object, n, n2, bl);
        ValueSet valueSet = this.dataDependencyTable.removeDependency(object);
        if (this.swapToDisk) {
            if (valueSet == null) {
                valueSet = this.diskCache.readDependency(object, true);
            } else {
                valueSet.union(this.diskCache.readDependency(object, true));
            }
        }
        if (valueSet == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
            }
            return;
        }
        Iterator iterator = valueSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.remove(e, n, n2, bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
        }
    }

    protected final void remove(Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Cache.remove(" + object + ") called with no cause/source tracking"));
        }
        this.remove(object, -1, -1);
    }

    protected final synchronized void remove(Object object, int n, int n2) {
        this.remove(object, n, n2, true);
    }

    protected final synchronized void remove(Object object, int n, int n2, boolean bl) {
        int n3;
        if (object == null) {
            throw new NullPointerException("input parameter id is null.");
        }
        if (n == 2) {
            this.cacheStatisticsListener.lruRemove(object);
        } else {
            this.cacheStatisticsListener.remove(object);
        }
        boolean bl2 = false;
        this.timeLimitDaemon.valueWasRemoved(this, object);
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(object);
        if (cacheEntry == null && this.swapToDisk) {
            cacheEntry = this.diskCache.readCacheEntry(object);
            if (cacheEntry == null) {
                return;
            }
            bl2 = true;
        }
        if (cacheEntry == null || cacheEntry.invalid || cacheEntry.removeWhenUnpinned) {
            return;
        }
        if (this.cachePerf.isPMIEnabled() && n != -1) {
            if (bl2) {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n, 3, n2);
            } else {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n, 1, n2);
            }
        }
        cacheEntry.invalid = true;
        Object object2 = null;
        object2 = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
        for (n3 = 0; n3 < cacheEntry._dataIds.length; ++n3) {
            if (bl2) continue;
            this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n3], object);
        }
        for (n3 = 0; n3 < cacheEntry._templates.length; ++n3) {
            if (bl2) continue;
            this.templateDependencyTable.removeEntry(cacheEntry._templates[n3], object);
        }
        if (!bl2) {
            this.entryHashtable.remove(object);
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry);
            }
            if (cacheEntry.refCount <= 0) {
                this.returnEntryToFreeList(cacheEntry);
            } else {
                cacheEntry.removeWhenUnpinned = true;
                cacheEntry.lruHead.remove(cacheEntry);
            }
        } else {
            this.diskCache.delCacheEntry(cacheEntry);
        }
        if (this.bEnableListener && bl && this.eventSource.getInvalidationListenerCount() > 0 && n > 0) {
            n3 = 1;
            if (n2 == 2) {
                n3 = 2;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent(object, object2, n, n3, this.cacheName);
            this.eventSource.fireEvent(invalidationEvent);
        }
    }

    protected synchronized void returnEntryToFreeList(CacheEntry cacheEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("returnEntryToFreeList: " + cacheEntry.id + ", " + cacheEntry.isOverflowEntry));
        }
        if (cacheEntry.lruHead != null) {
            cacheEntry.lruHead.remove(cacheEntry);
        }
        cacheEntry.id = null;
        cacheEntry.lruEvicted = false;
        cacheEntry.invalid = false;
        this.cacheEntryPool.add(cacheEntry);
    }

    public synchronized boolean finish(CacheEntry cacheEntry) {
        --cacheEntry.refCount;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unpin " + cacheEntry.getIdObject() + " max cache " + this.maxNumberCacheEntries + " pin cnt " + cacheEntry.refCount));
        }
        if (cacheEntry.refCount > 0) {
            return true;
        }
        if (cacheEntry.refCount < 0) {
            cacheEntry.refCount = 0;
        }
        if (cacheEntry.removeWhenUnpinned && cacheEntry.refCount == 0) {
            cacheEntry.removeWhenUnpinned = false;
            this.returnEntryToFreeList(cacheEntry);
            return true;
        }
        return true;
    }

    synchronized void clear(boolean bl) {
        this.batchUpdateDaemon.cacheCommandClear(bl, this);
    }

    private synchronized void clearLocal(int n) {
        int n2 = 1;
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
        Enumeration enumeration = this.entryHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.internalInvalidateById(e, n2, n, false);
        }
        if (this.bEnableListener) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent("*", null, 5, n3, this.cacheName);
            this.eventSource.fireEvent(invalidationEvent);
        }
    }

    public synchronized void clear() {
        Enumeration enumeration = this.entryHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.batchUpdateDaemon.invalidateById(e, 1, !enumeration.hasMoreElements(), this);
        }
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
    }

    public synchronized Enumeration getAllIds() {
        return this.entryHashtable.keys();
    }

    public synchronized Collection getAllDependencyIds() {
        Enumeration enumeration = this.dataDependencyTable.getKeys();
        if (enumeration == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public synchronized Collection getCacheIdsByDependency(String string) {
        return this.getCacheIdsByDependency((Object)string);
    }

    public synchronized Collection getCacheIdsByDependency(Object object) {
        ValueSet valueSet = this.dataDependencyTable.getEntries(object);
        if (valueSet == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(valueSet);
        return arrayList;
    }

    public synchronized Collection getCacheIdsByTemplate(String string) {
        ValueSet valueSet = this.templateDependencyTable.getEntries(string);
        if (valueSet == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(valueSet);
        return arrayList;
    }

    private synchronized CacheEntry getFreeLruEntry() {
        CacheEntry cacheEntry = null;
        if (this.getNumberCacheEntries() < this.maxNumberCacheEntries) {
            cacheEntry = (CacheEntry)this.cacheEntryPool.remove();
            cacheEntry.reset();
            return cacheEntry;
        }
        try {
            int n = (this.lruTop + this.lruBuckets.length - 1) % this.lruBuckets.length;
            while (cacheEntry == null && this.lruTop != n) {
                int n2;
                Object object;
                if (!this.lruBuckets[this.lruTop].isEmpty()) {
                    Iterator iterator = this.lruBuckets[this.lruTop].iterator();
                    while (iterator.hasNext()) {
                        cacheEntry = (CacheEntry)iterator.next();
                        if (cacheEntry.refCount != 0 || (object = cacheEntry.id) == null) continue;
                        n2 = 0;
                        if (this.swapToDisk && cacheEntry.persistToDisk) {
                            try {
                                this.lruToDisk(cacheEntry);
                                n2 = 1;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (n2 == 0) {
                            this.internalInvalidateById(object, 2, 5, true);
                            this.batchUpdateDaemon.invalidateById(object, 2, false, this);
                        }
                        return this.getFreeLruEntry();
                    }
                }
                int n3 = (this.lruTop + 1) % this.lruBuckets.length;
                object = this.lruBuckets[this.lruTop];
                while (!((CacheEntry.LRUHead)object).isEmpty()) {
                    CacheEntry cacheEntry2 = ((CacheEntry.LRUHead)object).removeFirst();
                    cacheEntry2.lruHead = this.lruBuckets[n3];
                    this.lruBuckets[n3].addFirst(cacheEntry2);
                }
                this.lruTop = n3;
                for (n2 = 0; n2 < this.lruBuckets.length; ++n2) {
                    this.lruBuckets[(this.lruTop + n2) % this.lruBuckets.length].priority = n2;
                }
            }
            cacheEntry = (CacheEntry)this.cacheEntryPool.remove();
            cacheEntry.reset();
            return cacheEntry;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.Cache.getFreeLruEntry", "1181", this);
            throwable.printStackTrace();
            return null;
        }
    }

    protected synchronized void lruToDisk(CacheEntry cacheEntry) throws IOException {
        if (cacheEntry.id == null) {
            return;
        }
        if (!cacheEntry.loadedFromDisk && !cacheEntry.prepareForSerialization()) {
            Object object = cacheEntry.id;
            this.internalInvalidateById(object, 2, 5, true);
            this.batchUpdateDaemon.invalidateById(object, 2, false, this);
            return;
        }
        this.cacheStatisticsListener.lruRemove(cacheEntry.id);
        this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        if (cacheEntry.loadedFromDisk) {
            this.removeInvalidationInfo(cacheEntry);
        } else {
            int n;
            this.diskCache.writeCacheEntry(cacheEntry);
            for (n = 0; n < cacheEntry._dataIds.length; ++n) {
                this.diskCache.writeDependencyEntry(cacheEntry._dataIds[n], cacheEntry.id);
                this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n], cacheEntry.id);
            }
            for (n = 0; n < cacheEntry._templates.length; ++n) {
                this.diskCache.writeTemplateEntry(cacheEntry._templates[n], cacheEntry.id);
                this.templateDependencyTable.removeEntry(cacheEntry._templates[n], cacheEntry.id);
            }
        }
        this.entryHashtable.remove(cacheEntry.id);
        ValueSet valueSet = this.dataDependencyTable.removeDependency(cacheEntry.id);
        if (valueSet != null && !cacheEntry.loadedFromDisk) {
            this.diskCache.writeDependency(cacheEntry.id, valueSet);
        }
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onInvalidate(cacheEntry.getTemplate(), 2, 3, 5);
        }
        this.returnEntryToFreeList(cacheEntry);
    }

    public synchronized void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Stopping cache: " + this.cacheName));
        }
        if (this.swapToDisk && !this.flushToDiskComplete) {
            this.flushToDisk();
            this.diskCache.close();
        }
    }

    public synchronized void stopOnDebug() {
        if (this.swapToDisk) {
            this.flushToDisk();
        }
    }

    private void flushToDisk() {
        boolean bl = false;
        if (this.cacheName != null) {
            Object object;
            if (this.cacheName.equals(DEFAULT_CACHE_NAME)) {
                object = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop");
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    bl = true;
                }
            } else {
                bl = this.flushToDiskOnStop;
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" Flush to disk on stop cache: " + this.cacheName));
                }
                object = this.entryHashtable.elements();
                while (object.hasMoreElements()) {
                    CacheEntry cacheEntry = (CacheEntry)object.nextElement();
                    try {
                        if (!cacheEntry.persistToDisk) continue;
                        this.lruToDisk(cacheEntry);
                    }
                    catch (IOException iOException) {}
                }
                this.diskCache.writeAuxiliaryDepTables();
            } else {
                this.diskCache.clearDiskCache();
            }
            this.flushToDiskComplete = true;
        }
    }

    public synchronized int getMaxNumberCacheEntries() {
        return this.maxNumberCacheEntries;
    }

    public synchronized int getNumberCacheEntries() {
        return this.entryHashtable.size();
    }

    public boolean shouldPull(int n, Object object) {
        return this.remoteServices.shouldPull(n, object);
    }

    public boolean getSwapToDisk() {
        return this.swapToDisk;
    }

    protected CacheEntry getEntryFromMemory(Object object) {
        return (CacheEntry)this.entryHashtable.get(object);
    }

    public synchronized Collection getIdsByRangeDisk(int n, int n2) {
        if (this.swapToDisk) {
            ValueSet valueSet = this.diskCache.readCacheIdsByRange(n, n2);
            return valueSet;
        }
        return null;
    }

    public synchronized Collection getDepIdsByRangeDisk(int n, int n2) {
        if (this.swapToDisk) {
            ValueSet valueSet = this.diskCache.readDependencyByRange(n, n2);
            return valueSet;
        }
        return null;
    }

    public synchronized Collection getTemplatesByRangeDisk(int n, int n2) {
        if (this.swapToDisk) {
            ValueSet valueSet = this.diskCache.readTemplatesByRange(n, n2);
            return valueSet;
        }
        return null;
    }

    public synchronized com.ibm.websphere.cache.CacheEntry getEntryDisk(Object object) {
        if (this.swapToDisk) {
            CacheEntry cacheEntry = this.diskCache.readCacheEntry(object);
            return cacheEntry;
        }
        return null;
    }

    public synchronized Collection getDepIdValueDisk(Object object) {
        if (this.swapToDisk) {
            ValueSet valueSet = this.diskCache.readDependency(object, false);
            return valueSet;
        }
        return null;
    }

    public synchronized Collection getTemplateValueDisk(String string) {
        if (this.swapToDisk) {
            ValueSet valueSet = this.diskCache.readTemplate(string, false);
            return valueSet;
        }
        return null;
    }

    public int getIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheIdsSize();
        }
        return 0;
    }

    public int getDepIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsSize();
        }
        return 0;
    }

    public int getTemplatesSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesSize();
        }
        return 0;
    }

    public synchronized void clearDisk() {
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
    }

    public synchronized boolean enableListener(boolean bl) {
        boolean bl2 = true;
        if (bl && this.eventSource == null) {
            bl2 = this.initEventSource();
        }
        this.bEnableListener = bl;
        return bl2;
    }

    private boolean initEventSource() {
        boolean bl = true;
        if (this.bUseListenerContext) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.cache.DCAsyncEventSource");
                this.eventSource = (EventSourceIntf)clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" Using listener's J2EE context for callback - cacheName= " + this.cacheName));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
            catch (Error error) {
                error.printStackTrace();
                bl = false;
            }
        }
        if (this.eventSource == null) {
            this.eventSource = new DCEventSource();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" Using caller thread context for callback - cacheName= " + this.cacheName));
            }
        }
        return bl;
    }

    public synchronized boolean addInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.addListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.removeListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean addChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.addListener(changeListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.removeListener(changeListener);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MutexEntry {
        public int references = 0;

        MutexEntry() {
        }
    }

    static class CacheEntryObjectPool
    extends ObjectPool {
        public CacheEntryObjectPool(int n) {
            super("CacheEntryPool", n);
        }

        public Object createObject() {
            return new CacheEntry();
        }
    }
}

