/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.util.FieldInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CacheConfig {
    public static final String CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    String serverName = "localhost";
    String propertiesDir = null;
    String dtdDir = null;
    String tempDir = null;
    int cacheSize = 2000;
    int maxTimeLimitInSeconds = 86400;
    int configReloadInterval = 5000;
    int timeGranularityInSeconds = 5;
    int batchUpdateInterval = 1000;
    int timeHoldingInvalidations = 300000;
    int cachePriority = CacheEntry.DEFAULT_PRIORITY;
    int jspCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int commandCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int replicationType = 0;
    int pushFrequency = 1;
    DRSSettings drss = null;
    String cacheName = null;
    boolean enableDiskOffload = false;
    String diskOffloadLocation = null;
    int diskHashBuckets = 1024;
    int htodCleanupHour = 0;
    long htodInvalInterval = 86400000L;
    String serverNodeName = null;
    String serverServerName = null;
    String cacheSprayerName = "com.ibm.ws.cache.CacheSprayerImpl";
    String notificationType = "unicast";
    String cacheStatisticsListenerBeanName = "com.ibm.ws.cache.CacheStatisticsListenerImpl";
    String commandStoragePolicyClassName = "com.ibm.ws.cache.command.SerializedPutCommandStorage";
    List externalGroups = new ArrayList();
    boolean useListenerContext = false;
    boolean flushToDiskOnStop = false;

    public void initCacheConfig(String string, String string2, String string3) {
        this.serverNodeName = string2;
        this.serverServerName = string3;
        string3 = string + "." + this.serverNodeName + "." + this.serverServerName;
        this.processOffloadDirectory();
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public void setEnableDiskOffload(boolean bl) {
        this.enableDiskOffload = bl;
        this.processOffloadDirectory();
    }

    public void setOffloadDirectory(String string) {
        this.diskOffloadLocation = string;
        this.processOffloadDirectory();
    }

    public void setUseListenerContext(boolean bl) {
        this.useListenerContext = bl;
    }

    public void setFlushToDiskOnStop(boolean bl) {
        this.flushToDiskOnStop = bl;
    }

    private void processOffloadDirectory() {
        if (this.enableDiskOffload) {
            String string = "";
            String string2 = this.tempDir + this.serverNodeName + File.separator + this.serverServerName + File.separator + "_dynacache";
            string2 = File.separatorChar == '\\' ? string2.replace('/', File.separatorChar) : string2.replace('\\', File.separatorChar);
            if (this.diskOffloadLocation != null && this.diskOffloadLocation.trim().length() != 0) {
                if (this.diskOffloadLocation.indexOf("##") > 0) {
                    return;
                }
                if (this.diskOffloadLocation.equals(string2)) {
                    return;
                }
                string = this.diskOffloadLocation.endsWith("/") || this.diskOffloadLocation.endsWith("\\") ? this.diskOffloadLocation + this.serverNodeName + File.separator + this.serverServerName : this.diskOffloadLocation + File.separator + this.serverNodeName + File.separator + this.serverServerName;
            }
            this.diskOffloadLocation = string.equals("") ? string2 : string + "##" + string2;
            this.diskOffloadLocation = File.separatorChar == '\\' ? this.diskOffloadLocation.replace('/', File.separatorChar) : this.diskOffloadLocation.replace('\\', File.separatorChar);
        }
    }

    public CacheConfig() {
        FieldInitializer.initFromSystemProperties((Object)this);
    }

    public void overrideCacheConfig(Properties properties) {
        if (properties != null) {
            String string = null;
            string = (String)properties.get(CACHE_SIZE);
            if (string != null) {
                this.setCacheSize(Integer.valueOf(string));
            }
            if ((string = (String)properties.get(ENABLE_DISK_OFFLOAD)) != null) {
                this.setEnableDiskOffload(Boolean.valueOf(string));
            }
            if ((string = (String)properties.get(DISK_OFFLOAD_LOCATION)) != null) {
                this.setOffloadDirectory(string);
            }
            if ((string = (String)properties.get(USE_LISTENER_CONTEXT)) != null) {
                this.setUseListenerContext(Boolean.valueOf(string));
            }
            if ((string = (String)properties.get(FLUSH_TO_DISK_ON_STOP)) != null) {
                this.setFlushToDiskOnStop(Boolean.valueOf(string));
            }
        }
    }

    static class ExternalCacheGroupMember {
        String address;
        String beanName;

        ExternalCacheGroupMember() {
        }
    }

    static class ExternalCacheGroup {
        String name;
        int type;
        List members;

        ExternalCacheGroup() {
        }
    }
}

