/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullCachePerfModule;
import com.ibm.ws.cache.PropertiesEntityResolver;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.cache.servlet.ServletCacheConfig;
import com.ibm.ws.drs.DRSCacheApp;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.FieldInitializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CacheServiceImpl
extends ComponentImpl
implements CacheService,
DeployedObjectListener {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$CacheServiceImpl == null ? (class$com$ibm$ws$cache$CacheServiceImpl = CacheServiceImpl.class$("com.ibm.ws.cache.CacheServiceImpl")) : class$com$ibm$ws$cache$CacheServiceImpl, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private Cache cache = null;
    private CommandCache commandCache = null;
    private JSPCache jspCache = null;
    private CacheUnitImpl cacheUnit = null;
    private boolean cacheEnabled = false;
    private ConfigManager configManager = null;
    private NotificationService _drsNotifSvc = null;
    private WCCMCacheConfig cacheConfig = null;
    private static String DISTRIBUTED_MAP_PROPERTIES = "distributedmap.properties";
    private HashSet processedUrls = new HashSet();
    static /* synthetic */ Class class$com$ibm$ws$cache$CacheServiceImpl;
    static /* synthetic */ Class class$com$ibm$ws$cache$CacheService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$MultibrokerDomain;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;

    public NotificationService getDRSNotificationService() {
        return this._drsNotifSvc;
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        DynamicCache dynamicCache = (DynamicCache)object;
        if (!dynamicCache.isEnable()) {
            throw new ComponentDisabledException();
        }
        this.addService(class$com$ibm$ws$cache$CacheService == null ? (class$com$ibm$ws$cache$CacheService = CacheServiceImpl.class$("com.ibm.ws.cache.CacheService")) : class$com$ibm$ws$cache$CacheService);
        VariableMap variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = CacheServiceImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
        String string = variableMap.expand("${WAS_TEMP_DIR}");
        String string2 = variableMap.expand("${WAS_PROPS_DIR}");
        String string3 = variableMap.expand("${WAS_INSTALL_ROOT}/properties");
        this.releaseService(variableMap);
        this.cacheConfig = new WCCMCacheConfig((DynamicCache)object, string, string2, string3);
        Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = CacheServiceImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
        this.cacheConfig.initCacheConfig(server.getCellName(), server.getNodeName(), server.getName());
        this.releaseService(server);
        PropertiesEntityResolver.propertiesDir = this.cacheConfig.propertiesDir;
        ServerCache.cachePerf = PmiFactory.createCachePerf();
        if (ServerCache.cachePerf == null) {
            ServerCache.cachePerf = new NullCachePerfModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNotificationServiceInstance(NotificationService notificationService, CacheConfig cacheConfig) {
        cacheConfig = this.cacheConfig;
        if (cacheConfig.replicationType > 0) {
            MultibrokerDomain multibrokerDomain = null;
            try {
                multibrokerDomain = (MultibrokerDomain)this.getService(class$com$ibm$ws$runtime$service$MultibrokerDomain == null ? (class$com$ibm$ws$runtime$service$MultibrokerDomain = CacheServiceImpl.class$("com.ibm.ws.runtime.service.MultibrokerDomain")) : class$com$ibm$ws$runtime$service$MultibrokerDomain);
                multibrokerDomain.initDRSCacheApp((DRSCacheApp)notificationService, cacheConfig.drss);
            }
            catch (Throwable throwable) {
                this.releaseService(multibrokerDomain);
                throw throwable;
            }
            this.releaseService(multibrokerDomain);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        try {
            this._drsNotifSvc = new DRSNotificationService();
            ServerCache.cacheService = this;
            this.cacheUnit = new CacheUnitImpl(this);
            ServerCache.cache = this.cache = this.cacheUnit.getCache();
            ServerCache.commandCache = this.commandCache = this.cacheUnit.getCommandCache();
            ServerCache.jspCache = this.jspCache = this.cacheUnit.getJSPCache();
            ServerCache.cacheUnit = this.cacheUnit;
            this.initNotificationServiceInstance(this._drsNotifSvc, this.cacheConfig);
            ConfigManager.setPropertiesDirectory(this.cacheConfig.dtdDir);
            this.configManager = ConfigManager.getInstance();
            this.configManager.setReloadInterval(this.cacheConfig.configReloadInterval);
            this.configManager.loadConfig(this.cacheConfig.propertiesDir + "cachespec.xml", false, false, null, null);
            ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? (class$com$ibm$ws$runtime$service$ApplicationMgr = CacheServiceImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr")) : class$com$ibm$ws$runtime$service$ApplicationMgr);
            applicationMgr.addDeployedObjectListener(this);
            this.releaseService(applicationMgr);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((Object)this, "DynaCache");
            mBeanFactory.activateMBean("DynaCache", (RuntimeCollaborator)defaultRuntimeCollaborator, mBeanFactory.getConfigId((Object)"WebSphere Dynamic Cache"), null);
            this.cacheEnabled = true;
            ServerCache.cacheEnabled = true;
            try {
                Cache cache = ServerCache.getCache("default");
                if (cache == null) {
                    cache = ServerCache.createCache("default", this.cacheConfig);
                }
                DistributedMapImpl distributedMapImpl = new DistributedMapImpl(cache);
                JndiHelper.recursiveBind((Context)new InitialContext(), (String)"services/cache/distributedmap", (Object)distributedMapImpl);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.cache.CacheServiceImpl.start", "154", this);
                System.out.println("**** ---->binding exception:" + namingException.getMessage());
                Tr.debug((TraceComponent)tc, (String)"dynacache exception:", (Object)namingException);
            }
            this.initializeDistributedMap(this.getClass().getClassLoader());
            this.setClassLoader();
            Tr.info((TraceComponent)tc, (String)"DYNA0048I");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Dynamic Caching initialized");
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.cache.ServerCache.start", "227", this);
            this.cacheEnabled = false;
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object)new Object[]{this.cacheConfig.serverName, adminException.getMessage()});
            Tr.debug((TraceComponent)tc, (String)"dynacache exception:", (Object)((Object)adminException));
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.CacheServiceImpl.start", "232", this);
            this.cacheEnabled = false;
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object)new Object[]{this.cacheConfig.serverName, illegalStateException.getMessage()});
            Tr.debug((TraceComponent)tc, (String)"dynacache exception:", (Object)illegalStateException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheServiceImpl.start", "237", this);
            this.cacheEnabled = false;
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object)new Object[]{this.cacheConfig.serverName, throwable.getMessage()});
            Tr.debug((TraceComponent)tc, (String)"dynacache exception:", (Object)throwable);
        }
    }

    public void stop() {
        Hashtable hashtable;
        if (this.cache != null) {
            this.cache.stop();
        }
        if ((hashtable = ServerCache.getCacheInstances()) != null) {
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                ((Cache)iterator.next()).stop();
            }
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObjectEvent.getPropertyName().equals("state")) {
            if (deployedObjectEvent.getNewValue().equals("STARTING")) {
                ModuleFile moduleFile = deployedObject.getModuleFile();
                String string = moduleFile.getName();
                if (moduleFile.isWARFile()) {
                    try {
                        this.initializeDistributedMap(deployedObject.getClassLoader());
                        String string2 = moduleFile.getAbsolutePath();
                        DeployedModule deployedModule = (DeployedModule)deployedObject;
                        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
                        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
                        String string3 = webModule.getContextRoot();
                        if (!string3.startsWith("/")) {
                            string3 = "/" + string3;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("servlet", string3);
                        hashMap.put("webservice", string3);
                        this.configManager.loadConfig(string2, true, true, string, hashMap);
                        ServletCacheConfig.getInstance().moduleStarting((DeployedModule)deployedObject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "270", this);
                    }
                } else if (moduleFile.isEJBJarFile()) {
                    try {
                        this.initializeDistributedMap(deployedObject.getClassLoader());
                        String string4 = moduleFile.getAbsolutePath();
                        HashMap hashMap = new HashMap();
                        this.configManager.loadConfig(string4, false, true, string, hashMap);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "274", this);
                    }
                }
            } else if (deployedObjectEvent.getNewValue().equals("STOPPING")) {
                // empty if block
            }
        }
    }

    private void initializeDistributedMap(ClassLoader classLoader) {
        try {
            Enumeration<URL> enumeration = classLoader.getResources(DISTRIBUTED_MAP_PROPERTIES);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (this.processedUrls.contains(uRL)) continue;
                this.processConfigUrl(uRL);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.CacheServiceImpl.initializeDistributedMap", "228", this);
        }
    }

    public void setClassLoader() {
        ApplicationServer applicationServer = (ApplicationServer)this.getService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = CacheServiceImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer);
        ServerCache.setClassLoader(applicationServer.getClassLoader());
        this.releaseService(applicationServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigUrl(URL uRL) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processConfigUrl: " + uRL));
        }
        this.processedUrls.add(uRL);
        InputStream inputStream = uRL.openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        int n = 0;
        VariableMap variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = CacheServiceImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
        try {
            boolean bl = false;
            do {
                String string;
                String string2;
                if ((string2 = properties.getProperty(string = "cache.instance." + n)) != null && string2.charAt(0) == '/') {
                    string2 = string2.substring(1);
                }
                Properties properties2 = new Properties();
                if (string2 != null) {
                    Object object;
                    Object object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding new cache instance: " + string2));
                    }
                    bl = true;
                    Iterator<Object> iterator = properties.keySet().iterator();
                    CacheConfig cacheConfig = ServerCache.cacheUnit.getCacheConfig();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        if (!((String)object2).startsWith(string)) continue;
                        object = variableMap.expand(properties.getProperty((String)object2));
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("adding property: " + (String)object2 + " value:" + (String)object));
                        }
                        properties2.put("com.ibm.ws.cache.CacheConfig" + ((String)object2).substring(string.length()), object);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("final props=" + properties2));
                    }
                    if ((object2 = ServerCache.getCache(string2)) == null) {
                        FieldInitializer.initFromSystemProperties((Object)cacheConfig, (Properties)properties2);
                        object2 = ServerCache.createCache(string2, cacheConfig);
                        object = new DistributedMapImpl((Cache)object2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("binding into JNDI using name: " + string2));
                        }
                        try {
                            JndiHelper.recursiveBind((Context)new InitialContext(), (String)string2, (Object)object);
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.cache.CacheServiceImpl.processConfigUrl", "278", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"error during bind", (Object)namingException);
                            }
                        }
                    }
                } else {
                    bl = false;
                }
                ++n;
            } while (bl);
        }
        finally {
            this.releaseService(variableMap);
        }
    }

    public int getCacheSize() {
        if (this.cacheConfig != null) {
            return this.cacheConfig.cacheSize;
        }
        return 0;
    }

    public int getUsedCacheSize() {
        if (this.cache != null) {
            Enumeration enumeration = this.cache.getAllIds();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
            return n;
        }
        return 0;
    }

    public boolean getDiskOverflow() {
        if (this.cacheConfig != null) {
            return this.cacheConfig.enableDiskOffload;
        }
        return false;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CommandCache getCommandCache() {
        return this.commandCache;
    }

    public JSPCache getJSPCache() {
        return this.jspCache;
    }

    public CachePerf getCachePerf() {
        return ServerCache.cachePerf;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getServerName() {
        String string = null;
        Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = CacheServiceImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
        string = server.getName();
        this.releaseService(server);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

