/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.Enumeration;

public class DependencyTable
implements Serializable {
    static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$DependencyTable == null ? (class$com$ibm$ws$cache$DependencyTable = DependencyTable.class$("com.ibm.ws.cache.DependencyTable")) : class$com$ibm$ws$cache$DependencyTable, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final int DEFAULT_SIZE = 1000;
    private FastHashtable dependencyToEntryTable = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$DependencyTable;

    public DependencyTable() {
        this(1000);
    }

    public DependencyTable(int n) {
        this.dependencyToEntryTable = new FastHashtable(n);
    }

    public void add(Object object, Object object2) {
        if (tc.isDebugEnabled() && object2 instanceof String) {
            Tr.debug((TraceComponent)tc, (String)("IMPORTANT: adding dependency " + object + " --> " + object2));
        }
        if (object == null) {
            throw new IllegalArgumentException("dependency cannot be null");
        }
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            valueSet = new ValueSet(4);
            this.dependencyToEntryTable.put(object, valueSet);
        }
        valueSet.add(object2);
    }

    public ValueSet removeDependency(Object object) {
        return (ValueSet)this.dependencyToEntryTable.remove(object);
    }

    public void removeEntry(String string, Object object) {
        this.removeEntry((Object)string, object);
    }

    public void removeEntry(Object object, Object object2) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            return;
        }
        valueSet.remove(object2);
        if (valueSet.size() == 0) {
            this.removeDependency(object);
        }
    }

    public void clear() {
        this.dependencyToEntryTable.clear();
    }

    public Enumeration getKeys() {
        return this.dependencyToEntryTable.keys();
    }

    public ValueSet getEntries(Object object) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        return valueSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

