/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.util.ObjectPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DistributedMapImpl
implements DistributedMap,
Referenceable {
    private Cache cache;
    private String myTemplate = (class$com$ibm$websphere$cache$DistributedMap == null ? (class$com$ibm$websphere$cache$DistributedMap = DistributedMapImpl.class$("com.ibm.websphere.cache.DistributedMap")) : class$com$ibm$websphere$cache$DistributedMap).getName();
    private int sharingPolicy = 1;
    private EntryInfoObjectPool entryInfoPool;
    static /* synthetic */ Class class$com$ibm$websphere$cache$DistributedMap;
    static /* synthetic */ Class class$com$ibm$websphere$cache$spi$DistributedMapFactory;

    public DistributedMapImpl(Cache cache) {
        this.cache = cache;
        this.entryInfoPool = new EntryInfoObjectPool(50);
    }

    public void setSharingPolicy(int n) {
        this.sharingPolicy = n;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public Object get(Object object) {
        Object object2 = this.cache.getValue(object, this.cache.shouldPull(this.sharingPolicy, object));
        return object2;
    }

    public Object put(Object object, Object object2) {
        EntryInfo entryInfo = (EntryInfo)this.entryInfoPool.remove();
        entryInfo.reset();
        entryInfo.setId(object);
        entryInfo.setSharingPolicy(this.sharingPolicy);
        entryInfo.setTimeLimit(-1);
        Object object3 = this.invalidateAndPut(entryInfo, object2, this.sharingPolicy);
        this.entryInfoPool.add(entryInfo);
        return object3;
    }

    public Object put(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        EntryInfo entryInfo = (EntryInfo)this.entryInfoPool.remove();
        entryInfo.reset();
        entryInfo.setId(object);
        entryInfo.setPriority(n);
        entryInfo.setTimeLimit(n2);
        entryInfo.setSharingPolicy(n3);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                entryInfo.addDataId(objectArray[i]);
            }
        }
        Object object3 = this.invalidateAndPut(entryInfo, object2, n3);
        this.entryInfoPool.add(entryInfo);
        return object3;
    }

    private Object invalidateAndPut(EntryInfo entryInfo, Object object, int n) {
        Object object2 = this.cache.invalidateAndSet(entryInfo, object, true);
        return object2;
    }

    public void invalidate(Object object) {
        this.cache.invalidateById(object, true);
    }

    public void invalidate(Object object, boolean bl) {
        this.cache.invalidateById(object, bl);
    }

    public int size() {
        return this.cache.getNumberCacheEntries();
    }

    public boolean isEmpty() {
        return this.cache.getNumberCacheEntries() == 0;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean containsValue(Object object) {
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object2 = this.get(e);
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object object) {
        Object object2 = this.get(object);
        this.cache.invalidateById(object, true);
        return object2;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        boolean bl = true;
        this.cache.clear(bl);
    }

    public Set keySet() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            arrayList.add(this.get(enumeration.nextElement()));
        }
        return arrayList;
    }

    public Set entrySet() {
        HashSet<DMIEntry> hashSet = new HashSet<DMIEntry>();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            hashSet.add(new DMIEntry(e, this.get(e)));
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference((class$com$ibm$websphere$cache$DistributedMap == null ? (class$com$ibm$websphere$cache$DistributedMap = DistributedMapImpl.class$("com.ibm.websphere.cache.DistributedMap")) : class$com$ibm$websphere$cache$DistributedMap).getName(), new StringRefAddr("cacheName", this.cache.getCacheName()), (class$com$ibm$websphere$cache$spi$DistributedMapFactory == null ? (class$com$ibm$websphere$cache$spi$DistributedMapFactory = DistributedMapImpl.class$("com.ibm.websphere.cache.spi.DistributedMapFactory")) : class$com$ibm$websphere$cache$spi$DistributedMapFactory).getName(), null);
        return reference;
    }

    public boolean enableListener(boolean bl) {
        return this.cache.enableListener(bl);
    }

    public boolean addInvalidationListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            return this.cache.addInvalidationListener(invalidationListener);
        }
        return false;
    }

    public boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            return this.cache.removeInvalidationListener(invalidationListener);
        }
        return false;
    }

    public boolean addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            return this.cache.addChangeListener(changeListener);
        }
        return false;
    }

    public boolean removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            return this.cache.removeChangeListener(changeListener);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EntryInfoObjectPool
    extends ObjectPool {
        public EntryInfoObjectPool(int n) {
            super("EntryInfoPool", n);
        }

        public Object createObject() {
            return new EntryInfo();
        }
    }

    class DMIEntry
    implements Map.Entry {
        Object key;
        Object value;

        DMIEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

