/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.Enumeration;

public class EntryInfo
implements com.ibm.websphere.cache.EntryInfo,
Serializable,
Cloneable {
    static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$EntryInfo == null ? (class$com$ibm$ws$cache$EntryInfo = EntryInfo.class$("com.ibm.ws.cache.EntryInfo")) : class$com$ibm$ws$cache$EntryInfo, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final int NOT_SHARED = 1;
    public static final int SHARED_PUSH = 2;
    public static final int SHARED_PULL = 3;
    public static final int SHARED_PUSH_PULL = 4;
    public static final boolean SET = true;
    public static final boolean UNSET = false;
    private boolean expirationTimeFlag = false;
    private boolean idFlag = false;
    private boolean priorityFlag = false;
    private boolean sharingPolicyFlag = false;
    private boolean lock = false;
    protected Object id = null;
    protected int timeLimit = -1;
    protected long expirationTime = -1L;
    protected int priority = -1;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    protected boolean useBatch = false;
    public ValueSet templates = new ValueSet(4);
    public String template = null;
    public ValueSet dataIds = new ValueSet(4);
    static /* synthetic */ Class class$com$ibm$ws$cache$EntryInfo;

    public void reset() {
        this.expirationTimeFlag = false;
        this.idFlag = false;
        this.priorityFlag = false;
        this.sharingPolicyFlag = false;
        this.lock = false;
        this.id = null;
        this.timeLimit = -1;
        this.expirationTime = -1L;
        this.priority = -1;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.useBatch = false;
        this.templates.clear();
        this.template = null;
        this.dataIds.clear();
    }

    public EntryInfo() {
    }

    public EntryInfo(Object object, String string, int n) {
        this.id = object;
        this.idFlag = true;
        this.templates.add(string);
        this.setTimeLimit(n);
    }

    public EntryInfo(Object object, String string, int n, int n2, int n3, Object[] objectArray) {
        this.id = object;
        this.idFlag = true;
        this.priority = n;
        this.priorityFlag = true;
        this.setTimeLimit(n2);
        this.sharingPolicy = n3;
        this.sharingPolicyFlag = true;
        this.templates.add(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.dataIds.add(objectArray[i]);
            }
        }
    }

    public String getId() {
        return (String)this.id;
    }

    public Object getIdObject() {
        return this.id;
    }

    public void setId(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.idFlag = true;
        this.id = object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set id=" + object));
        }
    }

    public void setId(String string) {
        this.setId((Object)string);
    }

    boolean wasIdSet() {
        return this.idFlag;
    }

    public boolean isBatchEnabled() {
        return ServerCache.isBatchEnabled();
    }

    public void setBatchEnabled(boolean bl) {
        this.useBatch = bl;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public boolean getPersistToDisk() {
        return this.persistToDisk;
    }

    public void setSharingPolicy(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.sharingPolicyFlag = true;
        this.sharingPolicy = n;
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Illegal sharing policy: " + n);
        }
    }

    public void setPersistToDisk(boolean bl) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.persistToDisk = bl;
    }

    boolean wasSharingPolicySet() {
        return this.sharingPolicyFlag;
    }

    public boolean isNotShared() {
        return this.sharingPolicy == 1;
    }

    public boolean isSharedPush() {
        return this.sharingPolicy == 2 || this.sharingPolicy == 4;
    }

    public boolean isSharedPull() {
        return this.sharingPolicy == 3 || this.sharingPolicy == 4;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.timeLimit = n;
        if (n > 0) {
            this.expirationTime = (long)(n * 1000) + System.currentTimeMillis();
        }
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long l) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.expirationTime = l;
        this.timeLimit = (int)((l - System.currentTimeMillis()) / 1000L);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.priorityFlag = true;
        this.priority = n;
    }

    public boolean wasPrioritySet() {
        return this.priorityFlag;
    }

    public Enumeration getTemplates() {
        return this.templates.elements();
    }

    public String getTemplate() {
        return (String)this.templates.getOne();
    }

    public void addTemplate(String string) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.templates.add(string);
    }

    public Enumeration getDataIds() {
        return this.dataIds.elements();
    }

    public void addDataId(String string) {
        this.addDataId((Object)string);
    }

    public void addDataId(Object object) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.dataIds.add(object);
    }

    public void unionDependencies(com.ibm.websphere.cache.EntryInfo entryInfo) {
        EntryInfo entryInfo2 = (EntryInfo)entryInfo;
        if (entryInfo2 == this) {
            return;
        }
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.dataIds.union(entryInfo2.dataIds);
        this.templates.union(entryInfo2.templates);
        if (entryInfo2.id != null) {
            this.dataIds.add(entryInfo2.id);
        }
        if (this.expirationTimeFlag) {
            this.setTimeLimit(entryInfo2.timeLimit);
        } else if (entryInfo2.timeLimit == -1 || entryInfo2.timeLimit != -1 && entryInfo2.timeLimit < this.timeLimit) {
            this.timeLimit = entryInfo2.timeLimit;
        }
    }

    final void lock() {
        this.lock = true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

