/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.ExternalCacheEntry;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class ExternalCacheFragment
implements InvalidationEvent,
Serializable {
    static final long serialVersionUID = 0x50002002L;
    private static SimpleDateFormat httpDateFormat = null;
    private static final String EXPIRES = "Expires";
    private String uri = null;
    private String host = null;
    private ArrayList vHostList = new ArrayList();
    private String externalCacheGroupId = null;
    private byte[] content = null;
    private ValueSet invalidationIds = new ValueSet(4);
    private ValueSet uris = new ValueSet(4);
    private Vector[] headerTable = null;
    private long expirationTime = -1L;
    private long timeStamp = -1L;
    private transient ExternalCacheEntry externalCacheEntry = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$ExternalCacheFragment;

    public String getExternalCacheGroupId() {
        return this.externalCacheGroupId;
    }

    public void setExternalCacheGroupId(String string) {
        this.externalCacheGroupId = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void addHostToList(String string) {
        if (!this.vHostList.contains(string)) {
            this.vHostList.add(string);
        }
    }

    public ArrayList getHostList() {
        return this.vHostList;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public Enumeration getInvalidationIds() {
        return this.invalidationIds.elements();
    }

    public void setInvalidationIds(ValueSet valueSet) {
        this.invalidationIds = valueSet;
    }

    public Enumeration getTemplates() {
        return this.uris.elements();
    }

    public void setTemplates(ValueSet valueSet) {
        this.uris = valueSet;
    }

    public Vector[] getHeaderTable() {
        return this.headerTable;
    }

    public void setHeaderTable(Vector[] vectorArray) {
        this.headerTable = vectorArray;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long l) {
        this.expirationTime = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public ExternalCacheEntry getEntry() {
        if (this.externalCacheEntry != null) {
            return this.externalCacheEntry;
        }
        this.externalCacheEntry = new ExternalCacheEntry();
        this.externalCacheEntry.uri = this.uri;
        this.externalCacheEntry.host = this.host;
        this.externalCacheEntry.content = this.content;
        this.externalCacheEntry.headerTable = this.headerTable;
        if (this.expirationTime >= 0L) {
            if (this.headerTable[0].contains(EXPIRES)) {
                this.headerTable[1].set(this.headerTable[0].indexOf(EXPIRES), httpDateFormat.format(new Date(this.expirationTime)));
            } else {
                this.headerTable[0].add(EXPIRES);
                this.headerTable[1].add(httpDateFormat.format(new Date(this.expirationTime)));
            }
        }
        return this.externalCacheEntry;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExternalCacheFragment)) {
            return false;
        }
        ExternalCacheFragment externalCacheFragment = (ExternalCacheFragment)object;
        return this.uri.equals(externalCacheFragment.uri);
    }

    public int hashCode() {
        if (this.uri == null) {
            return (class$com$ibm$ws$cache$ExternalCacheFragment == null ? (class$com$ibm$ws$cache$ExternalCacheFragment = ExternalCacheFragment.class$("com.ibm.ws.cache.ExternalCacheFragment")) : class$com$ibm$ws$cache$ExternalCacheFragment).hashCode();
        }
        return this.uri.hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        httpDateFormat.setTimeZone(timeZone);
    }
}

