/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheGroup;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;

public class ExternalCacheServices
implements Serializable {
    static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$ExternalCacheServices == null ? (class$com$ibm$ws$cache$ExternalCacheServices = ExternalCacheServices.class$("com.ibm.ws.cache.ExternalCacheServices")) : class$com$ibm$ws$cache$ExternalCacheServices, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private HashMap externalCacheGroups = new HashMap();
    private HashMap externalURLToECFTable = new HashMap();
    private DependencyTable idDependencyTable = new DependencyTable();
    private DependencyTable uriDependencyTable = new DependencyTable();
    static /* synthetic */ Class class$com$ibm$ws$cache$ExternalCacheServices;

    public Iterator getExternalCacheGroupNames() {
        return this.externalCacheGroups.keySet().iterator();
    }

    public void setExternalCacheGroups(HashMap hashMap) {
        this.externalCacheGroups = hashMap;
    }

    public void addExternalCacheAdapter(String string, String string2, String string3) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup == null) {
            Tr.error((TraceComponent)tc, (String)"dynacache.externalnotfound", (Object)string);
            return;
        }
        externalCacheGroup.addExternalCacheAdapter(string2, string3);
    }

    public void removeExternalCacheAdapter(String string, String string2) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup == null) {
            return;
        }
        externalCacheGroup.removeExternalCacheAdapter(string2);
    }

    public void start() {
        if (this.externalCacheGroups == null) {
            throw new IllegalStateException("externalCacheGroups must be set before start()");
        }
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        this.invalidateExternalCaches(hashMap, hashMap2);
        this.writeToExternalCaches(arrayList);
    }

    public void invalidateExternalCaches(HashMap hashMap, HashMap hashMap2) {
        boolean bl;
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        if (this.externalCacheGroups == null) {
            return;
        }
        ValueSet valueSet = new ValueSet(4);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExternalCacheServices.invalidate id: " + object5));
            }
            if ((object4 = this.idDependencyTable.removeDependency(object5)) == null) continue;
            valueSet.union((ValueSet)object4);
        }
        iterator = hashMap2.keySet().iterator();
        object5 = null;
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExternalCacheServices.invalidate template: " + (String)object4));
            }
            if ((object3 = ((InvalidateByTemplateEvent)hashMap2.get(object4)).getRemovedIds()) != null && ((HashSet)object3).size() > 0) {
                if (object5 == null) {
                    object5 = new HashSet(hashMap2.size());
                }
                ((HashSet)object5).add((Object)object3);
            }
            if ((serializable = this.uriDependencyTable.removeDependency(object4)) == null) continue;
            valueSet.union((ValueSet)serializable);
        }
        object4 = new ValueSet(10);
        object3 = valueSet.iterator();
        while (object3.hasNext()) {
            serializable = (ExternalCacheFragment)object3.next();
            String string = ((ExternalCacheFragment)serializable).getUri();
            ((HashSet)object4).add(string);
            this.externalURLToECFTable.remove(string);
            Enumeration enumeration = ((ExternalCacheFragment)serializable).getInvalidationIds();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.idDependencyTable.removeEntry(object2, (Object)serializable);
            }
            object2 = ((ExternalCacheFragment)serializable).getTemplates();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.uriDependencyTable.removeEntry((String)object, (Object)serializable);
            }
        }
        boolean bl2 = ((HashSet)object4).isEmpty();
        boolean bl3 = hashMap.isEmpty();
        boolean bl4 = bl = object5 == null || ((HashSet)object5).isEmpty();
        if (bl2 && bl3 && bl) {
            return;
        }
        object2 = this.externalCacheGroups.values().iterator();
        while (object2.hasNext()) {
            object = (ExternalCacheGroup)object2.next();
            if (!bl2) {
                ((ExternalCacheGroup)object).invalidatePages((ValueSet)object4);
            }
            if (!bl3) {
                ((ExternalCacheGroup)object).invalidateIds(hashMap);
            }
            if (bl) continue;
            ((ExternalCacheGroup)object).invalidateIds((HashSet)object5);
        }
    }

    private void writeToExternalCaches(ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        if (this.externalCacheGroups == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            object3 = (ExternalCacheFragment)arrayList.get(i);
            object2 = ((ExternalCacheFragment)object3).getExternalCacheGroupId();
            object = this.externalCacheGroups.get(object2);
            if (object == null) continue;
            String string = ((ExternalCacheFragment)object3).getUri();
            boolean bl = false;
            ExternalCacheFragment externalCacheFragment = (ExternalCacheFragment)this.externalURLToECFTable.get(string);
            if (externalCacheFragment != null && externalCacheFragment.getTimeStamp() >= ((ExternalCacheFragment)object3).getTimeStamp()) {
                if (!externalCacheFragment.getHostList().contains(((ExternalCacheFragment)object3).getHost())) {
                    bl = true;
                }
                if (System.currentTimeMillis() - externalCacheFragment.getTimeStamp() < 30000L) continue;
            }
            ((ExternalCacheFragment)object3).addHostToList(((ExternalCacheFragment)object3).getHost());
            if (!bl) {
                Object object4;
                this.externalURLToECFTable.put(string, object3);
                arrayList2 = ((ExternalCacheFragment)object3).getInvalidationIds();
                while (arrayList2.hasMoreElements()) {
                    object4 = (String)arrayList2.nextElement();
                    this.idDependencyTable.add(object4, object3);
                }
                object4 = ((ExternalCacheFragment)object3).getTemplates();
                while (object4.hasMoreElements()) {
                    String string2 = (String)object4.nextElement();
                    this.uriDependencyTable.add(string2, object3);
                }
            }
            if ((arrayList2 = (ArrayList)hashMap.get(object2)) == null) {
                arrayList2 = new ArrayList();
                hashMap.put(object2, arrayList2);
            }
            arrayList2.add(((ExternalCacheFragment)object3).getEntry());
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            object2 = (ArrayList)hashMap.get(object3);
            object = (ExternalCacheGroup)this.externalCacheGroups.get(object3);
            ((ExternalCacheGroup)object).writePages((ArrayList)object2);
        }
    }

    public void preInvoke(String string, ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup != null) {
            externalCacheGroup.preInvoke(servletCacheRequest, httpServletResponse);
        }
    }

    public void postInvoke(String string, ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup != null) {
            externalCacheGroup.postInvoke(servletCacheRequest, httpServletResponse);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

