/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.DynaAction;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.HTODDependencyTable;
import com.ibm.ws.cache.ReadWriteLock;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.ValueSetReadCallback;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashtableOnDisk;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivilegedAction;
import java.util.Enumeration;

public class HTODDynacache
implements DynacacheOnDisk {
    public static final boolean DELETE = true;
    public static final boolean CHECK_REMOVE_IDS_LIST = true;
    TraceComponent tc = null;
    private ReadWriteLock readWriteLock = new ReadWriteLock();
    protected String filename;
    protected String dirname;
    protected FileManager object_filemgr;
    protected FileManager dependency_filemgr;
    protected FileManager template_filemgr;
    static String object_suffix = "-objects";
    static String dependency_suffix = "-dependencies";
    static String template_suffix = "-templates";
    protected HashtableOnDisk object_cache = null;
    protected HashtableOnDisk dependency_cache = null;
    protected HashtableOnDisk template_cache = null;
    protected Cache cache = null;
    boolean auto_rehash = false;
    protected int initial_hashtable_size = 1296109;
    protected int hashtable_threshold = 75;
    protected int initial_valueset_size = 509;
    protected boolean valueset_rehash = true;
    protected int physical_disk_manager = 2;
    protected ValueSet removeIdsList = null;
    CachePerf cachePerf = ServerCache.cachePerf;
    protected HTODDependencyTable auxDataDependencyTable = null;
    protected HTODDependencyTable auxTemplateDependencyTable = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$HTODDynacache;

    public HTODDynacache(String string, String string2, Cache cache) throws IOException, ClassNotFoundException {
        this.dirname = string;
        this.filename = string2;
        this.cache = cache;
        this.tc = Trace.register(class$com$ibm$ws$cache$HTODDynacache == null ? (class$com$ibm$ws$cache$HTODDynacache = HTODDynacache.class$("com.ibm.ws.cache.HTODDynacache")) : class$com$ibm$ws$cache$HTODDynacache, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        this.init_files();
        this.auxDataDependencyTable = new HTODDependencyTable(1, 1000, 1000, 2, this);
        this.auxTemplateDependencyTable = new HTODDependencyTable(2, 100, 100, 2, this);
    }

    protected void init_files() throws IOException, ClassNotFoundException {
        this.initFileManager();
        this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L);
        if (this.object_cache == null) {
            HashtableOnDisk.createInstance(this.object_filemgr, this.initial_hashtable_size, this.hashtable_threshold);
            this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L);
        }
        if ((this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L)) == null) {
            HashtableOnDisk.createInstance(this.dependency_filemgr, this.initial_hashtable_size, this.hashtable_threshold);
            this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L);
        }
        if ((this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L)) == null) {
            HashtableOnDisk.createInstance(this.template_filemgr, this.initial_hashtable_size, this.hashtable_threshold);
            this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L);
        }
    }

    void initFileManager() {
        try {
            this.object_filemgr = new FileManagerImpl(this.filename + object_suffix + ".htod", false, "rw", this.physical_disk_manager);
            this.dependency_filemgr = new FileManagerImpl(this.filename + dependency_suffix + ".htod", false, "rw", this.physical_disk_manager);
            this.template_filemgr = new FileManagerImpl(this.filename + template_suffix + ".htod", false, "rw", this.physical_disk_manager);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.initFileManager", "159", this);
            throwable.printStackTrace();
        }
    }

    public void close() {
        try {
            this.object_cache.close();
            this.dependency_cache.close();
            this.template_cache.close();
            this.object_filemgr.close();
            this.dependency_filemgr.close();
            this.template_filemgr.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.close", "178", this);
        }
    }

    public void writeAuxiliaryDepTables() {
        ValueSet valueSet;
        Object e;
        Enumeration enumeration;
        if (!this.auxDataDependencyTable.isEmpty()) {
            enumeration = this.auxDataDependencyTable.getKeys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (!this.auxDataDependencyTable.isUpdated(e)) continue;
                valueSet = this.auxDataDependencyTable.getEntries(e);
                this.writeValueSet(this.dependency_cache, e, valueSet);
            }
            this.auxDataDependencyTable.clear();
        }
        if (!this.auxTemplateDependencyTable.isEmpty()) {
            enumeration = this.auxTemplateDependencyTable.getKeys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (!this.auxDataDependencyTable.isUpdated(e)) continue;
                valueSet = this.auxTemplateDependencyTable.getEntries(e);
                this.writeValueSet(this.template_cache, e, valueSet);
            }
            this.auxTemplateDependencyTable.clear();
        }
    }

    public void dump_object_statistics() {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("------------------ Object File Manager Statistics ---------------\n");
            this.object_filemgr.dump_stats(outputStreamWriter, true);
            outputStreamWriter.write("------------------ Object HTOD Statistics ---------------\n");
            this.object_cache.dump_htod_stats(outputStreamWriter, true);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("------------------ Dependency File Manager Statistics ---------------\n");
            this.dependency_filemgr.dump_stats(outputStreamWriter, true);
            outputStreamWriter.write("------------------ Dependency HTOD Statistics ---------------\n");
            this.dependency_cache.dump_htod_stats(outputStreamWriter, true);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("------------------ Template File Manager Statistics ---------------\n");
            this.template_filemgr.dump_stats(outputStreamWriter, true);
            outputStreamWriter.write("------------------ Template HTOD Statistics ---------------\n");
            this.template_cache.dump_htod_stats(outputStreamWriter, true);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.dump_object_statistics", "213", this);
            throwable.printStackTrace();
        }
    }

    public void clearDiskCache() {
        this.auxDataDependencyTable.clear();
        this.auxTemplateDependencyTable.clear();
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ReadWriteLock readWriteLock = HTODDynacache.this.readWriteLock;
                synchronized (readWriteLock) {
                    HTODDynacache.this.readWriteLock.preWrite();
                    try {
                        HTODDynacache.this.close();
                        File file = new File(HTODDynacache.this.dirname);
                        File[] fileArray = file.listFiles();
                        for (int i = 0; i < fileArray.length; ++i) {
                            fileArray[i].delete();
                        }
                        HTODDynacache.this.init_files();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.clearDiskCache", "229", this);
                        exception.printStackTrace();
                    }
                    finally {
                        HTODDynacache.this.readWriteLock.postWrite();
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delCacheEntry(CacheEntry cacheEntry) {
        int n;
        boolean bl = false;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            try {
                this.readWriteLock.preWrite();
                bl = this.object_cache.remove(cacheEntry.id);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "242", this);
                exception.printStackTrace();
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
        for (n = 0; n < cacheEntry._dataIds.length; ++n) {
            this.delDependencyEntry(cacheEntry._dataIds[n], cacheEntry.id);
        }
        for (n = 0; n < cacheEntry._templates.length; ++n) {
            this.delTemplateEntry(cacheEntry._templates[n], cacheEntry.id);
        }
        return bl;
    }

    public void delDependency(Object object) {
        this.auxDataDependencyTable.removeDependency(object);
        this.delValueSet(this.dependency_cache, object);
    }

    public void delTemplate(String string) {
        this.auxTemplateDependencyTable.removeDependency(string);
        this.delValueSet(this.template_cache, string);
    }

    public void delDependencyEntry(Object object, Object object2) {
        ValueSet valueSet = null;
        int n = this.auxDataDependencyTable.removeEntry(object, object2);
        if (n == 1) {
            valueSet = this.readValueSet(this.dependency_cache, object, false);
            if (valueSet != null) {
                valueSet.remove(object2);
                if (valueSet.size() == 0) {
                    this.delValueSet(this.dependency_cache, object);
                } else {
                    this.auxDataDependencyTable.add(object, valueSet, false);
                }
            }
        } else if (n == 2) {
            this.delValueSet(this.dependency_cache, object);
        }
    }

    public void delTemplateEntry(String string, Object object) {
        ValueSet valueSet = null;
        int n = this.auxTemplateDependencyTable.removeEntry(string, object);
        if (n == 1) {
            valueSet = this.readValueSet(this.template_cache, string, false);
            if (valueSet != null) {
                valueSet.remove(object);
                if (valueSet.size() == 0) {
                    this.delValueSet(this.template_cache, string);
                } else {
                    this.auxTemplateDependencyTable.add((Object)string, valueSet, false);
                }
            }
        } else if (n == 2) {
            this.delValueSet(this.template_cache, string);
        }
    }

    public CacheEntry readCacheEntry(Object object) {
        return this.readCacheEntry(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry readCacheEntry(Object object, boolean bl) {
        long l;
        Object object2;
        if (bl && this.removeIdsList != null) {
            object2 = this;
            synchronized (object2) {
                if (this.removeIdsList != null && !this.removeIdsList.isEmpty()) {
                    this.removeIdsList.remove(object);
                }
            }
        }
        object2 = null;
        Object object3 = null;
        try {
            this.readWriteLock.preRead();
            object3 = this.object_cache.get(object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "308", this);
            throwable.printStackTrace();
            CacheEntry cacheEntry = null;
            return cacheEntry;
        }
        finally {
            this.readWriteLock.postRead();
        }
        if (object3 != null) {
            try {
                object2 = (CacheEntry)SerializationUtility.deserialize((byte[])object3);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "328", this);
                throwable.printStackTrace();
                return null;
            }
        }
        if (object2 != null && ((CacheEntry)object2).timeLimit > 0 && ((CacheEntry)object2).expirationTime < (l = System.currentTimeMillis())) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("Expiring " + object));
            }
            Object object4 = this.cache;
            synchronized (object4) {
                this.delCacheEntry((CacheEntry)object2);
            }
            if (this.cache.bEnableListener) {
                object4 = new InvalidationEvent(((CacheEntry)object2).getIdObject(), ((CacheEntry)object2).getValue(), 3, 1, this.cache.cacheName);
                this.cache.eventSource.fireEvent((InvalidationEvent)object4);
            }
            if (this.cachePerf.isPMIEnabled()) {
                this.cachePerf.onInvalidate(((CacheEntry)object2).getTemplate(), 3, 3, 5);
            }
            object2 = null;
        }
        return object2;
    }

    public ValueSet readDependency(Object object, boolean bl) {
        ValueSet valueSet = this.auxDataDependencyTable.getEntries(object);
        if (valueSet == null) {
            valueSet = this.readValueSet(this.dependency_cache, object, bl);
            if (valueSet != null) {
                if (bl || valueSet.size() == 0) {
                    this.delValueSet(this.dependency_cache, object);
                } else {
                    this.auxDataDependencyTable.add(object, valueSet, true);
                }
            } else {
                valueSet = new ValueSet(1);
            }
            return valueSet;
        }
        if (bl) {
            this.auxDataDependencyTable.removeDependency(object);
            this.delValueSet(this.dependency_cache, object);
        }
        return valueSet;
    }

    public ValueSet readTemplate(String string, boolean bl) {
        ValueSet valueSet = this.auxTemplateDependencyTable.getEntries(string);
        if (valueSet == null) {
            valueSet = this.readValueSet(this.template_cache, string, bl);
            if (valueSet != null) {
                if (bl || valueSet.size() == 0) {
                    this.delValueSet(this.template_cache, string);
                } else {
                    this.auxTemplateDependencyTable.add((Object)string, valueSet, true);
                }
            } else {
                valueSet = new ValueSet(1);
            }
            return valueSet;
        }
        if (bl) {
            this.auxTemplateDependencyTable.removeDependency(string);
            this.delValueSet(this.template_cache, string);
        }
        return valueSet;
    }

    public ValueSet readCacheIdsByRange(int n, int n2) {
        return this.readByRange(this.object_cache, n, n2);
    }

    public ValueSet readDependencyByRange(int n, int n2) {
        return this.readByRange(this.dependency_cache, n, n2);
    }

    public ValueSet readTemplatesByRange(int n, int n2) {
        return this.readByRange(this.template_cache, n, n2);
    }

    public int getCacheIdsSize() {
        this.readWriteLock.preRead();
        int n = this.object_cache.size();
        this.readWriteLock.postRead();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getDepIdsSize() {
        this.readWriteLock.preRead();
        int n = this.dependency_cache.size();
        this.readWriteLock.postRead();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getTemplatesSize() {
        this.readWriteLock.preRead();
        int n = this.template_cache.size();
        this.readWriteLock.postRead();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheEntry(CacheEntry cacheEntry) throws IOException {
        Object object;
        Object object2;
        if (this.removeIdsList != null) {
            object2 = this;
            synchronized (object2) {
                if (this.removeIdsList != null && !this.removeIdsList.isEmpty()) {
                    this.removeIdsList.remove(cacheEntry.getIdObject());
                }
            }
        }
        object2 = null;
        int n = 0;
        try {
            object = new ByteArrayPlusOutputStream(256);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            objectOutputStream.writeObject(cacheEntry);
            objectOutputStream.flush();
            objectOutputStream.close();
            ((ByteArrayOutputStream)object).close();
            object2 = ((ByteArrayPlusOutputStream)object).getTheBuffer();
            n = ((ByteArrayOutputStream)object).size();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "350", this);
            throwable.printStackTrace();
            return;
        }
        object = this.readWriteLock;
        synchronized (object) {
            try {
                this.readWriteLock.preWrite();
                if (cacheEntry.timeLimit > 0) {
                    this.object_cache.put(cacheEntry.getIdObject(), (byte[])object2, n, cacheEntry.expirationTime, -1L);
                } else {
                    this.object_cache.put(cacheEntry.getIdObject(), (byte[])object2, n, -1L, -1L);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "368", this);
                throwable.printStackTrace();
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    public void writeDependency(Object object, ValueSet valueSet) {
        ValueSet valueSet2 = this.auxDataDependencyTable.getEntries(object);
        if (valueSet2 == null) {
            valueSet2 = this.readValueSet(this.dependency_cache, object, false);
            if (valueSet2 != null) {
                this.auxDataDependencyTable.add(object, valueSet, false);
            } else {
                this.auxDataDependencyTable.add(object, valueSet, true);
                this.writeValueSet(this.dependency_cache, object, valueSet);
            }
        } else {
            this.auxDataDependencyTable.replace(object, valueSet);
        }
    }

    public void writeDependencyEntry(Object object, Object object2) {
        ValueSet valueSet = this.auxDataDependencyTable.getEntries(object);
        if (valueSet == null) {
            valueSet = this.readValueSet(this.dependency_cache, object, false);
            if (valueSet == null) {
                valueSet = this.auxDataDependencyTable.add(object, object2, true);
                this.writeValueSet(this.dependency_cache, object, valueSet);
            } else {
                valueSet.add(object2);
                this.auxDataDependencyTable.add(object, valueSet, false);
            }
        } else {
            this.auxDataDependencyTable.add(object, valueSet, object2);
        }
    }

    public void writeTemplate(String string, ValueSet valueSet) {
        ValueSet valueSet2 = this.auxTemplateDependencyTable.getEntries(string);
        if (valueSet2 == null) {
            valueSet2 = this.readValueSet(this.template_cache, string, false);
            if (valueSet2 != null) {
                this.auxTemplateDependencyTable.add((Object)string, valueSet, false);
            } else {
                this.auxTemplateDependencyTable.add((Object)string, valueSet, true);
                this.writeValueSet(this.template_cache, string, valueSet);
            }
        } else {
            this.auxTemplateDependencyTable.replace(string, valueSet);
        }
    }

    public void writeTemplateEntry(String string, Object object) {
        ValueSet valueSet = this.auxTemplateDependencyTable.getEntries(string);
        if (valueSet == null) {
            valueSet = this.readValueSet(this.template_cache, string, false);
            if (valueSet == null) {
                valueSet = this.auxTemplateDependencyTable.add((Object)string, object, true);
                this.writeValueSet(this.template_cache, string, valueSet);
            } else {
                valueSet.add(object);
                this.auxTemplateDependencyTable.add((Object)string, valueSet, false);
            }
        } else {
            this.auxTemplateDependencyTable.add((Object)string, valueSet, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueSet readValueSet(HashtableOnDisk hashtableOnDisk, Object object, boolean bl) {
        ValueSet valueSet = null;
        Object[] objectArray = null;
        Object object2 = null;
        try {
            this.readWriteLock.preRead();
            object2 = hashtableOnDisk.get(object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readValueSet", "308", this);
            throwable.printStackTrace();
            ValueSet valueSet2 = null;
            return valueSet2;
        }
        finally {
            this.readWriteLock.postRead();
        }
        if (object2 != null) {
            try {
                objectArray = (Object[])SerializationUtility.deserialize((byte[])object2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readValueSet", "410", this);
                throwable.printStackTrace();
                return valueSet;
            }
        }
        if (objectArray != null) {
            valueSet = new ValueSet(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                valueSet.add(objectArray[i]);
            }
        }
        if (bl && object2 != null) {
            this.delValueSet(hashtableOnDisk, object);
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueSet readByRange(HashtableOnDisk hashtableOnDisk, int n, int n2) {
        ValueSet valueSet = null;
        this.readWriteLock.preRead();
        try {
            if (hashtableOnDisk != null) {
                if (n < 0) {
                    n = hashtableOnDisk.getPreviousRangeIndex();
                } else if (n > 0) {
                    n = hashtableOnDisk.getNextRangeIndex();
                } else {
                    hashtableOnDisk.initRangeIndex();
                }
                if (n2 == -1) {
                    n2 = hashtableOnDisk.size();
                }
                if (n2 <= 0) {
                    ValueSet valueSet2 = null;
                    return valueSet2;
                }
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("readByRange: before range index=" + n + " length=" + n2));
                }
                valueSet = new ValueSet(n2);
                ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet);
                int n3 = hashtableOnDisk.iterateKeys(valueSetReadCallback, n, n2);
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("readByRange: after range index=" + n3));
                }
                hashtableOnDisk.addRangeIndex(n3);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readByRange", "422", this);
            throwable.printStackTrace();
        }
        finally {
            this.readWriteLock.postRead();
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueSet readExpiredByRange(HashtableOnDisk hashtableOnDisk, int n, int n2, long l) {
        ValueSet valueSet = null;
        if (hashtableOnDisk == null) {
            return valueSet;
        }
        this.readWriteLock.preRead();
        try {
            if (n == 0) {
                hashtableOnDisk.rangeExpiredIndex = 0;
            }
            valueSet = new ValueSet(n2);
            DynaAction dynaAction = new DynaAction(valueSet, l);
            int n3 = hashtableOnDisk.iterateKeys(dynaAction, hashtableOnDisk.rangeExpiredIndex, n2);
            hashtableOnDisk.rangeExpiredIndex = valueSet.size() < n2 ? 0 : n3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.readExpiredByRange", "428", this);
            throwable.printStackTrace();
        }
        finally {
            this.readWriteLock.postRead();
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeValueSet(HashtableOnDisk hashtableOnDisk, Object object, ValueSet valueSet) {
        Object object2;
        if (valueSet.size() == 0) {
            this.delValueSet(hashtableOnDisk, object);
            return;
        }
        Object[] objectArray = valueSet.toArray(new Object[valueSet.size()]);
        byte[] byArray = null;
        int n = 0;
        try {
            object2 = new ByteArrayPlusOutputStream(256);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object2);
            objectOutputStream.writeObject(objectArray);
            objectOutputStream.flush();
            objectOutputStream.close();
            ((ByteArrayOutputStream)object2).close();
            byArray = ((ByteArrayPlusOutputStream)object2).getTheBuffer();
            n = ((ByteArrayOutputStream)object2).size();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "451", this);
            throwable.printStackTrace();
            return;
        }
        object2 = this.readWriteLock;
        synchronized (object2) {
            try {
                this.readWriteLock.preWrite();
                hashtableOnDisk.put(object, byArray, n, -1L, -1L);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "452", this);
                throwable.printStackTrace();
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delValueSet(HashtableOnDisk hashtableOnDisk, Object object) {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            try {
                this.readWriteLock.preWrite();
                hashtableOnDisk.remove(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.delValueSet", "412", this);
                throwable.printStackTrace();
            }
            finally {
                this.readWriteLock.postWrite();
            }
        }
    }

    void delValueSetEntry(HashtableOnDisk hashtableOnDisk, Object object, Object object2) {
        ValueSet valueSet = this.readValueSet(hashtableOnDisk, object, false);
        if (valueSet != null) {
            valueSet.remove(object2);
            if (valueSet.isEmpty()) {
                this.delValueSet(hashtableOnDisk, object);
            } else {
                this.writeValueSet(hashtableOnDisk, object, valueSet);
            }
        }
    }

    void writeValueSetEntry(HashtableOnDisk hashtableOnDisk, Object object, Object object2) {
        ValueSet valueSet = this.readValueSet(hashtableOnDisk, object, false);
        if (valueSet == null) {
            valueSet = new ValueSet(1);
        }
        valueSet.add(object2);
        this.writeValueSet(hashtableOnDisk, object, valueSet);
    }

    public int getNumObjects() {
        this.readWriteLock.preRead();
        int n = Math.max(this.object_cache.size(), 0) + Math.max(this.dependency_cache.size(), 0) + Math.max(this.template_cache.size(), 0);
        this.readWriteLock.postRead();
        return n;
    }

    public String cacheType() {
        return "htod";
    }

    public void dump_htod_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_htod_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_filemgr_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_stats_header(Writer writer) {
        try {
            this.object_cache.dump_stats_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_header(Writer writer) {
        try {
            this.object_cache.dump_filemgr_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reset_stats() {
        this.object_cache.reset_stats();
    }

    public boolean containsKey(Object object) {
        try {
            return this.object_cache.containsKey(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExpiredCache(long l) {
        if (this.object_cache == null) {
            return;
        }
        int n = 0;
        do {
            Object object;
            Object object2;
            ValueSet valueSet;
            int n2;
            if ((n2 = (valueSet = this.readExpiredByRange(this.object_cache, n, 20, l)).size()) == 0) {
                object2 = this;
                synchronized (object2) {
                    this.removeIdsList = null;
                }
                return;
            }
            object2 = this;
            synchronized (object2) {
                this.removeIdsList = valueSet;
            }
            object2 = null;
            do {
                object = this;
                synchronized (object) {
                    object2 = this.removeIdsList.getOne();
                    this.removeIdsList.remove(object2);
                }
                if (object2 == null || (object = this.readCacheEntry(object2, false)) == null) continue;
                this.delCacheEntry((CacheEntry)object);
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("HTOD cleanup for cache id: " + object2));
                }
                if (!this.cache.bEnableListener) continue;
                InvalidationEvent invalidationEvent = new InvalidationEvent(object2, ((CacheEntry)object).getValue(), 4, 1, this.cache.cacheName);
                this.cache.eventSource.fireEvent(invalidationEvent);
            } while (object2 != null);
            if (n2 >= 20) continue;
            object = this;
            synchronized (object) {
                this.removeIdsList = null;
                break;
            }
        } while (++n > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

